/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.publish.DownloadStateAndRemoveListener;
import com.aelitis.azureus.ui.swt.browser.listener.publish.LocalHoster;
import com.aelitis.azureus.ui.swt.browser.listener.publish.PublishListener;
import com.aelitis.azureus.ui.swt.browser.listener.publish.PublishTransaction;
import com.aelitis.azureus.ui.swt.browser.listener.publish.SeedingListener;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;

public class PublishUtils {
    public static void setupContext(ClientMessageContext context, Browser browser, PluginInterface pi, LocalHoster hoster, DownloadStateAndRemoveListener downloadListener) {
        context.addMessageListener(new PublishListener(browser.getShell(), pi, hoster));
        context.registerTransactionType("publish", PublishTransaction.class);
        context.addMessageListener(new DisplayListener(browser));
        context.addMessageListener(new SeedingListener(pi, downloadListener));
    }

    public static boolean isPublished(DownloadManager dm) {
        try {
            TOTorrent torrent = dm.getTorrent();
            if (torrent == null) {
                return false;
            }
            Map map = torrent.getAdditionalMapProperty("attributes");
            if (map != null) {
                Map mapAttr = (Map)map.get("Plugin.azdirector.ContentMap");
                return mapAttr != null && mapAttr.containsKey("DIRECTOR PUBLISH");
            }
        }
        catch (Exception e) {
            Debug.out("baH", e);
        }
        return false;
    }
}

