/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.ui.swt.utils.UIUpdatable;
import com.aelitis.azureus.ui.swt.utils.UIUpdater;
import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class UIUpdaterImpl
extends AEThread
implements ParameterListener,
UIUpdater {
    private static final LogIDs LOGID = LogIDs.UI3;
    private static String CFG_REFRESH_INTERVAL = "GUI Refresh";
    private int iWaitTime;
    private boolean finished = false;
    private boolean refreshed = true;
    private ArrayList updateables = new ArrayList();
    private AEMonitor updateables_mon = new AEMonitor("updateables");

    public UIUpdaterImpl() {
        super("UI Updater");
        COConfigurationManager.addAndFireParameterListener(CFG_REFRESH_INTERVAL, this);
    }

    public void runSupport() {
        while (!this.finished) {
            if (this.refreshed) {
                this.refreshed = false;
                if (!Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        try {
                            UIUpdaterImpl.this.update();
                        }
                        catch (Exception e) {
                            Logger.log(new LogEvent(LOGID, "Error while trying to update GUI", e));
                        }
                        UIUpdaterImpl.this.refreshed = true;
                    }
                })) {
                    this.refreshed = true;
                }
            }
            try {
                Thread.sleep(this.iWaitTime);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void parameterChanged(String parameterName) {
        this.iWaitTime = COConfigurationManager.getIntParameter(CFG_REFRESH_INTERVAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdater(UIUpdatable updateable) {
        this.updateables_mon.enter();
        try {
            if (!this.updateables.contains(updateable)) {
                this.updateables.add(updateable);
            }
        }
        finally {
            this.updateables_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdater(UIUpdatable updateable) {
        this.updateables_mon.enter();
        try {
            this.updateables.remove(updateable);
        }
        finally {
            this.updateables_mon.exit();
        }
    }

    public void stopIt() {
        this.finished = true;
        COConfigurationManager.removeParameterListener(CFG_REFRESH_INTERVAL, this);
    }

    private void update() {
        Object[] updateablesArray = this.updateables.toArray();
        for (int i = 0; i < updateablesArray.length; ++i) {
            if (!(updateablesArray[i] instanceof UIUpdatable)) continue;
            if (SWTThread.getInstance().getDisplay().isDisposed()) {
                return;
            }
            UIUpdatable updateable = (UIUpdatable)updateablesArray[i];
            try {
                updateable.updateUI();
                continue;
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "Error while trying to update GUI " + updateable.getUpdateUIName(), e));
            }
        }
    }
}

