/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnAzProduct;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnComplete;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnDateAdded2Liner;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnIsPrivate;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnIsSeeding;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnMediaThumb;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnProgressETA;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnQuality;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnRate;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnRateUpDown;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnSpeed;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnTitle;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.views.TorrentListViewListener;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.list.ListSelectionAdapter;
import com.aelitis.azureus.ui.swt.views.list.ListView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpItem;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class TorrentListView
extends ListView
implements GlobalManagerListener {
    public static final int VIEW_DOWNLOADING = 0;
    public static final int VIEW_RECENT_DOWNLOADED = 1;
    public static final int VIEW_MY_MEDIA = 2;
    public static final String TABLE_MYMEDIA = "MyMedia";
    private static final String[] LINK_KEYS = new String[]{"MainWindow.v3.currentDL.manage", "MainWindow.v3.recentDL.library", null};
    private static final String[] TABLE_IDS = new String[]{"Downloading", "Recent", "Media"};
    static final TableColumnCore[] tableIncompleteItemsMini = new TableColumnCore[]{new ColumnAzProduct("MyTorrents"), new ColumnMediaThumb("MyTorrents"), new ColumnTitle("MyTorrents"), new SizeItem("MyTorrents"), new ColumnQuality("MyTorrents"), new ColumnSpeed("MyTorrents"), new ColumnProgressETA("MyTorrents"), new ColumnDateAdded2Liner("MyTorrents", false)};
    static final TableColumnCore[] tableIncompleteItems = new TableColumnCore[]{new ColumnAzProduct("MyTorrents"), new ColumnMediaThumb("MyTorrents"), new ColumnTitle("MyTorrents"), new ColumnRate("MyTorrents"), new SizeItem("MyTorrents"), new ColumnQuality("MyTorrents"), new ColumnSpeed("MyTorrents"), new ColumnProgressETA("MyTorrents"), new ColumnDateAdded2Liner("MyTorrents", false)};
    static final TableColumnCore[] tableCompleteItemsMini = new TableColumnCore[]{new ColumnAzProduct("MySeeders"), new ColumnMediaThumb("MySeeders"), new ColumnTitle("MySeeders"), new SizeItem("MySeeders"), new ColumnRateUpDown("MySeeders"), new ColumnRate("MySeeders"), new ColumnDateAdded2Liner("MySeeders", false)};
    static final TableColumnCore[] tableCompleteItems = new TableColumnCore[]{new ColumnIsSeeding("MySeeders"), new ColumnAzProduct("MySeeders"), new ColumnMediaThumb("MySeeders"), new ColumnTitle("MySeeders"), new ColumnRate("MySeeders"), new SizeItem("MySeeders"), new ColumnSpeed("MySeeders"), new UpItem("MySeeders"), new ColumnRateUpDown("MySeeders"), new ColumnIsPrivate("MySeeders"), new ColumnDateAdded2Liner("MySeeders", false)};
    static final TableColumnCore[] tableMyMediaItems = new TableColumnCore[]{new ColumnComplete("MyMedia"), new ColumnAzProduct("MyMedia"), new ColumnMediaThumb("MyMedia"), new ColumnTitle("MyMedia"), new SizeItem("MyMedia"), new ColumnQuality("MyMedia"), new ColumnDateAdded2Liner("MyMedia", true), new ColumnRateUpDown("MyMedia"), new ColumnRate("MyMedia")};
    private final dowloadManagerListener dmListener;
    protected final GlobalManager globalManager;
    private final int viewMode;
    private TableColumnCore[] tableColumns;
    private final boolean bMiniMode;
    private final SWTSkin skin;
    private final SWTSkinObjectText countArea;
    private final ArrayList listeners = new ArrayList();
    private final AEMonitor listeners_mon = new AEMonitor("3.TLV.listeners");
    private final Composite dataArea;
    private boolean bAllowScrolling;
    protected boolean bSkipUpdateCount = false;

    public TorrentListView(AzureusCore core, SWTSkin skin, SWTSkinProperties skinProperties, Composite headerArea, SWTSkinObjectText countArea, final Composite dataArea, int viewMode, final boolean bMiniMode, boolean bAllowScrolling) {
        super(TABLE_IDS[viewMode] + (bMiniMode ? "-Mini" : ""), skinProperties, dataArea);
        this.skin = skin;
        this.countArea = countArea;
        this.dataArea = dataArea;
        this.viewMode = viewMode;
        this.bMiniMode = bMiniMode;
        this.bAllowScrolling = bAllowScrolling;
        this.dmListener = new dowloadManagerListener(this);
        this.tableColumns = viewMode == 0 ? (bMiniMode ? tableIncompleteItemsMini : tableIncompleteItems) : (viewMode == 1 ? (bMiniMode ? tableCompleteItemsMini : tableCompleteItems) : tableMyMediaItems);
        this.updateColumnList(this.tableColumns, "date_added");
        if (headerArea != null) {
            this.setupHeader(headerArea);
        }
        if (countArea != null) {
            countArea.setText("");
        }
        this.getControl().addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                if (bMiniMode) {
                    TorrentListView.this.fixupRowCount();
                }
                TorrentListView.this.expandNameColumn();
            }
        });
        Listener l = new Listener(){

            public void handleEvent(Event event2) {
                DownloadManager dm;
                ListRow row;
                if (event2.button == 2 && (row = TorrentListView.this.getRow(event2.x, event2.y)) != null && (dm = (DownloadManager)row.getDataSource(true)) != null) {
                    TOTorrent torrent = dm.getTorrent();
                    PlatformTorrentUtils.updateMetaData(torrent, 1L);
                    Utils.beep();
                }
            }
        };
        this.getControl().addListener(4, l);
        this.addSelectionListener(new ListSelectionAdapter(){

            public void defaultSelected(ListRow[] rows) {
                ListRow[] selectedRows = TorrentListView.this.getSelectedRows();
                if (selectedRows.length > 0) {
                    // empty if block
                }
            }
        }, false);
        this.globalManager = core.getGlobalManager();
        this.globalManager.addListener(this, false);
        dataArea.getDisplay().asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                DownloadManager[] managers = TorrentListView.this.sortDMList(TorrentListView.this.globalManager.getDownloadManagers());
                TorrentListView.this.bSkipUpdateCount = true;
                for (int i = 0; i < managers.length; ++i) {
                    DownloadManager dm = managers[i];
                    TorrentListView.this.downloadManagerAdded(dm);
                    if (dataArea.getSize().y / ListRow.ROW_HEIGHT != i) continue;
                    TorrentListView.this.processDataSourceQueue();
                    TorrentListView.this.bSkipUpdateCount = false;
                    TorrentListView.this.updateCount();
                    TorrentListView.this.bSkipUpdateCount = true;
                    for (int j = 0; j <= i; ++j) {
                        ListRow row = TorrentListView.this.getRow(j);
                        if (row == null) continue;
                        row.redraw(true);
                    }
                }
                TorrentListView.this.bSkipUpdateCount = false;
            }
        });
        dataArea.layout();
        this._expandNameColumn();
    }

    public void regetDownloads() {
        ListRow[] selectedRows = this.getSelectedRows();
        final int[] rowIndexes = new int[selectedRows.length];
        int selectedIndex = -1;
        if (selectedRows.length > 0) {
            for (int i = 0; i < selectedRows.length; ++i) {
                rowIndexes[i] = selectedRows[i].getIndex();
            }
        }
        this.removeAllDataSources(true);
        System.out.println("reget");
        this.fixupRowCount();
        if (selectedIndex >= 0) {
            this.dataArea.getDisplay().asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    for (int i = 0; i < rowIndexes.length; ++i) {
                        ListRow row = TorrentListView.this.getRow(rowIndexes[i]);
                        if (row == null) continue;
                        row.setSelected(true);
                    }
                }
            });
        }
    }

    protected void expandNameColumn() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TorrentListView.this._expandNameColumn();
            }
        });
    }

    protected void _expandNameColumn() {
        int viewWidth = this.getClientArea().width;
        int columnWidthTotal = 0;
        int nameColumnIdx = -1;
        TableColumnCore[] columns = this.getVisibleColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equals("name")) {
                nameColumnIdx = i;
                continue;
            }
            columnWidthTotal += columns[i].getWidth() + ListRow.MARGIN_WIDTH * 2;
        }
        if (nameColumnIdx >= 0) {
            columns[nameColumnIdx].setWidth(viewWidth - columnWidthTotal - ListRow.MARGIN_WIDTH * 2);
        }
    }

    protected void fixupRowCount() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TorrentListView.this._fixupRowCount();
            }
        });
    }

    private void _fixupRowCount() {
        if (this.dataArea.isDisposed() || this.bAllowScrolling) {
            return;
        }
        int changeCount = 0;
        int curRowCount = this.size(true);
        int maxRows = this.bAllowScrolling ? 100000 : this.dataArea.getSize().y / ListRow.ROW_HEIGHT;
        long totalPossible = this.getTotalPossible();
        if (curRowCount < maxRows && totalPossible > (long)curRowCount) {
            DownloadManager[] managers = this.sortDMList(this.globalManager.getDownloadManagers());
            int pos = 0;
            int i = 0;
            while ((long)i < totalPossible && curRowCount < maxRows) {
                DownloadManager dm = managers[i];
                if (this.isOurDownload(dm) && !this.dataSourceExists(dm)) {
                    this.addDataSource(dm, false);
                    ++changeCount;
                    ++curRowCount;
                    ++pos;
                }
                ++i;
            }
            this.processDataSourceQueue();
        } else {
            while (curRowCount > maxRows) {
                ListRow row;
                if ((row = this.getRow(--curRowCount)) != null) {
                    this.removeDataSource(row.getDataSource(true), true);
                }
                ++changeCount;
            }
        }
        this.updateCount();
    }

    protected DownloadManager[] sortDMList(List dms) {
        DownloadManager[] dmsArray = dms.toArray(new DownloadManager[0]);
        Arrays.sort(dmsArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                long l2;
                boolean bOurDL2;
                DownloadManager dm1 = (DownloadManager)o1;
                DownloadManager dm2 = (DownloadManager)o2;
                boolean bOurDL1 = TorrentListView.this.isOurDownload(dm1);
                if (bOurDL1 != (bOurDL2 = TorrentListView.this.isOurDownload(dm2))) {
                    return bOurDL1 ? -1 : 1;
                }
                long l1 = dm1 == null ? 0L : dm1.getDownloadState().getLongParameter("stats.download.added.time");
                long l = l2 = dm2 == null ? 0L : dm2.getDownloadState().getLongParameter("stats.download.added.time");
                return l1 == l2 ? 0 : (l1 > l2 ? -1 : 1);
            }
        });
        return dmsArray;
    }

    public void destroyInitiated() {
    }

    public void destroyed() {
    }

    public void downloadManagerAdded(DownloadManager dm) {
        dm.addListener(this.dmListener);
        if (this.isOurDownload(dm)) {
            this.addDataSource(dm, false);
            this.updateCount();
        }
    }

    public void downloadManagerRemoved(DownloadManager dm) {
        this.removeDataSource(dm, true);
        this.fixupRowCount();
    }

    public void seedingStatusChanged(boolean seeding_only_mode) {
    }

    public boolean isOurDownload(DownloadManager dm) {
        boolean bDownloadComplete = dm.isDownloadComplete(false);
        switch (this.viewMode) {
            case 0: {
                return !bDownloadComplete;
            }
            case 1: {
                return bDownloadComplete;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCount() {
        try {
            this.listeners_mon.enter();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                TorrentListViewListener l = (TorrentListViewListener)iter.next();
                l.countChanged();
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        if (this.countArea != null && this.bSkipUpdateCount) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    long size2;
                    if (TorrentListView.this.countArea == null) {
                        return;
                    }
                    long size1 = TorrentListView.this.size(true);
                    if (size1 == (size2 = TorrentListView.this.getTotalPossible())) {
                        TorrentListView.this.countArea.setText(MessageText.getString("MainWindow.v3.count", new String[]{"" + size1}));
                    } else {
                        TorrentListView.this.countArea.setText(MessageText.getString("MainWindow.v3.xofx", new String[]{"" + size1, "" + size2}));
                    }
                }
            });
        }
    }

    private long getTotalPossible() {
        int count = this.viewMode == 0 ? this.globalManager.downloadManagerCount(false) : (this.viewMode == 1 ? this.globalManager.downloadManagerCount(true) : this.globalManager.getDownloadManagers().size());
        return count;
    }

    public void addListener(TorrentListViewListener l) {
        this.listeners.add(l);
        l.countChanged();
        l.stateChanged(null);
    }

    public void removeListener(TorrentListViewListener l) {
        this.listeners.remove(l);
    }

    public void fillMenu(Menu menu) {
        Object[] dms = this.getSelectedDataSources();
        boolean hasSelection = dms.length > 0;
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu.explore");
        itemExplore.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TorrentListView.this.exploreTorrents();
            }
        });
        itemExplore.setEnabled(hasSelection);
    }

    private void exploreTorrents() {
        Object[] dataSources = this.getSelectedDataSources();
        for (int i = dataSources.length - 1; i >= 0; --i) {
            DownloadManager dm = (DownloadManager)dataSources[i];
            if (dm == null) continue;
            ManagerUtils.open(dm);
        }
    }

    private static class dowloadManagerListener
    implements DownloadManagerListener {
        private final TorrentListView view;

        public dowloadManagerListener(TorrentListView view) {
            this.view = view;
        }

        public void completionChanged(DownloadManager manager, boolean bCompleted) {
            if (this.view.isOurDownload(manager)) {
                this.view.addDataSource(manager, true);
            } else {
                this.view.removeDataSource(manager, true);
            }
            this.view.fixupRowCount();
        }

        public void downloadComplete(DownloadManager manager) {
            if (this.view.isOurDownload(manager)) {
                this.view.addDataSource(manager, true);
            } else {
                this.view.removeDataSource(manager, true);
            }
            this.view.fixupRowCount();
        }

        public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
        }

        public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(DownloadManager manager, int state) {
            try {
                this.view.listeners_mon.enter();
                Iterator iter = this.view.listeners.iterator();
                while (iter.hasNext()) {
                    TorrentListViewListener l = (TorrentListViewListener)iter.next();
                    l.stateChanged(manager);
                }
            }
            finally {
                this.view.listeners_mon.exit();
            }
        }
    }
}

