/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.list;

import com.aelitis.azureus.ui.swt.views.list.ListRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.ui.swt.components.BufferedTableItem;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;

public class ListCell
implements BufferedTableItem {
    private final int position;
    private String sText;
    protected Color colorFG;
    protected Color colorBG;
    protected Rectangle bounds;
    protected final ListRow row;
    private final int alignment;
    private boolean bLastIsShown = false;
    private TableCellCore cell;

    public ListCell(ListRow row, int position, int alignment, Rectangle bounds) {
        this.row = row;
        this.position = position;
        this.alignment = alignment;
        this.bounds = bounds;
    }

    public void dispose() {
    }

    public void doPaint(GC gc) {
        if (!this.isShowable()) {
            return;
        }
        if (this.sText == null) {
            return;
        }
        if (this.colorFG != null) {
            gc.setForeground(this.colorFG);
        }
        if (this.colorBG != null) {
            gc.setBackground(this.colorBG);
        }
        GCStringPrinter.printString(gc, this.sText, this.bounds, true, true, this.alignment | 0x40);
    }

    private boolean isShowable() {
        return this.position >= 0 && this.bounds != null && this.bounds.height > 0;
    }

    public Color getBackground() {
        if (this.colorBG == null) {
            return this.row.getBackground();
        }
        return this.colorBG;
    }

    public Rectangle getBounds() {
        this.bounds.y = this.row.getVisibleYOffset();
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public int getPosition() {
        return this.position;
    }

    public String getText() {
        return this.sText;
    }

    public boolean isShown() {
        boolean bIsShown;
        boolean bl = bIsShown = this.isShowable() && this.row.isVisible();
        if (bIsShown != this.bLastIsShown) {
            this.bLastIsShown = bIsShown;
            if (this.cell != null) {
                int mode = bIsShown ? 0 : 1;
                ((TableColumnCore)this.cell.getTableColumn()).invokeCellVisibilityListeners(this.cell, mode);
                this.cell.invokeVisibilityListeners(mode);
            }
        }
        return bIsShown;
    }

    public void locationChanged() {
    }

    public boolean needsPainting() {
        return this.isShown();
    }

    public void refresh() {
    }

    public void setIcon(Image img) {
    }

    public Image getIcon() {
        return null;
    }

    public boolean setForeground(Color color) {
        this.colorFG = color;
        return true;
    }

    public boolean setForeground(int red, int green, int blue) {
        return false;
    }

    public void setRowForeground(Color color) {
    }

    public boolean setText(String text) {
        if (this.sText == null && text == null) {
            return false;
        }
        if (this.sText != null && text != null && (this.sText == text || this.sText.equals(text))) {
            return false;
        }
        this.sText = text;
        this.redrawCell();
        return true;
    }

    protected void redrawCell() {
        if (!this.isShown()) {
            return;
        }
    }

    public Image getBackgroundImage() {
        return null;
    }

    public Color getForeground() {
        if (this.colorFG == null) {
            return this.row.getForeground();
        }
        return this.colorFG;
    }

    public ListRow getRow() {
        return this.row;
    }

    public void setTableCell(TableCellCore cell) {
        this.cell = cell;
    }
}

