/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.list;

import com.aelitis.azureus.ui.swt.views.list.ListCell;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem;

public class ListCellGraphic
extends ListCell
implements BufferedGraphicTableItem {
    private int marginHeight = 1;
    private int marginWidth = 1;
    private int orientation = 0x1000000;
    private Image image;
    private Rectangle imageBounds;

    public ListCellGraphic(ListRow row, int position, int alignment, Rectangle bounds) {
        super(row, position, alignment, bounds);
    }

    public Image getGraphic() {
        return this.image;
    }

    public Point getSize() {
        return new Point(this.bounds.width - this.marginWidth * 2, this.bounds.height - this.marginHeight * 2);
    }

    public void invalidate() {
    }

    public boolean setGraphic(Image img) {
        if (img != null && img.isDisposed()) {
            return false;
        }
        this.image = img;
        if (this.image != null) {
            this.imageBounds = this.image.getBounds();
        }
        this.redrawCell();
        return true;
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public void setMargin(int width, int height) {
        if (width >= 0) {
            this.marginWidth = width;
        }
        if (height >= 0) {
            this.marginHeight = height;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public void doPaint(GC gc) {
        if (this.getPosition() < 0) {
            return;
        }
        if (this.image != null && !this.image.isDisposed()) {
            int x;
            Point size = this.getSize();
            int y = this.marginHeight;
            y += (size.y - this.imageBounds.height) / 2;
            if (this.orientation == 0x1000000) {
                x = this.marginWidth;
                x += (size.x - this.marginWidth * 2 - this.imageBounds.width) / 2;
            } else {
                x = this.orientation == 131072 ? this.bounds.height - this.marginWidth - this.imageBounds.width : this.marginWidth;
            }
            int width = Math.min(this.bounds.width - x - this.marginWidth, this.imageBounds.width);
            int height = Math.min(this.bounds.height - y - this.marginHeight, this.imageBounds.height);
            if (width >= 0 && height >= 0) {
                gc.drawImage(this.image, 0, 0, width, height, this.bounds.x + x, this.bounds.y + y, width, height);
            }
        }
    }
}

