/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.list;

import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.views.list.ListCell;
import com.aelitis.azureus.ui.swt.views.list.ListCellGraphic;
import com.aelitis.azureus.ui.swt.views.list.ListView;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerFileInfoImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;

public class ListRow
implements TableRowCore {
    public static int ROW_HEIGHT = 38;
    public static int MARGIN_HEIGHT = 2;
    public static int MARGIN_WIDTH = 3;
    private SWTSkinProperties skinProperties;
    private Object coreDataSource;
    private Object pluginDataSource;
    private Map mapTableCells;
    private boolean bDisposed;
    private boolean bSelected;
    private ListView view;
    private final Composite parent;
    private Color fg;
    private Color bg;
    private boolean bRowVisuallyChangedSinceRefresh;

    public ListRow(ListView view, Composite parent, Object datasource) {
        this.parent = parent;
        this.coreDataSource = datasource;
        this.view = view;
        this.pluginDataSource = null;
        this.bDisposed = false;
        this.bSelected = false;
        this.mapTableCells = new HashMap();
        this.skinProperties = view.getSkinProperties();
        TableColumnCore[] columns = view.getAllColumns();
        int iStartPos = MARGIN_WIDTH;
        for (int i = 0; i < columns.length; ++i) {
            TableColumnCore column = columns[i];
            boolean bVisible = column.getPosition() >= 0;
            Rectangle bounds = bVisible ? new Rectangle(iStartPos, MARGIN_HEIGHT, column.getWidth(), ROW_HEIGHT - MARGIN_HEIGHT * 2) : null;
            int iColumnPos = column.getPosition();
            ListCell listCell = column.getType() == 2 ? new ListCellGraphic(this, iColumnPos, column.getSWTAlign(), bounds) : new ListCell(this, iColumnPos, column.getSWTAlign(), bounds);
            if (bVisible) {
                iStartPos += bounds.width + MARGIN_WIDTH * 2;
            }
            TableCellImpl cell = new TableCellImpl(this, column, i, listCell);
            listCell.setTableCell(cell);
            cell.setUpToDate(false);
            this.mapTableCells.put(column.getName(), cell);
        }
    }

    protected void resizeRow(Rectangle bounds) {
        if (this.bDisposed) {
            return;
        }
        long lTimeStart = System.currentTimeMillis();
        Iterator iter = this.mapTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore item = (TableCellCore)iter.next();
            ListCell cell = (ListCell)item.getBufferedTableItem();
            Rectangle cellBounds = cell.getBounds();
            if (cellBounds == null || cell.getPosition() < 0) continue;
            cellBounds.height = bounds.height - MARGIN_HEIGHT * 2;
            cell.setBounds(cellBounds);
        }
        long diff = System.currentTimeMillis() - lTimeStart;
        if (diff >= 50L) {
            System.out.println("resizeRow: " + diff + "ms");
        }
    }

    private void checkCellForSetting() {
        if (this.bDisposed) {
            throw new UIRuntimeException("ListRow is disposed.");
        }
    }

    private void setBackgroundColor(int iPosition) {
        boolean bOdd;
        this.checkCellForSetting();
        boolean bl = bOdd = (iPosition + 1) % 2 == 0;
        if (this.bSelected) {
            String sColorID = bOdd ? "color.row.odd.selected.bg" : "color.row.even.selected.bg";
            Color color = this.skinProperties.getColor(sColorID);
            this.bg = color != null ? color : this.parent.getDisplay().getSystemColor(26);
            sColorID = bOdd ? "color.row.odd.selected.fg" : "color.row.even.selected.fg";
            Color cText = this.skinProperties.getColor(sColorID);
            if (cText == null && (cText = this.skinProperties.getColor(sColorID = bOdd ? "color.row.odd.fg" : "color.row.even.fg")) == null) {
                cText = this.parent.getDisplay().getSystemColor(27);
            }
            this.fg = cText;
            this.bRowVisuallyChangedSinceRefresh = true;
            this.invalidate();
            if (this.isVisible()) {
                this.repaint();
            }
        } else {
            String sColorID;
            boolean bChanged = false;
            if (this.skinProperties != null) {
                sColorID = bOdd ? "color.row.odd.bg" : "color.row.even.bg";
                Color color = this.skinProperties.getColor(sColorID);
                if (color != null && !this.colorsEqual(color, this.bg)) {
                    bChanged = true;
                    this.bg = color;
                }
            } else {
                Color oldColor = this.bg;
                this.bg = this.parent.getBackground();
                if (!this.colorsEqual(oldColor, this.bg)) {
                    bChanged = true;
                }
            }
            sColorID = bOdd ? "color.row.odd.fg" : "color.row.even.fg";
            Color cText = this.skinProperties.getColor(sColorID);
            if (cText == null) {
                cText = this.parent.getDisplay().getSystemColor(27);
            }
            if (!this.colorsEqual(cText, this.fg)) {
                bChanged = true;
                this.fg = cText;
            }
            if (bChanged) {
                this.bRowVisuallyChangedSinceRefresh = true;
                this.invalidate();
                if (this.isVisible()) {
                    this.repaint();
                }
            }
        }
    }

    private boolean colorsEqual(Color color1, Color color2) {
        if (color1 == color2) {
            return true;
        }
        if (color1 == null || color2 == null) {
            return false;
        }
        return color1.equals((Object)color2);
    }

    private Color getAlternatingColor() {
        String sColorID;
        Color color;
        boolean bOdd;
        boolean bl = bOdd = (this.getIndex() + 1) % 2 == 0;
        if (this.skinProperties != null && (color = this.skinProperties.getColor(sColorID = bOdd ? "color.row.odd.bg" : "color.row.even.bg")) != null) {
            return color;
        }
        return this.parent.getBackground();
    }

    public void delete(boolean bDeleteSWTObject) {
        int iIndex = this.getIndex();
        this.bDisposed = true;
        long lTimeStart = System.currentTimeMillis();
        Iterator iter = this.mapTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore item = (TableCellCore)iter.next();
            try {
                item.dispose();
            }
            catch (Exception e) {
                Debug.out("Disposing ListRow Column", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPaint(GC gc, boolean bVisible) {
        if (this.bDisposed || !bVisible) {
            return;
        }
        long lTimeStart = System.currentTimeMillis();
        Rectangle oldClipping = gc.getClipping();
        try {
            gc.setForeground(this.getForeground());
            gc.setBackground(this.getBackground());
            Rectangle clientArea = this.view.getClientArea();
            gc.fillRectangle(0, this.view.rowGetVisibleYOffset(this), clientArea.width, ROW_HEIGHT);
            Iterator iter = this.mapTableCells.values().iterator();
            while (iter.hasNext()) {
                TableCellCore cell = (TableCellCore)iter.next();
                try {
                    Rectangle bounds;
                    if (!cell.needsPainting() || (bounds = cell.getBounds()) == null) continue;
                    Rectangle clipping = bounds.intersection(oldClipping);
                    gc.setClipping(clipping);
                    cell.doPaint(gc);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
        finally {
            gc.setClipping(oldClipping);
        }
        long diff = System.currentTimeMillis() - lTimeStart;
        if (diff > 30L) {
            System.out.println("doPaint: " + this.view.getTableID() + ": " + diff + "ms");
        }
    }

    public Object getDataSource(boolean bCoreObject) {
        TRHostTorrent item;
        DiskManagerFileInfo fileInfo2;
        PEPiece piece;
        PEPeer peer;
        DownloadManager dm;
        this.checkCellForSetting();
        if (bCoreObject) {
            return this.coreDataSource;
        }
        if (this.pluginDataSource != null) {
            return this.pluginDataSource;
        }
        if (this.coreDataSource instanceof DownloadManager && (dm = (DownloadManager)this.coreDataSource) != null) {
            try {
                this.pluginDataSource = DownloadManagerImpl.getDownloadStatic(dm);
            }
            catch (DownloadException e) {
                // empty catch block
            }
        }
        if (this.coreDataSource instanceof PEPeer && (peer = (PEPeer)this.coreDataSource) != null) {
            this.pluginDataSource = PeerManagerImpl.getPeerForPEPeer(peer);
        }
        if (this.coreDataSource instanceof PEPiece && (piece = (PEPiece)this.coreDataSource) != null) {
            this.pluginDataSource = null;
        }
        if (this.coreDataSource instanceof DiskManagerFileInfo && (fileInfo2 = (DiskManagerFileInfo)this.coreDataSource) != null) {
            try {
                this.pluginDataSource = new DiskManagerFileInfoImpl(DownloadManagerImpl.getDownloadStatic(fileInfo2.getDownloadManager()), fileInfo2);
            }
            catch (DownloadException downloadException) {
                // empty catch block
            }
        }
        if (this.coreDataSource instanceof TRHostTorrent && (item = (TRHostTorrent)this.coreDataSource) != null) {
            this.pluginDataSource = new TrackerTorrentImpl(item);
        }
        return this.pluginDataSource;
    }

    public Color getForeground() {
        if (this.fg == null) {
            this.setBackgroundColor(this.getIndex());
        }
        return this.fg;
    }

    public int getIndex() {
        return this.view.indexOf(this);
    }

    public TableCellCore getTableCellCore(String field) {
        if (this.bDisposed) {
            return null;
        }
        return (TableCellCore)this.mapTableCells.get(field);
    }

    public void invalidate() {
        if (this.bDisposed) {
            return;
        }
        long lTimeStart = System.currentTimeMillis();
        Iterator iter = this.mapTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore cell = (TableCellCore)iter.next();
            if (cell == null) continue;
            cell.invalidate(true);
        }
        long diff = System.currentTimeMillis() - lTimeStart;
        if (diff >= 10L) {
            System.out.println("invalidate: " + diff + "ms");
        }
    }

    public boolean isRowDisposed() {
        return this.bDisposed;
    }

    public boolean isSelected() {
        return this.bSelected;
    }

    public boolean isVisible() {
        return this.view.isRowVisible(this);
    }

    public void locationChanged(int iStartColumn) {
    }

    public boolean refresh(boolean bDoGraphics) {
        if (this.bDisposed) {
            return false;
        }
        boolean bVisible = this.isVisible();
        return this.refresh(bDoGraphics, bVisible);
    }

    public boolean refresh(boolean bDoGraphics, boolean bVisible) {
        if (!bVisible) {
            this.setUpToDate(false);
            return false;
        }
        boolean changed = false;
        Iterator iter = this.mapTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore item = (TableCellCore)iter.next();
            changed |= item.refresh(bDoGraphics, bVisible);
        }
        this.bRowVisuallyChangedSinceRefresh = false;
        return changed |= this.bRowVisuallyChangedSinceRefresh;
    }

    public void setForeground(Color c) {
        Iterator iter = this.mapTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore item = (TableCellCore)iter.next();
            item.setForeground(c);
        }
    }

    public boolean setHeight(int iHeight) {
        this.bRowVisuallyChangedSinceRefresh = true;
        return false;
    }

    public boolean setIconSize(Point pt) {
        this.bRowVisuallyChangedSinceRefresh = true;
        return false;
    }

    public void setSelected(boolean bSelected) {
        if (this.bSelected == bSelected) {
            return;
        }
        this.bSelected = bSelected;
        this.setBackgroundColor(this.getIndex());
        this.view.rowSetSelected(this, bSelected);
    }

    public void setFocused(boolean b) {
        if (b) {
            this.view.rowSetFocused(this);
        } else if (this.isFocused()) {
            this.view.rowSetFocused(null);
        }
    }

    public boolean isFocused() {
        return this.equals(this.view.getRowFocused());
    }

    public boolean setTableItem(int iRowPos) {
        if (!this.fixupPosition()) {
            return false;
        }
        ListRow row = this.view.getRow(iRowPos + 1);
        if (row != null) {
            row.fixupPosition();
        }
        this.bRowVisuallyChangedSinceRefresh = true;
        return true;
    }

    public boolean fixupPosition() {
        int iRowPos = this.getIndex();
        this.setBackgroundColor(iRowPos);
        return this.parent != null && !this.parent.isDisposed();
    }

    public void setUpToDate(boolean upToDate) {
        if (this.bDisposed) {
            return;
        }
        long lTimeStart = System.currentTimeMillis();
        Iterator iter = this.mapTableCells.values().iterator();
        while (iter.hasNext()) {
            boolean bOldUpToDate;
            TableCellCore cell = (TableCellCore)iter.next();
            if (cell == null || (bOldUpToDate = cell.isUpToDate()) == upToDate) continue;
            cell.setUpToDate(upToDate);
            ListCell listcell = (ListCell)cell.getBufferedTableItem();
            listcell.isShown();
        }
        long diff = System.currentTimeMillis() - lTimeStart;
        if (diff >= 50L) {
            System.out.println("sutd: " + upToDate + " for " + this.getIndex() + "; " + diff + "ms");
        }
    }

    public Object getDataSource() {
        return this.getDataSource(false);
    }

    public TableCell getTableCell(String sColumnName) {
        return null;
    }

    public String getTableID() {
        return null;
    }

    public boolean isValid() {
        if (this.bDisposed) {
            return true;
        }
        boolean valid = true;
        Iterator iter = this.mapTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore cell = (TableCellCore)iter.next();
            if (cell == null) continue;
            valid &= cell.isValid();
        }
        return valid;
    }

    public boolean getVisuallyChangedSinceLastRefresh() {
        if (this.bDisposed) {
            return true;
        }
        if (this.bRowVisuallyChangedSinceRefresh) {
            return true;
        }
        Iterator iter = this.mapTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore cell = (TableCellCore)iter.next();
            if (cell == null || !cell.getVisuallyChangedSinceRefresh()) continue;
            return true;
        }
        return false;
    }

    public Color getBackground() {
        if (this.bg == null) {
            this.setBackgroundColor(this.getIndex());
        }
        return this.bg;
    }

    public TableCellCore getTableCellCore(int x, int y) {
        Iterator iter = this.mapTableCells.values().iterator();
        while (iter.hasNext()) {
            Rectangle bounds;
            TableCellCore cell = (TableCellCore)iter.next();
            if (!cell.isShown() || (bounds = cell.getBounds()) == null || !bounds.contains(x, bounds.y)) continue;
            return cell;
        }
        return null;
    }

    public ListView getView() {
        return this.view;
    }

    public void redraw(boolean bDoGraphics) {
        this.view.rowRefresh(this, bDoGraphics, true);
    }

    public void setAlternatingBGColor(boolean bEvenIfNotVisible) {
        this.setBackgroundColor(this.getIndex());
    }

    public void doPaint(GC gc) {
        this.doPaint(gc, this.isVisible());
    }

    public void repaint() {
        this.redraw(true);
    }

    public String toString() {
        return "ListRow {" + this.getIndex() + (this.bDisposed ? ", Disposed" : "") + "," + this.view.getTableID() + "}";
    }

    public int getVisibleYOffset() {
        return this.view.rowGetVisibleYOffset(this);
    }
}

