/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.list;

import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.ui.swt.utils.UIUpdatable;
import com.aelitis.azureus.ui.swt.utils.UIUpdaterFactory;
import com.aelitis.azureus.ui.swt.views.list.ListCell;
import com.aelitis.azureus.ui.swt.views.list.ListCountChangeAdapter;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.list.ListSelectionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.TableView;
import org.gudy.azureus2.ui.swt.views.table.ITableStructureModificationListener;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.views.table.utils.TableStructureEventDispatcher;

public abstract class ListView
implements UIUpdatable,
Listener,
ITableStructureModificationListener {
    private static final LogIDs LOGID = LogIDs.UI3;
    private static final boolean DEBUGADDREMOVE = false;
    private static final ConfigurationManager configMan = ConfigurationManager.getInstance();
    private static final String CFG_SORTDIRECTION = "config.style.table.defaultSortOrder";
    private static final boolean DEBUG_SORTER = false;
    protected static final boolean DELAY_SCROLL = false;
    private Canvas listCanvas;
    private final SWTSkinProperties skinProperties;
    private TableColumnCore[] visibleColumns;
    private ArrayList selectedRows = new ArrayList();
    private AEMonitor selectedRows_mon = new AEMonitor("ListView:SR");
    private ArrayList rows = new ArrayList();
    private Map mapDataSourceToRow = new HashMap();
    private AEMonitor row_mon = new AEMonitor("ListView:OTSI");
    private ListRow rowFocused = null;
    private final String sTableID;
    private List dataSourcesToAdd = new ArrayList(4);
    private List dataSourcesToRemove = new ArrayList(4);
    private long lCancelSelectionTriggeredOn = -1L;
    private List listenersSelection = new ArrayList();
    private List listenersCountChange = new ArrayList();
    private boolean bMouseClickIsDefaultSelection = false;
    private int iGraphicRefresh;
    protected int graphicsUpdate;
    private TableColumnCore sortColumn;
    private long lLastSortedOn;
    private Composite headerArea;
    private TableColumnCore[] allColumns;
    private ScrollBar vBar;
    private Image imageView = null;
    private int iLastVBarPos;
    protected boolean bRestartRefreshVisible = false;
    private boolean bInRefreshVisible;

    public ListView(String sTableID, SWTSkinProperties skinProperties, Composite parent) {
        this.skinProperties = skinProperties;
        this.sTableID = sTableID;
        COConfigurationManager.addAndFireParameterListener("Graphics Update", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                ListView.this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
            }
        });
        parent.setBackgroundMode(2);
        this.listCanvas = new Canvas(parent, 1311232);
        this.listCanvas.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        this.listCanvas.setLayoutData((Object)formData);
        this.vBar = this.listCanvas.getVerticalBar();
        this.vBar.addListener(13, new Listener(){
            private TimerEvent event;

            public void handleEvent(Event e) {
                ListView.this.scrollTo(ListView.this.vBar.getSelection());
            }
        });
        this.vBar.setVisible(false);
        this.listCanvas.addListener(11, new Listener(){
            int w;
            {
                this.w = ((ListView)ListView.this).listCanvas.getSize().x;
            }

            public void handleEvent(Event e) {
                ListView.this.refreshScrollbar();
                int nw = ((ListView)ListView.this).listCanvas.getSize().x;
                if (this.w != nw) {
                    this.w = nw;
                    ListView.this.listCanvas.redraw();
                }
            }
        });
        this.listCanvas.addListener(9, new Listener(){
            Rectangle lastBounds = new Rectangle(0, 0, 0, 0);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void handleEvent(Event e) {
                bNeedsRefresh = false;
                clientArea = ListView.access$200(ListView.this).getClientArea();
                if (ListView.access$300(ListView.this) == null) {
                    ListView.access$302(ListView.this, new Image(e.gc.getDevice(), clientArea));
                    bNeedsRefresh = true;
                    e.setBounds(clientArea);
                } else if (!this.lastBounds.equals((Object)clientArea)) {
                    bNeedsRefresh = true;
                    newImageView = new Image(e.gc.getDevice(), clientArea);
                    if (this.lastBounds.width == clientArea.width) {
                        gc = null;
                        try {
                            gc = new GC((Drawable)newImageView);
                            gc.drawImage(ListView.access$300(ListView.this), 0, 0);
                        }
                        catch (Exception ex) {
                            if (ex instanceof IllegalArgumentException) ** GOTO lbl27
                            Debug.out(ex);
                        }
                        finally {
                            if (gc != null) {
                                gc.dispose();
                            }
                        }
                    } else {
                        e.setBounds(clientArea);
                    }
lbl27:
                    // 4 sources

                    ListView.access$300(ListView.this).dispose();
                    ListView.access$302(ListView.this, newImageView);
                }
                if (bNeedsRefresh) {
                    this.lastBounds = clientArea;
                    gc = null;
                    try {
                        gc = new GC((Drawable)ListView.access$300(ListView.this));
                        gc.setForeground(ListView.access$200(ListView.this).getForeground());
                        gc.setBackground(ListView.access$200(ListView.this).getBackground());
                        visibleRows = ListView.this.getVisibleRows();
                        if (visibleRows.length > 0) {
                            ofs = ListView.access$500(ListView.this, ListView.access$400(ListView.this));
                            start = e.y / ListRow.ROW_HEIGHT;
                            end = (e.y + e.height) / ListRow.ROW_HEIGHT + 1;
                            if (end > visibleRows.length) {
                                end = visibleRows.length;
                            }
                            lStart = System.currentTimeMillis();
                            for (i = start; i < end; ++i) {
                                row = visibleRows[i];
                                row.doPaint(gc, true);
                            }
                            endY = visibleRows.length * ListRow.ROW_HEIGHT + ofs;
                            if (endY < clientArea.height) {
                                gc.setBackground(ListView.access$200(ListView.this).getBackground());
                                gc.fillRectangle(0, endY, clientArea.width, clientArea.height - endY);
                            }
                            if ((diff = System.currentTimeMillis() - lStart) > 30L) {
                                System.out.println(diff + "ms to paint" + start + " - " + (end - 1));
                            }
                        } else {
                            gc.fillRectangle(clientArea);
                        }
                    }
                    catch (Exception ex) {
                        if (!(ex instanceof IllegalArgumentException)) {
                            Debug.out(ex);
                        }
                    }
                    finally {
                        if (gc != null) {
                            gc.dispose();
                        }
                    }
                }
                e.gc.drawImage(ListView.access$300(ListView.this), e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
            }
        });
        selectionListener l = new selectionListener();
        this.listCanvas.addListener(3, (Listener)l);
        this.listCanvas.addListener(4, (Listener)l);
        this.listCanvas.addListener(8, (Listener)this);
        this.listCanvas.addListener(15, (Listener)this);
        this.listCanvas.addListener(16, (Listener)this);
        this.listCanvas.addListener(31, (Listener)this);
        this.listCanvas.addListener(14, (Listener)this);
        this.listCanvas.addListener(1, (Listener)this);
        this.listCanvas.setMenu(this.createMenu());
        UIUpdaterFactory.getInstance().addUpdater(this);
        TableStructureEventDispatcher.getInstance(sTableID).addListener(this);
    }

    private int getOffset(int i) {
        int ofs = i % ListRow.ROW_HEIGHT;
        if (ofs == 0) {
            return 0;
        }
        return ofs;
    }

    protected void refreshScrollbar() {
        Rectangle client = this.listCanvas.getClientArea();
        int h = this.rows.size() * ListRow.ROW_HEIGHT - client.height;
        if (h <= 0 || client.height == 0) {
            if (this.vBar.isVisible()) {
                this.vBar.setVisible(false);
                this.listCanvas.redraw();
                this.headerArea.redraw();
            }
            this.iLastVBarPos = 0;
        } else {
            if (!this.vBar.isVisible()) {
                this.vBar.setVisible(true);
                this.listCanvas.redraw();
                this.headerArea.redraw();
            }
            this.vBar.setIncrement(ListRow.ROW_HEIGHT);
            this.vBar.setMaximum(h);
            this.vBar.setThumb(1);
            this.vBar.setPageIncrement(client.height / 2);
            if (this.iLastVBarPos != this.vBar.getSelection()) {
                this.scrollTo(this.vBar.getSelection());
            } else {
                this.listCanvas.redraw();
                this.refreshVisible(true, true);
            }
        }
    }

    private void scrollTo(int pos) {
        if (!this.vBar.getVisible()) {
            return;
        }
        if (pos == this.iLastVBarPos && pos == this.vBar.getSelection()) {
            return;
        }
        if (pos < 0) {
            System.err.println("scrollto " + pos + " via " + Debug.getCompressedStackTrace());
            pos = 0;
        }
        if (pos != this.vBar.getSelection()) {
            this.vBar.setSelection(pos);
        }
        this.iLastVBarPos = this.vBar.getSelection();
        this.listCanvas.redraw();
        this.refreshVisible(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupHeader(final Composite headerArea) {
        this.headerArea = headerArea;
        final Cursor cursor = new Cursor((Device)headerArea.getDisplay(), 21);
        headerArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Utils.disposeSWTObjects(new Object[]{cursor});
            }
        });
        Label lblCenterer = new Label(headerArea, 64);
        FormData formData = new FormData(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        lblCenterer.setLayoutData((Object)formData);
        ImageLoader imgLoader = ImageLoaderFactory.getInstance();
        final Image imgSortAsc = imgLoader.getImage("image.sort.asc");
        final Image imgSortDesc = imgLoader.getImage("image.sort.desc");
        int sortWidth = Math.max(imgSortAsc.getBounds().width, imgSortDesc.getBounds().width) + 2;
        GC gc = new GC((Drawable)headerArea);
        try {
            TableColumnCore[] columns = this.getVisibleColumns();
            for (int i = 0; i < columns.length; ++i) {
                TableColumnCore column = columns[i];
                String title = MessageText.getString(column.getTitleLanguageKey(), "");
                int minWidth = gc.textExtent((String)title).x + sortWidth;
                int oldWidth = column.getWidth();
                if (minWidth <= oldWidth) continue;
                column.setWidth(minWidth);
            }
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        headerArea.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                TableColumnCore[] columns = ListView.this.getVisibleColumns();
                int inColumn = -1;
                for (int i = 0; i < columns.length; ++i) {
                    Rectangle bounds = (Rectangle)headerArea.getData("Column" + i + "Bounds");
                    if (bounds == null || !bounds.contains(e.x, e.y)) continue;
                    inColumn = i;
                    break;
                }
                if (inColumn != -1) {
                    ListView.this.setSortColumn(columns[inColumn]);
                    System.out.println("sorting on " + columns[inColumn].getName());
                }
            }
        });
        headerArea.addMouseMoveListener(new MouseMoveListener(){
            Cursor cursor = null;

            public void mouseMove(MouseEvent e) {
                Cursor newCursor;
                TableColumnCore[] columns = ListView.this.getVisibleColumns();
                int inColumn = -1;
                for (int i = 0; i < columns.length; ++i) {
                    Rectangle bounds = (Rectangle)headerArea.getData("Column" + i + "Bounds");
                    if (bounds == null || !bounds.contains(e.x, e.y)) continue;
                    inColumn = i;
                    break;
                }
                Cursor cursor = newCursor = inColumn != -1 ? this.cursor : null;
                if (this.cursor != newCursor) {
                    headerArea.setCursor(newCursor);
                    this.cursor = newCursor;
                }
            }
        });
        headerArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TableColumnCore[] columns = ListView.this.getVisibleColumns();
                e.gc.setForeground(ListView.this.skinProperties.getColor("color.list.header.fg"));
                Rectangle clientArea = headerArea.getClientArea();
                int pos = clientArea.x + ListRow.MARGIN_WIDTH;
                for (int i = 0; i < columns.length; ++i) {
                    int width = columns[i].getWidth();
                    String key = columns[i].getTitleLanguageKey();
                    String text = MessageText.getString(key, "");
                    int align = columns[i].getSWTAlign();
                    int drawWidth = width;
                    if (columns[i].equals(ListView.this.sortColumn)) {
                        Image img = ListView.this.sortColumn.isSortAscending() ? imgSortAsc : imgSortDesc;
                        Rectangle bounds = img.getBounds();
                        if (align == 131072) {
                            e.gc.drawImage(img, pos + width - bounds.width, clientArea.height - bounds.height);
                            drawWidth -= bounds.width + 2;
                        } else {
                            e.gc.drawImage(img, pos, clientArea.height - bounds.height);
                            if (align == 0x1000000) {
                                int adj = bounds.width / 2 + 1;
                                pos += adj;
                                width -= adj;
                            } else {
                                pos += bounds.width + 2;
                                width -= bounds.width + 2;
                            }
                            drawWidth = width;
                        }
                    }
                    Rectangle bounds = new Rectangle(pos, clientArea.y, drawWidth, clientArea.height);
                    headerArea.setData("Column" + i + "Bounds", (Object)bounds);
                    if (text.length() > 0) {
                        GCStringPrinter.printString(e.gc, text, bounds, false, false, align);
                    }
                    pos += width + ListRow.MARGIN_WIDTH * 2;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveFocus(int relative, boolean moveall) {
        if (moveall) {
            System.err.println("moveall not supported " + Debug.getCompressedStackTrace());
        }
        this.selectedRows_mon.enter();
        try {
            if (this.selectedRows.size() == 0) {
                return;
            }
            ListRow firstRow = (ListRow)this.selectedRows.get(0);
            int index = this.indexOf(firstRow) + relative;
            if (index < 0) {
                index = 0;
            }
            if (index >= this.rows.size()) {
                if (index == 0) {
                    return;
                }
                index = this.rows.size() - 1;
            }
            ListRow newRow = (ListRow)this.rows.get(index);
            this.setSelectedRows(new ListRow[]{newRow});
        }
        finally {
            this.selectedRows_mon.exit();
        }
    }

    public void refreshVisible(final boolean doGraphics, final boolean bForceRedraw) {
        if (this.bInRefreshVisible) {
            this.bRestartRefreshVisible = true;
            return;
        }
        this.bInRefreshVisible = true;
        final Display display = this.listCanvas.getDisplay();
        display.asyncExec((Runnable)new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                TableRowCore[] visibleRows = ListView.this.getVisibleRows();
                try {
                    for (int i = 0; i < visibleRows.length; ++i) {
                        if (ListView.this.bRestartRefreshVisible) {
                            return;
                        }
                        final ListRow row = (ListRow)visibleRows[i];
                        if (bForceRedraw) {
                            row.invalidate();
                        }
                        display.asyncExec((Runnable)new AERunnable(){

                            public void runSupport() {
                                if ((this).ListView.this.bRestartRefreshVisible) {
                                    return;
                                }
                                if (!row.isVisible() || ListView.this.rowRefresh(row, doGraphics, bForceRedraw)) {
                                    // empty if block
                                }
                            }
                        });
                    }
                }
                finally {
                    ListView.this.bInRefreshVisible = false;
                    if (ListView.this.bRestartRefreshVisible) {
                        ListView.this.bRestartRefreshVisible = false;
                        ListView.this.refreshVisible(doGraphics, bForceRedraw);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataSourceQueue() {
        int i;
        Object[] dataSourcesAdd = null;
        Object[] dataSourcesRemove = null;
        try {
            this.row_mon.enter();
            if (this.dataSourcesToAdd.size() > 0) {
                dataSourcesAdd = this.dataSourcesToAdd.toArray();
                this.dataSourcesToAdd.clear();
                if (this.dataSourcesToRemove != null && this.dataSourcesToRemove.size() > 0) {
                    for (i = 0; i < dataSourcesAdd.length; ++i) {
                        if (!this.dataSourcesToRemove.contains(dataSourcesAdd[i])) continue;
                        this.dataSourcesToRemove.remove(dataSourcesAdd[i]);
                        dataSourcesAdd[i] = null;
                    }
                }
            }
            if (this.dataSourcesToRemove != null && this.dataSourcesToRemove.size() > 0) {
                dataSourcesRemove = this.dataSourcesToRemove.toArray();
                this.dataSourcesToRemove.clear();
            }
        }
        finally {
            this.row_mon.exit();
        }
        if (dataSourcesAdd != null) {
            this.addDataSources(dataSourcesAdd, true);
        }
        if (dataSourcesRemove != null) {
            for (i = 0; i < dataSourcesRemove.length; ++i) {
                Object ds = dataSourcesRemove[i];
                this.removeDataSource(ds, true);
            }
        }
    }

    public void addDataSource(Object datasource, boolean bImmediate) {
        this.addDataSources(new Object[]{datasource}, bImmediate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSources(final Object[] dataSources, boolean bImmediate) {
        long lTimeStart = System.currentTimeMillis();
        if (dataSources == null) {
            return;
        }
        if (!bImmediate) {
            try {
                this.row_mon.enter();
                if (this.dataSourcesToAdd == null) {
                    this.dataSourcesToAdd = new ArrayList(4);
                }
                for (int i = 0; i < dataSources.length; ++i) {
                    if (this.mapDataSourceToRow.containsKey(dataSources[i])) continue;
                    this.dataSourcesToAdd.add(dataSources[i]);
                }
                return;
            }
            finally {
                this.row_mon.exit();
            }
        }
        Utils.execSWTThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int i;
                int iFirstChange = -1;
                try {
                    ListView.this.row_mon.enter();
                    for (i = 0; i < dataSources.length; ++i) {
                        int index;
                        TableCellCore cell;
                        Object datasource = dataSources[i];
                        if (datasource == null || ListView.this.mapDataSourceToRow.containsKey(datasource)) continue;
                        ListRow row = new ListRow(ListView.this, (Composite)ListView.this.listCanvas, datasource);
                        if (ListView.this.sortColumn != null && (cell = row.getTableCellCore(ListView.this.sortColumn.getName())) != null) {
                            try {
                                cell.invalidate();
                                cell.refresh(true);
                            }
                            catch (Exception e) {
                                Logger.log(new LogEvent(LOGID, "Minor error adding a row to table " + ListView.this.sTableID, e));
                            }
                        }
                        if (ListView.this.rows.size() > 0 && ListView.this.sortColumn.compare(row, ListView.this.rows.get(ListView.this.rows.size() - 1)) >= 0) {
                            index = ListView.this.rows.size();
                        } else {
                            index = Collections.binarySearch(ListView.this.rows, row, ListView.this.sortColumn);
                            if (index < 0) {
                                index = -1 * index - 1;
                            }
                            if (index > ListView.this.rows.size()) {
                                index = ListView.this.rows.size();
                            }
                        }
                        if (iFirstChange < 0 || iFirstChange > index) {
                            iFirstChange = index;
                        }
                        ListView.this.rows.add(index, row);
                        ListView.this.log("addDS pos " + index);
                        ListView.this.mapDataSourceToRow.put(datasource, row);
                        ListView.this.triggerListenerRowAdded(row);
                    }
                }
                finally {
                    ListView.this.row_mon.exit();
                    if (iFirstChange >= 0) {
                        for (i = iFirstChange; i < ListView.this.rows.size(); ++i) {
                            ListRow row = (ListRow)ListView.this.rows.get(i);
                            row.fixupPosition();
                        }
                    }
                    ListView.this.refreshScrollbar();
                    ListView.this.refreshVisible(true, true);
                }
            }
        });
        long diff = System.currentTimeMillis() - lTimeStart;
        if (diff > 20L) {
            System.out.println("addDS(" + dataSources.length + "): " + diff + "ms");
        }
    }

    protected void log(String string) {
    }

    public void removeDataSource(final Object datasource, boolean bImmediate) {
        Utils.execSWTThread(new Runnable(){

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 49[SIMPLE_IF_TAKEN]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    public void removeAllDataSources(boolean bImmediate) {
        Utils.execSWTThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ListView.this.row_mon.enter();
                ListView.this.log("removeAll");
                try {
                    Iterator iterator = ListView.this.mapDataSourceToRow.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object datasource = iterator.next();
                        ListRow row = (ListRow)ListView.this.mapDataSourceToRow.get(datasource);
                        if (row == null) continue;
                        ListView.this.rows.remove(row);
                        row.setSelected(false);
                        row.setFocused(false);
                        row.delete(false);
                    }
                    ListView.this.mapDataSourceToRow.clear();
                    ListView.this.rows.clear();
                }
                finally {
                    ListView.this.row_mon.exit();
                }
            }
        }, !bImmediate);
    }

    private void addListenerAndChildren(Composite composite, int eventType, Listener listener) {
        composite.addListener(eventType, listener);
        Control[] children = composite.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            child.addListener(eventType, listener);
            if (!(child instanceof Composite)) continue;
            this.addListenerAndChildren((Composite)child, eventType, listener);
        }
    }

    public ListRow getRow(int x, int y) {
        int pos = (y + this.iLastVBarPos) / ListRow.ROW_HEIGHT;
        if (pos < this.rows.size() && pos >= 0) {
            ListRow row = (ListRow)this.rows.get(pos);
            return row;
        }
        return null;
    }

    public int indexOf(ListRow row) {
        return this.rows.indexOf(row);
    }

    public int size(boolean bIncludeQueue) {
        int size = this.rows.size();
        if (bIncludeQueue) {
            if (this.dataSourcesToAdd != null) {
                size += this.dataSourcesToAdd.size();
            }
            if (this.dataSourcesToRemove != null) {
                size += this.dataSourcesToRemove.size();
            }
        }
        return size;
    }

    public ListRow getRow(int i) {
        if (i < 0 || i >= this.rows.size()) {
            return null;
        }
        return (ListRow)this.rows.get(i);
    }

    public ListRow getRow(Object dataSource) {
        return (ListRow)this.mapDataSourceToRow.get(dataSource);
    }

    public List getSelectedDataSourcesList() {
        return this.getSelectedDataSourcesList(true);
    }

    public List getSelectedDataSourcesList(boolean bCoreDataSource) {
        ArrayList<Object> l = new ArrayList<Object>();
        ListRow[] selectedRows = this.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            ListRow row = selectedRows[i];
            if (row == null) continue;
            l.add(row.getDataSource(bCoreDataSource));
        }
        return l;
    }

    public Object[] getSelectedDataSources() {
        return this.getSelectedDataSourcesList().toArray();
    }

    public Object[] getSelectedDataSources(boolean bCoreDataSource) {
        return this.getSelectedDataSourcesList(bCoreDataSource).toArray();
    }

    public boolean dataSourceExists(Object dataSource) {
        return this.mapDataSourceToRow.containsKey(dataSource) || this.dataSourcesToAdd.contains(dataSource);
    }

    public SWTSkinProperties getSkinProperties() {
        return this.skinProperties;
    }

    public TableColumnCore[] getVisibleColumns() {
        if (this.visibleColumns == null) {
            return new TableColumnCore[0];
        }
        return this.visibleColumns;
    }

    public void updateColumnList(TableColumnCore[] columns, String defaultSortColumnID) {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        if (tcManager.getTableColumnCount(this.sTableID) != columns.length) {
            for (int i = 0; i < columns.length; ++i) {
                columns[i].setTableID(this.sTableID);
                tcManager.addColumn(columns[i]);
            }
        }
        tcManager.ensureIntegrety(this.sTableID);
        this.allColumns = columns;
        ArrayList<TableColumnCore> visibleColumnsList = new ArrayList<TableColumnCore>();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getPosition() < 0) continue;
            visibleColumnsList.add(columns[i]);
        }
        this.visibleColumns = visibleColumnsList.toArray(new TableColumnCore[0]);
        String sSortColumn = defaultSortColumnID;
        boolean bSortAscending = false;
        TableColumnCore tc = tcManager.getTableColumnCore(this.sTableID, sSortColumn);
        if (tc == null) {
            tc = this.visibleColumns[0];
        }
        this.sortColumn = tc;
        this.sortColumn.setSortAscending(bSortAscending);
        this.changeColumnIndicator();
    }

    private void changeColumnIndicator() {
        if (this.headerArea != null && !this.headerArea.isDisposed()) {
            this.headerArea.redraw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListRow[] getSelectedRows() {
        this.selectedRows_mon.enter();
        try {
            ListRow[] rows = new ListRow[this.selectedRows.size()];
            ListRow[] listRowArray = rows = this.selectedRows.toArray(rows);
            return listRowArray;
        }
        finally {
            this.selectedRows_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedRows(ListRow[] rows) {
        this.selectedRows_mon.enter();
        try {
            ArrayList<ListRow> rowsToSelect = new ArrayList<ListRow>();
            for (int i = 0; i < rows.length; ++i) {
                rowsToSelect.add(rows[i]);
            }
            ListRow[] selectedRows = this.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                ListRow selectedRow = selectedRows[i];
                boolean bStillSelected = false;
                for (int j = 0; j < rows.length; ++j) {
                    ListRow row = rows[j];
                    if (!row.equals(selectedRow)) continue;
                    bStillSelected = true;
                    break;
                }
                if (!bStillSelected) {
                    selectedRow.setSelected(false);
                    continue;
                }
                rowsToSelect.remove(selectedRow);
            }
            Iterator iter = rowsToSelect.iterator();
            while (iter.hasNext()) {
                ListRow row = (ListRow)iter.next();
                row.setSelected(true);
            }
            if (rows.length > 0) {
                rows[0].setFocused(true);
            }
        }
        finally {
            this.selectedRows_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rowSetSelected(ListRow row, boolean bSelected) {
        if (row == null || this.selectedRows.indexOf(row) >= 0 == bSelected) {
            return;
        }
        this.selectedRows_mon.enter();
        try {
            if (bSelected) {
                this.selectedRows.add(row);
            } else {
                this.selectedRows.remove(row);
            }
        }
        finally {
            this.selectedRows_mon.exit();
        }
        Iterator iter = this.listenersSelection.iterator();
        while (iter.hasNext()) {
            ListSelectionAdapter l = (ListSelectionAdapter)iter.next();
            try {
                if (bSelected) {
                    l.selected(row);
                    continue;
                }
                l.deselected(row);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public ListRow getRowFocused() {
        return this.rowFocused;
    }

    protected void rowSetFocused(ListRow row) {
        if (row != null) {
            this.rowShow(row);
        }
        this.rowFocused = row;
        Iterator iter = this.listenersSelection.iterator();
        while (iter.hasNext()) {
            ListSelectionAdapter l = (ListSelectionAdapter)iter.next();
            try {
                l.focusChanged(row);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public boolean rowIsSelected(ListRow row) {
        this.selectedRows_mon.enter();
        return this.selectedRows.indexOf(row) >= 0;
    }

    public void rowShow(ListRow row) {
        int iFocusedIdx;
        if (row == null) {
            return;
        }
        Rectangle clientArea = this.listCanvas.getClientArea();
        int iBottomIndex = (this.iLastVBarPos + clientArea.height - 1) / ListRow.ROW_HEIGHT;
        int iTopIndex = this.iLastVBarPos / ListRow.ROW_HEIGHT;
        int size = iBottomIndex - iTopIndex + 1;
        if (size <= 0) {
            return;
        }
        int i = row.getIndex();
        if (i > iTopIndex && i < iBottomIndex) {
            return;
        }
        int myPos = (i - iTopIndex) * ListRow.ROW_HEIGHT;
        if (i == iTopIndex) {
            int ofs = this.getOffset(this.iLastVBarPos);
            if (ofs == 0) {
                return;
            }
            this.scrollTo(myPos);
            return;
        }
        if (i == iBottomIndex) {
            int ofs = this.getOffset(this.iLastVBarPos + clientArea.height);
            if (ofs == 0) {
                return;
            }
            this.scrollTo((iTopIndex + 1) * ListRow.ROW_HEIGHT);
            return;
        }
        int ofs = 0;
        ListRow rowFocused = this.getRowFocused();
        if (rowFocused != null && (iFocusedIdx = rowFocused.getIndex()) >= iTopIndex && iFocusedIdx <= iBottomIndex && (ofs = rowFocused.getIndex() * ListRow.ROW_HEIGHT - this.iLastVBarPos) < 0) {
            ofs = 0;
        }
        this.scrollTo(i * ListRow.ROW_HEIGHT - ofs);
    }

    public boolean isFocused() {
        return this.listCanvas.isFocusControl();
    }

    public String getUpdateUIName() {
        return "ListView";
    }

    public void updateUI() {
        if (this.listCanvas.isDisposed()) {
            return;
        }
        this.processDataSourceQueue();
        ++this.iGraphicRefresh;
        boolean bDoGraphics = this.iGraphicRefresh % this.graphicsUpdate == 0;
        this.refreshVisible(bDoGraphics, false);
        this.sortTable();
    }

    public Rectangle getBounds() {
        Rectangle clientArea = this.listCanvas.getClientArea();
        return new Rectangle(clientArea.x, -this.iLastVBarPos, clientArea.width, clientArea.height);
    }

    public Rectangle getClientArea() {
        return this.listCanvas.getClientArea();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEvent(Event event2) {
        if (event2.type == 15 || event2.type == 16) {
            this.selectedRows_mon.enter();
            try {
                Iterator iter = this.selectedRows.iterator();
                while (iter.hasNext()) {
                    ListRow row = (ListRow)iter.next();
                    if (row == null) continue;
                    row.repaint();
                }
                return;
            }
            finally {
                this.selectedRows_mon.exit();
            }
        } else if (event2.type == 31) {
            event2.doit = true;
            switch (event2.detail) {
                case 64: {
                    if ((event2.stateMask & SWT.MOD2) > 0) {
                        ListRow nextRow;
                        ListRow focusedRow = this.getRowFocused();
                        if (focusedRow == null) return;
                        int index = focusedRow.getIndex();
                        if ((nextRow = this.getRow(++index)) == null) return;
                        if (nextRow.isSelected()) {
                            focusedRow.setSelected(false);
                        }
                        nextRow.setSelected(true);
                        nextRow.setFocused(true);
                        return;
                    }
                    if ((event2.stateMask & SWT.MOD1) > 0) {
                        ListRow nextRow;
                        ListRow focusedRow = this.getRowFocused();
                        if (focusedRow == null) return;
                        int index = focusedRow.getIndex();
                        if ((nextRow = this.getRow(++index)) == null) return;
                        nextRow.setFocused(true);
                        return;
                    }
                    this.moveFocus(1, false);
                    return;
                }
                case 32: {
                    if ((event2.stateMask & SWT.MOD2) > 0) {
                        ListRow previousRow;
                        ListRow activeRow = this.getRowFocused();
                        if (activeRow == null) return;
                        int index = activeRow.getIndex();
                        if ((previousRow = this.getRow(--index)) == null) return;
                        if (previousRow.isSelected()) {
                            activeRow.setSelected(false);
                        }
                        previousRow.setSelected(true);
                        previousRow.setFocused(true);
                        return;
                    }
                    if ((event2.stateMask & SWT.MOD1) > 0) {
                        ListRow nextRow;
                        ListRow focusedRow = this.getRowFocused();
                        if (focusedRow == null) return;
                        int index = focusedRow.getIndex();
                        if ((nextRow = this.getRow(--index)) == null) return;
                        nextRow.setFocused(true);
                        return;
                    }
                    this.moveFocus(-1, false);
                    return;
                }
                case 4: {
                    this._runDefaultAction();
                    return;
                }
                default: {
                    System.out.println("TR" + event2.detail);
                    return;
                }
            }
        } else if (event2.type == 1) {
            int key = event2.character;
            if (key <= 26 && key > 0) {
                key += 96;
            }
            if (event2.stateMask == SWT.MOD1) {
                switch (event2.keyCode) {
                    case 97: {
                        this.setSelectedRows(this.getRowsUnsorted());
                        return;
                    }
                    case 32: {
                        event2.doit = false;
                        ListRow focusedRow = this.getRowFocused();
                        if (focusedRow == null) return;
                        focusedRow.setSelected(!focusedRow.isSelected());
                    }
                }
                return;
            } else {
                switch (event2.keyCode) {
                    case 0x1000005: {
                        this.moveFocus(this.getClientArea().height / -ListRow.ROW_HEIGHT, false);
                        return;
                    }
                    case 0x1000006: {
                        this.moveFocus(this.getClientArea().height / ListRow.ROW_HEIGHT, false);
                        return;
                    }
                    case 0x1000007: {
                        ListRow row = (ListRow)this.rows.get(0);
                        if (row == null) return;
                        this.setSelectedRows(new ListRow[]{row});
                        return;
                    }
                    case 0x1000008: {
                        int i = this.rows.size();
                        if (i <= 0) return;
                        ListRow row = (ListRow)this.rows.get(i - 1);
                        if (row == null) return;
                        this.setSelectedRows(new ListRow[]{row});
                        return;
                    }
                }
            }
            return;
        } else {
            if (event2.type != 14 && event2.type != 8) return;
            this._runDefaultAction();
        }
    }

    private void _runDefaultAction() {
        if (this.lCancelSelectionTriggeredOn > 0L && System.currentTimeMillis() - this.lCancelSelectionTriggeredOn < 200L) {
            this.lCancelSelectionTriggeredOn = -1L;
        } else {
            ListRow[] selectedRows = this.getSelectedRows();
            Iterator iter = this.listenersSelection.iterator();
            while (iter.hasNext()) {
                ListSelectionAdapter l = (ListSelectionAdapter)iter.next();
                l.defaultSelected(selectedRows);
            }
        }
    }

    public void setMouseClickIsDefaultSelection(boolean b) {
        this.bMouseClickIsDefaultSelection = b;
    }

    public void addSelectionListener(ListSelectionAdapter listener, boolean bFireSelection) {
        this.listenersSelection.add(listener);
        if (bFireSelection) {
            ListRow[] rows = this.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                listener.selected(rows[i]);
            }
            listener.focusChanged(this.getRowFocused());
        }
    }

    public void addCountChangeListener(ListCountChangeAdapter listener) {
        this.listenersCountChange.add(listener);
    }

    protected void triggerListenerRowAdded(ListRow row) {
        Iterator iter = this.listenersCountChange.iterator();
        while (iter.hasNext()) {
            ListCountChangeAdapter l = (ListCountChangeAdapter)iter.next();
            l.rowAdded(row);
        }
    }

    protected void triggerListenerRowRemoved(ListRow row) {
        Iterator iter = this.listenersCountChange.iterator();
        while (iter.hasNext()) {
            ListCountChangeAdapter l = (ListCountChangeAdapter)iter.next();
            l.rowRemoved(row);
        }
    }

    public Control getControl() {
        return this.listCanvas;
    }

    public String getTableID() {
        return this.sTableID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListRow[] getRowsUnsorted() {
        try {
            this.row_mon.enter();
            ListRow[] listRowArray = this.rows.toArray(new ListRow[0]);
            return listRowArray;
        }
        finally {
            this.row_mon.exit();
        }
    }

    public void runForAllRows(TableView.GroupTableRowRunner runner) {
        ListRow[] rows = this.getRowsUnsorted();
        for (int i = 0; i < rows.length; ++i) {
            runner.run(rows[i]);
        }
    }

    public void columnInvalidate(TableColumnCore tableColumn) {
    }

    public void columnOrderChanged(int[] iPositions) {
    }

    public void columnSizeChanged(TableColumnCore tableColumn) {
        if (tableColumn.getPosition() < 0) {
            return;
        }
        final String id = tableColumn.getName();
        final int width = tableColumn.getWidth();
        final int position = tableColumn.getPosition();
        final int numColumns = this.visibleColumns.length;
        this.runForAllRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                TableCellCore cell = row.getTableCellCore(id);
                if (cell != null) {
                    Rectangle bounds = cell.getBounds();
                    int diff = width - bounds.width;
                    if (diff != 0) {
                        bounds.width = width;
                        ((ListCell)cell.getBufferedTableItem()).setBounds(bounds);
                        cell.refresh(true);
                        for (int i = position + 1; i < numColumns; ++i) {
                            TableColumnCore nextColumn = ListView.this.visibleColumns[i];
                            TableCellCore nextCell = row.getTableCellCore(nextColumn.getName());
                            if (nextCell == null) continue;
                            Rectangle nextBounds = nextCell.getBounds();
                            nextBounds.x += diff;
                            ((ListCell)nextCell.getBufferedTableItem()).setBounds(nextBounds);
                            nextCell.refresh(true);
                        }
                    }
                }
            }
        });
    }

    public void tableStructureChanged() {
    }

    public TableColumnCore getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(TableColumnCore sorter) {
        boolean bSameColumn = this.sortColumn.equals(sorter);
        if (!bSameColumn) {
            this.sortColumn = sorter;
            int iSortDirection = configMan.getIntParameter(CFG_SORTDIRECTION);
            if (iSortDirection == 0) {
                this.sortColumn.setSortAscending(true);
            } else if (iSortDirection == 1) {
                this.sortColumn.setSortAscending(false);
            } else {
                this.sortColumn.setSortAscending(!this.sortColumn.isSortAscending());
            }
            configMan.setParameter(this.sTableID + ".sortAsc", this.sortColumn.isSortAscending());
            configMan.setParameter(this.sTableID + ".sortColumn", this.sortColumn.getName());
        } else {
            this.sortColumn.setSortAscending(!this.sortColumn.isSortAscending());
            configMan.setParameter(this.sTableID + ".sortAsc", this.sortColumn.isSortAscending());
        }
        this.sortColumn.setLastSortValueChange(SystemTime.getCurrentTime());
        this.changeColumnIndicator();
        this.sortTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortTable() {
        try {
            this.row_mon.enter();
            if (this.sortColumn != null && this.sortColumn.getLastSortValueChange() > this.lLastSortedOn) {
                this.lLastSortedOn = SystemTime.getCurrentTime();
                if (this.sortColumn != null) {
                    String sColumnID = this.sortColumn.getName();
                    Iterator iter = this.rows.iterator();
                    while (iter.hasNext()) {
                        TableRowCore row = (TableRowCore)iter.next();
                        TableCellCore cell = row.getTableCellCore(sColumnID);
                        if (cell == null) continue;
                        cell.refresh(true, false, false);
                    }
                }
                Object[] rowsArray = this.rows.toArray();
                Arrays.sort(rowsArray, this.sortColumn);
                int iNumChanged = 0;
                int iFirstChange = -1;
                for (int i = 0; i < rowsArray.length; ++i) {
                    ListRow row = (ListRow)rowsArray[i];
                    if (row == this.rows.get(i)) continue;
                    ++iNumChanged;
                    if (iFirstChange >= 0) continue;
                    iFirstChange = i;
                }
                List<Object> list = Arrays.asList(rowsArray);
                this.rows = list instanceof ArrayList ? (ArrayList)list : new ArrayList<Object>(list);
                if (iFirstChange >= 0) {
                    for (int i = iFirstChange; i < this.rows.size(); ++i) {
                        ListRow row = (ListRow)this.rows.get(i);
                        row.fixupPosition();
                    }
                    this.refreshVisible(true, true);
                }
            }
        }
        finally {
            this.row_mon.exit();
        }
    }

    public TableColumnCore[] getAllColumns() {
        return this.allColumns;
    }

    public boolean isRowVisible(ListRow row) {
        if (this.listCanvas == null || this.listCanvas.isDisposed()) {
            return false;
        }
        Rectangle clientArea = this.listCanvas.getClientArea();
        int iBottomIndex = (this.iLastVBarPos + clientArea.height - 1) / ListRow.ROW_HEIGHT;
        int iTopIndex = this.iLastVBarPos / ListRow.ROW_HEIGHT;
        int size = iBottomIndex - iTopIndex + 1;
        if (size <= 0) {
            return false;
        }
        int i = row.getIndex();
        return i >= iTopIndex && i <= iBottomIndex;
    }

    public TableRowCore[] getVisibleRows() {
        if (this.listCanvas == null || this.listCanvas.isDisposed()) {
            return new TableRowCore[0];
        }
        int y = this.iLastVBarPos;
        Rectangle clientArea = this.listCanvas.getClientArea();
        int iBottomIndex = (y + clientArea.height - 1) / ListRow.ROW_HEIGHT;
        int iTopIndex = y / ListRow.ROW_HEIGHT;
        int size = iBottomIndex - iTopIndex + 1;
        if (size <= 0) {
            return new TableRowCore[0];
        }
        TableRowCore[] visiblerows = new TableRowCore[size];
        int pos = 0;
        for (int i = iTopIndex; i <= iBottomIndex; ++i) {
            TableRowCore row;
            if (i < 0 || i >= this.rows.size() || (row = (TableRowCore)this.rows.get(i)) == null) continue;
            visiblerows[pos++] = row;
        }
        if (pos <= visiblerows.length) {
            TableRowCore[] temp = new TableRowCore[pos];
            System.arraycopy(visiblerows, 0, temp, 0, pos);
            return temp;
        }
        return visiblerows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowRefresh(ListRow row, boolean bDoGraphics, boolean bForceRedraw) {
        if (this.listCanvas == null || this.listCanvas.isDisposed()) {
            return false;
        }
        Rectangle clientArea = this.listCanvas.getClientArea();
        int iTopIndex = this.getTopIndex();
        int i = row.getIndex();
        boolean changed = false;
        if (i >= iTopIndex) {
            int ofs = this.getOffset(this.iLastVBarPos);
            int y = (i - iTopIndex) * ListRow.ROW_HEIGHT - ofs;
            Rectangle rect = new Rectangle(clientArea.x, y, clientArea.width, ListRow.ROW_HEIGHT);
            if (this.imageView != null) {
                GC gc = null;
                try {
                    gc = new GC((Drawable)this.imageView);
                    gc.setClipping(rect);
                    if (!row.isVisible()) {
                        System.out.println("asked for row refresh but not visible " + row.getIndex() + ";" + Debug.getCompressedStackTrace());
                        boolean bl = false;
                        return bl;
                    }
                    changed |= row.refresh(bDoGraphics, true);
                    row.doPaint(gc, true);
                }
                catch (Exception e) {
                    if (!(e instanceof IllegalArgumentException)) {
                        Debug.out(e);
                    }
                }
                finally {
                    if (gc != null) {
                        gc.dispose();
                    }
                }
            }
            if (changed || bForceRedraw) {
                this.listCanvas.redraw(rect.x, rect.y, rect.width, rect.height, false);
            }
        }
        return changed;
    }

    private int getTopIndex() {
        if (this.listCanvas == null || this.listCanvas.isDisposed()) {
            return -1;
        }
        return this.iLastVBarPos / ListRow.ROW_HEIGHT;
    }

    protected int rowGetVisibleYOffset(TableRowCore row) {
        int i = row.getIndex();
        int iTopIndex = this.iLastVBarPos / ListRow.ROW_HEIGHT;
        int ofs = this.getOffset(this.iLastVBarPos);
        return (i - iTopIndex) * ListRow.ROW_HEIGHT - ofs;
    }

    public Menu createMenu() {
        final Menu menu = new Menu((Decorations)this.listCanvas.getShell(), 8);
        menu.addMenuListener(new MenuListener(){
            boolean bShown = false;

            public void menuHidden(MenuEvent e) {
                this.bShown = false;
                if (Constants.isOSX) {
                    return;
                }
                e.widget.getDisplay().asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        if (bShown || menu.isDisposed()) {
                            return;
                        }
                        MenuItem[] items = menu.getItems();
                        for (int i = 0; i < items.length; ++i) {
                            items[i].dispose();
                        }
                    }
                });
            }

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                this.bShown = true;
                ListView.this.fillMenu(menu);
            }
        });
        return menu;
    }

    public void fillMenu(Menu menu) {
    }

    static /* synthetic */ Image access$300(ListView x0) {
        return x0.imageView;
    }

    static /* synthetic */ Image access$302(ListView x0, Image x1) {
        x0.imageView = x1;
        return x0.imageView;
    }

    private class selectionListener
    implements Listener {
        private selectionListener() {
        }

        private TableCellMouseEvent createMouseEvent(TableCellCore cell, Event e, int type) {
            TableCellMouseEvent event2 = new TableCellMouseEvent();
            event2.cell = cell;
            event2.eventType = type;
            event2.button = e.button;
            event2.keyboardState = e.stateMask;
            event2.skipCoreFunctionality = false;
            int i = cell.getTableRowCore().getIndex();
            int iTopIndex = ListView.this.iLastVBarPos / ListRow.ROW_HEIGHT;
            int ofs = ListView.this.getOffset(ListView.this.iLastVBarPos);
            int y = (i - iTopIndex) * ListRow.ROW_HEIGHT - ofs;
            Rectangle r = cell.getBounds();
            event2.x = e.x - r.x;
            event2.y = e.y - r.y;
            return event2;
        }

        public void handleEvent(Event e) {
            TableCellCore cell;
            ListRow row = ListView.this.getRow(e.x, e.y);
            if (row == null) {
                return;
            }
            int mouseEventType = -1;
            switch (e.type) {
                case 3: {
                    mouseEventType = 0;
                    break;
                }
                case 4: {
                    if ((e.stateMask & SWT.MOD1) > 0) {
                        boolean select = !row.isSelected();
                        row.setSelected(select);
                        if (select) {
                            row.setFocused(true);
                        }
                    } else if ((e.stateMask & SWT.MOD2) > 0) {
                        ListRow rowFocused = ListView.this.getRowFocused();
                        if (rowFocused == null) {
                            boolean select = !row.isSelected();
                            row.setSelected(select);
                            if (select) {
                                row.setFocused(true);
                            }
                        } else {
                            int idxStart = rowFocused.getIndex();
                            int idxEnd = row.getIndex();
                            if (idxEnd != idxStart) {
                                int dir = idxStart < idxEnd ? 1 : -1;
                                for (int i = idxStart; i != idxEnd; i += dir) {
                                    ListRow rowToSelect = ListView.this.getRow(i);
                                    if (rowToSelect == null) continue;
                                    rowToSelect.setSelected(true);
                                }
                                ListRow rowToSelect = ListView.this.getRow(idxEnd);
                                if (rowToSelect != null) {
                                    rowToSelect.setSelected(true);
                                    rowToSelect.setFocused(true);
                                }
                            }
                        }
                    } else {
                        ListView.this.setSelectedRows(new ListRow[]{row});
                    }
                    if (ListView.this.listCanvas.isDisposed()) {
                        return;
                    }
                    ListView.this.listCanvas.setFocus();
                    mouseEventType = 1;
                }
            }
            if (mouseEventType != -1 && (cell = row.getTableCellCore(e.x, e.y)) != null) {
                TableColumn tc = cell.getTableColumn();
                TableCellMouseEvent event2 = this.createMouseEvent(cell, e, mouseEventType);
                ((TableColumnCore)tc).invokeCellMouseListeners(event2);
                cell.invokeMouseListeners(event2);
                if (event2.skipCoreFunctionality) {
                    ListView.this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                }
            }
            if (ListView.this.bMouseClickIsDefaultSelection && e.type == 4) {
                ListView.this._runDefaultAction();
            }
        }
    }
}

