/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.utils.PublishUtils;
import com.aelitis.azureus.ui.swt.views.TorrentListView;
import com.aelitis.azureus.ui.swt.views.TorrentListViewListener;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.list.ListSelectionAdapter;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class ManageCdList
extends SkinView {
    private SWTSkinObjectText lblCountAreaNotOurs;
    private SWTSkinObjectText lblCountAreaOurs;
    private TorrentListView view;
    private String PREFIX = "manage-cd-";
    private SWTSkinButtonUtility btnShare;
    private SWTSkinButtonUtility btnStop;
    private SWTSkinButtonUtility btnDelete;
    private SWTSkinButtonUtility btnDetails;
    private SWTSkinObjectText statusObject;
    private AzureusCore core;
    private boolean bShowMyPublished = false;
    private SWTSkinButtonUtility btnComments;
    private SWTSkinButtonUtility btnPlay;

    public Object showSupport(SWTSkinObject skinObject, Object params) {
        SWTSkin skin = skinObject.getSkin();
        this.core = AzureusCoreFactory.getSingleton();
        Composite cData = (Composite)skinObject.getControl();
        Composite cHeaders = null;
        skinObject = skin.getSkinObject(this.PREFIX + "list-headers");
        if (skinObject != null) {
            cHeaders = (Composite)skinObject.getControl();
        }
        if ((skinObject = skin.getSkinObject(this.PREFIX + "titlextra")) != null) {
            this.lblCountAreaNotOurs = (SWTSkinObjectText)skinObject;
            SWTSkinButtonUtility btnCountAreaNotOurs = new SWTSkinButtonUtility(skinObject);
            btnCountAreaNotOurs.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility) {
                    if (ManageCdList.this.bShowMyPublished) {
                        ManageCdList.this.bShowMyPublished = false;
                        ManageCdList.this.lblCountAreaOurs.switchSuffix("", 1, true);
                        ManageCdList.this.lblCountAreaNotOurs.switchSuffix("-selected", 1, true);
                        ManageCdList.this.view.regetDownloads();
                    }
                }
            });
        }
        this.lblCountAreaNotOurs.switchSuffix("-selected", 1, true);
        skinObject = skin.getSkinObject(this.PREFIX + "titlextra-2");
        if (skinObject != null) {
            this.lblCountAreaOurs = (SWTSkinObjectText)skinObject;
            SWTSkinButtonUtility btnCountAreaOurs = new SWTSkinButtonUtility(skinObject);
            btnCountAreaOurs.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility) {
                    if (!ManageCdList.this.bShowMyPublished) {
                        ManageCdList.this.bShowMyPublished = true;
                        ManageCdList.this.lblCountAreaNotOurs.switchSuffix("", 1, true);
                        ManageCdList.this.lblCountAreaOurs.switchSuffix("-selected", 1, true);
                        ManageCdList.this.view.regetDownloads();
                    }
                }
            });
        }
        this.view = new TorrentListView(this.core, skin, skin.getSkinProperties(), cHeaders, null, cData, 1, false, true){

            public boolean isOurDownload(DownloadManager dm) {
                if (dm == null) {
                    Debug.out("DM == null");
                    return false;
                }
                boolean bDownloadComplete = dm.isDownloadComplete(false);
                boolean isPublished = PublishUtils.isPublished(dm);
                try {
                    return bDownloadComplete && isPublished == ManageCdList.this.bShowMyPublished;
                }
                catch (Exception e) {
                    Debug.out("STUPID ERROR", e);
                    return false;
                }
            }
        };
        this.btnShare = TorrentListViewsUtils.addShareButton(skin, this.PREFIX, this.view);
        this.btnStop = TorrentListViewsUtils.addStopButton(skin, this.PREFIX, this.view);
        this.btnDetails = TorrentListViewsUtils.addDetailsButton(skin, this.PREFIX, this.view);
        this.btnComments = TorrentListViewsUtils.addCommentsButton(skin, this.PREFIX, this.view);
        this.btnPlay = TorrentListViewsUtils.addPlayButton(skin, this.PREFIX, this.view, false, true);
        this.view.addListener(new TorrentListViewListener(){
            boolean countChanging = false;

            public void countChanged() {
                if (this.countChanging) {
                    return;
                }
                this.countChanging = true;
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        countChanging = false;
                        long totalOurs = 0L;
                        long totalNotOurs = 0L;
                        GlobalManager globalManager = ManageCdList.this.core.getGlobalManager();
                        Object[] dms = globalManager.getDownloadManagers().toArray();
                        for (int i = 0; i < dms.length; ++i) {
                            DownloadManager dm = (DownloadManager)dms[i];
                            if (!dm.isDownloadComplete(false)) continue;
                            if (PublishUtils.isPublished(dm)) {
                                ++totalOurs;
                                continue;
                            }
                            ++totalNotOurs;
                        }
                        if (ManageCdList.this.lblCountAreaOurs != null) {
                            ManageCdList.this.lblCountAreaOurs.setText(MessageText.getString("MainWindow.v3." + ManageCdList.this.PREFIX + "ours.count", new String[]{"" + totalOurs}));
                        }
                        if (ManageCdList.this.lblCountAreaNotOurs != null) {
                            ManageCdList.this.lblCountAreaNotOurs.setText(MessageText.getString("MainWindow.v3." + ManageCdList.this.PREFIX + "notours.count", new String[]{"" + totalNotOurs}));
                            ManageCdList.this.lblCountAreaNotOurs.getControl().getParent().layout(true, true);
                        }
                    }
                });
            }
        });
        skinObject = skin.getSkinObject(this.PREFIX + "status");
        if (skinObject instanceof SWTSkinObjectText) {
            this.statusObject = (SWTSkinObjectText)skinObject;
            this.view.addListener(new TorrentListViewListener(){

                public void stateChanged(DownloadManager manager) {
                    ListRow[] selectedRows = ManageCdList.this.view.getSelectedRows();
                    ManageCdList.this.updateStatusText(selectedRows.length == 1 ? selectedRows[0] : null);
                }
            });
        }
        if ((skinObject = skin.getSkinObject(this.PREFIX + "delete")) instanceof SWTSkinObjectContainer) {
            this.btnDelete = new SWTSkinButtonUtility(skinObject);
            this.btnDelete.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility) {
                    ListRow[] selectedRows = ManageCdList.this.view.getSelectedRows();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        DownloadManager dm = (DownloadManager)selectedRows[i].getDataSource(true);
                        ManagerUtils.remove(dm, ManageCdList.this.btnDelete.getSkinObject().getControl().getShell(), false, false);
                    }
                }
            });
        }
        SWTSkinButtonUtility[] buttonsNeedingRow = new SWTSkinButtonUtility[]{this.btnDelete, this.btnStop};
        SWTSkinButtonUtility[] buttonsNeedingPlatform = new SWTSkinButtonUtility[]{this.btnDetails, this.btnComments, this.btnShare};
        SWTSkinButtonUtility[] buttonsNeedingSingleSelection = new SWTSkinButtonUtility[]{this.btnDetails, this.btnComments, this.btnShare};
        TorrentListViewsUtils.addButtonSelectionDisabler(this.view, buttonsNeedingRow, buttonsNeedingPlatform, buttonsNeedingSingleSelection, this.btnStop);
        this.view.addSelectionListener(new ListSelectionAdapter(){

            public void deselected(ListRow row) {
                this.update();
            }

            public void selected(ListRow row) {
                this.update();
            }

            public void focusChanged(ListRow focusedRow) {
                this.update();
            }

            private void update() {
                ListRow[] rows = ManageCdList.this.view.getSelectedRows();
                if (rows.length == 0 || rows.length > 1) {
                    ManageCdList.this.updateStatusText(null);
                } else {
                    ManageCdList.this.updateStatusText(rows[0]);
                }
            }
        }, true);
        return null;
    }

    protected void updateStatusText(TableRowCore row) {
        if (row != null) {
            DownloadManager dm = (DownloadManager)row.getDataSource(true);
            this.statusObject.setText(DisplayFormatters.formatDownloadStatus(dm));
        } else {
            this.statusObject.setTextID("MainWindow.v3." + this.PREFIX + "status.noselection");
        }
    }
}

