/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.views.TorrentListView;
import com.aelitis.azureus.ui.swt.views.TorrentListViewListener;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.list.ListSelectionAdapter;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class ManageDlList
extends SkinView {
    private SWTSkinObjectText lblCountArea;
    private String PREFIX = "manage-dl-";
    private TorrentListView view;
    private SWTSkinButtonUtility btnAdd;
    private SWTSkinButtonUtility btnStop;
    private SWTSkinButtonUtility btnDelete;
    private SWTSkinObjectText statusObject;
    private SWTSkinButtonUtility btnShare;
    private SWTSkinButtonUtility btnDetails;
    private SWTSkinButtonUtility btnComments;
    private SWTSkinButtonUtility btnPlay;

    public Object showSupport(SWTSkinObject skinObject, Object params) {
        SWTSkin skin = skinObject.getSkin();
        AzureusCore core = AzureusCoreFactory.getSingleton();
        Composite cData = (Composite)skinObject.getControl();
        Composite cHeaders = null;
        skinObject = skin.getSkinObject(this.PREFIX + "list-headers");
        if (skinObject != null) {
            cHeaders = (Composite)skinObject.getControl();
        }
        if ((skinObject = skin.getSkinObject(this.PREFIX + "titlextra")) instanceof SWTSkinObjectText) {
            this.lblCountArea = (SWTSkinObjectText)skinObject;
        }
        this.view = new TorrentListView(core, skin, skin.getSkinProperties(), cHeaders, this.lblCountArea, cData, 0, false, true);
        skinObject = skin.getSkinObject(this.PREFIX + "add");
        if (skinObject instanceof SWTSkinObjectContainer) {
            this.btnAdd = new SWTSkinButtonUtility(skinObject);
            this.btnAdd.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility) {
                    TorrentOpener.openTorrentWindow();
                }
            });
        }
        this.btnShare = TorrentListViewsUtils.addShareButton(skin, this.PREFIX, this.view);
        this.btnStop = TorrentListViewsUtils.addStopButton(skin, this.PREFIX, this.view);
        this.btnDetails = TorrentListViewsUtils.addDetailsButton(skin, this.PREFIX, this.view);
        this.btnComments = TorrentListViewsUtils.addCommentsButton(skin, this.PREFIX, this.view);
        this.btnPlay = TorrentListViewsUtils.addPlayButton(skin, this.PREFIX, this.view, true, false);
        skinObject = skin.getSkinObject(this.PREFIX + "status");
        if (skinObject instanceof SWTSkinObjectText) {
            this.statusObject = (SWTSkinObjectText)skinObject;
            this.view.addListener(new TorrentListViewListener(){

                public void stateChanged(DownloadManager manager) {
                    ListRow[] selectedRows = ManageDlList.this.view.getSelectedRows();
                    ManageDlList.this.updateStatusText(selectedRows.length == 1 ? selectedRows[0] : null);
                }
            });
        }
        if ((skinObject = skin.getSkinObject(this.PREFIX + "delete")) instanceof SWTSkinObjectContainer) {
            this.btnDelete = new SWTSkinButtonUtility(skinObject);
            this.btnDelete.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility) {
                    ListRow[] selectedRows = ManageDlList.this.view.getSelectedRows();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        DownloadManager dm = (DownloadManager)selectedRows[i].getDataSource(true);
                        ManagerUtils.remove(dm, ManageDlList.this.btnDelete.getSkinObject().getControl().getShell(), true, true);
                    }
                }
            });
        }
        SWTSkinButtonUtility[] buttonsNeedingRow = new SWTSkinButtonUtility[]{this.btnDelete, this.btnStop};
        SWTSkinButtonUtility[] buttonsNeedingPlatform = new SWTSkinButtonUtility[]{this.btnDetails, this.btnComments, this.btnShare};
        SWTSkinButtonUtility[] buttonsNeedingSingleSelection = new SWTSkinButtonUtility[]{this.btnDetails, this.btnComments, this.btnShare};
        TorrentListViewsUtils.addButtonSelectionDisabler(this.view, buttonsNeedingRow, buttonsNeedingPlatform, buttonsNeedingSingleSelection, this.btnStop);
        this.view.addSelectionListener(new ListSelectionAdapter(){

            public void deselected(ListRow row) {
                this.update();
            }

            public void selected(ListRow row) {
                this.update();
            }

            public void focusChanged(ListRow focusedRow) {
                this.update();
            }

            private void update() {
                ListRow[] rows = ManageDlList.this.view.getSelectedRows();
                if (rows.length == 0 || rows.length > 1) {
                    ManageDlList.this.updateStatusText(null);
                } else {
                    ManageDlList.this.updateStatusText(rows[0]);
                }
            }
        }, true);
        return null;
    }

    protected void updateStatusText(TableRowCore row) {
        if (row != null) {
            DownloadManager dm = (DownloadManager)row.getDataSource(true);
            this.statusObject.setText(DisplayFormatters.formatDownloadStatus(dm));
        } else {
            this.statusObject.setTextID("MainWindow.v3." + this.PREFIX + "status.noselection");
        }
    }
}

