/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.torrent.MetaDataUpdateListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectImage;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.utils.PublishUtils;
import com.aelitis.azureus.ui.swt.views.TorrentListView;
import com.aelitis.azureus.ui.swt.views.TorrentListViewListener;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.list.ListSelectionAdapter;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class MediaList
extends SkinView {
    private static final int ASYOUTYPE_UPDATEDELAY = 150;
    private SWTSkinObjectText lblCountAreaNotOurs;
    private SWTSkinObjectText lblCountAreaOurs;
    private TorrentListView view;
    private String PREFIX = "my-media-";
    private SWTSkinButtonUtility btnShare;
    private SWTSkinButtonUtility btnStop;
    private SWTSkinButtonUtility btnDelete;
    private SWTSkinButtonUtility btnDetails;
    private AzureusCore core;
    private SWTSkinButtonUtility btnComments;
    private SWTSkinButtonUtility btnPlay;
    private SWTSkinObjectImage skinImgThumb;
    private SWTSkinObjectText skinDetailInfo;
    private MetaDataUpdateListener listener;
    protected String sLastSearch = "";
    private Text txtFilter;
    private boolean bRegexSearch;
    private Label lblX;
    private TimerEvent searchUpdateEvent;

    public Object showSupport(SWTSkinObject skinObject, Object params) {
        final SWTSkin skin = skinObject.getSkin();
        this.core = AzureusCoreFactory.getSingleton();
        Composite cData = (Composite)skinObject.getControl();
        Composite cHeaders = null;
        skinObject = skin.getSkinObject(this.PREFIX + "list-headers");
        if (skinObject != null) {
            cHeaders = (Composite)skinObject.getControl();
        }
        this.view = new TorrentListView(this.core, skin, skin.getSkinProperties(), cHeaders, null, cData, 2, false, true){

            public boolean isOurDownload(DownloadManager dm) {
                if (MediaList.this.sLastSearch.length() == 0) {
                    return true;
                }
                boolean bOurs = true;
                try {
                    String[][] names = new String[][]{{"", dm.getDisplayName()}, {"t:", dm.getTorrent().getAnnounceURL().getHost()}, {"st:", "" + dm.getState()}};
                    String name = names[0][1];
                    String tmpSearch = MediaList.this.sLastSearch;
                    for (int i = 0; i < names.length; ++i) {
                        if (!tmpSearch.startsWith(names[i][0])) continue;
                        tmpSearch = tmpSearch.substring(names[i][0].length());
                        name = names[i][1];
                    }
                    String s = MediaList.this.bRegexSearch ? tmpSearch : "\\Q" + tmpSearch.replaceAll("[|;]", "\\\\E|\\\\Q") + "\\E";
                    Pattern pattern = Pattern.compile(s, 2);
                    if (!pattern.matcher(name).find()) {
                        bOurs = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bOurs;
            }

            public void regetDownloads() {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        globalManager.removeListener(MediaList.this.view);
                        this.removeAllDataSources(true);
                        System.out.println("reget");
                        globalManager.addListener(MediaList.this.view, false);
                        DownloadManager[] managers = this.sortDMList(globalManager.getDownloadManagers());
                        bSkipUpdateCount = true;
                        for (int i = 0; i < managers.length; ++i) {
                            DownloadManager dm = managers[i];
                            this.downloadManagerAdded(dm);
                            if (this.getControl().getSize().y / ListRow.ROW_HEIGHT != i) continue;
                            this.processDataSourceQueue();
                            bSkipUpdateCount = false;
                            this.updateCount();
                            bSkipUpdateCount = true;
                            for (int j = 0; j <= i; ++j) {
                                ListRow row = this.getRow(j);
                                if (row == null) continue;
                                row.redraw(true);
                            }
                        }
                        bSkipUpdateCount = false;
                    }
                });
            }

            public void updateUI() {
                super.updateUI();
                Control control = MediaList.this.skinDetailInfo.getControl();
                if (control == null || control.isDisposed() || !control.isVisible()) {
                    return;
                }
                if (MediaList.this.view.getSelectedRows().length != 1) {
                    MediaList.this.updateDetailsInfo();
                }
            }
        };
        this.btnShare = TorrentListViewsUtils.addShareButton(skin, this.PREFIX, this.view);
        this.btnStop = TorrentListViewsUtils.addStopButton(skin, this.PREFIX, this.view);
        this.btnDetails = TorrentListViewsUtils.addDetailsButton(skin, this.PREFIX, this.view);
        this.btnComments = TorrentListViewsUtils.addCommentsButton(skin, this.PREFIX, this.view);
        this.btnPlay = TorrentListViewsUtils.addPlayButton(skin, this.PREFIX, this.view, false, true);
        this.view.addListener(new TorrentListViewListener(){
            boolean countChanging = false;

            public void stateChanged(final DownloadManager manager) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (manager == null) {
                            return;
                        }
                        ListRow row = MediaList.this.view.getRow(manager);
                        if (row == null) {
                            return;
                        }
                        if (manager.isDownloadComplete(false)) {
                            row.setForeground(null);
                        } else {
                            Color c = skin.getSkinProperties().getColor("color.library.incomplete");
                            row.setForeground(c);
                        }
                    }
                });
            }

            public void countChanged() {
                if (this.countChanging) {
                    return;
                }
                this.countChanging = true;
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        countChanging = false;
                        long totalOurs = 0L;
                        long totalNotOurs = 0L;
                        GlobalManager globalManager = MediaList.this.core.getGlobalManager();
                        Object[] dms = globalManager.getDownloadManagers().toArray();
                        for (int i = 0; i < dms.length; ++i) {
                            DownloadManager dm = (DownloadManager)dms[i];
                            if (!dm.isDownloadComplete(false)) continue;
                            if (PublishUtils.isPublished(dm)) {
                                ++totalOurs;
                                continue;
                            }
                            ++totalNotOurs;
                        }
                        if (MediaList.this.lblCountAreaOurs != null) {
                            MediaList.this.lblCountAreaOurs.setText(MessageText.getString("MainWindow.v3." + MediaList.this.PREFIX + "ours.count", new String[]{"" + totalOurs}));
                        }
                        if (MediaList.this.lblCountAreaNotOurs != null) {
                            MediaList.this.lblCountAreaNotOurs.setText(MessageText.getString("MainWindow.v3." + MediaList.this.PREFIX + "notours.count", new String[]{"" + totalNotOurs}));
                            MediaList.this.lblCountAreaNotOurs.getControl().getParent().layout(true, true);
                        }
                    }
                });
            }
        });
        skinObject = skin.getSkinObject(this.PREFIX + "delete");
        if (skinObject instanceof SWTSkinObjectContainer) {
            this.btnDelete = new SWTSkinButtonUtility(skinObject);
            this.btnDelete.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility) {
                    ListRow[] selectedRows = MediaList.this.view.getSelectedRows();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        DownloadManager dm = (DownloadManager)selectedRows[i].getDataSource(true);
                        ManagerUtils.remove(dm, MediaList.this.btnDelete.getSkinObject().getControl().getShell(), true, true);
                    }
                }
            });
        }
        SWTSkinButtonUtility[] buttonsNeedingRow = new SWTSkinButtonUtility[]{this.btnDelete, this.btnStop};
        SWTSkinButtonUtility[] buttonsNeedingPlatform = new SWTSkinButtonUtility[]{this.btnDetails, this.btnComments, this.btnShare};
        SWTSkinButtonUtility[] buttonsNeedingSingleSelection = new SWTSkinButtonUtility[]{this.btnDetails, this.btnComments, this.btnShare};
        TorrentListViewsUtils.addButtonSelectionDisabler(this.view, buttonsNeedingRow, buttonsNeedingPlatform, buttonsNeedingSingleSelection, this.btnStop);
        this.view.addSelectionListener(new ListSelectionAdapter(){

            public void selected(ListRow row) {
                DownloadManager dm;
                boolean bDisable = true;
                if (row != null && (dm = (DownloadManager)row.getDataSource(true)) != null) {
                    bDisable = !dm.isDownloadComplete(false);
                }
                MediaList.this.btnPlay.setDisabled(bDisable);
            }
        }, false);
        skinObject = skin.getSkinObject(this.PREFIX + "bigthumb");
        if (skinObject instanceof SWTSkinObjectImage) {
            this.listener = new MetaDataUpdateListener(){

                public void metaDataUpdated(TOTorrent torrent) {
                    DownloadManager dm;
                    ListRow rowFocused = MediaList.this.view.getRowFocused();
                    if (rowFocused != null && (dm = (DownloadManager)rowFocused.getDataSource(true)).getTorrent().equals(torrent)) {
                        MediaList.this.update();
                    }
                }
            };
            PlatformTorrentUtils.addListener(this.listener);
            this.skinImgThumb = (SWTSkinObjectImage)skinObject;
            this.view.addSelectionListener(new ListSelectionAdapter(){

                public void deselected(ListRow row) {
                    MediaList.this.update();
                }

                public void selected(ListRow row) {
                    MediaList.this.update();
                }

                public void focusChanged(ListRow focusedRow) {
                    MediaList.this.update();
                }
            }, false);
        }
        if ((skinObject = skin.getSkinObject(this.PREFIX + "detail-info")) instanceof SWTSkinObjectText) {
            this.skinDetailInfo = (SWTSkinObjectText)skinObject;
            this.view.addSelectionListener(new ListSelectionAdapter(){

                public void deselected(ListRow row) {
                    MediaList.this.updateDetailsInfo();
                }

                public void selected(ListRow row) {
                    MediaList.this.updateDetailsInfo();
                }

                public void focusChanged(ListRow focusedRow) {
                    MediaList.this.updateDetailsInfo();
                }
            }, true);
        }
        if ((skinObject = skin.getSkinObject("search-text")) != null) {
            // empty if block
        }
        return null;
    }

    protected void updateLastSearch() {
        if (this.txtFilter != null && !this.txtFilter.isDisposed()) {
            if (!this.sLastSearch.equals(this.txtFilter.getText())) {
                this.txtFilter.setText(this.sLastSearch);
                this.txtFilter.setSelection(this.sLastSearch.length());
            }
            if (this.sLastSearch.length() > 0) {
                if (this.bRegexSearch) {
                    try {
                        Pattern.compile(this.sLastSearch, 2);
                        this.txtFilter.setBackground(Colors.colorAltRow);
                        Messages.setLanguageTooltip((Widget)this.txtFilter, "MyTorrentsView.filter.tooltip");
                    }
                    catch (Exception e) {
                        this.txtFilter.setBackground(Colors.colorErrorBG);
                        this.txtFilter.setToolTipText(e.getMessage());
                    }
                } else {
                    this.txtFilter.setBackground(null);
                    Messages.setLanguageTooltip((Widget)this.txtFilter, "MyTorrentsView.filter.tooltip");
                }
            }
        }
        if (this.lblX != null && !this.lblX.isDisposed()) {
            Image img = ImageRepository.getImage(this.sLastSearch.length() > 0 ? "smallx" : "smallx-gray");
            this.lblX.setImage(img);
        }
        if (this.searchUpdateEvent != null) {
            this.searchUpdateEvent.cancel();
        }
        this.searchUpdateEvent = SimpleTimer.addEvent("SearchUpdate", SystemTime.getOffsetTime(150L), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                MediaList.this.searchUpdateEvent = null;
                MediaList.this.doFilter();
            }
        });
    }

    protected void doFilter() {
        this.view.regetDownloads();
    }

    private void updateDetailsInfo() {
        ListRow[] rows = this.view.getSelectedRows();
        if (rows.length == 0 || rows.length > 1) {
            int completed = 0;
            ListRow[] rowsUnsorted = this.view.getRowsUnsorted();
            if (rowsUnsorted.length == 0) {
                return;
            }
            int all = rowsUnsorted.length;
            for (int i = 0; i < all; ++i) {
                ListRow row = rowsUnsorted[i];
                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                if (dm == null || !dm.isDownloadComplete(false)) continue;
                ++completed;
            }
            this.skinDetailInfo.setText(MessageText.getString("MainWindow.v3.myMedia.noneSelected", new String[]{"" + all, "" + completed}));
            return;
        }
        String sText = "";
        DownloadManager dm = (DownloadManager)rows[0].getDataSource(true);
        if (dm != null) {
            TOTorrent torrent = dm.getTorrent();
            String s = PlatformTorrentUtils.getContentTitle(torrent);
            if (s != null) {
                sText = sText + s + "\n\n";
            }
            if ((s = PlatformTorrentUtils.getContentDescription(torrent)) != null) {
                sText = sText + s + "\n";
            }
        }
        this.skinDetailInfo.setText(sText);
    }

    private void update() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                byte[] imageBytes;
                ListRow[] rows = MediaList.this.view.getSelectedRows();
                if (rows.length == 0 || rows.length > 1) {
                    MediaList.this.skinImgThumb.setImage(null);
                    return;
                }
                Image image = null;
                DownloadManager dm = (DownloadManager)rows[0].getDataSource(true);
                if (dm != null && (imageBytes = PlatformTorrentUtils.getContentThumbnail(dm.getTorrent())) != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(imageBytes);
                    image = new Image((Device)MediaList.this.skinImgThumb.getControl().getDisplay(), (InputStream)bais);
                }
                Image oldImage = MediaList.this.skinImgThumb.getImage();
                Utils.disposeSWTObjects(new Object[]{oldImage});
                MediaList.this.skinImgThumb.setImage(image);
            }
        });
    }

    static /* synthetic */ Text access$2300(MediaList x0) {
        return x0.txtFilter;
    }
}

