/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.views.TorrentListView;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.list.ListView;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class MiniDownloadList
extends SkinView {
    private static String PREFIX = "minidownload-";
    private TorrentListView view;
    private SWTSkinButtonUtility btnAdd;
    private SWTSkinButtonUtility btnStop;
    private SWTSkinButtonUtility btnDelete;
    private SWTSkinButtonUtility btnDetails;
    private SWTSkinButtonUtility btnPlay;
    private SWTSkinButtonUtility btnShare;
    private SWTSkinButtonUtility btnComments;

    public Object showSupport(SWTSkinObject skinObject, Object params) {
        SWTSkin skin = skinObject.getSkin();
        AzureusCore core = AzureusCoreFactory.getSingleton();
        Composite cData = (Composite)skinObject.getControl();
        Composite cHeaders = null;
        SWTSkinObjectText lblCountArea = null;
        skinObject = skin.getSkinObject(PREFIX + "list-headers");
        if (skinObject != null) {
            cHeaders = (Composite)skinObject.getControl();
        }
        if ((skinObject = skin.getSkinObject(PREFIX + "titlextra")) instanceof SWTSkinObjectText) {
            lblCountArea = (SWTSkinObjectText)skinObject;
        }
        this.view = new TorrentListView(core, skin, skin.getSkinProperties(), cHeaders, lblCountArea, cData, 0, true, true);
        skinObject = skin.getSkinObject(PREFIX + "add");
        if (skinObject instanceof SWTSkinObjectContainer) {
            this.btnAdd = new SWTSkinButtonUtility(skinObject);
            this.btnAdd.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility) {
                    TorrentOpener.openTorrentWindow();
                }
            });
        }
        this.btnShare = TorrentListViewsUtils.addShareButton(skin, PREFIX, this.view);
        this.btnStop = TorrentListViewsUtils.addStopButton(skin, PREFIX, this.view);
        this.btnDetails = TorrentListViewsUtils.addDetailsButton(skin, PREFIX, this.view);
        this.btnComments = TorrentListViewsUtils.addCommentsButton(skin, PREFIX, this.view);
        this.btnPlay = TorrentListViewsUtils.addPlayButton(skin, PREFIX, this.view, true, false);
        SWTSkinObject soStream = skin.getSkinObject(PREFIX + "stream");
        if (soStream instanceof SWTSkinObjectContainer) {
            SWTSkinButtonUtility btn = new SWTSkinButtonUtility(soStream);
            btn.setDisabled(true);
            Composite c = (Composite)soStream.getControl();
            Control[] children = c.getChildren();
            c.setToolTipText("Coming Soon");
            for (int i = 0; i < children.length; ++i) {
                Control control = children[i];
                control.setToolTipText("Coming Soon");
            }
        }
        if ((skinObject = skin.getSkinObject(PREFIX + "delete")) instanceof SWTSkinObjectContainer) {
            this.btnDelete = new SWTSkinButtonUtility(skinObject);
            this.btnDelete.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility) {
                    ListRow[] selectedRows = MiniDownloadList.this.view.getSelectedRows();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        DownloadManager dm = (DownloadManager)selectedRows[i].getDataSource(true);
                        MiniDownloadList.remove(dm, MiniDownloadList.this.view, true, true);
                    }
                }
            });
        }
        SWTSkinButtonUtility[] buttonsNeedingRow = new SWTSkinButtonUtility[]{this.btnDelete, this.btnStop};
        SWTSkinButtonUtility[] buttonsNeedingPlatform = new SWTSkinButtonUtility[]{this.btnDetails, this.btnComments, this.btnShare};
        SWTSkinButtonUtility[] buttonsNeedingSingleSelection = new SWTSkinButtonUtility[]{this.btnDetails, this.btnComments, this.btnShare};
        TorrentListViewsUtils.addButtonSelectionDisabler(this.view, buttonsNeedingRow, buttonsNeedingPlatform, buttonsNeedingSingleSelection, this.btnStop);
        return null;
    }

    public static void remove(final DownloadManager dm, final ListView view, final boolean bDeleteTorrent, final boolean bDeleteData) {
        block7: {
            int choice;
            boolean confirmDataDelete;
            Shell shell = view.getControl().getShell();
            if (COConfigurationManager.getBooleanParameter("confirm_torrent_removal")) {
                MessageBox mb = new MessageBox(shell, 200);
                mb.setText(MessageText.getString("deletedata.title"));
                mb.setMessage(MessageText.getString("deletetorrent.message1") + dm.getDisplayName() + " :\n" + dm.getTorrentFileName() + MessageText.getString("deletetorrent.message2"));
                if (mb.open() == 128) {
                    return;
                }
            }
            if ((confirmDataDelete = COConfigurationManager.getBooleanParameter("Confirm Data Delete")) && bDeleteData) {
                String path = dm.getSaveLocation().toString();
                MessageBox mb = new MessageBox(shell, 200);
                mb.setText(MessageText.getString("deletedata.title"));
                mb.setMessage(MessageText.getString("deletedata.message1") + dm.getDisplayName() + " :\n" + path + MessageText.getString("deletedata.message2"));
                choice = mb.open();
            } else {
                choice = 64;
            }
            if (choice == 64) {
                try {
                    dm.getGlobalManager().canDownloadManagerBeRemoved(dm);
                    view.removeDataSource(dm, true);
                    new AEThread("asyncStop", true){

                        public void runSupport() {
                            try {
                                dm.stopIt(70, bDeleteTorrent, bDeleteData);
                                dm.getGlobalManager().removeDownloadManager(dm);
                            }
                            catch (GlobalManagerDownloadRemovalVetoException f) {
                                if (!f.isSilent()) {
                                    Alerts.showErrorMessageBoxUsingResourceString("globalmanager.download.remove.veto", f);
                                }
                                view.addDataSource(dm, true);
                            }
                            catch (Exception ex) {
                                view.addDataSource(dm, true);
                                Debug.printStackTrace(ex);
                            }
                        }
                    }.start();
                }
                catch (GlobalManagerDownloadRemovalVetoException f) {
                    if (f.isSilent()) break block7;
                    Alerts.showErrorMessageBoxUsingResourceString("globalmanager.download.remove.veto", f);
                }
            }
        }
    }
}

