/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.utils.PublishUtils;
import com.aelitis.azureus.ui.swt.views.TorrentListView;
import com.aelitis.azureus.ui.swt.views.TorrentListViewListener;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class MiniRecentList
extends SkinView {
    private static String PREFIX = "minirecent-";
    private TorrentListView view;
    private SWTSkinButtonUtility btnShare;
    private SWTSkinButtonUtility btnStop;
    private SWTSkinButtonUtility btnDelete;
    private SWTSkinButtonUtility btnDetails;
    private SWTSkinButtonUtility btnComments;
    private SWTSkinObjectText skinHeaderText;
    private SWTSkinButtonUtility btnPlay;

    public Object showSupport(SWTSkinObject skinObject, Object params) {
        final SWTSkin skin = skinObject.getSkin();
        AzureusCore core = AzureusCoreFactory.getSingleton();
        final Composite cData = (Composite)skinObject.getControl();
        Composite cHeaders = null;
        SWTSkinObjectText lblCountArea = null;
        skinObject = skin.getSkinObject(PREFIX + "list-headers");
        if (skinObject != null) {
            cHeaders = (Composite)skinObject.getControl();
        }
        if ((skinObject = skin.getSkinObject(PREFIX + "xOfx")) instanceof SWTSkinObjectText) {
            lblCountArea = (SWTSkinObjectText)skinObject;
        }
        if ((skinObject = skin.getSkinObject(PREFIX + "header-text")) instanceof SWTSkinObjectText) {
            this.skinHeaderText = (SWTSkinObjectText)skinObject;
        }
        if ((skinObject = skin.getSkinObject(PREFIX + "link")) instanceof SWTSkinObjectText) {
            SWTSkinButtonUtility btn = new SWTSkinButtonUtility(skinObject);
            btn.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility) {
                    skin.setActiveTab("maintabs", "maintabs.library");
                }
            });
        }
        this.view = new TorrentListView(core, skin, skin.getSkinProperties(), cHeaders, lblCountArea, cData, 1, true, false);
        this.btnShare = TorrentListViewsUtils.addShareButton(skin, PREFIX, this.view);
        this.btnStop = TorrentListViewsUtils.addStopButton(skin, PREFIX, this.view);
        this.btnDetails = TorrentListViewsUtils.addDetailsButton(skin, PREFIX, this.view);
        this.btnComments = TorrentListViewsUtils.addCommentsButton(skin, PREFIX, this.view);
        this.btnPlay = TorrentListViewsUtils.addPlayButton(skin, PREFIX, this.view, false, true);
        skinObject = skin.getSkinObject(PREFIX + "delete");
        if (skinObject instanceof SWTSkinObjectContainer) {
            this.btnDelete = new SWTSkinButtonUtility(skinObject);
            this.btnDelete.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility) {
                    ListRow[] selectedRows = MiniRecentList.this.view.getSelectedRows();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        DownloadManager dm = (DownloadManager)selectedRows[i].getDataSource(true);
                        if (PublishUtils.isPublished(dm)) {
                            String title = MessageText.getString("stopSeeding.title");
                            String text = MessageText.getString("stopSeeding.text");
                            int result = MessageBoxShell.open(cData.getShell(), title, text, new String[]{MessageText.getString("stopSeeding.delete"), MessageText.getString("stopSeeding.cancel")}, 1);
                            if (result != 0) continue;
                            ManagerUtils.remove(dm, MiniRecentList.this.btnDelete.getSkinObject().getControl().getShell(), false, false);
                            continue;
                        }
                        ManagerUtils.remove(dm, MiniRecentList.this.btnDelete.getSkinObject().getControl().getShell(), true, true);
                    }
                }
            });
        }
        SWTSkinButtonUtility[] buttonsNeedingRow = new SWTSkinButtonUtility[]{this.btnDelete, this.btnStop};
        SWTSkinButtonUtility[] buttonsNeedingPlatform = new SWTSkinButtonUtility[]{this.btnDetails, this.btnComments, this.btnShare};
        SWTSkinButtonUtility[] buttonsNeedingSingleSelection = new SWTSkinButtonUtility[]{this.btnDetails, this.btnComments, this.btnShare};
        TorrentListViewsUtils.addButtonSelectionDisabler(this.view, buttonsNeedingRow, buttonsNeedingPlatform, buttonsNeedingSingleSelection, this.btnStop);
        if (this.skinHeaderText != null) {
            this.view.addListener(new TorrentListViewListener(){

                public void countChanged() {
                    MiniRecentList.this.skinHeaderText.setText(MessageText.getString("MainWindow.v3.recentDL", new String[]{"" + MiniRecentList.this.view.size(true)}));
                }
            });
        }
        return null;
    }
}

