/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.listener.publish.DownloadStateAndRemoveListener;
import com.aelitis.azureus.ui.swt.browser.listener.publish.LocalHoster;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.utils.PublishUtils;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.util.Constants;
import com.aelitis.azureus.util.LocalResourceHTTPServer;
import java.io.File;
import java.net.URL;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;

public class Publish
extends SkinView
implements LocalHoster {
    private LocalResourceHTTPServer local_publisher;
    private Browser browser;

    public Object showSupport(SWTSkinObject skinObject, Object params) {
        AzureusCore core = AzureusCoreFactory.getSingleton();
        PluginInterface pi = core.getPluginManager().getPluginInterfaceByID("azdirector");
        if (pi == null) {
            PluginManager.registerPlugin(new Plugin(){

                public void initialize(PluginInterface pluginInterface) throws PluginException {
                }
            }, "azdirector");
            pi = core.getPluginManager().getPluginInterfaceByID("azdirector");
        }
        UISWTInstance swtInstance = UIFunctionsManagerSWT.getUIFunctionsSWT().getUISWTInstance();
        try {
            this.local_publisher = new LocalResourceHTTPServer(pi, null);
        }
        catch (Throwable e) {
            Debug.out("Failed to create local resource publisher", e);
        }
        Composite cArea = (Composite)skinObject.getControl();
        this.browser = new Browser(cArea, 0);
        this.browser.setLayoutData((Object)Utils.getFilledFormData());
        DownloadStateAndRemoveListener downloadListener = new DownloadStateAndRemoveListener(pi, cArea.getDisplay(), swtInstance);
        pi.getDownloadManager().addListener(downloadListener);
        BrowserContext context = new BrowserContext("publish", this.browser, null);
        PublishUtils.setupContext(context, this.browser, pi, this, downloadListener);
        this.restart();
        cArea.layout(true);
        return null;
    }

    public URL hostFile(File f) {
        try {
            return this.local_publisher.publishResource(f);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void restart() {
        if (this.browser != null) {
            String sURL = Constants.URL_PREFIX + "PublishedContent.html?" + Constants.URL_SUFFIX;
            System.out.println(sURL);
            this.browser.setUrl(sURL);
            this.browser.setData("StartURL", (Object)sURL);
        }
    }
}

