/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.views.TorrentListView;
import com.aelitis.azureus.ui.swt.views.TorrentListViewListener;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.list.ListSelectionAdapter;
import com.aelitis.azureus.ui.swt.views.skin.StartStopButtonUtil;
import com.aelitis.azureus.util.Constants;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class TorrentListViewsUtils {
    public static SWTSkinButtonUtility addShareButton(final SWTSkin skin, String PREFIX, final TorrentListView view) {
        SWTSkinObject skinObject = skin.getSkinObject(PREFIX + "send-selected");
        if (skinObject == null) {
            return null;
        }
        SWTSkinButtonUtility btn = new SWTSkinButtonUtility(skinObject);
        btn.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

            public void pressed(SWTSkinButtonUtility buttonUtility) {
                DownloadManager dm;
                ListRow[] selectedRows = view.getSelectedRows();
                if (selectedRows.length > 0 && (dm = (DownloadManager)selectedRows[0].getDataSource(true)) != null) {
                    try {
                        String url = Constants.URL_PREFIX + "share/" + dm.getTorrent().getHashWrapper().toBase32String() + ".html?" + Constants.URL_SUFFIX;
                        url = Constants.URL_PREFIX + "details/" + dm.getTorrent().getHashWrapper().toBase32String() + ".html#share?" + Constants.URL_SUFFIX;
                        skin.setActiveTab("maintabs", "maintabs.browse");
                        SWTSkinObject skinObjectBrowser = skin.getSkinObject("browse");
                        if (skinObjectBrowser instanceof SWTSkinObjectBrowser) {
                            SWTSkinObjectBrowser sob = (SWTSkinObjectBrowser)skinObjectBrowser;
                            sob.setURL(url);
                        }
                    }
                    catch (TOTorrentException e) {
                        Debug.out(e);
                    }
                }
            }
        });
        return btn;
    }

    public static SWTSkinButtonUtility addStopButton(SWTSkin skin, String PREFIX, final TorrentListView view) {
        SWTSkinObject skinObject = skin.getSkinObject(PREFIX + "stop");
        if (skinObject == null) {
            return null;
        }
        final SWTSkinButtonUtility btn = new SWTSkinButtonUtility(skinObject);
        btn.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

            public void pressed(SWTSkinButtonUtility buttonUtility) {
                ListRow[] selectedRows = view.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    DownloadManager dm = (DownloadManager)selectedRows[i].getDataSource(true);
                    int state = dm.getState();
                    if (state == 75 || state == 70 || state == 65 || state == 100) {
                        ManagerUtils.start(dm);
                        StartStopButtonUtil.updateStopButton(view, btn);
                        continue;
                    }
                    ManagerUtils.stop(dm, (Composite)btn.getSkinObject().getControl());
                    StartStopButtonUtil.updateStopButton(view, btn);
                }
            }
        });
        view.addListener(new TorrentListViewListener(){

            public void stateChanged(DownloadManager manager) {
                StartStopButtonUtil.updateStopButton(view, btn);
            }
        });
        return btn;
    }

    public static SWTSkinButtonUtility addDetailsButton(final SWTSkin skin, String PREFIX, final TorrentListView view) {
        SWTSkinObject skinObject = skin.getSkinObject(PREFIX + "viewdetails");
        if (skinObject == null) {
            return null;
        }
        SWTSkinButtonUtility btn = new SWTSkinButtonUtility(skinObject);
        btn.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

            public void pressed(SWTSkinButtonUtility buttonUtility) {
                ListRow[] selectedRows = view.getSelectedRows();
                if (selectedRows.length > 0) {
                    TorrentListViewsUtils.viewDetails(skin, selectedRows[0]);
                }
            }
        });
        return btn;
    }

    public static void viewDetails(SWTSkin skin, ListRow row) {
        DownloadManager dm = (DownloadManager)row.getDataSource(true);
        if (dm != null) {
            if (!PlatformTorrentUtils.isContent(dm.getTorrent())) {
                return;
            }
            try {
                String url = Constants.URL_PREFIX + "details/" + dm.getTorrent().getHashWrapper().toBase32String() + ".html?" + Constants.URL_SUFFIX;
                UIFunctions functions = UIFunctionsManager.getUIFunctions();
                functions.viewURL(url, "browse", 0, 0, false);
            }
            catch (TOTorrentException e) {
                Debug.out(e);
            }
        }
    }

    public static SWTSkinButtonUtility addCommentsButton(SWTSkin skin, String PREFIX, final TorrentListView view) {
        SWTSkinObject skinObject = skin.getSkinObject(PREFIX + "comment");
        if (skinObject == null) {
            return null;
        }
        SWTSkinButtonUtility btn = new SWTSkinButtonUtility(skinObject);
        btn.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

            public void pressed(SWTSkinButtonUtility buttonUtility) {
                DownloadManager dm;
                ListRow[] selectedRows = view.getSelectedRows();
                if (selectedRows.length > 0 && (dm = (DownloadManager)selectedRows[0].getDataSource(true)) != null) {
                    try {
                        String url = Constants.URL_PREFIX + "comment/" + dm.getTorrent().getHashWrapper().toBase32String() + ".html?" + Constants.URL_SUFFIX;
                        UIFunctions functions = UIFunctionsManager.getUIFunctions();
                        functions.viewURL(url, "browse", 0, 0, false);
                    }
                    catch (TOTorrentException e) {
                        Debug.out(e);
                    }
                }
            }
        });
        return btn;
    }

    public static SWTSkinButtonUtility addPlayButton(SWTSkin skin, String PREFIX, final TorrentListView view, boolean bOnlyIfMediaServer, boolean bPlayOnDoubleClick) {
        PluginInterface pi;
        SWTSkinObject skinObject = skin.getSkinObject(PREFIX + "play");
        if (skinObject == null) {
            return null;
        }
        if (bOnlyIfMediaServer && ((pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("aeupnpmediaserver")) == null || !pi.isOperational() || pi.isDisabled())) {
            skinObject.getControl().setVisible(false);
            return null;
        }
        final SWTSkinButtonUtility btn = new SWTSkinButtonUtility(skinObject);
        btn.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

            public void pressed(SWTSkinButtonUtility buttonUtility) {
                ListRow[] selectedRows = view.getSelectedRows();
                if (selectedRows.length <= 0) {
                    return;
                }
                TorrentListViewsUtils.playOrStream((DownloadManager)selectedRows[0].getDataSource(true));
            }
        });
        view.addSelectionListener(new ListSelectionAdapter(){

            public void deselected(ListRow row) {
                this.update();
            }

            public void selected(ListRow row) {
                this.update();
            }

            public void focusChanged(ListRow focusedRow) {
                this.update();
            }

            private void update() {
                EnhancedDownloadManager edm;
                DownloadManagerEnhancer dmEnhancer;
                DownloadManager dm;
                boolean bDisabled;
                ListRow[] rows = view.getSelectedRows();
                boolean bl = bDisabled = rows.length != 1;
                if (!(bDisabled || (dm = (DownloadManager)rows[0].getDataSource(true)).isDownloadComplete(false) || (dmEnhancer = DownloadManagerEnhancer.getSingleton()) == null || (edm = dmEnhancer.getEnhancedDownload(dm)) == null || edm.supportsProgressiveMode() && edm.getProgressivePlayETA() <= 0L)) {
                    bDisabled = true;
                }
                btn.setDisabled(bDisabled);
            }

            public void defaultSelected(ListRow[] rows) {
                if (rows.length == 1) {
                    TorrentListViewsUtils.playOrStream((DownloadManager)rows[0].getDataSource(true));
                }
            }
        }, true);
        return btn;
    }

    public static void playOrStream(DownloadManager dm) {
        File file;
        EnhancedDownloadManager edm;
        DownloadManagerEnhancer dmEnhancer;
        if (dm == null) {
            return;
        }
        boolean bComplete = dm.isDownloadComplete(false);
        if (!(bComplete || (dmEnhancer = DownloadManagerEnhancer.getSingleton()) == null || (edm = dmEnhancer.getEnhancedDownload(dm)) == null || edm.supportsProgressiveMode() && edm.getProgressivePlayETA() <= 0L)) {
            return;
        }
        String sFile = dm.getDownloadState().getPrimaryFile();
        if (sFile == null) {
            DiskManagerFileInfo[] diskManagerFileInfo = dm.getDiskManagerFileInfo();
            if (diskManagerFileInfo == null && diskManagerFileInfo.length == 0) {
                return;
            }
            file = diskManagerFileInfo[0].getFile(true);
        } else {
            file = new File(sFile);
        }
        String ext = FileUtil.getExtension(file.getName());
        boolean untrusted = TorrentListViewsUtils.isUntrustworthyContent(ext);
        boolean trusted = TorrentListViewsUtils.isTrustedContent(ext);
        if (untrusted || !trusted) {
            String sFileType;
            String sTextID;
            String sPrefix = untrusted ? "mb.NotTrusted." : "mb.UnknownContent.";
            UIFunctionsSWT functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (functionsSWT == null) {
                return;
            }
            Program program = Program.findProgram((String)ext);
            if (program == null) {
                sTextID = sPrefix + "noapp.text";
                sFileType = ext;
            } else {
                sTextID = sPrefix + "text";
                sFileType = program.getName();
            }
            int i = MessageBoxShell.open(functionsSWT.getMainShell(), MessageText.getString(sPrefix + "title"), MessageText.getString(sTextID, new String[]{dm.getDisplayName(), sFileType, ext}), new String[]{MessageText.getString(sPrefix + "button.run"), MessageText.getString(sPrefix + "button.cancel")}, 1);
            if (i != 0) {
                return;
            }
        }
        if (bComplete) {
            ManagerUtils.run(dm);
        } else {
            try {
                TorrentListViewsUtils.playViaMediaServer(DownloadManagerImpl.getDownloadStatic(dm));
            }
            catch (DownloadException e) {
                Debug.out(e);
            }
        }
    }

    private static boolean isTrustedContent(String ext) {
        PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("aeupnpmediaserver");
        ArrayList<String> whiteList = new ArrayList<String>();
        String[] goodExts = null;
        if (pi != null && pi.isOperational()) {
            try {
                goodExts = (String[])pi.getIPC().invoke("getRecognizedExtensions", null);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (goodExts == null) {
            goodExts = new String[]{"mpg", "avi", "mov", "flv", "flc", "mp4", "mpeg", "divx", "wmv", "asf"};
        }
        for (int i = 0; i < goodExts.length; ++i) {
            String name;
            Program program = Program.findProgram((String)goodExts[i]);
            if (program == null || whiteList.contains(name = program.getName())) continue;
            System.out.println("adding " + name);
            whiteList.add(name);
        }
        Program program = Program.findProgram((String)ext);
        if (program == null) {
            return false;
        }
        return whiteList.contains(program.getName());
    }

    private static boolean isUntrustworthyContent(String ext) {
        Object[] badExts = new String[]{"bas", "bat", "com", "cmd", "cpl", "exe", "js", "lnk", "mdb", "msi", "osx", "pif", "reg", "scr", "vb", "vbe", "vbs", "wsh", "wsf"};
        if (ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        return Arrays.binarySearch(badExts, ext) >= 0;
    }

    public static void playViaMediaServer(Download download) {
        PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("aeupnpmediaserver");
        if (pi == null) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not found"));
            return;
        }
        if (!pi.isOperational()) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not operational"));
            return;
        }
        try {
            pi.getIPC().invoke("playDownload", new Object[]{download});
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LogIDs.UI3, "IPC to media server plugin failed", e));
        }
    }

    public static void addButtonSelectionDisabler(final TorrentListView view, final SWTSkinButtonUtility[] buttonsNeedingRow, final SWTSkinButtonUtility[] buttonsNeedingPlatform, final SWTSkinButtonUtility[] buttonsNeedingSingleSelection, final SWTSkinButtonUtility btnStop) {
        view.addSelectionListener(new ListSelectionAdapter(){

            public void deselected(ListRow row) {
                this.update();
            }

            public void selected(ListRow row) {
                this.update();
            }

            public void focusChanged(ListRow focusedRow) {
                this.update();
            }

            private void update() {
                int i;
                ListRow[] rows = view.getSelectedRows();
                boolean bDisabled = rows.length == 0;
                for (i = 0; i < buttonsNeedingRow.length; ++i) {
                    if (buttonsNeedingRow[i] == null) continue;
                    buttonsNeedingRow[i].setDisabled(bDisabled);
                }
                if (!bDisabled) {
                    for (i = 0; i < rows.length; ++i) {
                        ListRow row = rows[i];
                        DownloadManager dm = (DownloadManager)row.getDataSource(true);
                        if (PlatformTorrentUtils.isContent(dm.getTorrent())) continue;
                        bDisabled = true;
                        break;
                    }
                }
                for (i = 0; i < buttonsNeedingPlatform.length; ++i) {
                    if (buttonsNeedingPlatform[i] == null) continue;
                    buttonsNeedingPlatform[i].setDisabled(bDisabled);
                }
                if (rows.length > 1) {
                    for (i = 0; i < buttonsNeedingSingleSelection.length; ++i) {
                        if (buttonsNeedingSingleSelection[i] == null) continue;
                        buttonsNeedingSingleSelection[i].setDisabled(true);
                    }
                }
                if (btnStop != null) {
                    StartStopButtonUtil.updateStopButton(view, btnStop);
                }
            }
        }, true);
    }

    public static void main(String[] args) {
        AzureusCoreFactory.create();
        System.out.println(TorrentListViewsUtils.isTrustedContent(FileUtil.getExtension("moo.exep")));
        System.out.println(TorrentListViewsUtils.isUntrustworthyContent(FileUtil.getExtension("moo.exe")));
    }
}

