/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.content.AzureusPlatformContentDirectory;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentManager;

public class InitialisationFunctions {
    private static final String EXTENSION_PREFIX = "&azid=";

    public static void initialise(AzureusCore core) {
        DownloadManagerEnhancer.initialise(core);
        InitialisationFunctions.registerTrackerURLExtensions(core);
        AzureusPlatformContentDirectory.register();
    }

    protected static void registerTrackerURLExtensions(AzureusCore core) {
        byte[] secure_id = core.getCryptoManager().getSecureID();
        final String extension = EXTENSION_PREFIX + Base32.encode(secure_id);
        PluginInterface pi = core.getPluginManager().getDefaultPluginInterface();
        TorrentManager tm = pi.getTorrentManager();
        final TorrentAttribute ta = tm.getAttribute("TrackerClientExtensions");
        pi.getDownloadManager().addListener(new DownloadManagerListener(){

            public void downloadAdded(Download download) {
                String value = download.getAttribute(ta);
                if (value != null) {
                    if (value.indexOf(extension) != -1) {
                        return;
                    }
                    if (value.indexOf(InitialisationFunctions.EXTENSION_PREFIX) != -1) {
                        String[] bits = value.split("&");
                        value = "";
                        for (int i = 0; i < bits.length; ++i) {
                            String bit = bits[i].trim();
                            if (bit.length() == 0 || bit.startsWith(InitialisationFunctions.EXTENSION_PREFIX.substring(1))) continue;
                            value = value + "&" + bit;
                        }
                    }
                    value = value + extension;
                } else {
                    value = extension;
                }
                download.setAttribute(ta, value);
            }

            public void downloadRemoved(Download download) {
            }
        });
    }
}

