/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import edu.harvard.syrah.nc.Coordinate;
import java.io.DataOutputStream;
import java.io.IOException;

abstract class SyrahPosition
implements DHTNetworkPosition {
    protected SyrahPosition() {
    }

    public abstract Coordinate getStableCoords();

    public abstract Coordinate getCoords();

    public abstract float getError();

    public abstract long getAge();

    public byte getPositionType() {
        return 5;
    }

    public int getSerialisedSize() {
        return 33;
    }

    public void serialise(DataOutputStream dos) throws IOException {
        this.getCoords().toSerialized(dos);
        dos.writeFloat(this.getError());
        dos.writeLong(this.getAge());
    }

    public boolean isValid() {
        return !Float.isNaN(this.getError()) && this.getCoords().isValid();
    }

    public String toString() {
        return new String(this.getCoords() + ",er=" + this.getError() + ",age=" + this.getAge());
    }
}

