/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.services;

import com.aelitis.net.upnp.UPnPAction;
import com.aelitis.net.upnp.UPnPActionArgument;
import com.aelitis.net.upnp.UPnPActionInvocation;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.impl.UPnPImpl;
import com.aelitis.net.upnp.impl.device.UPnPRootDeviceImpl;
import com.aelitis.net.upnp.impl.services.UPnPServiceImpl;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import com.aelitis.net.upnp.services.UPnPWANConnectionListener;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class UPnPSSWANConnectionImpl
implements UPnPWANConnection {
    private static AEMonitor class_mon = new AEMonitor("UPnPSSWANConnection");
    private static List services = new ArrayList();
    private UPnPServiceImpl service;
    private List mappings = new ArrayList();
    private List listeners = new ArrayList();
    private boolean recheck_mappings = true;
    private boolean last_mapping_check_failed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UPnPSSWANConnectionImpl(UPnPServiceImpl _service) {
        this.service = _service;
        try {
            class_mon.enter();
            services.add(this);
        }
        finally {
            class_mon.exit();
        }
    }

    public int getCapabilities() {
        String device_name = this.service.getDevice().getRootDevice().getDevice().getFriendlyName();
        int capabilities = -1;
        if (device_name.equals("WRT54G")) {
            capabilities = -2;
        }
        return capabilities;
    }

    public UPnPService getGenericService() {
        return this.service;
    }

    public String[] getStatusInfo() throws UPnPException {
        UPnPAction act = this.service.getAction("GetStatusInfo");
        if (act == null) {
            this.log("Action 'GetStatusInfo' not supported, binding not established");
            throw new UPnPException("GetStatusInfo not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        UPnPActionArgument[] args = inv.invoke();
        String connection_status = null;
        String connection_error = null;
        String uptime = null;
        for (int i = 0; i < args.length; ++i) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewConnectionStatus")) {
                connection_status = arg.getValue();
                continue;
            }
            if (name.equalsIgnoreCase("NewLastConnectionError")) {
                connection_error = arg.getValue();
                continue;
            }
            if (!name.equalsIgnoreCase("NewUptime")) continue;
            uptime = arg.getValue();
        }
        return new String[]{connection_status, connection_error, uptime};
    }

    public void periodicallyRecheckMappings(boolean on) {
        this.recheck_mappings = on;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkMappings() throws UPnPException {
        ArrayList mappings_copy;
        if (!this.recheck_mappings) {
            return;
        }
        try {
            class_mon.enter();
            mappings_copy = new ArrayList(this.mappings);
        }
        finally {
            class_mon.exit();
        }
        UPnPWANConnectionPortMapping[] current = this.getPortMappings();
        Iterator it = mappings_copy.iterator();
        block5: while (it.hasNext()) {
            portMapping mapping = (portMapping)it.next();
            for (int j = 0; j < current.length; ++j) {
                UPnPWANConnectionPortMapping c = current[j];
                if (c.getExternalPort() != mapping.getExternalPort() || c.isTCP() != mapping.isTCP()) continue;
                it.remove();
                continue block5;
            }
        }
        boolean log = false;
        if (mappings_copy.size() > 0) {
            if (!this.last_mapping_check_failed) {
                this.last_mapping_check_failed = true;
                log = true;
            }
        } else {
            this.last_mapping_check_failed = false;
        }
        it = mappings_copy.iterator();
        while (it.hasNext()) {
            portMapping mapping = (portMapping)it.next();
            try {
                if (log) {
                    this.log("Re-establishing mapping " + mapping.getString());
                }
                this.addPortMapping(mapping.isTCP(), mapping.getExternalPort(), mapping.getDescription());
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPortMapping(boolean tcp, int port, String description) throws UPnPException {
        UPnPAction act = this.service.getAction("AddPortMapping");
        if (act == null) {
            this.log("Action 'AddPortMapping' not supported, binding not established");
        } else {
            UPnPActionInvocation add_inv = act.getInvocation();
            add_inv.addArgument("NewRemoteHost", "");
            add_inv.addArgument("NewExternalPort", "" + port);
            add_inv.addArgument("NewProtocol", tcp ? "TCP" : "UDP");
            add_inv.addArgument("NewInternalPort", "" + port);
            add_inv.addArgument("NewInternalClient", this.service.getDevice().getRootDevice().getLocalAddress().getHostAddress());
            add_inv.addArgument("NewEnabled", "1");
            add_inv.addArgument("NewPortMappingDescription", description);
            add_inv.addArgument("NewLeaseDuration", "0");
            boolean ok = false;
            try {
                add_inv.invoke();
                ok = true;
            }
            catch (UPnPException original_error) {
                try {
                    UPnPActionInvocation rem_inv = act.getInvocation();
                    rem_inv.addArgument("NewRemoteHost", "");
                    rem_inv.addArgument("NewProtocol", tcp ? "TCP" : "UDP");
                    rem_inv.addArgument("NewExternalPort", "" + port);
                    rem_inv.invoke();
                }
                catch (Throwable e) {
                    throw original_error;
                }
                add_inv.invoke();
                ok = true;
            }
            finally {
                ((UPnPRootDeviceImpl)this.service.getDevice().getRootDevice()).portMappingResult(ok);
                for (int i = 0; i < this.listeners.size(); ++i) {
                    UPnPWANConnectionListener listener = (UPnPWANConnectionListener)this.listeners.get(i);
                    try {
                        listener.mappingResult(this, ok);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            try {
                class_mon.enter();
                Iterator it = this.mappings.iterator();
                while (it.hasNext()) {
                    portMapping m = (portMapping)it.next();
                    if (m.getExternalPort() != port || m.isTCP() != tcp) continue;
                    it.remove();
                }
                this.mappings.add(new portMapping(port, tcp, "", description));
            }
            finally {
                class_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePortMapping(boolean tcp, int port) throws UPnPException {
        UPnPAction act = this.service.getAction("DeletePortMapping");
        if (act == null) {
            this.log("Action 'DeletePortMapping' not supported, binding not removed");
        } else {
            boolean mapping_found = false;
            try {
                class_mon.enter();
                Iterator it = this.mappings.iterator();
                while (it.hasNext()) {
                    portMapping mapping = (portMapping)it.next();
                    if (mapping.getExternalPort() != port || mapping.isTCP() != tcp) continue;
                    it.remove();
                    mapping_found = true;
                    break;
                }
            }
            finally {
                class_mon.exit();
            }
            try {
                long start = SystemTime.getCurrentTime();
                UPnPActionInvocation inv = act.getInvocation();
                inv.addArgument("NewRemoteHost", "");
                inv.addArgument("NewProtocol", tcp ? "TCP" : "UDP");
                inv.addArgument("NewExternalPort", "" + port);
                inv.invoke();
                long elapsed = SystemTime.getCurrentTime() - start;
                if (elapsed > 4000L) {
                    String info = this.service.getDevice().getRootDevice().getInfo();
                    ((UPnPImpl)this.service.getDevice().getRootDevice().getUPnP()).logAlert("UPnP device '" + info + "' is taking a long time to release port mappings, consider disabling this via the UPnP configuration.", false, 3);
                }
            }
            catch (UPnPException e) {
                if (mapping_found) {
                    throw e;
                }
                this.log("Removal of mapping failed but not established explicitly so ignoring error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UPnPWANConnectionPortMapping[] getPortMappings() throws UPnPException {
        boolean ok = true;
        try {
            int entries = 0;
            UPnPAction act = this.service.getAction("GetGenericPortMappingEntry");
            if (act == null) {
                this.log("Action 'GetGenericPortMappingEntry' not supported, can't enumerate bindings");
                UPnPWANConnectionPortMapping[] uPnPWANConnectionPortMappingArray = new UPnPWANConnectionPortMapping[]{};
                return uPnPWANConnectionPortMappingArray;
            }
            ArrayList<portMapping> res = new ArrayList<portMapping>();
            portMapping prev_mapping = null;
            for (int i = 0; i < (entries == 0 ? 512 : entries); ++i) {
                UPnPActionInvocation inv = act.getInvocation();
                inv.addArgument("NewPortMappingIndex", "" + i);
                try {
                    UPnPActionArgument[] outs = inv.invoke();
                    int port = 0;
                    boolean tcp = false;
                    String internal_host = null;
                    String description = "";
                    for (int j = 0; j < outs.length; ++j) {
                        UPnPActionArgument out = outs[j];
                        String out_name = out.getName();
                        if (out_name.equalsIgnoreCase("NewExternalPort")) {
                            port = Integer.parseInt(out.getValue());
                            continue;
                        }
                        if (out_name.equalsIgnoreCase("NewProtocol")) {
                            tcp = out.getValue().equalsIgnoreCase("TCP");
                            continue;
                        }
                        if (out_name.equalsIgnoreCase("NewInternalClient")) {
                            internal_host = out.getValue();
                            continue;
                        }
                        if (!out_name.equalsIgnoreCase("NewPortMappingDescription")) continue;
                        description = out.getValue();
                    }
                    if (prev_mapping != null && prev_mapping.getExternalPort() == port && prev_mapping.isTCP() == tcp) break;
                    prev_mapping = new portMapping(port, tcp, internal_host, description);
                    res.add(prev_mapping);
                    continue;
                }
                catch (UPnPException e) {
                    if (entries == 0) break;
                    ok = false;
                    throw e;
                }
            }
            UPnPWANConnectionPortMapping[] res2 = new UPnPWANConnectionPortMapping[res.size()];
            res.toArray(res2);
            UPnPWANConnectionPortMapping[] uPnPWANConnectionPortMappingArray = res2;
            return uPnPWANConnectionPortMappingArray;
        }
        finally {
            for (int i = 0; i < this.listeners.size(); ++i) {
                UPnPWANConnectionListener listener = (UPnPWANConnectionListener)this.listeners.get(i);
                try {
                    listener.mappingsReadResult(this, ok);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public String getExternalIPAddress() throws UPnPException {
        UPnPAction act = this.service.getAction("GetExternalIPAddress");
        if (act == null) {
            this.log("Action 'GetExternalIPAddress' not supported, binding not established");
            throw new UPnPException("GetExternalIPAddress not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        UPnPActionArgument[] args = inv.invoke();
        String ip = null;
        for (int i = 0; i < args.length; ++i) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (!name.equalsIgnoreCase("NewExternalIPAddress")) continue;
            ip = arg.getValue();
        }
        return ip;
    }

    protected void log(String str) {
        this.service.getDevice().getRootDevice().getUPnP().log(str);
    }

    public void addListener(UPnPWANConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(UPnPWANConnectionListener listener) {
        this.listeners.add(listener);
    }

    static {
        SimpleTimer.addPeriodicEvent("UPnPSSWAN:checker", 600000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent ev) {
                try {
                    ArrayList<UPnPSSWANConnectionImpl> to_check = new ArrayList<UPnPSSWANConnectionImpl>();
                    try {
                        class_mon.enter();
                        Iterator it = services.iterator();
                        while (it.hasNext()) {
                            UPnPSSWANConnectionImpl s = (UPnPSSWANConnectionImpl)it.next();
                            if (s.getGenericService().getDevice().getRootDevice().isDestroyed()) {
                                it.remove();
                                continue;
                            }
                            to_check.add(s);
                        }
                    }
                    finally {
                        class_mon.exit();
                    }
                    for (int i = 0; i < to_check.size(); ++i) {
                        try {
                            ((UPnPSSWANConnectionImpl)to_check.get(i)).checkMappings();
                            continue;
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        });
    }

    protected class portMapping
    implements UPnPWANConnectionPortMapping {
        protected int external_port;
        protected boolean tcp;
        protected String internal_host;
        protected String description;

        protected portMapping(int _external_port, boolean _tcp, String _internal_host, String _description) {
            this.external_port = _external_port;
            this.tcp = _tcp;
            this.internal_host = _internal_host;
            this.description = _description;
        }

        public boolean isTCP() {
            return this.tcp;
        }

        public int getExternalPort() {
            return this.external_port;
        }

        public String getInternalHost() {
            return this.internal_host;
        }

        public String getDescription() {
            return this.description;
        }

        protected String getString() {
            return this.getDescription() + " [" + this.getExternalPort() + ":" + (this.isTCP() ? "TCP" : "UDP") + "]";
        }
    }
}

