/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.services;

import com.aelitis.net.upnp.UPnPAction;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.UPnPStateVariable;
import com.aelitis.net.upnp.impl.device.UPnPDeviceImpl;
import com.aelitis.net.upnp.impl.services.UPnPActionImpl;
import com.aelitis.net.upnp.impl.services.UPnPSSWANCommonInterfaceConfigImpl;
import com.aelitis.net.upnp.impl.services.UPnPSSWANIPConnectionImpl;
import com.aelitis.net.upnp.impl.services.UPnPSSWANPPPConnectionImpl;
import com.aelitis.net.upnp.impl.services.UPnPStateVariableImpl;
import com.aelitis.net.upnp.services.UPnPSpecificService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class UPnPServiceImpl
implements UPnPService {
    protected UPnPDeviceImpl device;
    protected String service_type;
    protected String desc_url;
    protected String control_url;
    protected List actions;
    protected List state_vars;
    protected boolean direct_invoke;

    public UPnPServiceImpl(UPnPDeviceImpl _device, String indent, SimpleXMLParserDocumentNode service_node) {
        this.device = _device;
        this.service_type = service_node.getChild("ServiceType").getValue().trim();
        this.desc_url = this.device.getAbsoluteURL(service_node.getChild("SCPDURL").getValue());
        this.control_url = this.device.getAbsoluteURL(service_node.getChild("controlURL").getValue());
        this.device.getUPnP().log(indent + this.service_type + ":desc=" + this.desc_url + ", control=" + this.control_url);
    }

    public UPnPDevice getDevice() {
        return this.device;
    }

    public String getServiceType() {
        return this.service_type;
    }

    public UPnPAction[] getActions() throws UPnPException {
        if (this.actions == null) {
            this.loadDescription();
        }
        UPnPAction[] res = new UPnPAction[this.actions.size()];
        this.actions.toArray(res);
        return res;
    }

    public UPnPAction getAction(String name) throws UPnPException {
        UPnPAction[] my_actions = this.getActions();
        for (int i = 0; i < my_actions.length; ++i) {
            if (!my_actions[i].getName().equalsIgnoreCase(name)) continue;
            return my_actions[i];
        }
        return null;
    }

    public UPnPStateVariable[] getStateVariables() throws UPnPException {
        if (this.state_vars == null) {
            this.loadDescription();
        }
        UPnPStateVariable[] res = new UPnPStateVariable[this.state_vars.size()];
        this.state_vars.toArray(res);
        return res;
    }

    public UPnPStateVariable getStateVariable(String name) throws UPnPException {
        UPnPStateVariable[] vars = this.getStateVariables();
        for (int i = 0; i < vars.length; ++i) {
            if (!vars[i].getName().equalsIgnoreCase(name)) continue;
            return vars[i];
        }
        return null;
    }

    public URL getDescriptionURL() throws UPnPException {
        return this.getURL(this.desc_url);
    }

    public URL getControlURL() throws UPnPException {
        return this.getURL(this.control_url);
    }

    protected URL getURL(String basis) throws UPnPException {
        try {
            URL target;
            if (basis.toLowerCase().startsWith("http")) {
                target = new URL(basis);
            } else {
                URL root_location = this.device.getRootDevice().getLocation();
                target = new URL(root_location.getProtocol() + "://" + root_location.getHost() + (root_location.getPort() == -1 ? "" : ":" + root_location.getPort()) + (basis.startsWith("/") ? "" : "/") + basis);
            }
            return target;
        }
        catch (MalformedURLException e) {
            throw new UPnPException("Malformed URL", e);
        }
    }

    protected void loadDescription() throws UPnPException {
        SimpleXMLParserDocument doc = this.device.getUPnP().downloadXML(this.getDescriptionURL());
        this.parseActions(doc.getChild("ActionList"));
        this.parseStateVars(doc.getChild("ServiceStateTable"));
    }

    protected void parseActions(SimpleXMLParserDocumentNode action_list) {
        this.actions = new ArrayList();
        SimpleXMLParserDocumentNode[] kids = action_list.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            this.actions.add(new UPnPActionImpl(this, kids[i]));
        }
    }

    protected void parseStateVars(SimpleXMLParserDocumentNode action_list) {
        this.state_vars = new ArrayList();
        SimpleXMLParserDocumentNode[] kids = action_list.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            this.state_vars.add(new UPnPStateVariableImpl(this, kids[i]));
        }
    }

    public UPnPSpecificService getSpecificService() {
        if (this.service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANIPConnection:1")) {
            return new UPnPSSWANIPConnectionImpl(this);
        }
        if (this.service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANPPPConnection:1")) {
            return new UPnPSSWANPPPConnectionImpl(this);
        }
        if (this.service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1")) {
            return new UPnPSSWANCommonInterfaceConfigImpl(this);
        }
        return null;
    }

    public boolean getDirectInvocations() {
        return this.direct_invoke;
    }

    public void setDirectInvocations(boolean force) {
        this.direct_invoke = force;
    }
}

