/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.syrah.nc;

import edu.harvard.syrah.nc.Vec;
import edu.harvard.syrah.nc.VivaldiClient;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Coordinate {
    protected static final int CLASS_HASH = Coordinate.class.hashCode();
    protected final double[] coords;
    protected final byte version;
    protected final int num_dims;
    public static double MIN_COORD = 0.1;

    public byte getVersion() {
        return this.version;
    }

    public Coordinate makeCopy() {
        return new Coordinate(this.coords, true);
    }

    public Coordinate(int num_dimensions) {
        this.coords = new double[num_dimensions];
        this.version = (byte)4;
        if (VivaldiClient.USE_HEIGHT) {
            --num_dimensions;
        }
        this.num_dims = num_dimensions;
    }

    public Coordinate(int num_dimensions, DataInputStream dis) throws IOException {
        this.coords = new double[num_dimensions];
        this.version = dis.readByte();
        for (int i = 0; i < num_dimensions; ++i) {
            this.coords[i] = dis.readFloat();
        }
        if (VivaldiClient.USE_HEIGHT) {
            --num_dimensions;
        }
        this.num_dims = num_dimensions;
    }

    public void toSerialized(DataOutputStream dos) throws IOException {
        int num_dims = this.coords.length;
        dos.writeByte(this.version);
        for (int i = 0; i < num_dims; ++i) {
            dos.writeFloat((float)this.coords[i]);
        }
    }

    protected Coordinate(Coordinate c) {
        this(c.coords, true);
    }

    protected Coordinate(double[] init_pos, boolean make_copy) {
        int _num_dims = init_pos.length;
        if (make_copy) {
            this.coords = new double[_num_dims];
            System.arraycopy(init_pos, 0, this.coords, 0, _num_dims);
        } else {
            this.coords = init_pos;
        }
        this.version = (byte)4;
        if (VivaldiClient.USE_HEIGHT) {
            --_num_dims;
        }
        this.num_dims = _num_dims;
    }

    public Coordinate(float[] init_pos) {
        int _num_dims = init_pos.length;
        this.coords = new double[_num_dims];
        for (int i = 0; i < _num_dims; ++i) {
            this.coords[i] = init_pos[i];
        }
        this.version = (byte)4;
        if (VivaldiClient.USE_HEIGHT) {
            --_num_dims;
        }
        this.num_dims = _num_dims;
    }

    public boolean isCompatible(Coordinate _other) {
        return this.version == _other.version;
    }

    public void bump() {
        for (int i = 0; i < this.coords.length; ++i) {
            if (!(Math.abs(this.coords[i]) < MIN_COORD)) continue;
            double length = VivaldiClient.random.nextDouble() + MIN_COORD;
            if ((!VivaldiClient.USE_HEIGHT || i < this.coords.length - 1) && VivaldiClient.random.nextBoolean()) {
                length *= -1.0;
            }
            int n = i;
            this.coords[n] = this.coords[n] + length;
        }
    }

    public int getNumDimensions() {
        return this.coords.length;
    }

    public double distanceToNonOriginCoord(Coordinate c) {
        if (this.atOrigin() || c.atOrigin()) {
            return Double.NaN;
        }
        return this.distanceTo(c);
    }

    public double distanceTo(Coordinate c) {
        if (!this.isCompatible(c)) {
            return Double.NaN;
        }
        if (!this.isValid() || !c.isValid()) {
            return Double.NaN;
        }
        assert (VivaldiClient.USE_HEIGHT && this.num_dims == this.coords.length - 1 || !VivaldiClient.USE_HEIGHT && this.num_dims == this.coords.length);
        if (c == null) {
            return -1.0;
        }
        double sum = 0.0;
        for (int i = 0; i < this.num_dims; ++i) {
            double abs_dist = this.coords[i] - c.coords[i];
            sum += abs_dist * abs_dist;
        }
        sum = Math.sqrt(sum);
        if (VivaldiClient.USE_HEIGHT && sum > 0.0) {
            sum = sum + this.coords[this.coords.length - 1] + c.coords[this.coords.length - 1];
        }
        return sum;
    }

    public void add(Vec v) {
        int num_dims = this.coords.length;
        for (int i = 0; i < num_dims; ++i) {
            int n = i;
            this.coords[n] = this.coords[n] + v.direction[i];
        }
    }

    protected Vec getDirection(Coordinate c) {
        double length = this.distanceTo(c);
        if (length == 0.0) {
            return null;
        }
        Vec new_vec = new Vec(this.coords.length);
        for (int i = 0; i < this.num_dims; ++i) {
            new_vec.direction[i] = (c.coords[i] - this.coords[i]) / length;
        }
        if (VivaldiClient.USE_HEIGHT) {
            new_vec.direction[this.coords.length - 1] = (c.coords[this.coords.length - 1] + this.coords[this.coords.length - 1]) / length;
        }
        return new_vec;
    }

    protected boolean assign(Coordinate c) {
        if (this.coords.length != c.coords.length) {
            return false;
        }
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i] = c.coords[i];
        }
        return true;
    }

    public void checkHeight() {
        if (!VivaldiClient.USE_HEIGHT) {
            return;
        }
        if (this.coords[this.coords.length - 1] <= MIN_COORD) {
            this.coords[this.coords.length - 1] = VivaldiClient.random.nextDouble() + MIN_COORD;
        }
    }

    public boolean atOrigin() {
        for (int i = 0; i < this.coords.length; ++i) {
            if (this.coords[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    public Vec asVectorFromZero(boolean make_copy) {
        return new Vec(this.coords, make_copy);
    }

    public boolean isValid() {
        double NEG_MAX_DIST_FROM_ORIGIN = -1.0 * VivaldiClient.MAX_DIST_FROM_ORIGIN;
        for (int i = 0; i < this.coords.length; ++i) {
            if (Double.isNaN(this.coords[i])) {
                return false;
            }
            if (!(this.coords[i] > VivaldiClient.MAX_DIST_FROM_ORIGIN) && !(this.coords[i] < NEG_MAX_DIST_FROM_ORIGIN)) continue;
            return false;
        }
        return !VivaldiClient.USE_HEIGHT || !(this.coords[this.coords.length - 1] < 0.0);
    }

    protected void reset() {
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i] = 0.0;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Coordinate) {
            Coordinate c = (Coordinate)obj;
            int num_dims = this.coords.length;
            for (int i = 0; i < num_dims; ++i) {
                if (this.coords[i] == c.coords[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int num_dims = this.coords.length;
        int hc = CLASS_HASH;
        for (int i = 0; i < num_dims; ++i) {
            hc ^= new Double(this.coords[i]).hashCode();
        }
        return hc;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(1024);
        sbuf.append("[");
        int num_dims = this.coords.length;
        int i = 0;
        while (true) {
            if (i == num_dims - 1 && VivaldiClient.USE_HEIGHT) {
                sbuf.append('h');
            }
            sbuf.append(VivaldiClient.nf.format(this.coords[i]));
            if (++i >= num_dims) break;
            sbuf.append(",");
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    public String toStringAsVector() {
        StringBuffer sbuf = new StringBuffer(1024);
        for (int i = 0; i < this.coords.length; ++i) {
            if (i == this.coords.length - 1 && VivaldiClient.USE_HEIGHT) {
                sbuf.append('h');
            }
            sbuf.append(VivaldiClient.nf.format(this.coords[i]));
            if (i == this.coords.length - 1) continue;
            sbuf.append(" ");
        }
        return sbuf.toString();
    }
}

