/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.syrah.nc;

import edu.harvard.syrah.nc.ApplicationObserver;
import edu.harvard.syrah.nc.Coordinate;
import edu.harvard.syrah.nc.EWMAStatistic;
import edu.harvard.syrah.nc.ObserverList;
import edu.harvard.syrah.nc.RemoteState;
import edu.harvard.syrah.nc.Vec;
import edu.harvard.syrah.nc.WindowStatistic;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VivaldiClient<T> {
    protected static Logger crawler_log = Logger.getLogger(VivaldiClient.class.getName());
    public static final boolean SIMULATION = false;
    public static boolean debug = false;
    public static boolean debugCrawler = false;
    public static boolean debugGood = false;
    public static final byte VERSION_02 = 2;
    public static final byte VERSION_03 = 3;
    public static final byte VERSION_04 = 4;
    public static final byte CURRENT_VERSION = 4;
    public static double COORD_ERROR = 0.1;
    public static double COORD_CONTROL = 0.25;
    public static boolean USE_HEIGHT = true;
    public static final int MAX_NEIGHBORS = 512;
    protected static final int WINDOW_SIZE = 64;
    public static long RS_EXPIRATION = 259200000L;
    public static final long MAINTENANCE_PERIOD = 600000L;
    public static final int MAX_RS_MAP_SIZE = 32768;
    private long lastMaintenanceStamp = 0L;
    public static Random random = new Random();
    public static final double APP_UPDATE_THRESHOLD = 0.1;
    public static final double OUTRAGEOUSLY_LARGE_RTT = 20000.0;
    public static double GRAVITY_DIAMETER = 512.0;
    public static double MAX_DIST_FROM_ORIGIN = 60000.0;
    protected static final NumberFormat nf = NumberFormat.getInstance();
    protected static final int NFDigits = 3;
    static boolean haveSetFormat = false;
    protected final int num_dims;
    protected Coordinate app_coord;
    protected Coordinate sys_coord;
    protected double error;
    public static final double MAX_ERROR = 1.0;
    public static boolean keepStatistics = true;
    public static final int RUNNING_STAT_HISTORY = 1024;
    protected WindowStatistic running_sys_error;
    protected WindowStatistic running_app_error;
    protected EWMAStatistic running_sys_dd;
    protected EWMAStatistic running_app_dd;
    protected EWMAStatistic running_neighbors_used;
    protected EWMAStatistic running_relative_diff;
    protected EWMAStatistic running_sys_update_frequency;
    protected EWMAStatistic running_app_update_frequency;
    protected EWMAStatistic running_age;
    protected EWMAStatistic running_gravity;
    protected long time_of_last_app_update = -1L;
    protected final List<RemoteState<T>> neighbors;
    protected long time_of_last_sys_update = -1L;
    protected final ObserverList obs_list;
    protected final HashMap<T, RemoteState<T>> rs_map;
    protected final Set<T> hosts;
    protected Coordinate start_centroid;
    protected boolean updated_app_coord_at_least_once = false;
    protected final List<Coordinate> start_coords;
    protected final List<Coordinate> current_coords;
    protected Coordinate nearest_neighbor;
    protected T local_addr;
    private Map<T, Integer> addr2id = new HashMap<T, Integer>();
    private int idCounter = 0;

    public VivaldiClient(int _num_dims) {
        this.num_dims = _num_dims;
        this.app_coord = new Coordinate(this.num_dims);
        this.sys_coord = new Coordinate(this.num_dims);
        this.error = 1.0;
        this.neighbors = new ArrayList<RemoteState<T>>();
        this.obs_list = new ObserverList();
        this.rs_map = new HashMap();
        this.hosts = Collections.unmodifiableSet(this.rs_map.keySet());
        this.start_coords = new LinkedList<Coordinate>();
        this.current_coords = new LinkedList<Coordinate>();
        this.nearest_neighbor = null;
        if (keepStatistics) {
            this.running_sys_update_frequency = new EWMAStatistic();
            this.running_app_update_frequency = new EWMAStatistic();
            this.running_sys_error = new WindowStatistic(1024);
            this.running_app_error = new WindowStatistic(1024);
            this.running_sys_dd = new EWMAStatistic();
            this.running_app_dd = new EWMAStatistic();
            this.running_neighbors_used = new EWMAStatistic();
            this.running_relative_diff = new EWMAStatistic();
            this.running_age = new EWMAStatistic();
            this.running_gravity = new EWMAStatistic();
        }
        if (!haveSetFormat) {
            if (nf.getMaximumFractionDigits() > 3) {
                nf.setMaximumFractionDigits(3);
            }
            if (nf.getMinimumFractionDigits() > 3) {
                nf.setMinimumFractionDigits(3);
            }
            nf.setGroupingUsed(false);
            haveSetFormat = true;
        }
    }

    public void setLocalID(T _local_addr) {
        this.local_addr = _local_addr;
    }

    protected ApplicationStatistics computeApplicationStatistics() {
        ApplicationStatistics appStats = new ApplicationStatistics();
        if (this.sys_coord.atOrigin() || this.neighbors == null || this.neighbors.size() == 0) {
            return appStats;
        }
        int rrl_wrong = 0;
        int rrl_count = 0;
        double narl_loss = 0.0;
        double narl_sum = 0.0;
        double ralp_loss = 0.0;
        double ralp_sum = 0.0;
        for (RemoteState<T> A_rs : this.neighbors) {
            double A_rtt = A_rs.getSample();
            double A_metric = this.sys_coord.distanceTo(A_rs.getLastCoordinate());
            if (!(A_rtt > 0.0) || !(A_metric > 0.0)) continue;
            for (RemoteState<T> B_rs : this.neighbors) {
                if (A_rs.addr.equals(B_rs.addr)) continue;
                double B_rtt = B_rs.getSample();
                double B_metric = this.sys_coord.distanceTo(B_rs.getLastCoordinate());
                if (!(B_rtt > 0.0) || !(B_metric > 0.0)) continue;
                double rtt_diff = Math.abs(A_rtt - B_rtt);
                ++rrl_count;
                narl_sum += rtt_diff;
                if (A_rtt > B_rtt && A_metric < B_metric || B_rtt > A_rtt && B_metric < A_metric) {
                    ++rrl_wrong;
                    narl_loss += rtt_diff;
                }
                if (A_rtt > B_rtt && A_metric < B_metric) {
                    ralp_loss += rtt_diff;
                    ralp_sum += A_rtt;
                }
                if (!(B_rtt > A_rtt) || !(B_metric < A_metric)) continue;
                ralp_loss += rtt_diff;
                ralp_sum += B_rtt;
            }
        }
        appStats.validLinkCount = rrl_count;
        if (rrl_count > 0) {
            appStats.rrl = (double)rrl_wrong / (double)rrl_count;
        }
        if (narl_sum > 0.0) {
            appStats.narl = narl_loss / narl_sum;
        }
        if (ralp_sum > 0.0) {
            appStats.ralp = ralp_loss / ralp_sum;
        }
        return appStats;
    }

    public synchronized String toString() {
        if (keepStatistics) {
            ApplicationStatistics appStats = this.computeApplicationStatistics();
            return new String("[sc=" + this.sys_coord + ",ac=" + this.app_coord + ",er=" + nf.format(this.error) + ",sys_re50=" + nf.format(this.running_sys_error.getPercentile(0.5)) + ",sys_re95=" + nf.format(this.running_sys_error.getPercentile(0.95)) + ",app_re50=" + nf.format(this.running_app_error.getPercentile(0.5)) + ",app_re95=" + nf.format(this.running_app_error.getPercentile(0.95)) + ",sys_dd=" + nf.format(this.running_sys_dd.get()) + ",app_dd=" + nf.format(this.running_app_dd.get()) + ",ne=" + nf.format(this.running_neighbors_used.get()) + ",rd=" + nf.format(this.running_relative_diff.get()) + ",sf=" + nf.format(this.running_sys_update_frequency.get()) + ",af=" + nf.format(this.running_app_update_frequency.get()) + ",rrl=" + nf.format(appStats.rrl) + ",narl=" + nf.format(appStats.narl) + ",ralp=" + nf.format(appStats.ralp) + ",age=" + this.getAge(System.currentTimeMillis()) + ",vl=" + nf.format(appStats.validLinkCount) + ",gr=" + nf.format(this.running_gravity.get()) + ",nn=" + nf.format(this.sys_coord.distanceTo(this.nearest_neighbor)) + "]");
        }
        return new String("[sc=" + this.sys_coord + ",ac=" + this.app_coord + ",er=" + nf.format(this.error) + ",nn=" + nf.format(this.sys_coord.distanceTo(this.nearest_neighbor)) + "]");
    }

    public synchronized Hashtable<String, Double> getStatistics() {
        Hashtable<String, Double> stats = new Hashtable<String, Double>();
        for (int i = 0; i < this.num_dims; ++i) {
            stats.put("sys_coord_" + i, this.sys_coord.coords[i]);
            stats.put("app_coord_" + i, this.sys_coord.coords[i]);
        }
        stats.put("er", this.error);
        stats.put("nn", this.sys_coord.distanceTo(this.nearest_neighbor));
        if (keepStatistics) {
            ApplicationStatistics appStats = this.computeApplicationStatistics();
            stats.put("rrl", appStats.rrl);
            stats.put("narl", appStats.narl);
            stats.put("ralp", appStats.ralp);
            stats.put("age", new Double(this.getAge(System.currentTimeMillis())));
            stats.put("vl", new Double(appStats.validLinkCount));
            stats.put("gr", this.running_gravity.get());
            stats.put("sys_re50", this.running_sys_error.getPercentile(0.5));
            stats.put("sys_re95", this.running_sys_error.getPercentile(0.95));
            stats.put("app_re50", this.running_app_error.getPercentile(0.5));
            stats.put("app_re95", this.running_app_error.getPercentile(0.95));
            stats.put("sys_dd", this.running_sys_dd.get());
            stats.put("app_dd", this.running_app_dd.get());
            stats.put("ne", this.running_neighbors_used.get());
            stats.put("rd", this.running_relative_diff.get());
            stats.put("sf", this.running_sys_update_frequency.get());
            stats.put("af", this.running_app_update_frequency.get());
        }
        return stats;
    }

    public synchronized void reset() {
        this.sys_coord.reset();
        this.app_coord.reset();
        this.error = 1.0;
        this.rs_map.clear();
        this.start_coords.clear();
        this.current_coords.clear();
        this.nearest_neighbor = null;
    }

    public synchronized boolean updatedYet() {
        return this.updated_app_coord_at_least_once;
    }

    public synchronized int getNumDimensions() {
        return this.num_dims;
    }

    public synchronized Coordinate getApplicationCoords() {
        return new Coordinate(this.sys_coord);
    }

    public synchronized Coordinate getSystemCoords() {
        return new Coordinate(this.sys_coord);
    }

    public synchronized double getSystemError() {
        return this.error;
    }

    public synchronized long getAge(long curr_time) {
        if (curr_time < this.time_of_last_sys_update) {
            return 0L;
        }
        return curr_time - this.time_of_last_sys_update;
    }

    public synchronized ObserverList getObserverList() {
        return this.obs_list;
    }

    public synchronized boolean addHost(T addr) {
        if (this.rs_map.containsKey(addr)) {
            return false;
        }
        RemoteState<T> rs = new RemoteState<T>(addr);
        this.rs_map.put(addr, rs);
        return true;
    }

    public synchronized boolean addHost(T addr, Coordinate _r_coord, double r_error, long curr_time, boolean can_update) {
        RemoteState<T> rs = null;
        if (this.rs_map.containsKey(addr)) {
            if (!can_update) {
                return false;
            }
            rs = this.rs_map.get(addr);
        } else {
            rs = new RemoteState<T>(addr);
            this.rs_map.put(addr, rs);
        }
        Coordinate r_coord = _r_coord.makeCopy();
        rs.assign(r_coord, r_error, curr_time);
        return true;
    }

    public synchronized boolean removeHost(T addr) {
        return this.rs_map.containsKey(addr);
    }

    public synchronized boolean containsHost(T addr) {
        return this.rs_map.containsKey(addr);
    }

    public synchronized Set<T> getHosts() {
        return this.hosts;
    }

    public synchronized boolean processSample(T addr, Coordinate _r_coord, double r_error, double sample_rtt, long sample_age, long curr_time, boolean can_add) {
        int id = this.getIdFromAddr(addr);
        if (debugCrawler && debugGood) {
            crawler_log.info(id + " START");
        }
        assert (_r_coord != this.sys_coord);
        assert (_r_coord != null);
        assert (this.sys_coord != null);
        if (!this.sys_coord.isCompatible(_r_coord)) {
            if (debugCrawler && debug) {
                crawler_log.info("INVALID " + id + " s " + sample_rtt + " NOT_COMPAT " + _r_coord.getVersion());
            }
            return false;
        }
        if (!this.sys_coord.isValid() || Double.isNaN(this.error)) {
            if (debugCrawler) {
                crawler_log.info(id + " RESET, USE_HEIGHT=" + USE_HEIGHT);
            }
            this.reset();
        }
        if (r_error <= 0.0 || r_error > 1.0 || Double.isNaN(r_error) || !_r_coord.isValid()) {
            if (debugCrawler && debug) {
                crawler_log.info(id + " BUSTED his coord is busted: r_error " + r_error + " r_coord " + _r_coord);
            }
            return false;
        }
        if (sample_rtt > 20000.0) {
            if (debug) {
                System.err.println("Warning: skipping huge RTT of " + nf.format(sample_rtt) + " from " + addr);
            }
            if (debugCrawler) {
                crawler_log.info(id + " HUGE " + sample_rtt);
            }
            return false;
        }
        RemoteState<T> addr_rs = this.rs_map.get(addr);
        if (addr_rs == null) {
            if (!can_add) {
                if (debugCrawler) {
                    crawler_log.info(id + " NO_ADD");
                }
                return false;
            }
            this.addHost(addr);
            addr_rs = this.rs_map.get(addr);
        }
        Coordinate r_coord = _r_coord.makeCopy();
        addr_rs.addSample(sample_rtt, sample_age, r_coord, r_error, curr_time);
        if (this.sys_coord.atOrigin()) {
            this.sys_coord.bump();
        }
        boolean didUpdate = false;
        int sample_size = addr_rs.getSampleSize();
        double smoothed_rtt = addr_rs.getSample();
        if (addr_rs.isValid(curr_time)) {
            this.addNeighbor(addr_rs);
            this.updateError(addr, r_coord, r_error, smoothed_rtt, sample_rtt, sample_age, sample_size, curr_time);
            this.updateSystemCoordinate(curr_time);
            this.tryUpdateAppCoordinate(curr_time);
            didUpdate = true;
        } else if (debugCrawler && debug) {
            String reason = addr_rs.getSampleSize() < RemoteState.MIN_SAMPLE_SIZE ? "TOO_FEW" : (addr_rs.getSample() <= 0.0 ? "sample is " + addr_rs.getSample() : (addr_rs.getLastError() <= 0.0 ? "error is " + addr_rs.getLastError() : (addr_rs.getLastUpdateTime() <= 0L ? "last update " + addr_rs.getLastUpdateTime() : (addr_rs.getLastCoordinate().atOrigin() ? "AT_ORIGIN" : "UNKNOWN"))));
            crawler_log.info("INVALID " + id + " s " + sample_rtt + " ss " + smoothed_rtt + " c " + sample_size + " " + reason);
        }
        if (this.lastMaintenanceStamp < curr_time - 600000L) {
            this.performMaintenance(curr_time);
            this.lastMaintenanceStamp = curr_time;
        }
        return didUpdate;
    }

    private int getIdFromAddr(T addr) {
        if (debugCrawler) {
            if (addr instanceof Integer) {
                return (Integer)addr;
            }
            if (!this.addr2id.containsKey(addr)) {
                this.addr2id.put(addr, this.idCounter);
                ++this.idCounter;
            }
            return this.addr2id.get(addr);
        }
        return 0;
    }

    protected void updateError(T addr, Coordinate r_coord, double r_error, double smoothed_rtt, double sample_rtt, long sample_age, int sample_size, long curr_time) {
        double sys_distance = this.sys_coord.distanceTo(r_coord);
        double app_distance = 0.0;
        if (this.app_coord != null) {
            app_distance = this.app_coord.distanceTo(r_coord);
        }
        if (app_distance == 0.0 || sys_distance == 0.0) {
            if (debugCrawler) {
                crawler_log.info("bad distance sys " + sys_distance + " app " + app_distance);
            }
            return;
        }
        assert (smoothed_rtt > 0.0);
        double sys_sample_error = Math.abs(sys_distance - smoothed_rtt) / smoothed_rtt;
        double app_sample_error = Math.abs(app_distance - smoothed_rtt) / smoothed_rtt;
        if (debugCrawler) {
            int remote_id = this.getIdFromAddr(addr);
            String info = "UPDATE " + remote_id + " re " + nf.format(sys_sample_error) + " rtt " + nf.format(smoothed_rtt) + " raw " + nf.format(sample_rtt) + " age " + sample_age + " dist " + nf.format(sys_distance) + " ssize " + sample_size + " lE " + nf.format(this.error) + " rE " + nf.format(r_error) + " rV " + r_coord.getVersion() + " lc " + this.sys_coord + " rc " + r_coord;
            crawler_log.info(info);
        }
        if (sys_sample_error < 0.0) {
            sys_sample_error = 0.0;
        }
        if (sys_sample_error > 1.0) {
            sys_sample_error = 1.0;
        }
        double alpha = this.error / (this.error + r_error) * COORD_ERROR;
        this.error = sys_sample_error * alpha + (1.0 - alpha) * this.error;
        if (keepStatistics) {
            this.running_sys_error.add(sys_sample_error);
            this.running_app_error.add(app_sample_error);
        }
    }

    protected boolean addNeighbor(RemoteState<T> guy) {
        boolean added = false;
        if (!this.neighbors.contains(guy)) {
            this.neighbors.add(guy);
            added = true;
        }
        if (this.neighbors.size() > 512) {
            this.neighbors.remove(0);
        }
        return added;
    }

    protected boolean removeNeighbor(RemoteState<T> guy) {
        if (this.neighbors.contains(guy)) {
            this.neighbors.remove(guy);
            return true;
        }
        return false;
    }

    public synchronized T getNeighborToPing(long curr_time) {
        long NEIGHBOR_PING_EXPIRE_TIME = 600000L;
        long expire_time = curr_time - 600000L;
        ArrayList<RemoteState<T>> recentNeighbors = new ArrayList<RemoteState<T>>();
        for (RemoteState<T> neighbor : this.neighbors) {
            if (neighbor.getLastUpdateTime() <= expire_time) continue;
            recentNeighbors.add(neighbor);
        }
        if (recentNeighbors.size() > 0) {
            Collections.shuffle(recentNeighbors);
            RemoteState neighbor = (RemoteState)recentNeighbors.get(0);
            if (debugCrawler && debugGood) {
                int id = this.getIdFromAddr(neighbor.getAddress());
                crawler_log.info("pinging neighbor " + id);
            }
            return ((RemoteState)recentNeighbors.get(0)).getAddress();
        }
        return null;
    }

    protected void updateSystemCoordinate(long curr_time) {
        long oldestSample = curr_time;
        double nearest_neighbor_distance = Double.MAX_VALUE;
        Collections.shuffle(this.neighbors);
        for (RemoteState<T> neighbor : this.neighbors) {
            double distance = this.sys_coord.distanceTo(neighbor.getLastCoordinate());
            if (distance < nearest_neighbor_distance) {
                nearest_neighbor_distance = distance;
                this.nearest_neighbor = neighbor.getLastCoordinate();
            }
            if (oldestSample <= neighbor.getLastUpdateTime()) continue;
            oldestSample = neighbor.getLastUpdateTime();
        }
        double sampleWeightSum = 0.0;
        for (RemoteState<T> neighbor : this.neighbors) {
            double distance = this.sys_coord.distanceTo(neighbor.getLastCoordinate());
            sampleWeightSum += (double)(neighbor.getLastUpdateTime() - oldestSample);
        }
        assert (sampleWeightSum >= 0.0);
        Vec force = new Vec(this.sys_coord.getNumDimensions());
        for (RemoteState<T> neighbor : this.neighbors) {
            double distance = this.sys_coord.distanceTo(neighbor.getLastCoordinate());
            while (distance == 0.0) {
                this.sys_coord.bump();
                distance = this.sys_coord.distanceTo(neighbor.getLastCoordinate());
            }
            Vec unitVector = this.sys_coord.getDirection(neighbor.getLastCoordinate());
            double latency = neighbor.getSample();
            double weight = this.error / (neighbor.getLastError() + this.error);
            if (weight == 0.0) continue;
            double sampleError = distance - latency;
            double sampleWeight = 1.0;
            if (sampleWeightSum > 0.0) {
                sampleWeight = (double)(neighbor.getLastUpdateTime() - oldestSample) / sampleWeightSum;
            }
            if (debugCrawler && debugGood) {
                int id = this.getIdFromAddr(neighbor.getAddress());
                crawler_log.info("f " + id + " age " + Math.round((double)(curr_time - neighbor.getLastUpdateTime()) / 1000.0) + " er " + sampleError + " sw " + sampleWeight + " comb " + sampleError * sampleWeight);
            }
            unitVector.scale(sampleError * sampleWeight);
            force.add(unitVector);
        }
        if (USE_HEIGHT) {
            force.direction[force.direction.length - 1] = -1.0 * force.direction[force.direction.length - 1];
        }
        force.scale(COORD_CONTROL);
        if (debugCrawler && debugGood) {
            crawler_log.info("t " + force.getLength() + " " + force);
        }
        this.sys_coord.add(force);
        this.sys_coord.checkHeight();
        double distance_delta = force.getLength();
        if (keepStatistics) {
            this.running_sys_dd.add(distance_delta);
            if (this.neighbors != null) {
                this.running_neighbors_used.add(this.neighbors.size());
            }
            if (this.time_of_last_sys_update > 0L) {
                long since_last_sys_update = curr_time - this.time_of_last_sys_update;
                this.running_sys_update_frequency.add(since_last_sys_update);
            }
        }
        this.time_of_last_sys_update = curr_time;
    }

    protected void performMaintenance(long curr_time) {
        if (debugCrawler && debugGood) {
            crawler_log.info("performing maintenance");
        }
        if (this.rs_map.size() > 32768) {
            RS_EXPIRATION = (long)(0.9 * (double)RS_EXPIRATION);
            if (debugCrawler && debugGood) {
                crawler_log.info("lowered RS_EXPIRATION to " + RS_EXPIRATION + " size " + this.rs_map.size());
            }
        }
        long expirationStamp = curr_time - RS_EXPIRATION;
        Set<Map.Entry<T, RemoteState<T>>> states = this.rs_map.entrySet();
        Iterator<Map.Entry<T, RemoteState<T>>> stateIter = states.iterator();
        while (stateIter.hasNext()) {
            Map.Entry<T, RemoteState<T>> entry = stateIter.next();
            if (entry.getValue().getLastUpdateTime() >= expirationStamp) continue;
            if (debugCrawler && debugGood) {
                crawler_log.info("tossing " + entry.getValue().getAddress());
            }
            this.removeNeighbor(entry.getValue());
            stateIter.remove();
        }
    }

    protected void tryUpdateAppCoordinate(long curr_time) {
        double scale_factor = 0.015625;
        if (this.start_coords.size() < 64) {
            Vec start_vec = new Vec(this.num_dims);
            this.start_coords.add(this.sys_coord);
            for (Coordinate next_coord : this.start_coords) {
                start_vec.add(next_coord.asVectorFromZero(false));
            }
            start_vec.scale(0.015625);
            this.start_centroid = start_vec.asCoordinateFromZero(false);
        }
        this.current_coords.add(this.sys_coord);
        if (this.current_coords.size() > 64) {
            this.current_coords.remove(0);
        }
        Vec curr_vec = new Vec(this.num_dims);
        for (Coordinate next_coord : this.current_coords) {
            curr_vec.add(next_coord.asVectorFromZero(false));
        }
        curr_vec.scale(0.015625);
        Coordinate curr_centroid = curr_vec.asCoordinateFromZero(false);
        double start_dist = this.start_centroid.distanceTo(this.nearest_neighbor);
        double curr_dist = curr_centroid.distanceTo(this.nearest_neighbor);
        double relative_diff = Math.abs((start_dist - curr_dist) / start_dist);
        if (keepStatistics) {
            this.running_relative_diff.add(relative_diff);
        }
        if (relative_diff > 0.1) {
            this.updated_app_coord_at_least_once = true;
            this.start_coords.clear();
            this.current_coords.clear();
        }
        boolean did_update = false;
        if (relative_diff > 0.1 || !this.updated_app_coord_at_least_once) {
            if (keepStatistics) {
                double app_dd = this.app_coord.distanceTo(curr_centroid);
                this.running_app_dd.add(app_dd);
            }
            this.app_coord = curr_centroid;
            did_update = true;
            if (keepStatistics) {
                double MIN_SYS_ERROR_SIZE = 128.0;
                if (!this.updated_app_coord_at_least_once && (double)this.running_sys_error.getSize() > 128.0 && this.running_sys_error.getPercentile(0.5) < 0.2) {
                    this.updated_app_coord_at_least_once = true;
                }
            }
            Iterator<ApplicationObserver> i = this.obs_list.iterator();
            while (i.hasNext()) {
                ApplicationObserver obs = i.next();
                obs.coordinatesUpdated(this.app_coord);
            }
            if (keepStatistics) {
                if (this.time_of_last_app_update > 0L) {
                    long since_last_app_update = curr_time - this.time_of_last_app_update;
                    this.running_app_update_frequency.add(since_last_app_update);
                }
                this.time_of_last_app_update = curr_time;
            }
        }
        if (debug && debugCrawler) {
            crawler_log.info("app_coord update: done " + did_update + " rolling " + this.updated_app_coord_at_least_once + " start " + this.start_coords.size() + " current " + this.current_coords.size() + " diff " + nf.format(relative_diff));
        }
    }

    public static void setRandomSeed(long seed) {
        random = new Random(seed);
    }

    public void startUp(DataInputStream is) throws IOException {
        if (debugCrawler) {
            crawler_log.info("startUp");
        }
        boolean valid = false;
        if (is.available() > 0) {
            int version = 1;
            if (is.available() != 25) {
                version = is.readInt();
            }
            try {
                this.sys_coord = new Coordinate(this.num_dims, is);
                this.error = is.readFloat();
                if (this.sys_coord.isValid() && !Double.isNaN(this.error)) {
                    valid = true;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (!valid) {
            this.sys_coord = new Coordinate(this.num_dims);
            this.error = 1.0;
        }
    }

    public synchronized void shutDown(DataOutputStream os) throws IOException {
        if (debugCrawler) {
            crawler_log.info("shutDown");
        }
        os.writeInt(1);
        this.sys_coord.toSerialized(os);
        os.writeFloat((float)this.error);
    }

    class ApplicationStatistics {
        double rrl = 0.0;
        double narl = 0.0;
        double ralp = 0.0;
        int validLinkCount = 0;
    }
}

