/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.syrah.nc;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class WindowStatistic {
    public static boolean debug = false;
    protected final int max_history;
    protected final List<Statistic> samples;
    protected boolean dirty = true;
    protected double previousPercentile = -1.0;
    protected double previousValue = -1.0;

    public WindowStatistic(int _max_history) {
        assert (_max_history >= 0);
        this.max_history = _max_history;
        this.samples = new LinkedList<Statistic>();
    }

    public synchronized void add(double sample) {
        this.samples.add(new Statistic(sample));
        this.dirty = true;
        while (this.samples.size() > this.max_history) {
            this.samples.remove(0);
            if (!debug) continue;
            System.out.println("tossing sample " + this.samples.get(0) + ", size=" + this.samples.size());
        }
    }

    public synchronized int getSize() {
        return this.samples.size();
    }

    public synchronized boolean withinVariance(double pct) {
        if (this.samples.size() < 2) {
            return true;
        }
        double mean = this.getMean();
        for (int i = 0; i < this.samples.size(); ++i) {
            double pctDiff = Math.abs(this.samples.get((int)i).sample - mean) / mean;
            if (!(pctDiff > pct)) continue;
            return false;
        }
        return true;
    }

    public synchronized double getPercentile(double p) {
        if (!this.dirty && p == this.previousPercentile) {
            return this.previousValue;
        }
        double val = this.calcPercentile(p);
        this.previousPercentile = p;
        this.previousValue = val;
        this.dirty = false;
        return val;
    }

    protected double calcPercentile(double p) {
        if (this.samples.size() == 0) {
            return 0.0;
        }
        Object[] samples_copy = new Double[this.samples.size()];
        for (int i = 0; i < this.samples.size(); ++i) {
            samples_copy[i] = this.samples.get((int)i).sample;
            if (!debug) continue;
            System.out.println(i + " " + samples_copy[i]);
        }
        Arrays.sort(samples_copy);
        int percentile = (int)((double)samples_copy.length * p);
        if (percentile < 0) {
            percentile = 0;
        }
        double val = (Double)samples_copy[percentile];
        if (debug) {
            System.out.println("p= " + p + " per=" + percentile + " val=" + val);
        }
        return val;
    }

    protected double getSum() {
        double sampleSum = 0.0;
        if (this.samples.size() > 0) {
            for (int i = 0; i < this.samples.size(); ++i) {
                sampleSum += this.samples.get((int)i).sample;
            }
        }
        return sampleSum;
    }

    public double getMean() {
        return this.getSum() / (double)this.getSize();
    }

    class Statistic {
        public final double sample;

        public Statistic(double _sample) {
            this.sample = _sample;
        }

        public String toString() {
            return new String("v=" + this.sample);
        }
    }
}

