/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.category.impl;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;

public class CategoryImpl
implements Category,
Comparable {
    private String sName;
    private int type;
    private List managers = new ArrayList();
    private static final int LDT_CATEGORY_DMADDED = 1;
    private static final int LDT_CATEGORY_DMREMOVED = 2;
    private ListenerManager category_listeners = ListenerManager.createManager("CatListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            CategoryListener target = (CategoryListener)_listener;
            if (type == 1) {
                target.downloadManagerAdded(CategoryImpl.this, (DownloadManager)value);
            } else if (type == 2) {
                target.downloadManagerRemoved(CategoryImpl.this, (DownloadManager)value);
            }
        }
    });

    public CategoryImpl(String sName) {
        this.sName = sName;
        this.type = 0;
    }

    public CategoryImpl(String sName, int type) {
        this.sName = sName;
        this.type = type;
    }

    public void addCategoryListener(CategoryListener l) {
        this.category_listeners.addListener(l);
    }

    public void removeCategoryListener(CategoryListener l) {
        this.category_listeners.removeListener(l);
    }

    public String getName() {
        return this.sName;
    }

    public int getType() {
        return this.type;
    }

    public List getDownloadManagers() {
        return this.managers;
    }

    public void addManager(DownloadManagerState manager_state) {
        if (manager_state.getCategory() != this) {
            manager_state.setCategory(this);
            return;
        }
        DownloadManager manager = manager_state.getDownloadManager();
        if (!this.managers.contains(manager)) {
            this.managers.add(manager);
            this.category_listeners.dispatch(1, manager);
        }
    }

    public void removeManager(DownloadManagerState manager_state) {
        if (manager_state.getCategory() == this) {
            manager_state.setCategory(null);
            return;
        }
        DownloadManager manager = manager_state.getDownloadManager();
        if (this.managers.contains(manager) || this.type != 0) {
            this.managers.remove(manager);
            this.category_listeners.dispatch(2, manager);
        }
    }

    public int compareTo(Object b) {
        boolean bTypeIsUser;
        boolean aTypeIsUser = this.type == 0;
        boolean bl = bTypeIsUser = ((Category)b).getType() == 0;
        if (aTypeIsUser == bTypeIsUser) {
            return this.sName.compareToIgnoreCase(((Category)b).getName());
        }
        if (aTypeIsUser) {
            return 1;
        }
        return -1;
    }
}

