/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import com.aelitis.azureus.core.proxy.socks.AESocksProxy;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemProperties;

public class ConfigurationChecker {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static boolean system_properties_set = false;
    private static boolean checked = false;
    private static boolean new_install = false;
    private static AEMonitor class_mon = new AEMonitor("ConfigChecker");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setSystemProperties() {
        try {
            class_mon.enter();
            if (system_properties_set) {
                return;
            }
            COConfigurationManager.preInitialise();
            int connect_timeout = COConfigurationManager.getIntParameter("Tracker Client Connect Timeout");
            int read_timeout = COConfigurationManager.getIntParameter("Tracker Client Read Timeout");
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "TrackerClient: connect timeout = " + connect_timeout + ", read timeout = " + read_timeout));
            }
            System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(connect_timeout * 1000));
            System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(read_timeout * 1000));
            boolean TEST_PROXY = false;
            if (TEST_PROXY) {
                try {
                    AESocksProxy proxy = AESocksProxyFactory.create(16234, 0L, 0L);
                    System.setProperty("socksProxyHost", "127.0.0.1");
                    System.setProperty("socksProxyPort", "" + proxy.getPort());
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            } else if (COConfigurationManager.getBooleanParameter("Enable.Proxy", false)) {
                String host = COConfigurationManager.getStringParameter("Proxy.Host");
                String port = COConfigurationManager.getStringParameter("Proxy.Port");
                String user = COConfigurationManager.getStringParameter("Proxy.Username");
                String pass = COConfigurationManager.getStringParameter("Proxy.Password");
                if (user.trim().equalsIgnoreCase("<none>")) {
                    user = "";
                }
                if (COConfigurationManager.getBooleanParameter("Enable.SOCKS", false)) {
                    System.setProperty("socksProxyHost", host);
                    System.setProperty("socksProxyPort", port);
                    if (user.length() > 0) {
                        System.setProperty("java.net.socks.username", user);
                        System.setProperty("java.net.socks.password", pass);
                    }
                } else {
                    System.setProperty("http.proxyHost", host);
                    System.setProperty("http.proxyPort", port);
                    System.setProperty("https.proxyHost", host);
                    System.setProperty("https.proxyPort", port);
                    if (user.length() > 0) {
                        System.setProperty("http.proxyUser", user);
                        System.setProperty("http.proxyPassword", pass);
                    }
                }
            }
            SESecurityManager.initialise();
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkConfiguration() {
        try {
            int cache_max;
            String uniqueId;
            int iIgnoreSPRatio;
            int iDLMin;
            int iSeedingMin;
            int minQueueingShareRatio;
            int peersRatio;
            int tcp_port;
            int udp2;
            int udp1;
            String this_version;
            class_mon.enter();
            if (checked) {
                return;
            }
            checked = true;
            boolean changed = false;
            String last_version = COConfigurationManager.getStringParameter("azureus.version", "");
            if (!last_version.equals(this_version = "2.5.0.4")) {
                if (!COConfigurationManager.hasParameter("First Recorded Version", true)) {
                    COConfigurationManager.setParameter("First Recorded Version", last_version.length() == 0 ? this_version : last_version);
                } else {
                    String sMinVersion;
                    String sFirstVersion = COConfigurationManager.getStringParameter("First Recorded Version");
                    String string = sMinVersion = Constants.compareVersions(sFirstVersion, this_version) > 0 ? this_version : sFirstVersion;
                    if (last_version.length() > 0) {
                        sMinVersion = Constants.compareVersions(sMinVersion, last_version) > 0 ? last_version : sMinVersion;
                    }
                    COConfigurationManager.setParameter("First Recorded Version", sMinVersion);
                }
                COConfigurationManager.setParameter("azureus.version", this_version);
                changed = true;
            }
            if (last_version.length() == 0) {
                new_install = true;
                if (COConfigurationManager.doesParameterNonDefaultExist("diagnostics.tidy_close")) {
                    if (!COConfigurationManager.doesParameterNonDefaultExist("Use default data dir")) {
                        COConfigurationManager.setParameter("Use default data dir", true);
                        changed = true;
                    }
                    if (!COConfigurationManager.doesParameterNonDefaultExist("Tracker Port Enable")) {
                        COConfigurationManager.setParameter("Tracker Port Enable", true);
                        changed = true;
                    }
                }
                if (COConfigurationManager.getBooleanParameter("Use default data dir") && !COConfigurationManager.doesParameterNonDefaultExist("Default save path")) {
                    COConfigurationManager.setParameter("Default save path", SystemProperties.getUserPath() + "downloads");
                    changed = true;
                }
                if (!COConfigurationManager.doesParameterNonDefaultExist("User Mode")) {
                    COConfigurationManager.setParameter("User Mode", 0);
                    changed = true;
                }
                if (!COConfigurationManager.doesParameterNonDefaultExist("TCP.Listen.Port")) {
                    int rand_port = RandomUtils.generateRandomNetworkListenPort();
                    COConfigurationManager.setParameter("TCP.Listen.Port", rand_port);
                    COConfigurationManager.setParameter("UDP.Listen.Port", rand_port);
                    COConfigurationManager.setParameter("UDP.NonData.Listen.Port", rand_port);
                    changed = true;
                }
            } else if (!COConfigurationManager.doesParameterNonDefaultExist("User Mode")) {
                COConfigurationManager.setParameter("User Mode", 2);
                changed = true;
            }
            if (!COConfigurationManager.doesParameterNonDefaultExist("UDP.Listen.Port")) {
                COConfigurationManager.setParameter("UDP.Listen.Port", COConfigurationManager.getIntParameter("TCP.Listen.Port"));
                changed = true;
            }
            if (!COConfigurationManager.getBooleanParameter("Plugin.DHT.dht.portdefault", true)) {
                COConfigurationManager.removeParameter("Plugin.DHT.dht.portdefault");
                int tcp_port2 = COConfigurationManager.getIntParameter("TCP.Listen.Port");
                int udp_port = COConfigurationManager.getIntParameter("UDP.Listen.Port");
                int dht_port = COConfigurationManager.getIntParameter("Plugin.DHT.dht.port", udp_port);
                if (dht_port != udp_port && tcp_port2 == udp_port) {
                    COConfigurationManager.setParameter("UDP.Listen.Port", dht_port);
                }
                changed = true;
            }
            if (!COConfigurationManager.doesParameterNonDefaultExist("UDP.NonData.Listen.Port")) {
                COConfigurationManager.setParameter("UDP.NonData.Listen.Port", COConfigurationManager.getIntParameter("UDP.Listen.Port"));
                changed = true;
            }
            if ((udp1 = COConfigurationManager.getIntParameter("UDP.Listen.Port")) != (udp2 = COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port"))) {
                COConfigurationManager.setParameter("UDP.NonData.Listen.Port", udp1);
                changed = true;
            }
            if ((tcp_port = COConfigurationManager.getIntParameter("TCP.Listen.Port")) == 6880 || tcp_port >= 45100 && tcp_port <= 45103) {
                int new_tcp_port = RandomUtils.generateRandomNetworkListenPort();
                COConfigurationManager.setParameter("TCP.Listen.Port", new_tcp_port);
                if (COConfigurationManager.getIntParameter("UDP.Listen.Port") == tcp_port) {
                    COConfigurationManager.setParameter("UDP.Listen.Port", new_tcp_port);
                }
                if (COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port") == tcp_port) {
                    COConfigurationManager.setParameter("UDP.NonData.Listen.Port", new_tcp_port);
                }
                changed = true;
            }
            if (!COConfigurationManager.doesParameterDefaultExist("Tracker Key Enable Client")) {
                boolean old_value = COConfigurationManager.getBooleanParameter("Tracker Key Enable");
                COConfigurationManager.setParameter("Tracker Key Enable Client", old_value);
                COConfigurationManager.setParameter("Tracker Key Enable Server", old_value);
                changed = true;
            }
            int maxUpSpeed = COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0);
            int maxDownSpeed = COConfigurationManager.getIntParameter("Max Download Speed KBs", 0);
            if (maxUpSpeed > 0 && maxUpSpeed < 5 && (maxDownSpeed == 0 || maxDownSpeed > 2 * maxUpSpeed)) {
                changed = true;
                COConfigurationManager.setParameter("Max Upload Speed KBs", 5);
            }
            if ((peersRatio = COConfigurationManager.getIntParameter("Stop Peers Ratio", 0)) > 14) {
                COConfigurationManager.setParameter("Stop Peers Ratio", 14);
                changed = true;
            }
            if ((minQueueingShareRatio = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_ShareRatio")) < 500) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_ShareRatio", 500);
                changed = true;
            }
            if ((iSeedingMin = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_SeedingMinutes")) < 90 && iSeedingMin != 0) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_SeedingMinutes", 90);
                changed = true;
            }
            if ((iDLMin = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_DLMinutes")) < 180 && iDLMin != 0) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_DLMinutes", 180);
                changed = true;
            }
            if ((iIgnoreSPRatio = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_ignoreSPRatio")) < 10 && iIgnoreSPRatio != 0) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_ignoreSPRatio", 10);
                changed = true;
            }
            if ((uniqueId = COConfigurationManager.getStringParameter("ID", null)) == null || uniqueId.length() != 20) {
                uniqueId = RandomUtils.generateRandomAlphanumerics(20);
                COConfigurationManager.setParameter("ID", uniqueId);
                changed = true;
            }
            if ((cache_max = COConfigurationManager.getIntParameter("diskmanager.perf.cache.size")) > COConfigurationManager.CONFIG_CACHE_SIZE_MAX_MB) {
                COConfigurationManager.setParameter("diskmanager.perf.cache.size", COConfigurationManager.CONFIG_CACHE_SIZE_MAX_MB);
                changed = true;
            }
            if (cache_max < 1) {
                COConfigurationManager.setParameter("diskmanager.perf.cache.size", 4);
                changed = true;
            }
            if (Constants.isOSX) {
                boolean sound = COConfigurationManager.getBooleanParameter("Play Download Finished", true);
                boolean confirmExit = COConfigurationManager.getBooleanParameter("confirmationOnExit", false);
                if (sound || confirmExit) {
                    COConfigurationManager.setParameter("Play Download Finished", false);
                    COConfigurationManager.setParameter("confirmationOnExit", false);
                    changed = true;
                }
            }
            if (Constants.isOSX) {
                if (COConfigurationManager.getBooleanParameter("enable_small_osx_fonts")) {
                    System.setProperty("org.eclipse.swt.internal.carbon.smallFonts", "1");
                } else {
                    System.getProperties().remove("org.eclipse.swt.internal.carbon.smallFonts");
                }
            }
            String[] path_params = new String[]{"Default save path", "General_sDefaultTorrent_Directory", "Watch Torrent Folder Path", "Completed Files Directory"};
            for (int i = 0; i < path_params.length; ++i) {
                if (!path_params[i].endsWith(SystemProperties.SEP)) continue;
                String new_path = path_params[i].substring(0, path_params[i].length() - 1);
                COConfigurationManager.setParameter(path_params[i], new_path);
                changed = true;
            }
            if (ConfigurationManager.getInstance().doesParameterNonDefaultExist("General_bEnableLanguageUpdate")) {
                File user_dir = new File(SystemProperties.getUserPath());
                File[] files = user_dir.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.startsWith("MessagesBundle") && name.endsWith(".properties");
                    }
                });
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (!file.exists()) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "ConfigurationChecker:: removing old language file: " + file.getAbsolutePath()));
                    }
                    file.renameTo(new File(file.getParentFile(), "delme" + file.getName()));
                }
                ConfigurationManager.getInstance().removeParameter("General_bEnableLanguageUpdate");
                changed = true;
            }
            if (changed) {
                COConfigurationManager.save();
            }
        }
        finally {
            class_mon.exit();
        }
        ConfigurationDefaults.getInstance().runVerifiers();
    }

    public static final boolean isNewInstall() {
        return new_install;
    }

    public static void main(String[] args) {
        Integer obj = new Integer(1);
        HashMap<String, Integer> test = new HashMap<String, Integer>();
        int collisions = 0;
        for (int i = 0; i < 1000000; ++i) {
            String id = RandomUtils.generateRandomAlphanumerics(20);
            if (test.containsKey(id)) {
                ++collisions;
            } else {
                test.put(id, obj);
            }
            if (i % 1000 != 0) continue;
            System.out.println(i + " : " + id + " : " + collisions);
        }
        System.out.println("\n" + collisions);
    }
}

