/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class DiskManagerFileInfoImpl
implements DiskManagerFileInfo,
CacheFileOwner {
    private File file;
    private int file_index;
    private CacheFile cache_file;
    private String extension;
    private long downloaded;
    private DiskManagerHelper diskManager;
    private TOTorrentFile torrent_file;
    private boolean priority = false;
    private boolean skipped = false;
    private CopyOnWriteList listeners;

    public DiskManagerFileInfoImpl(DiskManagerHelper _disk_manager, File _file, int _file_index, TOTorrentFile _torrent_file, boolean _linear_storage) throws CacheFileManagerException {
        this.diskManager = _disk_manager;
        this.torrent_file = _torrent_file;
        this.file = _file;
        this.file_index = _file_index;
        this.cache_file = CacheFileManagerFactory.getSingleton().createFile(this, _file, _linear_storage ? 1 : 2);
        if (!_linear_storage) {
            this.skipped = true;
        }
    }

    public String getCacheFileOwnerName() {
        return this.diskManager.getInternalName();
    }

    public TOTorrentFile getCacheFileTorrentFile() {
        return this.torrent_file;
    }

    public File getCacheFileControlFile(String name) {
        return this.diskManager.getDownloadState().getStateFile(name);
    }

    public void flushCache() throws Exception {
        this.cache_file.flushCache();
    }

    protected void moveFile(File newFile, boolean link_only) throws CacheFileManagerException {
        if (!link_only) {
            this.cache_file.moveFile(newFile);
        }
        this.file = newFile;
    }

    public CacheFile getCacheFile() {
        return this.cache_file;
    }

    public void setAccessMode(int mode) throws CacheFileManagerException {
        int old_mode = this.cache_file.getAccessMode();
        this.cache_file.setAccessMode(mode == 1 ? 1 : 2);
        if (old_mode != mode) {
            this.diskManager.accessModeChanged(this, old_mode, mode);
        }
    }

    public int getAccessMode() {
        int mode = this.cache_file.getAccessMode();
        return mode == 1 ? 1 : 2;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public String getExtension() {
        return this.extension;
    }

    public File getFile(boolean follow_link) {
        File res;
        if (follow_link && (res = this.getLink()) != null) {
            return res;
        }
        return this.file;
    }

    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    public boolean setLink(File link_destination) {
        Debug.out("setLink: download must be stopped");
        return false;
    }

    public File getLink() {
        return this.diskManager.getDownloadState().getFileLink(this.getFile(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStorageType(int type) {
        boolean bl;
        int old_type;
        String[] types = this.diskManager.getStorageTypes();
        int n = old_type = types[this.file_index].equals("L") ? 1 : 2;
        if (type == old_type) {
            return true;
        }
        if (type == 2) {
            Debug.out("Download must be stopped for linear -> compact conversion");
            return false;
        }
        boolean set_skipped = false;
        try {
            this.cache_file.setStorageType(type == 1 ? 1 : 2);
            set_skipped = type == 2 && !this.isSkipped();
            bl = true;
            types[this.file_index] = this.cache_file.getStorageType() == 1 ? "L" : "C";
        }
        catch (Throwable e) {
            boolean bl2;
            try {
                Debug.printStackTrace(e);
                this.diskManager.setFailed(this, "Failed to change storage type for '" + this.getFile(true) + "': " + Debug.getNestedExceptionMessage(e));
                bl2 = false;
                types[this.file_index] = this.cache_file.getStorageType() == 1 ? "L" : "C";
            }
            catch (Throwable throwable) {
                types[this.file_index] = this.cache_file.getStorageType() == 1 ? "L" : "C";
                DownloadManagerState dm_state = this.diskManager.getDownloadState();
                dm_state.setListAttribute("storetypes", types);
                dm_state.save();
                if (set_skipped) {
                    this.setSkipped(true);
                }
                throw throwable;
            }
            DownloadManagerState dm_state = this.diskManager.getDownloadState();
            dm_state.setListAttribute("storetypes", types);
            dm_state.save();
            if (set_skipped) {
                this.setSkipped(true);
            }
            return bl2;
        }
        DownloadManagerState dm_state = this.diskManager.getDownloadState();
        dm_state.setListAttribute("storetypes", types);
        dm_state.save();
        if (set_skipped) {
            this.setSkipped(true);
        }
        return bl;
    }

    public int getStorageType() {
        String[] types = this.diskManager.getStorageTypes();
        return types[this.file_index].equals("L") ? 1 : 2;
    }

    protected boolean isLinked() {
        return this.getLink() != null;
    }

    public int getFirstPieceNumber() {
        return this.torrent_file.getFirstPieceNumber();
    }

    public int getLastPieceNumber() {
        return this.torrent_file.getLastPieceNumber();
    }

    public long getLength() {
        return this.torrent_file.getLength();
    }

    public int getIndex() {
        return this.file_index;
    }

    public int getNbPieces() {
        return this.torrent_file.getNumberOfPieces();
    }

    public void setDownloaded(long l) {
        this.downloaded = l;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public void setPriority(boolean b) {
        this.priority = b;
        this.diskManager.priorityChanged(this);
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public void setSkipped(boolean _skipped) {
        if (!_skipped && this.getStorageType() == 2 && !this.setStorageType(1)) {
            return;
        }
        this.skipped = _skipped;
        this.diskManager.skippedFileSetChanged(this);
    }

    public DiskManager getDiskManager() {
        return this.diskManager;
    }

    public DownloadManager getDownloadManager() {
        DownloadManagerState state = this.diskManager.getDownloadState();
        if (state == null) {
            return null;
        }
        return state.getDownloadManager();
    }

    public void dataWritten(long offset, long size) {
        if (this.listeners != null) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    ((DiskManagerFileInfoListener)it.next()).dataWritten(offset, size);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void dataChecked(long offset, long size) {
        if (this.listeners != null) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    ((DiskManagerFileInfoListener)it.next()).dataChecked(offset, size);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public DirectByteBuffer read(long offset, int length) throws IOException {
        DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)6, length);
        try {
            this.cache_file.read(buffer, offset, (short)1);
        }
        catch (Throwable e) {
            buffer.returnToPool();
            Debug.printStackTrace(e);
            throw new IOException(e.getMessage());
        }
        return buffer;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(final DiskManagerFileInfoListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteList();
        }
        CopyOnWriteList copyOnWriteList = this.listeners;
        synchronized (copyOnWriteList) {
            if (this.listeners.getList().contains(listener)) {
                return;
            }
        }
        this.listeners.add(listener);
        new Runnable(){
            private long file_start;
            private long file_end;
            private long current_write_start = -1L;
            private long current_write_end = -1L;
            private long current_check_start = -1L;
            private long current_check_end = -1L;

            public void run() {
                TOTorrentFile[] tfs = DiskManagerFileInfoImpl.this.torrent_file.getTorrent().getFiles();
                long torrent_offset = 0L;
                for (int i = 0; i < DiskManagerFileInfoImpl.this.file_index; ++i) {
                    torrent_offset += tfs[i].getLength();
                }
                this.file_start = torrent_offset;
                this.file_end = this.file_start + DiskManagerFileInfoImpl.this.torrent_file.getLength();
                DiskManagerPiece[] pieces = DiskManagerFileInfoImpl.this.diskManager.getPieces();
                int first_piece = DiskManagerFileInfoImpl.this.getFirstPieceNumber();
                int last_piece = DiskManagerFileInfoImpl.this.getLastPieceNumber();
                long piece_size = DiskManagerFileInfoImpl.this.torrent_file.getTorrent().getPieceLength();
                for (int i = first_piece; i <= last_piece; ++i) {
                    long piece_offset = piece_size * (long)i;
                    DiskManagerPiece piece = pieces[i];
                    if (piece.isDone()) {
                        long bit_start = piece_offset;
                        long bit_end = bit_start + (long)piece.getLength();
                        this.bitWritten(bit_start, bit_end, true);
                        continue;
                    }
                    int block_offset = 0;
                    for (int j = 0; j < piece.getNbBlocks(); ++j) {
                        int block_size = piece.getBlockSize(j);
                        if (piece.isWritten(j)) {
                            long bit_start = piece_offset + (long)block_offset;
                            long bit_end = bit_start + (long)block_size;
                            this.bitWritten(bit_start, bit_end, false);
                        }
                        block_offset += block_size;
                    }
                }
                this.bitWritten(-1L, -1L, false);
            }

            protected void bitWritten(long bit_start, long bit_end, boolean checked) {
                if (this.current_write_start == -1L) {
                    this.current_write_start = bit_start;
                    this.current_write_end = bit_end;
                } else if (this.current_write_end == bit_start) {
                    this.current_write_end = bit_end;
                } else {
                    if (this.current_write_start < this.file_start) {
                        this.current_write_start = this.file_start;
                    }
                    if (this.current_write_end > this.file_end) {
                        this.current_write_end = this.file_end;
                    }
                    if (this.current_write_start < this.current_write_end) {
                        try {
                            listener.dataWritten(this.current_write_start - this.file_start, this.current_write_end - this.current_write_start);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    this.current_write_start = bit_start;
                    this.current_write_end = bit_end;
                }
                if (checked && this.current_check_start == -1L) {
                    this.current_check_start = bit_start;
                    this.current_check_end = bit_end;
                } else if (checked && this.current_check_end == bit_start) {
                    this.current_check_end = bit_end;
                } else {
                    if (this.current_check_start < this.file_start) {
                        this.current_check_start = this.file_start;
                    }
                    if (this.current_check_end > this.file_end) {
                        this.current_check_end = this.file_end;
                    }
                    if (this.current_check_start < this.current_check_end) {
                        try {
                            listener.dataChecked(this.current_check_start - this.file_start, this.current_check_end - this.current_check_start);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    if (checked) {
                        this.current_check_start = bit_start;
                        this.current_check_end = bit_end;
                    } else {
                        this.current_check_start = -1L;
                        this.current_check_end = -1L;
                    }
                }
            }
        }.run();
    }

    public void removeListener(DiskManagerFileInfoListener listener) {
        this.listeners.remove(listener);
    }
}

