/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;

public class DiskManagerUtil {
    private static final LogIDs LOGID = LogIDs.DISK;
    protected static int max_read_block_size;

    public static boolean checkBlockConsistency(DiskManager dm, String originator, int pieceNumber, int offset, int length) {
        if (length > max_read_block_size) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "CHECKBLOCK2: " + originator + " length=" + length + " > " + max_read_block_size));
            }
            return false;
        }
        if (length <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "CHECKBLOCK2: " + originator + " length=" + length + " <= 0"));
            }
            return false;
        }
        if (pieceNumber < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "CHECKBLOCK2: " + originator + " pieceNumber=" + pieceNumber + " < 0"));
            }
            return false;
        }
        if (pieceNumber >= dm.getNbPieces()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "CHECKBLOCK2: " + originator + " pieceNumber=" + pieceNumber + " >= this.nbPieces=" + dm.getNbPieces()));
            }
            return false;
        }
        int pLength = dm.getPieceLength();
        if (pieceNumber == dm.getNbPieces() - 1) {
            pLength = dm.getLastPieceLength();
        }
        if (offset < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "CHECKBLOCK2: " + originator + " offset=" + offset + " < 0"));
            }
            return false;
        }
        if (offset > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "CHECKBLOCK2: " + originator + " offset=" + offset + " > pLength=" + pLength));
            }
            return false;
        }
        if (offset + length > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "CHECKBLOCK2: " + originator + " offset=" + offset + " + length=" + length + " > pLength=" + pLength));
            }
            return false;
        }
        if (!dm.getPiece(pieceNumber).isDone()) {
            Logger.log(new LogEvent((Object)dm, LOGID, 3, "CHECKBLOCK2: " + originator + " piece #" + pieceNumber + " not done"));
            return false;
        }
        return true;
    }

    static {
        ParameterListener param_listener = new ParameterListener(){

            public void parameterChanged(String str) {
                max_read_block_size = COConfigurationManager.getIntParameter("BT Request Max Block Size");
            }
        };
        COConfigurationManager.addAndFireParameterListener("BT Request Max Block Size", param_listener);
    }
}

