/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckInstance;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.access.impl.DiskManagerCheckRequestImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ConcurrentHasher;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequest;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequestListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SystemTime;

public class DMCheckerImpl
implements DMChecker {
    protected static final LogIDs LOGID = LogIDs.DISK;
    private static boolean flush_pieces;
    private static boolean checking_read_priority;
    protected DiskManagerHelper disk_manager;
    protected int async_checks;
    protected AESemaphore async_check_sem = new AESemaphore("DMChecker::asyncCheck");
    protected int async_reads;
    protected AESemaphore async_read_sem = new AESemaphore("DMChecker::asyncRead");
    private boolean started;
    protected volatile boolean stopped;
    private int pieceLength;
    private int lastPieceLength;
    protected int nbPieces;
    private volatile boolean complete_recheck_in_progress;
    private volatile int complete_recheck_progress;
    protected AEMonitor this_mon = new AEMonitor("DMChecker");

    public DMCheckerImpl(DiskManagerHelper _disk_manager) {
        this.disk_manager = _disk_manager;
        this.pieceLength = this.disk_manager.getPieceLength();
        this.lastPieceLength = this.disk_manager.getLastPieceLength();
        this.nbPieces = this.disk_manager.getNbPieces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new RuntimeException("DMChecker: start while started");
            }
            if (this.stopped) {
                throw new RuntimeException("DMChecker: start after stopped");
            }
            this.started = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        long now;
        int i;
        int check_wait;
        int read_wait;
        try {
            this.this_mon.enter();
            if (this.stopped || !this.started) {
                return;
            }
            this.stopped = true;
            read_wait = this.async_reads;
            check_wait = this.async_checks;
        }
        finally {
            this.this_mon.exit();
        }
        long log_time = SystemTime.getCurrentTime();
        for (i = 0; i < read_wait; ++i) {
            now = SystemTime.getCurrentTime();
            if (now < log_time) {
                log_time = now;
            } else if (now - log_time > 1000L) {
                log_time = now;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_manager, LOGID, "Waiting for check-reads to complete - " + (read_wait - i) + " remaining"));
                }
            }
            this.async_read_sem.reserve();
        }
        log_time = SystemTime.getCurrentTime();
        for (i = 0; i < check_wait; ++i) {
            now = SystemTime.getCurrentTime();
            if (now < log_time) {
                log_time = now;
            } else if (now - log_time > 1000L) {
                log_time = now;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_manager, LOGID, "Waiting for checks to complete - " + (read_wait - i) + " remaining"));
                }
            }
            this.async_check_sem.reserve();
        }
    }

    public int getCompleteRecheckStatus() {
        if (this.complete_recheck_in_progress) {
            return this.complete_recheck_progress;
        }
        return -1;
    }

    public DiskManagerCheckRequest createRequest(int pieceNumber, Object user_data) {
        return new DiskManagerCheckRequestImpl(pieceNumber, user_data);
    }

    public void enqueueCompleteRecheckRequest(final DiskManagerCheckRequest request2, final DiskManagerCheckRequestListener listener) {
        this.complete_recheck_progress = 0;
        this.complete_recheck_in_progress = true;
        AEThread t = new AEThread("DMChecker::completeRecheck"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                DiskManagerRecheckInstance recheck_inst = DMCheckerImpl.this.disk_manager.getRecheckScheduler().register(DMCheckerImpl.this.disk_manager, true);
                try {
                    int i;
                    final AESemaphore sem = new AESemaphore("DMChecker::completeRecheck");
                    int checks_submitted = 0;
                    final AESemaphore run_sem = new AESemaphore("DMChecker::completeRecheck:runsem", 2);
                    for (i = 0; i < DMCheckerImpl.this.nbPieces; ++i) {
                        DMCheckerImpl.this.complete_recheck_progress = 1000 * i / DMCheckerImpl.this.nbPieces;
                        DiskManagerPiece dm_piece = DMCheckerImpl.this.disk_manager.getPiece(i);
                        if (!dm_piece.isDone() && dm_piece.isSkipped()) continue;
                        run_sem.reserve();
                        while (!DMCheckerImpl.this.stopped && !recheck_inst.getPermission()) {
                        }
                        if (DMCheckerImpl.this.stopped) break;
                        DMCheckerImpl.this.enqueueCheckRequest(DMCheckerImpl.this.createRequest(i, request2.getUserData()), new DiskManagerCheckRequestListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                                try {
                                    listener.checkCompleted(request2, passed);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                                finally {
                                    this.complete();
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void checkCancelled(DiskManagerCheckRequest request2) {
                                try {
                                    listener.checkCancelled(request2);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                                finally {
                                    this.complete();
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                                try {
                                    listener.checkFailed(request2, cause);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                                finally {
                                    this.complete();
                                }
                            }

                            protected void complete() {
                                run_sem.release();
                                sem.release();
                            }
                        }, false);
                        ++checks_submitted;
                    }
                    for (i = 0; i < checks_submitted; ++i) {
                        sem.reserve();
                    }
                }
                finally {
                    DMCheckerImpl.this.complete_recheck_in_progress = false;
                    recheck_inst.unregister();
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public void enqueueCheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        this.enqueueCheckRequest(request2, listener, flush_pieces);
    }

    protected void enqueueCheckRequest(DiskManagerCheckRequest request2, final DiskManagerCheckRequestListener listener, boolean read_flush) {
        request2.requestStarts();
        this.enqueueCheckRequestSupport(request2, new DiskManagerCheckRequestListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                request2.requestEnds(true);
                try {
                    int piece_number = request2.getPieceNumber();
                    DiskManagerPiece piece = DMCheckerImpl.this.disk_manager.getPiece(request2.getPieceNumber());
                    piece.setDone(passed);
                    if (passed) {
                        DMPieceList piece_list = DMCheckerImpl.this.disk_manager.getPieceList(piece_number);
                        for (int i = 0; i < piece_list.size(); ++i) {
                            DMPieceMapEntry piece_entry = piece_list.get(i);
                            piece_entry.getFile().dataChecked(piece_entry.getOffset(), piece_entry.getLength());
                        }
                    }
                }
                finally {
                    listener.checkCompleted(request2, passed);
                    if (Logger.isEnabled()) {
                        if (passed) {
                            Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 0, "Piece " + request2.getPieceNumber() + " passed hash check."));
                        } else {
                            Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 1, "Piece " + request2.getPieceNumber() + " failed hash check."));
                        }
                    }
                }
            }

            public void checkCancelled(DiskManagerCheckRequest request2) {
                request2.requestEnds(false);
                listener.checkCancelled(request2);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 1, "Piece " + request2.getPieceNumber() + " hash check cancelled."));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                request2.requestEnds(false);
                try {
                    DMCheckerImpl.this.disk_manager.getPiece(request2.getPieceNumber()).setDone(false);
                }
                finally {
                    listener.checkFailed(request2, cause);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 1, "Piece " + request2.getPieceNumber() + " failed hash check - " + Debug.getNestedExceptionMessage(cause)));
                    }
                }
            }
        }, read_flush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueCheckRequestSupport(final DiskManagerCheckRequest request2, final DiskManagerCheckRequestListener listener, boolean read_flush) {
        int pieceNumber = request2.getPieceNumber();
        try {
            final byte[] required_hash = this.disk_manager.getPieceHash(pieceNumber);
            DMPieceList pieceList = this.disk_manager.getPieceList(pieceNumber);
            try {
                boolean all_compact = pieceList.size() > 0;
                for (int i = 0; i < pieceList.size(); ++i) {
                    DMPieceMapEntry piece_entry = pieceList.get(i);
                    DiskManagerFileInfoImpl file_info = piece_entry.getFile();
                    CacheFile cache_file = file_info.getCacheFile();
                    if (cache_file.compareLength(piece_entry.getOffset()) < 0L) {
                        listener.checkCompleted(request2, false);
                        return;
                    }
                    if (!all_compact || cache_file.getStorageType() == 2 && file_info.getNbPieces() > 2) continue;
                    all_compact = false;
                }
                if (all_compact) {
                    listener.checkCompleted(request2, false);
                    return;
                }
            }
            catch (Throwable e) {
                listener.checkCancelled(request2);
                return;
            }
            int this_piece_length = pieceNumber < this.nbPieces - 1 ? this.pieceLength : this.lastPieceLength;
            DiskManagerReadRequest read_request = this.disk_manager.createReadRequest(pieceNumber, 0, this_piece_length);
            try {
                this.this_mon.enter();
                if (this.stopped) {
                    listener.checkCancelled(request2);
                    return;
                }
                ++this.async_reads;
            }
            finally {
                this.this_mon.exit();
            }
            read_request.setFlush(read_flush);
            read_request.setUseCache(!request2.isAdHoc());
            this.disk_manager.enqueueReadRequest(read_request, new DiskManagerReadRequestListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void readCompleted(DiskManagerReadRequest read_request, DirectByteBuffer buffer) {
                    this.complete();
                    try {
                        DMCheckerImpl.this.this_mon.enter();
                        if (DMCheckerImpl.this.stopped) {
                            buffer.returnToPool();
                            listener.checkCancelled(request2);
                            return;
                        }
                        ++DMCheckerImpl.this.async_checks;
                    }
                    finally {
                        DMCheckerImpl.this.this_mon.exit();
                    }
                    try {
                        final DirectByteBuffer f_buffer = buffer;
                        ConcurrentHasher.getSingleton().addRequest(buffer.getBuffer((byte)8), new ConcurrentHasherRequestListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void complete(ConcurrentHasherRequest hash_request) {
                                int async_result = 3;
                                try {
                                    byte[] testHash = hash_request.getResult();
                                    if (testHash != null) {
                                        async_result = 1;
                                        for (int i = 0; i < testHash.length; ++i) {
                                            if (testHash[i] == required_hash[i]) continue;
                                            async_result = 2;
                                            break;
                                        }
                                    }
                                    Object var6_5 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var6_6 = null;
                                    try {
                                        f_buffer.returnToPool();
                                        if (async_result == 1) {
                                            listener.checkCompleted(request2, true);
                                        } else if (async_result == 2) {
                                            listener.checkCompleted(request2, false);
                                        } else {
                                            listener.checkCancelled(request2);
                                        }
                                    }
                                    finally {
                                        try {
                                            (this).DMCheckerImpl.this.this_mon.enter();
                                            --(this).DMCheckerImpl.this.async_checks;
                                            if ((this).DMCheckerImpl.this.stopped) {
                                                (this).DMCheckerImpl.this.async_check_sem.release();
                                            }
                                        }
                                        finally {
                                            (this).DMCheckerImpl.this.this_mon.exit();
                                        }
                                    }
                                    throw throwable;
                                }
                                try {
                                    f_buffer.returnToPool();
                                    if (async_result == 1) {
                                        listener.checkCompleted(request2, true);
                                    }
                                    if (async_result == 2) {
                                        listener.checkCompleted(request2, false);
                                    }
                                    listener.checkCancelled(request2);
                                }
                                finally {
                                    try {
                                        (this).DMCheckerImpl.this.this_mon.enter();
                                        --(this).DMCheckerImpl.this.async_checks;
                                        if ((this).DMCheckerImpl.this.stopped) {
                                            (this).DMCheckerImpl.this.async_check_sem.release();
                                        }
                                    }
                                    finally {
                                        (this).DMCheckerImpl.this.this_mon.exit();
                                    }
                                }
                            }
                        }, request2.isLowPriority());
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        buffer.returnToPool();
                        listener.checkFailed(request2, e);
                    }
                }

                public void readFailed(DiskManagerReadRequest read_request, Throwable cause) {
                    this.complete();
                    listener.checkFailed(request2, cause);
                }

                public int getPriority() {
                    return checking_read_priority ? 0 : -1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void complete() {
                    try {
                        DMCheckerImpl.this.this_mon.enter();
                        --DMCheckerImpl.this.async_reads;
                        if (DMCheckerImpl.this.stopped) {
                            DMCheckerImpl.this.async_read_sem.release();
                        }
                    }
                    finally {
                        DMCheckerImpl.this.this_mon.exit();
                    }
                }
            });
        }
        catch (Throwable e) {
            this.disk_manager.setFailed("Piece check error - " + Debug.getNestedExceptionMessage(e));
            Debug.printStackTrace(e);
            listener.checkFailed(request2, e);
        }
    }

    static {
        ParameterListener param_listener = new ParameterListener(){

            public void parameterChanged(String str) {
                flush_pieces = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.flushpieces");
                checking_read_priority = COConfigurationManager.getBooleanParameter("diskmanager.perf.checking.read.priority");
            }
        };
        COConfigurationManager.addAndFireParameterListeners(new String[]{"diskmanager.perf.cache.flushpieces", "diskmanager.perf.checking.read.priority"}, param_listener);
    }
}

