/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerStats;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerActivationListener;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateFactory;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.DownloadManagerTrackerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.peers.PeerDescriptor;

public class Test {
    final int CACHE_SIZE = 16;
    final boolean CACHE_ENABLE = true;
    final int BLOCK_SIZE = 16384;
    final boolean READ_TEST = true;
    final boolean RANDOM_TEST = false;
    final boolean CHECK_WRITES = false;

    protected Test() {
        try {
            COConfigurationManager.initialiseFromMap(new HashMap());
            COConfigurationManager.setParameter("diskmanager.perf.cache.enable", true);
            COConfigurationManager.setParameter("diskmanager.perf.cache.size", 16);
            File file = new File("C:\\temp\\dmtest.dat");
            file.deleteOnExit();
            RandomAccessFile raf = new RandomAccessFile(file, "rwd");
            raf.setLength(0x6400000L);
            raf.close();
            TOTorrentCreator creator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(file, new URL("http://dummy/"));
            final TOTorrent torrent = creator.create();
            File torrent_file = new File("C:\\temp\\dmtest.torrent");
            TorrentUtils.writeToFile(torrent, torrent_file);
            DownloadManagerState download_manager_state = DownloadManagerStateFactory.getDownloadState(torrent);
            TorrentUtils.setResumeDataCompletelyValid(download_manager_state);
            download_manager_state.save();
            PEPeerManagerDummy pm = new PEPeerManagerDummy();
            final DiskManager dm = DiskManagerFactory.create(torrent, new DownloadManagerDummy(file, pm));
            pm.setDiskManager(dm);
            dm.addListener(new DiskManagerListener(){

                public void stateChanged(int oldState, int newState) {
                    System.out.println("dm state change: " + newState);
                    if (newState != 4) {
                        return;
                    }
                    try {
                        final CacheFileManagerStats cache_stats = CacheFileManagerFactory.getSingleton().getStats();
                        int pieces = torrent.getNumberOfPieces();
                        int piece_size = (int)torrent.getPieceLength();
                        int blocks_per_piece = piece_size / 16384;
                        final int[] done = new int[]{0};
                        final long[] bytes = new long[]{0L};
                        final long start = System.currentTimeMillis();
                        for (int i = 0; i < 100000; ++i) {
                            int j = 0;
                            while (j < blocks_per_piece) {
                                int piece_number = i % pieces;
                                int block_number = j++;
                                DiskManagerReadRequest res = dm.createReadRequest(piece_number, 16384 * block_number, 16384);
                                dm.enqueueReadRequest(res, new DiskManagerReadRequestListener(){

                                    public void readCompleted(DiskManagerReadRequest request2, DirectByteBuffer data) {
                                        data.returnToPool();
                                        done[0] = done[0] + 1;
                                        bytes[0] = bytes[0] + 16384L;
                                        if (done[0] % 1000 == 0) {
                                            long now = System.currentTimeMillis();
                                            float bps = (float)(bytes[0] * 1000L / (now - start)) / 1024.0f;
                                            System.out.println("done = " + done[0] + ", bps = " + bps);
                                            System.out.println("    " + cache_stats.getBytesReadFromCache() + "/" + cache_stats.getBytesReadFromFile());
                                        }
                                    }

                                    public void readFailed(DiskManagerReadRequest request2, Throwable cause) {
                                        Debug.out(cause);
                                    }

                                    public int getPriority() {
                                        return -1;
                                    }
                                });
                            }
                            if (i % 1000 != 0) continue;
                            System.out.println(i);
                            System.out.println("    " + cache_stats.getBytesWrittenToCache() + "/" + cache_stats.getBytesWrittenToFile() + ": av = " + cache_stats.getAverageBytesWrittenToCache() + "/" + cache_stats.getAverageBytesWrittenToFile());
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }

                public void filePriorityChanged(DiskManagerFileInfo file) {
                }

                public void pieceDoneChanged(DiskManagerPiece piece) {
                }

                public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
                }
            });
            Thread.sleep(10000000L);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static void main(String[] args) {
        new Test();
    }

    protected class PEPeerManagerDummy
    implements PEPeerManager {
        protected DiskManager dm;

        protected PEPeerManagerDummy() {
        }

        protected void setDiskManager(DiskManager _dm) {
            this.dm = _dm;
        }

        public DiskManager getDiskManager() {
            return null;
        }

        public void generateEvidence(IndentWriter writer) {
        }

        public PiecePicker getPiecePicker() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public LimitedRateGroup getUploadLimitedRateGroup() {
            return null;
        }

        public LimitedRateGroup getDownloadLimitedRateGroup() {
            return null;
        }

        public void start() {
        }

        public PeerExchangerItem createPeerExchangeConnection(PEPeerTransport base_peer) {
            return null;
        }

        public void peerVerifiedAsSelf(PEPeerTransport self) {
        }

        public void stopAll() {
        }

        public boolean seedPieceRecheck() {
            return false;
        }

        public void peerConnectionClosed(PEPeerTransport peer, boolean connect_failed) {
        }

        public boolean isInEndGameMode() {
            return false;
        }

        public int getAverageCompletionInThousandNotation() {
            return 0;
        }

        public byte[] getHash() {
            return null;
        }

        public PeerIdentityDataID getPeerIdentityDataID() {
            return null;
        }

        public byte[] getPeerId() {
            return null;
        }

        public void blockWritten(int pieceNumber, int offset, PEPeer peer) {
        }

        public void asyncPieceChecked(int pieceNumber, boolean result) {
            this.dm.getPiece(pieceNumber).setDone(false);
        }

        public int[] getAvailability() {
            return null;
        }

        public int calcAvailability(int pieceNumber) {
            return 0;
        }

        public int getAvailability(int pieceNumber) {
            return 0;
        }

        public float getMinAvailability() {
            return 0.0f;
        }

        public boolean isPieceActive(int pieceNumber) {
            return false;
        }

        public PEPiece getPiece(int pieceNumber) {
            return null;
        }

        public boolean hasDownloadablePiece() {
            return false;
        }

        public PEPiece[] getPieces() {
            return null;
        }

        public PEPeerManagerStats getStats() {
            return null;
        }

        public void processTrackerResponse(TRTrackerAnnouncerResponse response) {
        }

        public int getNbPeers() {
            return 0;
        }

        public int getNbSeeds() {
            return 0;
        }

        public int getNbHashFails() {
            return 0;
        }

        public void setNbHashFails(int fails) {
        }

        public int getPiecesNumber() {
            return 0;
        }

        public int getPieceLength(int pieceNumber) {
            return 0;
        }

        public long getRemaining() {
            return 0L;
        }

        public int getDownloadPriority() {
            return 0;
        }

        public long getETA() {
            return 0L;
        }

        public String getElapsedTime() {
            return null;
        }

        public long getTimeStarted() {
            return 0L;
        }

        public long getTimeStartedSeeding() {
            return 0L;
        }

        public void addListener(PEPeerManagerListener l) {
        }

        public void removeListener(PEPeerManagerListener l) {
        }

        public boolean needsMD5CheckOnCompletion(int pieceNumber) {
            return false;
        }

        public boolean isSeeding() {
            return false;
        }

        public boolean isSuperSeedMode() {
            return false;
        }

        public int getNbRemoteConnections() {
            return 0;
        }

        public long getLastRemoteConnectionTime() {
            return 0L;
        }

        public int getMaxNewConnectionsAllowed() {
            return 0;
        }

        public void dataBytesReceived(PEPeer peer, int l) {
        }

        public void dataBytesSent(PEPeer peer, int l) {
        }

        public void protocolBytesSent(PEPeer peer, int length) {
        }

        public void protocolBytesReceived(PEPeer peer, int length) {
        }

        public void discarded(PEPeer peer, int l) {
        }

        public PEPeerStats createPeerStats(PEPeer owner) {
            return null;
        }

        public List getPeers() {
            return null;
        }

        public List getPeers(String address) {
            return null;
        }

        public PeerDescriptor[] getPendingPeers(String address) {
            return null;
        }

        public void addPeer(PEPeer peer) {
        }

        public void addPeer(String ip_address, int port, int udp_port, boolean use_crypto) {
        }

        public void removePeer(PEPeer peer) {
        }

        public void removePeer(PEPeer peer, String reason) {
        }

        public void peerAdded(PEPeer pc) {
        }

        public void peerRemoved(PEPeer pc) {
        }

        public DiskManagerReadRequest createDiskManagerRequest(int pieceNumber, int offset, int length) {
            return null;
        }

        public void requestCanceled(DiskManagerReadRequest item) {
        }

        public boolean validatePieceReply(int pieceNumber, int offset, DirectByteBuffer data) {
            return false;
        }

        public void writeBlock(int pieceNumber, int offset, DirectByteBuffer data, PEPeer sender, boolean cancel) {
        }

        public boolean isWritten(int piece_number, int offset) {
            return false;
        }

        public Object getData(String key) {
            return null;
        }

        public void setData(String key, Object value) {
        }

        public void addPiece(PEPiece piece, int pieceNumber) {
        }

        public float getAvgAvail() {
            return 0.0f;
        }

        public PEPeerTransport getTransportFromIdentity(byte[] peer_id) {
            return null;
        }

        public PEPeerTransport getTransportFromAddress(String peer) {
            return null;
        }
    }

    protected class DownloadManagerDummy
    implements DownloadManager {
        protected File file;
        protected PEPeerManager peer_manager;

        protected DownloadManagerDummy(File _file, PEPeerManager _pm) {
            this.file = _file;
            this.peer_manager = _pm;
        }

        public void initialize() {
        }

        public void destroy(boolean is_duplicate) {
        }

        public void generateEvidence(IndentWriter writer) {
        }

        public int getState() {
            return 0;
        }

        public int getSubState() {
            return 0;
        }

        public void setStateWaiting() {
        }

        public void setStateDownloading() {
        }

        public void setStateStopped() {
        }

        public void setStateFinishing() {
        }

        public void setStateSeeding() {
        }

        public void setStateQueued() {
        }

        public void downloadRemoved() {
        }

        public DownloadManagerState getDownloadState() {
            return null;
        }

        public void startDownload() {
        }

        public void startDownloadInitialized(boolean initStoppedDownloads) {
        }

        public boolean seedPieceRecheck() {
            return false;
        }

        public void stopIt(int _stateAfterStopping, boolean remove_torrent, boolean remove_data) {
        }

        public boolean pause() {
            return false;
        }

        public boolean isPaused() {
            return false;
        }

        public void resume() {
        }

        public boolean isAZMessagingEnabled() {
            return true;
        }

        public void setAZMessagingEnabled(boolean enable) {
        }

        public GlobalManager getGlobalManager() {
            return null;
        }

        public DiskManager getDiskManager() {
            return null;
        }

        public DiskManagerFileInfo[] getDiskManagerFileInfo() {
            return null;
        }

        public PEPeerManager getPeerManager() {
            return this.peer_manager;
        }

        public void setAnnounceResult(DownloadAnnounceResult result) {
        }

        public void setScrapeResult(DownloadScrapeResult result) {
        }

        public void addListener(DownloadManagerListener listener) {
        }

        public void removeListener(DownloadManagerListener listener) {
        }

        public void addTrackerListener(DownloadManagerTrackerListener listener) {
        }

        public void removeTrackerListener(DownloadManagerTrackerListener listener) {
        }

        public void addDiskListener(DownloadManagerDiskListener listener) {
        }

        public void removeDiskListener(DownloadManagerDiskListener listener) {
        }

        public void addActivationListener(DownloadManagerActivationListener listener) {
        }

        public void removeActivationListener(DownloadManagerActivationListener listener) {
        }

        public int getActivationCount() {
            return 0;
        }

        public void addPeerListener(DownloadManagerPeerListener listener) {
        }

        public void removePeerListener(DownloadManagerPeerListener listener) {
        }

        public void addPeer(PEPeer peer) {
        }

        public void removePeer(PEPeer peer) {
        }

        public void addPiece(PEPiece piece) {
        }

        public void removePiece(PEPiece piece) {
        }

        public TOTorrent getTorrent() {
            return null;
        }

        public TRTrackerAnnouncer getTrackerClient() {
            return null;
        }

        public void requestTrackerAnnounce(boolean now) {
        }

        public void requestTrackerScrape(boolean now) {
        }

        public TRTrackerScraperResponse getTrackerScrapeResponse() {
            return null;
        }

        public void setTrackerScrapeResponse(TRTrackerScraperResponse response) {
        }

        public String getDisplayName() {
            return null;
        }

        public String getInternalName() {
            return null;
        }

        public long getSize() {
            return 9L;
        }

        public String getTorrentFileName() {
            return null;
        }

        public void setTorrentFileName(String string) {
        }

        public File getSaveLocation() {
            return this.file;
        }

        public File getAbsoluteSaveLocation() {
            return this.file;
        }

        public void setTorrentSaveDir(String sPath) {
        }

        public int getPriority() {
            return 9;
        }

        public boolean isForceStart() {
            return false;
        }

        public void setForceStart(boolean forceStart) {
        }

        public boolean isPersistent() {
            return false;
        }

        public boolean isDownloadComplete() {
            return false;
        }

        public boolean isDownloadComplete(boolean b) {
            return false;
        }

        public String getTrackerStatus() {
            return null;
        }

        public int getTrackerTime() {
            return 0;
        }

        public String getTorrentComment() {
            return null;
        }

        public String getTorrentCreatedBy() {
            return null;
        }

        public long getTorrentCreationDate() {
            return 0L;
        }

        public int getNbPieces() {
            return 0;
        }

        public String getPieceLength() {
            return null;
        }

        public int getNbSeeds() {
            return 0;
        }

        public int getNbPeers() {
            return 0;
        }

        public boolean filesExist() {
            return false;
        }

        public String getErrorDetails() {
            return null;
        }

        public void setErrorDetail(String str) {
        }

        public int getIndex() {
            return 0;
        }

        public boolean isMoveableDown() {
            return false;
        }

        public boolean isMoveableUp() {
            return false;
        }

        public void moveDown() {
        }

        public void moveUp() {
        }

        public DownloadManagerStats getStats() {
            return null;
        }

        public int getPosition() {
            return 0;
        }

        public void setPosition(int newPosition) {
        }

        public boolean getAssumedComplete() {
            return false;
        }

        public void setOnlySeeding(boolean onlySeeding) {
        }

        public void restartDownload(boolean use_fast_resume) {
        }

        public int getPrevState() {
            return 0;
        }

        public void setPrevState(int state) {
        }

        public DiskManager initializeDiskManager() {
            return null;
        }

        public boolean canForceRecheck() {
            return false;
        }

        public void forceRecheck() {
        }

        public void resetFile(DiskManagerFileInfo file) {
        }

        public void recheckFile(DiskManagerFileInfo file) {
        }

        public int getHealthStatus() {
            return 0;
        }

        public int getNATStatus() {
            return 0;
        }

        public Category getCategory() {
            return null;
        }

        public void setCategory(Category cat) {
        }

        public void deleteDataFiles() {
        }

        public void mergeTorrentDetails(DownloadManager other_manager) {
        }

        public void saveResumeData() {
        }

        public void saveDownload() {
        }

        public void moveDataFiles(File new_parent_dir) {
        }

        public void renameDownload(String name) {
        }

        public void moveTorrentFile(File new_parent_dir) {
        }

        public File[] calculateDefaultPaths(boolean for_moving) {
            return null;
        }

        public boolean isInDefaultSaveDir() {
            return false;
        }

        public Object getData(String key) {
            return null;
        }

        public void setData(String key, Object value) {
        }

        public boolean isDataAlreadyAllocated() {
            return false;
        }

        public void setDataAlreadyAllocated(boolean already_allocated) {
        }

        public long getCreationTime() {
            return 0L;
        }

        public void setCreationTime(long t) {
        }

        public void setSeedingRank(int rank) {
        }

        public int getSeedingRank() {
            return 0;
        }

        public void addPeerListener(DownloadManagerPeerListener listener, boolean bDispatchForExisting) {
        }

        public PEPiece[] getCurrentPieces() {
            return null;
        }

        public PEPeer[] getCurrentPeers() {
            return null;
        }

        public int getEffectiveMaxUploads() {
            return 0;
        }

        public int getMaxUploads() {
            return 0;
        }

        public void setMaxUploads(int max_slots) {
        }

        public int getEffectiveUploadRateLimitBytesPerSecond() {
            return 0;
        }

        public boolean requestAssumedCompleteMode() {
            return false;
        }
    }
}

