/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.resume;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckInstance;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;

public class RDResumeHandler {
    private static final LogIDs LOGID = LogIDs.DISK;
    private static final byte PIECE_NOT_DONE = 0;
    private static final byte PIECE_DONE = 1;
    private static final byte PIECE_RECHECK_REQUIRED = 2;
    private static final byte PIECE_STARTED = 3;
    private static boolean use_fast_resume;
    private static boolean use_fast_resume_recheck_all;
    private DiskManagerImpl disk_manager;
    private DMChecker checker;
    private volatile boolean started;
    private volatile boolean stopped;
    private volatile boolean stopped_for_close;
    private volatile boolean check_in_progress;
    private volatile boolean check_resume_was_valid;
    private volatile boolean check_is_full_check;
    private volatile boolean check_interrupted;
    private volatile int check_position;

    public RDResumeHandler(DiskManagerImpl _disk_manager, DMChecker _writer_and_checker) {
        this.disk_manager = _disk_manager;
        this.checker = _writer_and_checker;
    }

    public void start() {
        if (this.started) {
            Debug.out("RDResumeHandler: reuse not supported");
        }
        this.started = true;
    }

    public void stop(boolean closing) {
        this.stopped_for_close |= closing;
        if (this.check_in_progress) {
            this.check_interrupted = true;
        }
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAllPieces(boolean newfiles) {
        DiskManagerRecheckInstance recheck_inst = this.disk_manager.getRecheckScheduler().register(this.disk_manager, false);
        final AESemaphore run_sem = new AESemaphore("RDResumeHandler::checkAllPieces:runsem", 2);
        try {
            boolean resume_data_complete;
            block48: {
                resume_data_complete = false;
                try {
                    this.check_in_progress = true;
                    boolean resumeEnabled = use_fast_resume;
                    if (newfiles) {
                        resumeEnabled = false;
                    }
                    final AESemaphore pending_checks_sem = new AESemaphore("RD:PendingChecks");
                    int pending_check_num = 0;
                    DiskManagerPiece[] pieces = this.disk_manager.getPieces();
                    if (resumeEnabled) {
                        boolean resumeValid = false;
                        byte[] resume_pieces = null;
                        Map partialPieces = null;
                        Map resume_data = this.getResumeData();
                        if (resume_data != null) {
                            try {
                                resume_pieces = (byte[])resume_data.get("resume data");
                                if (resume_pieces != null && resume_pieces.length != pieces.length) {
                                    Debug.out("Resume data array length mismatch: " + resume_pieces.length + "/" + pieces.length);
                                    resume_pieces = null;
                                }
                                partialPieces = (Map)resume_data.get("blocks");
                                boolean bl = resumeValid = ((Long)resume_data.get("valid")).intValue() == 1;
                                if (RDResumeHandler.isTorrentResumeDataComplete(this.disk_manager.getDownloadManager().getDownloadState(), resume_data)) {
                                    resume_data_complete = true;
                                } else {
                                    resume_data.put("valid", new Long(0L));
                                    this.saveResumeData(resume_data);
                                }
                            }
                            catch (Exception ignore) {
                                // empty catch block
                            }
                        }
                        if (resume_pieces == null) {
                            this.check_is_full_check = true;
                            resumeValid = false;
                            resume_pieces = new byte[pieces.length];
                            Arrays.fill(resume_pieces, (byte)2);
                        }
                        this.check_resume_was_valid = resumeValid;
                        DiskManagerFileInfo[] files = this.disk_manager.getFiles();
                        HashMap<DiskManagerFileInfo, Long> file_sizes = new HashMap<DiskManagerFileInfo, Long>();
                        for (int i = 0; i < files.length; ++i) {
                            try {
                                Long len = new Long(((DiskManagerFileInfoImpl)files[i]).getCacheFile().getLength());
                                file_sizes.put(files[i], len);
                                continue;
                            }
                            catch (CacheFileManagerException e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        boolean recheck_all = use_fast_resume_recheck_all;
                        if (!recheck_all) {
                            long total_not_done = 0L;
                            int piece_size = this.disk_manager.getPieceLength();
                            for (int i = 0; i < pieces.length; ++i) {
                                if (resume_pieces[i] == 1) continue;
                                total_not_done += (long)piece_size;
                            }
                            if (total_not_done < 0x4000000L) {
                                recheck_all = true;
                            }
                        }
                        if (Logger.isEnabled()) {
                            int total_not_done = 0;
                            int total_done = 0;
                            int total_started = 0;
                            int total_recheck = 0;
                            for (int i = 0; i < pieces.length; ++i) {
                                byte piece_state = resume_pieces[i];
                                if (piece_state == 0) {
                                    ++total_not_done;
                                    continue;
                                }
                                if (piece_state == 1) {
                                    ++total_done;
                                    continue;
                                }
                                if (piece_state == 3) {
                                    ++total_started;
                                    continue;
                                }
                                ++total_recheck;
                            }
                            String str = "valid=" + resumeValid + ",not done=" + total_not_done + ",done=" + total_done + ",started=" + total_started + ",recheck=" + total_recheck + ",rc all=" + recheck_all + ",full=" + this.check_is_full_check;
                            Logger.log(new LogEvent(this.disk_manager, LOGID, str));
                        }
                        for (int i = 0; i < pieces.length; ++i) {
                            this.check_position = i;
                            DiskManagerPiece dm_piece = pieces[i];
                            this.disk_manager.setPercentDone((i + 1) * 1000 / this.disk_manager.getNbPieces());
                            byte piece_state = resume_pieces[i];
                            if (piece_state == 1) {
                                DMPieceList list = this.disk_manager.getPieceList(i);
                                for (int j = 0; j < list.size(); ++j) {
                                    DMPieceMapEntry entry = list.get(j);
                                    Long file_size = (Long)file_sizes.get(entry.getFile());
                                    if (file_size == null) {
                                        piece_state = 0;
                                        if (!Logger.isEnabled()) break;
                                        Logger.log(new LogEvent((Object)this.disk_manager, LOGID, 1, "Piece #" + i + ": file is missing, " + "fails re-check."));
                                        break;
                                    }
                                    long expected_size = entry.getOffset() + (long)entry.getLength();
                                    if (file_size >= expected_size) continue;
                                    piece_state = 0;
                                    if (!Logger.isEnabled()) break;
                                    Logger.log(new LogEvent((Object)this.disk_manager, LOGID, 1, "Piece #" + i + ": file is too small, fails re-check. File size = " + file_size + ", piece needs " + expected_size));
                                    break;
                                }
                            }
                            if (piece_state == 1) {
                                dm_piece.setDone(true);
                                continue;
                            }
                            if (piece_state == 0 && !recheck_all || piece_state != 2 && resumeValid) continue;
                            run_sem.reserve();
                            while (!this.stopped && !recheck_inst.getPermission()) {
                            }
                            if (this.stopped) break;
                            try {
                                DiskManagerCheckRequest request2 = this.disk_manager.createCheckRequest(i, null);
                                request2.setLowPriority(true);
                                this.checker.enqueueCheckRequest(request2, new DiskManagerCheckRequestListener(){

                                    public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                                        this.complete();
                                    }

                                    public void checkCancelled(DiskManagerCheckRequest request2) {
                                        this.complete();
                                    }

                                    public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                                        this.complete();
                                    }

                                    protected void complete() {
                                        run_sem.release();
                                        pending_checks_sem.release();
                                    }
                                });
                                ++pending_check_num;
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        while (pending_check_num > 0) {
                            pending_checks_sem.reserve();
                            --pending_check_num;
                        }
                        if (partialPieces != null) {
                            Iterator iter = partialPieces.entrySet().iterator();
                            while (iter.hasNext()) {
                                Map.Entry key = iter.next();
                                int pieceNumber = Integer.parseInt((String)key.getKey());
                                DiskManagerPiece dm_piece = pieces[pieceNumber];
                                if (dm_piece.isDone()) continue;
                                List blocks = (List)partialPieces.get(key.getKey());
                                Iterator iterBlock = blocks.iterator();
                                while (iterBlock.hasNext()) {
                                    dm_piece.setWritten(((Long)iterBlock.next()).intValue());
                                }
                            }
                        }
                        break block48;
                    }
                    for (int i = 0; i < pieces.length; ++i) {
                        this.check_position = i;
                        run_sem.reserve();
                        while (!this.stopped && !recheck_inst.getPermission()) {
                        }
                        if (this.stopped) break;
                        this.disk_manager.setPercentDone((i + 1) * 1000 / this.disk_manager.getNbPieces());
                        try {
                            DiskManagerCheckRequest request3 = this.disk_manager.createCheckRequest(i, null);
                            request3.setLowPriority(true);
                            this.checker.enqueueCheckRequest(request3, new DiskManagerCheckRequestListener(){

                                public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                                    this.complete();
                                }

                                public void checkCancelled(DiskManagerCheckRequest request2) {
                                    this.complete();
                                }

                                public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                                    this.complete();
                                }

                                protected void complete() {
                                    run_sem.release();
                                    pending_checks_sem.release();
                                }
                            });
                            ++pending_check_num;
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    while (pending_check_num > 0) {
                        pending_checks_sem.reserve();
                        --pending_check_num;
                    }
                }
                finally {
                    this.check_in_progress = false;
                }
            }
            if (!this.stopped && !resume_data_complete) {
                try {
                    this.saveResumeData(true);
                }
                catch (Exception e) {
                    Debug.out("Failed to dump initial resume data to disk");
                    Debug.printStackTrace(e);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        finally {
            recheck_inst.unregister();
        }
    }

    public void saveResumeData(boolean interim_save) throws Exception {
        if (this.check_in_progress && interim_save) {
            return;
        }
        DiskManagerFileInfo[] files = this.disk_manager.getFiles();
        if (!use_fast_resume) {
            for (int i = 0; i < files.length; ++i) {
                files[i].flushCache();
            }
            return;
        }
        boolean was_complete = RDResumeHandler.isTorrentResumeDataComplete(this.disk_manager.getDownloadManager().getDownloadState());
        DiskManagerPiece[] pieces = this.disk_manager.getPieces();
        byte[] resume_pieces = new byte[pieces.length];
        for (int i = 0; i < resume_pieces.length; ++i) {
            DiskManagerPiece piece = pieces[i];
            resume_pieces[i] = this.stopped_for_close && this.check_interrupted && this.check_is_full_check && i >= this.check_position ? 2 : (piece.isDone() ? 1 : (piece.getNbWritten() > 0 ? 3 : 0));
        }
        HashMap<String, Object> resume_data = new HashMap<String, Object>();
        resume_data.put("resume data", resume_pieces);
        HashMap partialPieces = new HashMap();
        for (int i = 0; i < pieces.length; ++i) {
            DiskManagerPiece piece = pieces[i];
            boolean[] written = piece.getWritten();
            if (piece.isDone() || piece.getNbWritten() <= 0 || written == null) continue;
            boolean all_written = true;
            for (int j = 0; j < written.length; ++j) {
                if (written[j]) continue;
                all_written = false;
                break;
            }
            if (all_written) {
                resume_pieces[i] = 2;
                continue;
            }
            ArrayList<Long> blocks = new ArrayList<Long>();
            for (int j = 0; j < written.length; ++j) {
                if (!written[j]) continue;
                blocks.add(new Long(j));
            }
            partialPieces.put("" + i, blocks);
        }
        resume_data.put("blocks", partialPieces);
        long lValid = this.check_interrupted ? (this.check_resume_was_valid ? 1L : 0L) : (interim_save ? 0L : 1L);
        resume_data.put("valid", new Long(lValid));
        for (int i = 0; i < files.length; ++i) {
            files[i].flushCache();
        }
        boolean is_complete = RDResumeHandler.isTorrentResumeDataComplete(this.disk_manager.getDownloadManager().getDownloadState(), resume_data);
        if (!was_complete || !is_complete) {
            this.saveResumeData(resume_data);
        }
    }

    protected Map getResumeData() {
        return RDResumeHandler.getResumeData(this.disk_manager.getDownloadManager());
    }

    protected static Map getResumeData(DownloadManager download_manager) {
        return RDResumeHandler.getResumeData(download_manager.getDownloadState());
    }

    protected static Map getResumeData(DownloadManagerState download_manager_state) {
        Map resume_map = download_manager_state.getResumeData();
        if (resume_map != null) {
            Map resume_data = (Map)resume_map.get("data");
            return resume_data;
        }
        return null;
    }

    protected void saveResumeData(Map resume_data) {
        RDResumeHandler.saveResumeData(this.disk_manager.getDownloadManager().getDownloadState(), resume_data);
    }

    protected static void saveResumeData(DownloadManagerState download_manager_state, Map resume_data) {
        HashMap<String, Map> resume_map = new HashMap<String, Map>();
        resume_map.put("data", resume_data);
        download_manager_state.setResumeData(resume_map);
    }

    public static void setTorrentResumeDataComplete(DownloadManagerState download_manager_state) {
        TOTorrent torrent = download_manager_state.getTorrent();
        int piece_count = torrent.getNumberOfPieces();
        byte[] resume_pieces = new byte[piece_count];
        Arrays.fill(resume_pieces, (byte)1);
        HashMap<String, Object> resume_data = new HashMap<String, Object>();
        resume_data.put("resume data", resume_pieces);
        HashMap partialPieces = new HashMap();
        resume_data.put("blocks", partialPieces);
        resume_data.put("valid", new Long(1L));
        RDResumeHandler.saveResumeData(download_manager_state, resume_data);
    }

    protected static int clearResumeDataSupport(DownloadManager download_manager, DiskManagerFileInfo file, boolean recheck, boolean ignore_first_and_last) {
        Map partial_pieces;
        DownloadManagerState download_manager_state = download_manager.getDownloadState();
        Map resume_data = RDResumeHandler.getResumeData(download_manager);
        if (resume_data == null) {
            return 0;
        }
        int pieces_cleared = 0;
        byte[] resume_pieces = (byte[])resume_data.get("resume data");
        int first_piece = file.getFirstPieceNumber();
        int last_piece = file.getLastPieceNumber();
        if (ignore_first_and_last) {
            ++first_piece;
            --last_piece;
        }
        if (resume_pieces != null) {
            for (int i = first_piece; i <= last_piece && i < resume_pieces.length; ++i) {
                if (resume_pieces[i] == 1) {
                    ++pieces_cleared;
                }
                resume_pieces[i] = recheck ? 2 : 0;
            }
        }
        if ((partial_pieces = (Map)resume_data.get("blocks")) != null) {
            Iterator iter = partial_pieces.keySet().iterator();
            while (iter.hasNext()) {
                int piece_number = Integer.parseInt((String)iter.next());
                if (piece_number < first_piece || piece_number > last_piece) continue;
                iter.remove();
            }
        }
        resume_data.put("valid", new Long(1L));
        RDResumeHandler.saveResumeData(download_manager_state, resume_data);
        return pieces_cleared;
    }

    public static int storageTypeChanged(DownloadManager download_manager, DiskManagerFileInfo file) {
        return RDResumeHandler.clearResumeDataSupport(download_manager, file, false, true);
    }

    public static void clearResumeData(DownloadManager download_manager, DiskManagerFileInfo file) {
        RDResumeHandler.clearResumeDataSupport(download_manager, file, false, false);
    }

    public static void recheckFile(DownloadManager download_manager, DiskManagerFileInfo file) {
        RDResumeHandler.clearResumeDataSupport(download_manager, file, true, false);
    }

    public static void setTorrentResumeDataNearlyComplete(DownloadManagerState download_manager_state) {
        TOTorrent torrent = download_manager_state.getTorrent();
        long piece_count = torrent.getNumberOfPieces();
        byte[] resume_pieces = new byte[(int)piece_count];
        Arrays.fill(resume_pieces, (byte)1);
        for (int i = 0; i < 3; ++i) {
            int piece_num = (int)(Math.random() * (double)piece_count);
            resume_pieces[piece_num] = 2;
        }
        HashMap<String, Object> resumeMap = new HashMap<String, Object>();
        resumeMap.put("resume data", resume_pieces);
        HashMap partialPieces = new HashMap();
        resumeMap.put("blocks", partialPieces);
        resumeMap.put("valid", new Long(0L));
        RDResumeHandler.saveResumeData(download_manager_state, resumeMap);
    }

    public static boolean isTorrentResumeDataComplete(DownloadManagerState dms) {
        Map resume_data = RDResumeHandler.getResumeData(dms);
        return RDResumeHandler.isTorrentResumeDataComplete(dms, resume_data);
    }

    protected static boolean isTorrentResumeDataComplete(DownloadManagerState download_manager_state, Map resume_data) {
        try {
            int piece_count = download_manager_state.getTorrent().getNumberOfPieces();
            if (resume_data != null) {
                boolean valid;
                byte[] pieces = (byte[])resume_data.get("resume data");
                Map blocks = (Map)resume_data.get("blocks");
                boolean bl = valid = ((Long)resume_data.get("valid")).intValue() == 1;
                if (blocks == null || blocks.size() > 0) {
                    return false;
                }
                if (valid && pieces != null && pieces.length == piece_count) {
                    for (int i = 0; i < pieces.length; ++i) {
                        if (pieces[i] == 1) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return false;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Use Resume", "On Resume Recheck All"}, new ParameterListener(){

            public void parameterChanged(String str) {
                use_fast_resume = COConfigurationManager.getBooleanParameter("Use Resume");
                use_fast_resume_recheck_all = COConfigurationManager.getBooleanParameter("On Resume Recheck All");
            }
        });
    }
}

