/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.FileUtil;

public class DownloadManagerDefaultPaths {
    private static final MovementInformation[] COMPLETION_DETAILS;
    private static final MovementInformation[] REMOVAL_DETAILS;
    private static final MovementInformation[] UPDATE_FOR_MOVE_DETAILS;
    private static final MovementInformation[] UPDATE_FOR_LOGIC_DETAILS;
    private static final TargetSpecification[] DEFAULT_DIRS;
    private static final String STATE_INCOMPLETE = "incomplete download";
    private static final String STATE_COMPLETE_DND = "dnd-complete download";
    private static final String STATE_COMPLETE = "fully-complete download";
    private static final String SUBDIR_PARAM = "File.move.subdir_is_default";

    private static String normaliseRelativePathPart(String name) {
        if ((name = name.trim()).length() == 0) {
            return "";
        }
        if (name.equals(".") || name.equals("..")) {
            return null;
        }
        return FileUtil.convertOSSpecificChars(name).trim();
    }

    public static File normaliseRelativePath(File path) {
        File parent;
        if (path.isAbsolute()) {
            return null;
        }
        String child_name = DownloadManagerDefaultPaths.normaliseRelativePathPart(path.getName());
        if (child_name == null) {
            return null;
        }
        if (parent == null) {
            return new File(child_name);
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(child_name);
        String filepart = null;
        for (parent = path.getParentFile(); parent != null; parent = parent.getParentFile()) {
            filepart = DownloadManagerDefaultPaths.normaliseRelativePathPart(parent.getName());
            if (filepart == null) {
                return null;
            }
            if (filepart.length() == 0) continue;
            parts.add(0, filepart);
        }
        StringBuffer sb = new StringBuffer((String)parts.get(0));
        for (int i = 1; i < parts.size(); ++i) {
            sb.append(File.separatorChar);
            sb.append(parts.get(i));
        }
        return new File(sb.toString());
    }

    private static File[] getDefaultDirs(LogRelation lr) {
        ArrayList<File> results = new ArrayList<File>();
        File location = null;
        TargetSpecification ts = null;
        for (int i = 0; i < DEFAULT_DIRS.length; ++i) {
            ts = DEFAULT_DIRS[i];
            location = ts.getTarget(null, lr, ts);
            if (location == null) continue;
            results.add(location);
        }
        return results.toArray(new File[results.size()]);
    }

    private static String getStateDescriptor(DownloadManager dm) {
        if (dm.isDownloadComplete(true)) {
            return STATE_COMPLETE;
        }
        if (dm.isDownloadComplete(false)) {
            return STATE_COMPLETE_DND;
        }
        return STATE_INCOMPLETE;
    }

    private static void logInfo(String message, LogRelation lr) {
        if (lr == null) {
            return;
        }
        if (!Logger.isEnabled()) {
            return;
        }
        Logger.log(new LogEvent((Object)lr, LogIDs.CORE, 0, message));
    }

    private static void logWarn(String message, LogRelation lr) {
        if (lr == null) {
            return;
        }
        if (!Logger.isEnabled()) {
            return;
        }
        Logger.log(new LogEvent((Object)lr, LogIDs.CORE, 1, message));
    }

    private static String describe(DownloadManager dm, ContextDescriptor cs) {
        if (cs == null) {
            if (dm == null) {
                return "";
            }
            return "\"" + dm.getDisplayName() + "\"";
        }
        if (dm == null) {
            return "\"" + cs.getContext() + "\"";
        }
        return "\"" + dm.getDisplayName() + "\" with regard to \"" + cs.getContext() + "\"";
    }

    private static TransferDetails determinePaths(DownloadManager dm, MovementInformation mi, boolean assumecomplete) {
        LogRelation lr = dm instanceof LogRelation ? (LogRelation)((Object)dm) : null;
        boolean proceed = mi.source.matchesDownload(dm, lr, mi, assumecomplete);
        if (!proceed) {
            DownloadManagerDefaultPaths.logInfo("Cannot consider " + DownloadManagerDefaultPaths.describe(dm, mi) + " - does not match source criteria.", lr);
            return null;
        }
        File target_path = mi.target.getTarget(dm, lr, mi);
        if (target_path == null) {
            DownloadManagerDefaultPaths.logInfo("Unable to determine an appropriate target for " + DownloadManagerDefaultPaths.describe(dm, mi) + ".", lr);
            return null;
        }
        DownloadManagerDefaultPaths.logInfo("Determined path for " + DownloadManagerDefaultPaths.describe(dm, mi) + ".", lr);
        return mi.transfer.getTransferDetails(dm, lr, mi, target_path);
    }

    private static TransferDetails determinePaths(DownloadManager dm, MovementInformation[] mis, boolean assumecomplete) {
        TransferDetails result = null;
        for (int i = 0; i < mis.length; ++i) {
            result = DownloadManagerDefaultPaths.determinePaths(dm, mis[i], assumecomplete);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static boolean isInDefaultDownloadDir(DownloadManager dm) {
        SourceSpecification source = new SourceSpecification();
        source.setBoolean("default subdir", SUBDIR_PARAM);
        return source.checkDefaultDir(dm.getSaveLocation().getParentFile(), DownloadManagerDefaultPaths.getDefaultDirs(null));
    }

    public static TransferDetails onCompletion(DownloadManager dm, boolean set_on_completion_flag) {
        TransferDetails td = DownloadManagerDefaultPaths.determinePaths(dm, COMPLETION_DETAILS, true);
        if (set_on_completion_flag) {
            LogRelation lr = dm instanceof LogRelation ? (LogRelation)((Object)dm) : null;
            DownloadManagerDefaultPaths.logInfo("Setting completion flag on " + DownloadManagerDefaultPaths.describe(dm, null) + ", may have been set before.", lr);
            dm.getDownloadState().setFlag(8L, true);
        }
        return td;
    }

    public static TransferDetails onRemoval(DownloadManager dm) {
        return DownloadManagerDefaultPaths.determinePaths(dm, REMOVAL_DETAILS, false);
    }

    public static File[] getDefaultSavePaths(DownloadManager dm, boolean for_moving) {
        MovementInformation[] mi = for_moving ? UPDATE_FOR_MOVE_DETAILS : UPDATE_FOR_LOGIC_DETAILS;
        TransferDetails details = DownloadManagerDefaultPaths.determinePaths(dm, mi, false);
        File[] result = new File[2];
        if (!for_moving) {
            result[0] = dm.getSaveLocation();
            result[1] = new File(dm.getTorrentFileName()).getParentFile();
        }
        if (details != null) {
            result[0] = details.transfer_destination;
            if (details.move_torrent) {
                result[1] = result[0];
            }
        }
        return result;
    }

    static {
        DEFAULT_DIRS = new TargetSpecification[3];
        TargetSpecification dest = new TargetSpecification();
        dest.setBoolean("enabled", true);
        dest.setString("target", "Default save path");
        dest.setContext("default save dir");
        DownloadManagerDefaultPaths.DEFAULT_DIRS[0] = dest;
        SourceSpecification source = new SourceSpecification();
        source.setBoolean("default dir", "Move Only When In Default Save Dir");
        source.setBoolean("default subdir", SUBDIR_PARAM);
        source.setBoolean("persistent only", true);
        source.setBoolean("check exclusion flag", true);
        source.setBoolean("check completion flag", true);
        source.setBoolean(STATE_INCOMPLETE, false);
        source.setBoolean(STATE_COMPLETE_DND, false);
        source.setBoolean(STATE_COMPLETE, true);
        dest = new TargetSpecification();
        dest.setBoolean("enabled", "Move Completed When Done");
        dest.setString("target", "Completed Files Directory");
        dest.setContext("completed files dir");
        TransferSpecification trans = new TransferSpecification();
        trans.setBoolean("torrent", "Move Torrent When Done");
        MovementInformation mi_1 = new MovementInformation(source, dest, trans, "Move on completion");
        COMPLETION_DETAILS = new MovementInformation[]{mi_1};
        DownloadManagerDefaultPaths.DEFAULT_DIRS[1] = dest;
        source = new SourceSpecification();
        source.setBoolean("default dir", "File.move.download.removed.only_in_default");
        source.setBoolean("default subdir", SUBDIR_PARAM);
        source.setBoolean("persistent only", true);
        source.setBoolean("check exclusion flag", true);
        source.setBoolean("check completion flag", false);
        source.setBoolean(STATE_INCOMPLETE, false);
        source.setBoolean(STATE_COMPLETE_DND, "File.move.download.removed.move_partial");
        source.setBoolean(STATE_COMPLETE, true);
        dest = new TargetSpecification();
        dest.setBoolean("enabled", "File.move.download.removed.enabled");
        dest.setString("target", "File.move.download.removed.path");
        dest.setContext("removed files dir");
        trans = new TransferSpecification();
        trans.setBoolean("torrent", "File.move.download.removed.move_torrent");
        mi_1 = new MovementInformation(source, dest, trans, "Move on removal");
        REMOVAL_DETAILS = new MovementInformation[]{mi_1};
        DownloadManagerDefaultPaths.DEFAULT_DIRS[2] = dest;
        source = new SourceSpecification();
        source.updateSettings(DownloadManagerDefaultPaths.COMPLETION_DETAILS[0].source.getSettings());
        source.setBoolean("default dir", true);
        mi_1 = new MovementInformation(source, DownloadManagerDefaultPaths.COMPLETION_DETAILS[0].target, DownloadManagerDefaultPaths.COMPLETION_DETAILS[0].transfer, "Update completed download");
        source = new SourceSpecification();
        source.setBoolean("default dir", true);
        source.setBoolean("default subdir", SUBDIR_PARAM);
        source.setBoolean("persistent only", true);
        source.setBoolean("check exclusion flag", true);
        source.setBoolean("check completion flag", false);
        source.setBoolean(STATE_INCOMPLETE, true);
        source.setBoolean(STATE_COMPLETE_DND, true);
        source.setBoolean(STATE_COMPLETE, true);
        dest = new TargetSpecification();
        dest.setBoolean("enabled", true);
        dest.setString("target", "Default save path");
        trans = new TransferSpecification();
        trans.setBoolean("torrent", false);
        MovementInformation mi_2 = new MovementInformation(source, dest, trans, "Update incomplete download");
        UPDATE_FOR_MOVE_DETAILS = new MovementInformation[]{mi_1, mi_2};
        UPDATE_FOR_LOGIC_DETAILS = new MovementInformation[UPDATE_FOR_MOVE_DETAILS.length];
        for (int i = 0; i < UPDATE_FOR_MOVE_DETAILS.length; ++i) {
            MovementInformation mi = UPDATE_FOR_MOVE_DETAILS[i];
            source = new SourceSpecification();
            source.updateSettings(mi.source.getSettings());
            source.setBoolean("default dir", false);
            source.setBoolean("persistent only", false);
            source.setBoolean("check exclusion flag", false);
            DownloadManagerDefaultPaths.UPDATE_FOR_LOGIC_DETAILS[i] = new MovementInformation(source, mi.target, mi.transfer, mi.title.replaceAll("Update", "Calculate path for"));
        }
    }

    private static class TransferSpecification
    extends ParameterHelper {
        private TransferSpecification() {
        }

        public TransferDetails getTransferDetails(DownloadManager dm, LogRelation lr, ContextDescriptor cd, File target_path) {
            if (target_path == null) {
                throw new NullPointerException();
            }
            TransferDetails result = new TransferDetails();
            result.transfer_destination = target_path;
            result.move_torrent = this.getBoolean("torrent");
            return result;
        }
    }

    private static class TargetSpecification
    extends ParameterHelper {
        private TargetSpecification() {
        }

        public File getTarget(DownloadManager dm, LogRelation lr, ContextDescriptor cd) {
            if (!this.getBoolean("enabled")) {
                DownloadManagerDefaultPaths.logInfo("Target for " + DownloadManagerDefaultPaths.describe(dm, cd) + " is not enabled.", lr);
                return null;
            }
            String location = this.getString("target").trim();
            if (location.length() == 0) {
                DownloadManagerDefaultPaths.logInfo("No explicit target for " + DownloadManagerDefaultPaths.describe(dm, cd) + ".", lr);
                return null;
            }
            File target = new File(FileUtil.getCanonicalFileName(location));
            String relative_path = null;
            if (dm != null && dm.getDownloadState() != null) {
                relative_path = dm.getDownloadState().getRelativeSavePath();
            }
            if (relative_path != null && relative_path.length() > 0) {
                DownloadManagerDefaultPaths.logInfo("Consider relative save path: " + relative_path, lr);
                target = new File(target.getPath() + File.separator + relative_path);
            }
            return target;
        }
    }

    private static class SourceSpecification
    extends ParameterHelper {
        private SourceSpecification() {
        }

        public boolean matchesDownload(DownloadManager dm, LogRelation lr, ContextDescriptor context, boolean assumecomplete) {
            if (this.getBoolean("persistent only") && !dm.isPersistent()) {
                DownloadManagerDefaultPaths.logWarn(DownloadManagerDefaultPaths.describe(dm, context) + " is not persistent.", lr);
                return false;
            }
            if (this.getBoolean("check exclusion flag") && dm.getDownloadState().getFlag(4L)) {
                DownloadManagerDefaultPaths.logWarn(DownloadManagerDefaultPaths.describe(dm, context) + " has exclusion flag set.", lr);
                return false;
            }
            if (this.getBoolean("check completion flag") && dm.getDownloadState().getFlag(8L)) {
                DownloadManagerDefaultPaths.logInfo(DownloadManagerDefaultPaths.describe(dm, context) + " has completion flag set.", lr);
                return false;
            }
            if (this.getBoolean("default dir")) {
                DownloadManagerDefaultPaths.logInfo("Checking if " + DownloadManagerDefaultPaths.describe(dm, context) + " is inside default dirs.", lr);
                File[] default_dirs = DownloadManagerDefaultPaths.getDefaultDirs(lr);
                File current_location = dm.getSaveLocation().getParentFile();
                if (!this.checkDefaultDir(current_location, default_dirs)) {
                    DownloadManagerDefaultPaths.logWarn(DownloadManagerDefaultPaths.describe(dm, context) + " doesn't exist in any of the following default directories" + " (current dir: " + current_location + ", subdirectories checked: " + this.getBoolean("default subdir") + ") - " + Arrays.asList(default_dirs), lr);
                    return false;
                }
                DownloadManagerDefaultPaths.logInfo(DownloadManagerDefaultPaths.describe(dm, context) + " does exist inside default dirs.", lr);
            }
            if (!assumecomplete) {
                String current_state = DownloadManagerDefaultPaths.getStateDescriptor(dm);
                boolean can_move = this.getBoolean(current_state);
                String log_message = DownloadManagerDefaultPaths.describe(dm, context) + " is " + (can_move ? "" : "not ") + "in an appropriate state (is " + "currently \"" + current_state + "\").";
                if (!can_move) {
                    DownloadManagerDefaultPaths.logWarn(log_message, lr);
                    return false;
                }
                DownloadManagerDefaultPaths.logInfo(log_message, lr);
            }
            return true;
        }

        public boolean checkDefaultDir(File location, File[] default_dirs) {
            location = FileUtil.canonise(location);
            boolean subdir = this.getBoolean("default subdir");
            for (int i = 0; i < default_dirs.length; ++i) {
                if (!(subdir ? FileUtil.isAncestorOf(default_dirs[i], location) : default_dirs[i].equals(location))) continue;
                return true;
            }
            return false;
        }
    }

    private static abstract class ParameterHelper
    implements ContextDescriptor {
        private Map settings = new HashMap();
        private String context = null;

        private ParameterHelper() {
        }

        protected boolean getBoolean(String key) {
            Object result = this.settings.get(key);
            if (result == null) {
                throw new RuntimeException("bad key: " + key);
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return COConfigurationManager.getBooleanParameter((String)result);
        }

        protected void setBoolean(String key, boolean value) {
            this.settings.put(key, value);
        }

        protected void setBoolean(String key, String param) {
            this.settings.put(key, param);
        }

        protected void setString(String key, String param) {
            this.settings.put(key, param);
        }

        protected String getString(String key) {
            String result = (String)this.settings.get(key);
            if (result == null) {
                throw new RuntimeException("bad key: " + key);
            }
            return COConfigurationManager.getStringParameter(result);
        }

        public Map getSettings() {
            return this.settings;
        }

        public void updateSettings(Map settings) {
            this.settings.putAll(settings);
        }

        public String getContext() {
            return this.context;
        }

        public void setContext(String context) {
            this.context = context;
        }
    }

    private static class MovementInformation
    implements ContextDescriptor {
        final SourceSpecification source;
        final TargetSpecification target;
        final TransferSpecification transfer;
        final String title;

        MovementInformation(SourceSpecification source, TargetSpecification target, TransferSpecification transfer, String title) {
            this.source = source;
            this.target = target;
            this.transfer = transfer;
            this.title = title;
        }

        public String getContext() {
            return this.title;
        }
    }

    private static interface ContextDescriptor {
        public String getContext();
    }

    public static class TransferDetails {
        public File transfer_destination;
        public boolean move_torrent;

        public String toString() {
            return "TransferDetails [dest: " + this.transfer_destination.getPath() + ", move-torrent: " + this.move_torrent + "]";
        }
    }
}

