/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.BlockedIp;
import org.gudy.azureus2.core3.ipfilter.IPFilterListener;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.BannedIpImpl;
import org.gudy.azureus2.core3.ipfilter.impl.BlockedIpImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IPAddressRangeManager;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UnresolvableHostManager;

public class IpFilterImpl
implements IpFilter {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final long BAN_IP_PERSIST_TIME = 604800000L;
    private static final int MAX_BLOCKS_TO_REMEMBER = 500;
    private static IpFilterImpl ipFilter;
    private static AEMonitor class_mon;
    private IPAddressRangeManager range_manager = new IPAddressRangeManager();
    private Map bannedIps;
    private LinkedList ipsBlocked;
    private int num_ips_blocked = 0;
    private int num_ips_blocked_loggable = 0;
    private long last_update_time;
    private List listeners = new ArrayList();

    private IpFilterImpl() {
        ipFilter = this;
        this.bannedIps = new HashMap();
        this.ipsBlocked = new LinkedList();
        try {
            this.loadBannedIPs();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        try {
            this.loadFilters();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IpFilter getInstance() {
        try {
            class_mon.enter();
            if (ipFilter == null) {
                ipFilter = new IpFilterImpl();
            }
            IpFilterImpl ipFilterImpl = ipFilter;
            return ipFilterImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    public File getFile() {
        return FileUtil.getUserFile("filters.config");
    }

    public void reload() throws Exception {
        this.loadFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws Exception {
        try {
            class_mon.enter();
            HashMap map = new HashMap();
            ArrayList filters = new ArrayList();
            map.put("ranges", filters);
            ArrayList entries = this.range_manager.getEntries();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                IpRange range = (IpRange)iter.next();
                if (!range.isValid() || range.isSessionOnly()) continue;
                String description = range.getDescription();
                String startIp = range.getStartIp();
                String endIp = range.getEndIp();
                HashMap<String, Object> mapRange = new HashMap<String, Object>();
                mapRange.put("description", description.getBytes("UTF-8"));
                mapRange.put("start", startIp);
                mapRange.put("end", endIp);
                filters.add(mapRange);
            }
            FileOutputStream fos = null;
            try {
                File filtersFile = FileUtil.getUserFile("filters.config");
                fos = new FileOutputStream(filtersFile);
                fos.write(BEncoder.encode(map));
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFilters() throws Exception {
        try {
            class_mon.enter();
            ArrayList<IpRangeImpl> new_ipRanges = new ArrayList<IpRangeImpl>(1024);
            FileInputStream fin = null;
            BufferedInputStream bin = null;
            try {
                File filtersFile = FileUtil.getUserFile("filters.config");
                if (filtersFile.exists()) {
                    fin = new FileInputStream(filtersFile);
                    bin = new BufferedInputStream(fin, 16384);
                    Map map = BDecoder.decode(bin);
                    List list = (List)map.get("ranges");
                    ListIterator iter = list.listIterator();
                    while (iter.hasNext()) {
                        Map range = (Map)iter.next();
                        String description = new String((byte[])range.get("description"), "UTF-8");
                        String startIp = new String((byte[])range.get("start"));
                        String endIp = new String((byte[])range.get("end"));
                        IpRangeImpl ipRange = new IpRangeImpl(description, startIp, endIp, false);
                        ipRange.setAddedToRangeList(true);
                        new_ipRanges.add(ipRange);
                    }
                }
            }
            finally {
                if (bin != null) {
                    try {
                        bin.close();
                    }
                    catch (Throwable e) {}
                }
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Throwable e) {}
                }
                Iterator it = new_ipRanges.iterator();
                while (it.hasNext()) {
                    ((IpRange)it.next()).checkValid();
                }
                this.markAsUpToDate();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBannedIPs() {
        if (!COConfigurationManager.getBooleanParameter("Ip Filter Banning Persistent")) {
            return;
        }
        try {
            class_mon.enter();
            Map map = FileUtil.readResilientConfigFile("banips.config");
            List ips = (List)map.get("ips");
            if (ips != null) {
                long now = SystemTime.getCurrentTime();
                for (int i = 0; i < ips.size(); ++i) {
                    Map entry = (Map)ips.get(i);
                    String ip = new String((byte[])entry.get("ip"));
                    String desc = new String((byte[])entry.get("desc"), "UTF-8");
                    Long ltime = (Long)entry.get("time");
                    long time = ltime;
                    boolean drop = false;
                    if (time > now) {
                        time = now;
                    } else if (now - time >= 604800000L) {
                        drop = true;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 0, "Persistent ban dropped as too old : " + ip + ", " + desc));
                        }
                    }
                    if (drop) continue;
                    int int_ip = this.range_manager.addressToInt(ip);
                    this.bannedIps.put(new Integer(int_ip), new BannedIpImpl(ip, desc, time));
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveBannedIPs() {
        if (!COConfigurationManager.getBooleanParameter("Ip Filter Banning Persistent")) {
            return;
        }
        try {
            class_mon.enter();
            HashMap map = new HashMap();
            ArrayList ips = new ArrayList();
            Iterator it = this.bannedIps.values().iterator();
            while (it.hasNext()) {
                BannedIpImpl bip = (BannedIpImpl)it.next();
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("ip", bip.getIp());
                entry.put("desc", bip.getTorrentName().getBytes("UTF-8"));
                entry.put("time", new Long(bip.getBanningTime()));
                ips.add(entry);
            }
            map.put("ips", ips);
            FileUtil.writeResilientConfigFile("banips.config", map);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        finally {
            class_mon.exit();
        }
    }

    protected boolean isInRange(IpRangeImpl range, String address) {
        return this.range_manager.isInRange(range, address);
    }

    public boolean isInRange(String ipAddress) {
        return this.isInRange(ipAddress, "");
    }

    public boolean isInRange(String ipAddress, String torrent_name) {
        return this.isInRange(ipAddress, torrent_name, true);
    }

    public boolean isInRange(String ipAddress, String torrent_name, boolean loggable) {
        if (this.isBanned(ipAddress)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        if (ipAddress.equals("127.0.0.1")) {
            return false;
        }
        if (AddressUtils.isLANLocalAddress(ipAddress) != 2) {
            return false;
        }
        if (!COConfigurationManager.getBooleanParameter("Ip Filter Enabled", true)) {
            return false;
        }
        boolean allow = COConfigurationManager.getBooleanParameter("Ip Filter Allow");
        IpRange match = (IpRange)this.range_manager.isInRange(ipAddress);
        if (match != null) {
            if (!allow) {
                if (AENetworkClassifier.categoriseAddress(ipAddress) != "Public") {
                    return false;
                }
                this.addBlockedIP(new BlockedIpImpl(ipAddress, match, torrent_name, loggable), loggable);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Ip Blocked : " + ipAddress + ", in range : " + match));
                }
                return true;
            }
            return false;
        }
        if (allow) {
            if (AENetworkClassifier.categoriseAddress(ipAddress) != "Public") {
                return false;
            }
            this.addBlockedIP(new BlockedIpImpl(ipAddress, null, torrent_name, loggable), loggable);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Ip Blocked : " + ipAddress + ", not in any range"));
            }
            return true;
        }
        return false;
    }

    public boolean isInRange(InetAddress ipAddress, String torrent_name, boolean loggable) {
        if (this.isBanned(ipAddress)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        if (ipAddress.isLoopbackAddress() || ipAddress.isLinkLocalAddress() || ipAddress.isSiteLocalAddress()) {
            return false;
        }
        if (AddressUtils.isLANLocalAddress(ipAddress) != 2) {
            return false;
        }
        if (!COConfigurationManager.getBooleanParameter("Ip Filter Enabled", true)) {
            return false;
        }
        boolean allow = COConfigurationManager.getBooleanParameter("Ip Filter Allow");
        IpRange match = (IpRange)this.range_manager.isInRange(ipAddress);
        if (match != null) {
            if (!allow) {
                this.addBlockedIP(new BlockedIpImpl(ipAddress.getHostAddress(), match, torrent_name, loggable), loggable);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Ip Blocked : " + ipAddress + ", in range : " + match));
                }
                return true;
            }
            return false;
        }
        if (allow) {
            this.addBlockedIP(new BlockedIpImpl(ipAddress.getHostAddress(), null, torrent_name, loggable), loggable);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Ip Blocked : " + ipAddress + ", not in any range"));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBlockedIP(BlockedIp ip, boolean loggable) {
        try {
            class_mon.enter();
            this.ipsBlocked.addLast(ip);
            ++this.num_ips_blocked;
            if (loggable) {
                ++this.num_ips_blocked_loggable;
            }
            if (this.ipsBlocked.size() > 500) {
                this.ipsBlocked.removeFirst();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBanned(InetAddress ipAddress) {
        try {
            class_mon.enter();
            int address = this.range_manager.addressToInt(ipAddress);
            Integer i_address = new Integer(address);
            boolean bl = this.bannedIps.get(i_address) != null;
            return bl;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBanned(String ipAddress) {
        try {
            class_mon.enter();
            int address = this.range_manager.addressToInt(ipAddress);
            Integer i_address = new Integer(address);
            boolean bl = this.bannedIps.get(i_address) != null;
            return bl;
        }
        finally {
            class_mon.exit();
        }
    }

    public boolean getInRangeAddressesAreAllowed() {
        boolean allow = COConfigurationManager.getBooleanParameter("Ip Filter Allow");
        return allow;
    }

    public void setInRangeAddressesAreAllowed(boolean b) {
        COConfigurationManager.setParameter("Ip Filter Allow", b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getIpRanges() {
        try {
            class_mon.enter();
            ArrayList arrayList = new ArrayList(this.range_manager.getEntries());
            return arrayList;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpRange[] getRanges() {
        try {
            class_mon.enter();
            ArrayList entries = this.range_manager.getEntries();
            IpRange[] res = new IpRange[entries.size()];
            entries.toArray(res);
            IpRange[] ipRangeArray = res;
            return ipRangeArray;
        }
        finally {
            class_mon.exit();
        }
    }

    public IpRange createRange(boolean sessionOnly) {
        return new IpRangeImpl("", "", "", sessionOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRange(IpRange range) {
        try {
            class_mon.enter();
            ((IpRangeImpl)range).setAddedToRangeList(true);
            range.checkValid();
        }
        finally {
            class_mon.exit();
        }
        this.markAsUpToDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRange(IpRange range) {
        try {
            class_mon.enter();
            ((IpRangeImpl)range).setAddedToRangeList(false);
            this.range_manager.removeRange(range);
        }
        finally {
            class_mon.exit();
        }
        this.markAsUpToDate();
    }

    public int getNbRanges() {
        ArrayList entries = this.range_manager.getEntries();
        return entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValidOrNot(IpRangeImpl range, boolean valid) {
        try {
            class_mon.enter();
            if (!range.getAddedToRangeList()) {
                return;
            }
        }
        finally {
            class_mon.exit();
        }
        if (valid) {
            this.range_manager.addRange(range);
        } else {
            this.range_manager.removeRange(range);
        }
    }

    public int getNbIpsBlocked() {
        return this.num_ips_blocked;
    }

    public int getNbIpsBlockedAndLoggable() {
        return this.num_ips_blocked_loggable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ban(String ipAddress, String torrent_name) {
        boolean block_ban = false;
        ArrayList<BannedIpImpl> new_bans = new ArrayList<BannedIpImpl>();
        try {
            class_mon.enter();
            int address = this.range_manager.addressToInt(ipAddress);
            Integer i_address = new Integer(address);
            if (this.bannedIps.get(i_address) == null) {
                BannedIpImpl new_ban = new BannedIpImpl(ipAddress, torrent_name);
                new_bans.add(new_ban);
                this.bannedIps.put(i_address, new_ban);
                if (!UnresolvableHostManager.isPseudoAddress(ipAddress)) {
                    long l_address = address;
                    if (l_address < 0L) {
                        l_address += 0x100000000L;
                    }
                    long start = l_address & 0xFFFFFFFFFFFFFF00L;
                    long end = start + 256L;
                    int hits = 0;
                    for (long i = start; i < end; ++i) {
                        Integer a = new Integer((int)i);
                        if (this.bannedIps.get(a) == null) continue;
                        ++hits;
                    }
                    int hit_limit = COConfigurationManager.getIntParameter("Ip Filter Ban Block Limit");
                    if (hits >= hit_limit) {
                        block_ban = true;
                        for (long i = start; i < end; ++i) {
                            Integer a = new Integer((int)i);
                            if (this.bannedIps.get(a) != null) continue;
                            BannedIpImpl new_block_ban = new BannedIpImpl(PRHelpers.intToAddress((int)i), torrent_name + " [block ban]");
                            new_bans.add(new_block_ban);
                            this.bannedIps.put(a, new_block_ban);
                        }
                    }
                }
                this.saveBannedIPs();
            }
        }
        finally {
            class_mon.exit();
        }
        List listeners_ref = this.listeners;
        for (int i = 0; i < new_bans.size(); ++i) {
            BannedIp entry = (BannedIp)new_bans.get(i);
            for (int j = 0; j < listeners_ref.size(); ++j) {
                try {
                    ((IPFilterListener)listeners_ref.get(j)).IPBanned(entry);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        return block_ban;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BannedIp[] getBannedIps() {
        try {
            class_mon.enter();
            BannedIp[] res = new BannedIp[this.bannedIps.size()];
            this.bannedIps.values().toArray(res);
            BannedIp[] bannedIpArray = res;
            return bannedIpArray;
        }
        finally {
            class_mon.exit();
        }
    }

    public int getNbBannedIps() {
        return this.bannedIps.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBannedIps() {
        try {
            class_mon.enter();
            this.bannedIps.clear();
            this.saveBannedIPs();
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unban(String ipAddress) {
        try {
            class_mon.enter();
            int address = this.range_manager.addressToInt(ipAddress);
            Integer i_address = new Integer(address);
            this.bannedIps.remove(i_address);
            this.saveBannedIPs();
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockedIp[] getBlockedIps() {
        try {
            class_mon.enter();
            BlockedIp[] res = new BlockedIp[this.ipsBlocked.size()];
            this.ipsBlocked.toArray(res);
            BlockedIp[] blockedIpArray = res;
            return blockedIpArray;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBlockedIPs() {
        try {
            class_mon.enter();
            this.ipsBlocked.clear();
            this.num_ips_blocked = 0;
            this.num_ips_blocked_loggable = 0;
        }
        finally {
            class_mon.exit();
        }
    }

    public boolean isEnabled() {
        return COConfigurationManager.getBooleanParameter("Ip Filter Enabled", true);
    }

    public void setEnabled(boolean enabled) {
        COConfigurationManager.setParameter("Ip Filter Enabled", enabled);
    }

    public void markAsUpToDate() {
        this.last_update_time = SystemTime.getCurrentTime();
    }

    public long getLastUpdateTime() {
        return this.last_update_time;
    }

    public long getTotalAddressesInRange() {
        return this.range_manager.getTotalSpan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IPFilterListener l) {
        try {
            class_mon.enter();
            ArrayList<IPFilterListener> new_listeners = new ArrayList<IPFilterListener>(this.listeners);
            new_listeners.add(l);
            this.listeners = new_listeners;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IPFilterListener l) {
        try {
            class_mon.enter();
            ArrayList new_listeners = new ArrayList(this.listeners);
            new_listeners.remove(l);
            this.listeners = new_listeners;
        }
        finally {
            class_mon.exit();
        }
    }

    public static void main(String[] args) {
        IpFilterImpl filter = new IpFilterImpl();
        filter.ban("255.1.1.1", "parp");
        filter.ban("255.1.1.2", "parp");
        filter.ban("255.1.2.2", "parp");
        System.out.println("is banned:" + filter.isBanned("255.1.1.4"));
    }

    static {
        class_mon = new AEMonitor("IpFilter:class");
    }
}

