/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.net.UnknownHostException;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.IpFilterImpl;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;

public class IpRangeImpl
implements IpRange {
    private static final byte FLAG_SESSION_ONLY = 1;
    private static final byte FLAG_ADDED_TO_RANGE_LIST = 2;
    private Object startIp;
    private Object endIp;
    private byte flags;
    private Object descRef = null;
    private static final byte FLAG_MERGED = 4;
    private int merged_end;
    private IpRange[] my_merged_entries;

    public IpRangeImpl(String _description, String _startIp, String _endIp, boolean _sessionOnly) {
        if (_sessionOnly) {
            this.flags = 1;
        }
        if (_startIp == null || _endIp == null) {
            throw new RuntimeException("Invalid start/end values - null not supported");
        }
        this.startIp = _startIp == "" ? "" : _startIp.trim();
        this.endIp = _endIp == "" ? "" : _endIp.trim();
        if (_description != "") {
            this.setDescription(_description);
        }
        this.checkValid();
    }

    public void checkValid() {
        if (this.startIp != null && this.endIp != null) {
            if (this.startIp instanceof String) {
                try {
                    this.startIp = new Integer(PRHelpers.addressToInt((String)this.startIp));
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            if (this.endIp instanceof String) {
                try {
                    this.endIp = new Integer(PRHelpers.addressToInt((String)this.endIp));
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        ((IpFilterImpl)IpFilterImpl.getInstance()).setValidOrNot(this, this.isValid());
    }

    public boolean isValid() {
        if (this.startIp instanceof Integer && this.endIp instanceof Integer) {
            long start_address = ((Integer)this.startIp).intValue();
            long end_address = ((Integer)this.endIp).intValue();
            if (start_address < 0L) {
                start_address += 0x100000000L;
            }
            if (end_address < 0L) {
                end_address += 0x100000000L;
            }
            return end_address >= start_address;
        }
        return false;
    }

    public boolean isInRange(String ipAddress) {
        if (!this.isValid()) {
            return false;
        }
        try {
            long int_address = PRHelpers.addressToInt(ipAddress);
            if (int_address < 0L) {
                int_address += 0x100000000L;
            }
            long start_address = ((Integer)this.startIp).intValue();
            long end_address = ((Integer)this.endIp).intValue();
            if (start_address < 0L) {
                start_address += 0x100000000L;
            }
            if (end_address < 0L) {
                end_address += 0x100000000L;
            }
            return int_address >= start_address && int_address <= end_address;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public String getDescription() {
        return new String(IpFilterManagerFactory.getSingleton().getDescription(this.descRef));
    }

    public void setDescription(String str) {
        this.descRef = IpFilterManagerFactory.getSingleton().addDecription(this, str.getBytes());
    }

    public String getStartIp() {
        return this.startIp instanceof Integer ? PRHelpers.intToAddress((Integer)this.startIp) : (String)this.startIp;
    }

    public long getStartIpLong() {
        if (this.startIp instanceof Integer) {
            long val = ((Integer)this.startIp).intValue();
            if (val < 0L) {
                val += 0x100000000L;
            }
            return val;
        }
        return -1L;
    }

    public void setStartIp(String str) {
        if (str == null) {
            throw new RuntimeException("Invalid start value - null not supported");
        }
        if (str.equals(this.getStartIp())) {
            return;
        }
        this.startIp = str;
        if (this.endIp != "") {
            this.checkValid();
        }
    }

    public String getEndIp() {
        return this.endIp instanceof Integer ? PRHelpers.intToAddress((Integer)this.endIp) : (String)this.endIp;
    }

    public long getEndIpLong() {
        if (this.endIp instanceof Integer) {
            long val = ((Integer)this.endIp).intValue();
            if (val < 0L) {
                val += 0x100000000L;
            }
            return val;
        }
        return -1L;
    }

    public void setEndIp(String str) {
        if (str == null) {
            throw new RuntimeException("Invalid end value - null not supported");
        }
        if (str.equals(this.getEndIp())) {
            return;
        }
        this.endIp = str;
        if (this.startIp != "") {
            this.checkValid();
        }
    }

    public String toString() {
        return this.getDescription() + " : " + this.getStartIp() + " - " + this.getEndIp();
    }

    public boolean isSessionOnly() {
        return (this.flags & 1) != 0;
    }

    public void setSessionOnly(boolean _sessionOnly) {
        this.flags = _sessionOnly ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public int compareStartIpTo(IpRange other) {
        long l = this.getStartIpLong() - ((IpRangeImpl)other).getStartIpLong();
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    public int compareEndIpTo(IpRange other) {
        long l = this.getEndIpLong() - ((IpRangeImpl)other).getEndIpLong();
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    protected void setAddedToRangeList(boolean b) {
        this.flags = b ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    protected boolean getAddedToRangeList() {
        return (this.flags & 2) != 0;
    }

    public int compareDescription(IpRange other) {
        return this.getDescription().compareTo(other.getDescription());
    }

    protected Object getDescRef() {
        return this.descRef;
    }

    protected void setDescRef(Object descRef) {
        this.descRef = descRef;
    }

    public long getMergedEndLong() {
        return this.merged_end < 0 ? (long)this.merged_end + 0x100000000L : (long)this.merged_end;
    }

    public IpRange[] getMergedEntries() {
        return this.my_merged_entries;
    }

    public void resetMergeInfo() {
        this.flags = (byte)(this.flags & 0xFFFFFFFB);
        if (this.endIp instanceof Integer) {
            this.merged_end = (Integer)this.endIp;
        }
    }

    public boolean getMerged() {
        return (this.flags & 4) != 0;
    }

    public void setMerged() {
        this.flags = (byte)(this.flags | 4);
    }

    public void setMergedEnd(long endIpLong) {
        this.merged_end = (int)(endIpLong >= 0x100000000L ? endIpLong - 0x100000000L : endIpLong);
    }

    public void addMergedEntry(IpRange e2) {
        if (this.my_merged_entries == null) {
            this.my_merged_entries = new IpRange[]{e2};
        } else {
            IpRange[] x = new IpRange[this.my_merged_entries.length + 1];
            System.arraycopy(this.my_merged_entries, 0, x, 0, this.my_merged_entries.length);
            x[x.length - 1] = e2;
            this.my_merged_entries = x;
        }
    }
}

