/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.util.Average;

public class PEPeerStatsImpl
implements PEPeerStats {
    private PEPeer owner;
    private long total_data_bytes_received = 0L;
    private long total_protocol_bytes_received = 0L;
    private final Average data_receive_speed = Average.getInstance(1000, 10);
    private final Average protocol_receive_speed = Average.getInstance(1000, 10);
    private long total_data_bytes_sent = 0L;
    private long total_protocol_bytes_sent = 0L;
    private final Average data_send_speed = Average.getInstance(1000, 5);
    private final Average protocol_send_speed = Average.getInstance(1000, 5);
    private final Average receive_speed_for_choking = Average.getInstance(1000, 20);
    private final Average estimated_download_speed = Average.getInstance(5000, 100);
    private final Average estimated_upload_speed = Average.getInstance(3000, 60);
    private long total_bytes_discarded = 0L;
    private long total_bytes_downloaded = 0L;

    public PEPeerStatsImpl(PEPeer _owner) {
        this.owner = _owner;
    }

    public PEPeer getPeer() {
        return this.owner;
    }

    public void dataBytesSent(int num_bytes) {
        this.total_data_bytes_sent += (long)num_bytes;
        this.data_send_speed.addValue(num_bytes);
    }

    public void protocolBytesSent(int num_bytes) {
        this.total_protocol_bytes_sent += (long)num_bytes;
        this.protocol_send_speed.addValue(num_bytes);
    }

    public void dataBytesReceived(int num_bytes) {
        this.total_data_bytes_received += (long)num_bytes;
        this.data_receive_speed.addValue(num_bytes);
        this.receive_speed_for_choking.addValue(num_bytes);
    }

    public void protocolBytesReceived(int num_bytes) {
        this.total_protocol_bytes_received += (long)num_bytes;
        this.protocol_receive_speed.addValue(num_bytes);
    }

    public void bytesDiscarded(int num_bytes) {
        this.total_bytes_discarded += (long)num_bytes;
    }

    public void hasNewPiece(int piece_size) {
        this.total_bytes_downloaded += (long)piece_size;
        this.estimated_download_speed.addValue(piece_size);
    }

    public void statisticalSentPiece(int piece_size) {
        this.estimated_upload_speed.addValue(piece_size);
    }

    public long getDataReceiveRate() {
        return this.data_receive_speed.getAverage();
    }

    public long getProtocolReceiveRate() {
        return this.protocol_receive_speed.getAverage();
    }

    public long getDataSendRate() {
        return this.data_send_speed.getAverage();
    }

    public long getProtocolSendRate() {
        return this.protocol_send_speed.getAverage();
    }

    public long getSmoothDataReceiveRate() {
        return this.receive_speed_for_choking.getAverage();
    }

    public long getTotalBytesDiscarded() {
        return this.total_bytes_discarded;
    }

    public long getTotalBytesDownloadedByPeer() {
        return this.total_bytes_downloaded;
    }

    public long getEstimatedDownloadRateOfPeer() {
        return this.estimated_download_speed.getAverage();
    }

    public long getEstimatedUploadRateOfPeer() {
        return this.estimated_upload_speed.getAverage();
    }

    public long getTotalDataBytesReceived() {
        return this.total_data_bytes_received;
    }

    public long getTotalProtocolBytesReceived() {
        return this.total_protocol_bytes_received;
    }

    public long getTotalDataBytesSent() {
        return this.total_data_bytes_sent;
    }

    public long getTotalProtocolBytesSent() {
        return this.total_protocol_bytes_sent;
    }
}

