/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.control;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ConnectDisconnectManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.peermanager.control.PeerControlInstance;
import com.aelitis.azureus.core.peermanager.control.PeerControlScheduler;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.peermanager.nat.PeerNATInitiator;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraversalAdapter;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraverser;
import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabase;
import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabaseFactory;
import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePickerFactory;
import com.aelitis.azureus.core.peermanager.unchoker.DownloadingUnchoker;
import com.aelitis.azureus.core.peermanager.unchoker.SeedingUnchoker;
import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadHelper;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSlotManager;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.IPFilterListener;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerManagerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportFactory;
import org.gudy.azureus2.core3.peer.impl.PEPieceImpl;
import org.gudy.azureus2.core3.peer.impl.PEPieceWriteImpl;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPeer;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPiece;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.BrokenMd5Hasher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.peers.PeerDescriptor;

public class PEPeerControlImpl
extends LogRelation
implements PEPeerControl,
ParameterListener,
DiskManagerWriteRequestListener,
PeerControlInstance,
PeerNATInitiator,
DiskManagerCheckRequestListener,
IPFilterListener {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final int WARNINGS_LIMIT = 2;
    private static final int CHECK_REASON_DOWNLOADED = 1;
    private static final int CHECK_REASON_COMPLETE = 2;
    private static final int CHECK_REASON_SCAN = 3;
    private static final int CHECK_REASON_SEEDING_CHECK = 4;
    private static final int SEED_CHECK_WAIT_MARKER = 65526;
    private static boolean disconnect_seeds_when_seeding = COConfigurationManager.getBooleanParameter("Disconnect Seed");
    private static boolean enable_seeding_piece_rechecks = COConfigurationManager.getBooleanParameter("Seeding Piece Check Recheck Enable");
    private static IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private volatile boolean is_running = false;
    private volatile ArrayList peer_transports_cow = new ArrayList();
    private final AEMonitor peer_transports_mon = new AEMonitor("PEPeerControl:PT");
    protected final PEPeerManagerAdapter adapter;
    private final DiskManager disk_mgr;
    private final DiskManagerPiece[] dm_pieces;
    private final PiecePicker piecePicker;
    private long lastNeededUndonePieceChange;
    private boolean seeding_mode;
    private boolean restart_initiated;
    private final int _nbPieces;
    private PEPieceImpl[] pePieces;
    private int nbPiecesActive;
    private int nbPeersSnubbed;
    private PeerIdentityDataID _hash;
    private final byte[] _myPeerId;
    private PEPeerManagerStats _stats;
    private int _seeds;
    private int _peers;
    private int _remotes;
    private long last_remote_time;
    private long _timeStarted;
    private long _timeStartedSeeding = -1L;
    private long _timeFinished;
    private Average _averageReceptionSpeed;
    private long mainloop_loop_count;
    private static final int MAINLOOP_ONE_SECOND_INTERVAL = 1000 / PeerControlScheduler.SCHEDULE_PERIOD_MILLIS;
    private static final int MAINLOOP_FIVE_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 5;
    private static final int MAINLOOP_TEN_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 10;
    private static final int MAINLOOP_THIRTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 30;
    private static final int MAINLOOP_SIXTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 60;
    private static final int MAINLOOP_TEN_MINUTE_INTERVAL = MAINLOOP_SIXTY_SECOND_INTERVAL * 10;
    private volatile ArrayList peer_manager_listeners_cow = new ArrayList();
    private final List piece_check_result_list = new ArrayList();
    private final AEMonitor piece_check_result_list_mon = new AEMonitor("PEPeerControl:PCRL");
    private boolean superSeedMode;
    private int superSeedModeCurrentPiece;
    private int superSeedModeNumberOfAnnounces;
    private SuperSeedPiece[] superSeedPieces;
    private final AEMonitor this_mon = new AEMonitor("PEPeerControl");
    private long ip_filter_last_update_time;
    private Map user_data;
    private Unchoker unchoker;
    private static boolean fast_unchoke_new_peers;
    private final UploadHelper upload_helper = new UploadHelper(){

        public int getPriority() {
            return 4;
        }

        public ArrayList getAllPeers() {
            ArrayList peer_transports = PEPeerControlImpl.this.peer_transports_cow;
            return peer_transports;
        }

        public boolean isSeeding() {
            return PEPeerControlImpl.this.seeding_mode;
        }
    };
    private PeerDatabase peer_database = PeerDatabaseFactory.createPeerDatabase();
    private int next_rescan_piece = -1;
    private long rescan_piece_time = -1L;
    private long last_eta;
    private long last_eta_calculation;
    private static final int UDP_FALLBACK_MAX = 32;
    private static final int MAX_UDP_TRAVERSAL_COUNT = 3;
    private static final int MAX_UDP_CONNECTIONS = 10;
    private Map udp_fallbacks = new LinkedHashMap(32, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 32;
        }
    };
    private int udp_traversal_count;
    private final LimitedRateGroup upload_limited_rate_group = new LimitedRateGroup(){

        public int getRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getUploadRateLimitBytesPerSecond();
        }
    };
    private final LimitedRateGroup download_limited_rate_group = new LimitedRateGroup(){

        public int getRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getDownloadRateLimitBytesPerSecond();
        }
    };

    public PEPeerControlImpl(byte[] _peer_id, PEPeerManagerAdapter _adapter, DiskManager diskManager) {
        this._myPeerId = _peer_id;
        this.adapter = _adapter;
        this.disk_mgr = diskManager;
        this._nbPieces = this.disk_mgr.getNbPieces();
        this.dm_pieces = this.disk_mgr.getPieces();
        this.pePieces = new PEPieceImpl[this._nbPieces];
        this.piecePicker = PiecePickerFactory.create(this);
        COConfigurationManager.addParameterListener("Ip Filter Enabled", this);
        COConfigurationManager.addParameterListener("Disconnect Seed", this);
        ip_filter.addListener(this);
    }

    public void start() {
        try {
            this._hash = PeerIdentityManager.createDataID(this.disk_mgr.getTorrent().getHash());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this._hash = PeerIdentityManager.createDataID(new byte[20]);
        }
        for (int i = 0; i < this._nbPieces; ++i) {
            DiskManagerPiece dmPiece = this.dm_pieces[i];
            if (dmPiece.isDone() || dmPiece.getNbWritten() <= 0) continue;
            this.addPiece(new PEPieceImpl(this, dmPiece, 0), i, true);
        }
        this.peer_transports_cow = new ArrayList();
        this.mainloop_loop_count = 0L;
        this._averageReceptionSpeed = Average.getInstance(1000, 30);
        this._stats = new PEPeerManagerStatsImpl(this);
        this.superSeedMode = COConfigurationManager.getBooleanParameter("Use Super Seeding") && this.getRemaining() == 0L;
        this.superSeedModeCurrentPiece = 0;
        if (this.superSeedMode) {
            this.initialiseSuperSeedMode();
        }
        this.checkFinished(true);
        UploadSlotManager.getSingleton().registerHelper(this.upload_helper);
        this.lastNeededUndonePieceChange = Long.MIN_VALUE;
        this._timeStarted = SystemTime.getCurrentTime();
        this.is_running = true;
        this.adapter.getPeerManagerRegistration().activate(this);
        PeerNATTraverser.getSingleton().register(this);
        PeerControlSchedulerFactory.getSingleton().register(this);
    }

    public void stopAll() {
        this.is_running = false;
        UploadSlotManager.getSingleton().deregisterHelper(this.upload_helper);
        PeerControlSchedulerFactory.getSingleton().unregister(this);
        PeerNATTraverser.getSingleton().unregister(this);
        this.adapter.getPeerManagerRegistration().deactivate();
        this.closeAndRemoveAllPeers("download stopped", false);
        for (int i = 0; i < this._nbPieces; ++i) {
            if (this.pePieces[i] == null) continue;
            this.removePiece(this.pePieces[i], i);
        }
        COConfigurationManager.removeParameterListener("Ip Filter Enabled", this);
        COConfigurationManager.removeParameterListener("Disconnect Seed", this);
        ip_filter.removeListener(this);
        ArrayList peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            ((PEPeerManagerListener)peer_manager_listeners.get(i)).destroyed();
        }
    }

    public DiskManager getDiskManager() {
        return this.disk_mgr;
    }

    public PiecePicker getPiecePicker() {
        return this.piecePicker;
    }

    public PEPeerManagerAdapter getAdapter() {
        return this.adapter;
    }

    public String getDisplayName() {
        return this.adapter.getDisplayName();
    }

    public void schedule() {
        try {
            this.updateTrackerAnnounceInterval();
            this.doConnectionChecks();
            this.processPieceChecks();
            if (!this.seeding_mode) {
                this.checkCompletedPieces();
            }
            this.updateStats();
            this.checkInterested();
            this.piecePicker.updateAvailability();
            this.checkCompletionState();
            if (this.seeding_mode) {
                this.checkSeeds();
            } else {
                this.checkRequests();
                this.piecePicker.allocateRequests();
                this.checkRescan();
                this.checkSpeedAndReserved();
                this.check99PercentBug();
            }
            this.updatePeersInSuperSeedMode();
            this.doUnchokes();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        ++this.mainloop_loop_count;
    }

    private void analyseTrackerResponse(TRTrackerAnnouncerResponse tracker_response) {
        Map extensions;
        TRTrackerAnnouncerResponsePeer[] peers = tracker_response.getPeers();
        if (peers != null) {
            this.addPeersFromTracker(tracker_response.getPeers());
        }
        if ((extensions = tracker_response.getExtensions()) != null) {
            this.addExtendedPeersFromTracker(extensions);
        }
    }

    public void processTrackerResponse(TRTrackerAnnouncerResponse response) {
        if (this.is_running) {
            this.analyseTrackerResponse(response);
        }
    }

    private void addExtendedPeersFromTracker(Map extensions) {
        Map protocols = (Map)extensions.get("protocols");
        if (protocols != null) {
            System.out.println("PEPeerControl: tracker response contained protocol extensions");
            Iterator protocol_it = protocols.keySet().iterator();
            while (protocol_it.hasNext()) {
                String protocol_name = (String)protocol_it.next();
                Map protocol = (Map)protocols.get(protocol_name);
                List transports = PEPeerTransportFactory.createExtendedTransports(this, protocol_name, protocol);
                for (int i = 0; i < transports.size(); ++i) {
                    PEPeer transport = (PEPeer)transports.get(i);
                    this.addPeer(transport);
                }
            }
        }
    }

    public List getPeers() {
        return this.peer_transports_cow;
    }

    public List getPeers(String address) {
        ArrayList<PEPeerTransport> result = new ArrayList<PEPeerTransport>();
        Iterator it = this.peer_transports_cow.iterator();
        while (it.hasNext()) {
            PEPeerTransport peer = (PEPeerTransport)it.next();
            if (!peer.getIp().equals(address)) continue;
            result.add(peer);
        }
        return result;
    }

    public PeerDescriptor[] getPendingPeers(String address) {
        return this.peer_database.getDiscoveredPeers();
    }

    public void addPeer(PEPeer _transport) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        if (!ip_filter.isInRange(transport.getIp(), this.adapter.getDisplayName())) {
            ArrayList peer_transports = this.peer_transports_cow;
            if (!peer_transports.contains(transport)) {
                this.addToPeerTransports(transport);
            } else {
                Debug.out("addPeer():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                transport.closeConnection("already connected");
            }
        } else {
            transport.closeConnection("IP address blocked by filters");
        }
    }

    public void removePeer(PEPeer _transport) {
        this.removePeer(_transport, "remove peer");
    }

    public void removePeer(PEPeer _transport, String reason) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        this.closeAndRemovePeer(transport, reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemovePeer(PEPeerTransport peer, String reason, boolean log_if_not_found) {
        boolean removed = false;
        try {
            this.peer_transports_mon.enter();
            if (this.peer_transports_cow.contains(peer)) {
                ArrayList new_peer_transports = new ArrayList(this.peer_transports_cow);
                new_peer_transports.remove(peer);
                this.peer_transports_cow = new_peer_transports;
                removed = true;
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (removed) {
            peer.closeConnection(reason);
            this.peerRemoved(peer);
        } else if (log_if_not_found) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemoveAllPeers(String reason, boolean reconnect) {
        PEPeerTransport peer;
        int i;
        ArrayList peer_transports;
        try {
            this.peer_transports_mon.enter();
            peer_transports = this.peer_transports_cow;
            this.peer_transports_cow = new ArrayList(0);
        }
        finally {
            this.peer_transports_mon.exit();
        }
        for (i = 0; i < peer_transports.size(); ++i) {
            peer = (PEPeerTransport)peer_transports.get(i);
            try {
                peer.closeConnection(reason);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            try {
                this.peerRemoved(peer);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (reconnect) {
            for (i = 0; i < peer_transports.size(); ++i) {
                peer = (PEPeerTransport)peer_transports.get(i);
                PEPeerTransport reconnected_peer = peer.reconnect();
                if (reconnected_peer == null) continue;
                this.addToPeerTransports(reconnected_peer);
            }
        }
    }

    public void addPeer(String ip_address, int tcp_port, int udp_port, boolean use_crypto) {
        String fail_reason;
        byte type = use_crypto ? (byte)1 : 0;
        PeerItem peer_item = PeerItemFactory.createPeerItem(ip_address, tcp_port, PeerItem.convertSourceID("Plugin"), type, udp_port, (byte)1, 0);
        byte crypto_level = 1;
        if (!this.isAlreadyConnected(peer_item) && (fail_reason = TCPNetworkManager.TCP_OUTGOING_ENABLED && tcp_port > 0 ? this.makeNewOutgoingConnection("Plugin", ip_address, tcp_port, udp_port, true, use_crypto, crypto_level) : (UDPNetworkManager.UDP_OUTGOING_ENABLED && udp_port > 0 ? this.makeNewOutgoingConnection("Plugin", ip_address, tcp_port, udp_port, false, use_crypto, crypto_level) : "No usable protocol")) != null) {
            Debug.out("injected peer was not added - " + fail_reason);
        }
    }

    private void addPeersFromTracker(TRTrackerAnnouncerResponsePeer[] peers) {
        for (int i = 0; i < peers.length; ++i) {
            int http_port;
            TRTrackerAnnouncerResponsePeer peer = peers[i];
            ArrayList peer_transports = this.peer_transports_cow;
            boolean already_connected = false;
            for (int x = 0; x < peer_transports.size(); ++x) {
                boolean same_allowed;
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(x);
                if (!peer.getAddress().equals(transport.getIp())) continue;
                boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || transport.getIp().equals("127.0.0.1");
                if (same_allowed && peer.getPort() != transport.getPort()) continue;
                already_connected = true;
                break;
            }
            if (already_connected) continue;
            if (this.peer_database != null) {
                byte type = peer.getProtocol() == 2 ? (byte)1 : 0;
                byte crypto_level = peer.getAZVersion() < 3 ? (byte)1 : 2;
                PeerItem item = PeerItemFactory.createPeerItem(peer.getAddress(), peer.getPort(), PeerItem.convertSourceID(peer.getSource()), type, peer.getUDPPort(), crypto_level, peer.getUploadSpeed());
                this.peer_database.addDiscoveredPeer(item);
            }
            if ((http_port = peer.getHTTPPort()) == 0) continue;
            this.adapter.addHTTPSeed(peer.getAddress(), http_port);
        }
    }

    private String makeNewOutgoingConnection(String peer_source, String address, int tcp_port, int udp_port, boolean use_tcp, boolean require_crypto, byte crypto_level) {
        boolean same_allowed;
        if (ip_filter.isInRange(address, this.adapter.getDisplayName())) {
            return "IPFilter block";
        }
        int needed = this.getMaxNewConnectionsAllowed();
        if (!(needed != 0 || peer_source == "Plugin" && this.doOptimisticDisconnect(AddressUtils.isLANLocalAddress(address) != 2))) {
            return "Too many connections";
        }
        boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || address.equals("127.0.0.1");
        if (!same_allowed && PeerIdentityManager.containsIPAddress(this._hash, address)) {
            return "Already connected to IP";
        }
        if (PeerUtils.ignorePeerPort(tcp_port)) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Skipping connect with " + address + ":" + tcp_port + " as peer port is in ignore list."));
            }
            return "TCP port in ignore list";
        }
        PEPeerTransport real = PEPeerTransportFactory.createTransport(this, peer_source, address, tcp_port, udp_port, use_tcp, require_crypto, crypto_level);
        this.addToPeerTransports(real);
        return null;
    }

    private void checkCompletedPieces() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        for (int i = 0; i < this._nbPieces; ++i) {
            DiskManagerPiece dmPiece = this.dm_pieces[i];
            if (!dmPiece.isNeedsCheck()) continue;
            dmPiece.setChecking();
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(i, new Integer(1));
            req.setAdHoc(false);
            this.disk_mgr.enqueueCheckRequest(req, this);
        }
    }

    private boolean checkEmptyPiece(int pieceNumber) {
        if (this.piecePicker.isInEndGameMode()) {
            return false;
        }
        PEPieceImpl pePiece = this.pePieces[pieceNumber];
        DiskManagerPiece dmPiece = this.dm_pieces[pieceNumber];
        if (pePiece == null || pePiece.isRequested()) {
            return false;
        }
        if (dmPiece.getNbWritten() > 0 || pePiece.getNbRequests() > 0 || pePiece.getSpeed() > 0 || pePiece.getReservedBy() != null) {
            return false;
        }
        this.removePiece(pePiece, pieceNumber);
        return true;
    }

    private void checkSpeedAndReserved() {
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL != 0L) {
            return;
        }
        int nbPieces = this._nbPieces;
        PEPieceImpl[] pieces = this.pePieces;
        for (int i = 0; i < nbPieces; ++i) {
            long timeSinceActivity;
            PEPieceImpl pePiece = pieces[i];
            if (pePiece == null || (timeSinceActivity = pePiece.getTimeSinceLastActivity()) <= 4000L) continue;
            int oldSpeed = pePiece.getSpeed();
            if (oldSpeed > 0) {
                DiskManagerPiece dmPiece = this.dm_pieces[i];
                if (pePiece.isRequested() || timeSinceActivity > 29000L) {
                    pePiece.setSpeed(0);
                    continue;
                }
                long calcSpeed = (long)(dmPiece.getNbWritten() * 16384) / timeSinceActivity - 1L;
                if (calcSpeed >= (long)oldSpeed) continue;
                pePiece.setSpeed((int)(calcSpeed > 0L ? calcSpeed : 0L));
                continue;
            }
            if (timeSinceActivity <= 120000L) continue;
            String reservingPeer = pePiece.getReservedBy();
            if (reservingPeer != null) {
                if (this.needsMD5CheckOnCompletion(i)) {
                    this.badPeerDetected(reservingPeer);
                } else {
                    PEPeerTransport pt = this.getTransportFromAddress(reservingPeer);
                    if (pt != null) {
                        this.closeAndRemovePeer(pt, "Reserved piece data timeout; 120 seconds", true);
                    }
                }
                pePiece.setReservedBy(null);
            }
            this.checkEmptyPiece(i);
        }
    }

    private void check99PercentBug() {
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L) {
            long now = SystemTime.getCurrentTime();
            for (int i = 0; i < this.pePieces.length; ++i) {
                DiskManagerPiece dm_piece;
                PEPieceImpl pe_piece = this.pePieces[i];
                if (pe_piece == null || (dm_piece = this.dm_pieces[i]).isDone() || !pe_piece.isDownloaded() || now - pe_piece.getLastDownloadTime(now) <= 60000L || this.disk_mgr.hasOutstandingWriteRequestForPiece(i)) continue;
                Debug.out("Fully downloaded piece stalled pending write, resetting p_piece " + i);
                pe_piece.reset();
            }
        }
    }

    private void checkInterested() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        if (this.lastNeededUndonePieceChange >= this.piecePicker.getNeededUndonePieceChange()) {
            return;
        }
        this.lastNeededUndonePieceChange = this.piecePicker.getNeededUndonePieceChange();
        ArrayList peer_transports = this.peer_transports_cow;
        int cntPeersSnubbed = 0;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            peer.checkInterested();
            if (!peer.isSnubbed()) continue;
            ++cntPeersSnubbed;
        }
        this.setNbPeersSnubbed(cntPeersSnubbed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPieceChecks() {
        if (this.piece_check_result_list.size() > 0) {
            ArrayList pieces;
            try {
                this.piece_check_result_list_mon.enter();
                pieces = new ArrayList(this.piece_check_result_list);
                this.piece_check_result_list.clear();
            }
            finally {
                this.piece_check_result_list_mon.exit();
            }
            Iterator it = pieces.iterator();
            while (it.hasNext()) {
                Object[] data = (Object[])it.next();
                this.processPieceCheckResult((DiskManagerCheckRequest)data[0], (Integer)data[1]);
            }
        }
    }

    private void checkRescan() {
        long piece_size;
        long millis_per_piece;
        if (this.rescan_piece_time == 0L) {
            return;
        }
        if (this.next_rescan_piece == -1) {
            if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL == 0L && this.adapter.isPeriodicRescanEnabled()) {
                this.next_rescan_piece = 0;
            }
        } else if (this.mainloop_loop_count % (long)MAINLOOP_TEN_MINUTE_INTERVAL == 0L && !this.adapter.isPeriodicRescanEnabled()) {
            this.next_rescan_piece = -1;
        }
        if (this.next_rescan_piece == -1) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        if (this.rescan_piece_time > now) {
            this.rescan_piece_time = now;
        }
        if (now - this.rescan_piece_time < (millis_per_piece = (piece_size = (long)this.disk_mgr.getPieceLength()) / 250L)) {
            return;
        }
        while (this.next_rescan_piece != -1) {
            int this_piece = this.next_rescan_piece++;
            if (this.next_rescan_piece == this._nbPieces) {
                this.next_rescan_piece = -1;
            }
            if (this.pePieces[this_piece] != null || this.dm_pieces[this_piece].isDone()) continue;
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(this_piece, new Integer(3));
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rescanning piece " + this_piece));
            }
            this.rescan_piece_time = 0L;
            try {
                this.disk_mgr.enqueueCheckRequest(req, this);
            }
            catch (Throwable e) {
                this.rescan_piece_time = now;
                Debug.printStackTrace(e);
            }
            break;
        }
    }

    private void checkFinished(boolean start_of_day) {
        boolean all_pieces_done;
        boolean bl = all_pieces_done = this.disk_mgr.getRemainingExcludingDND() == 0L;
        if (all_pieces_done) {
            this.seeding_mode = true;
            this.piecePicker.clearEndGameChunks();
            if (!start_of_day) {
                this.adapter.setStateFinishing();
            }
            this._timeFinished = SystemTime.getCurrentTime();
            ArrayList peer_transports = this.peer_transports_cow;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
                pc.setSnubbed(false);
            }
            this.setNbPeersSnubbed(0);
            boolean checkPieces = COConfigurationManager.getBooleanParameter("Check Pieces on Completion", true);
            if (checkPieces && !start_of_day) {
                DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(-1, new Integer(2));
                this.disk_mgr.enqueueCompleteRecheckRequest(req, this);
            }
            this.disk_mgr.downloadEnded();
            this._timeStartedSeeding = SystemTime.getCurrentTime();
            this.adapter.setStateSeeding(start_of_day);
        }
    }

    protected void checkCompletionState() {
        boolean dm_done;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        boolean bl = dm_done = this.disk_mgr.getRemainingExcludingDND() == 0L;
        if (this.seeding_mode) {
            if (!dm_done) {
                this.seeding_mode = false;
                this._timeStartedSeeding = -1L;
                this._timeFinished = 0L;
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Turning off seeding mode for PEPeerManager"));
            }
        } else if (dm_done) {
            this.checkFinished(false);
            if (this.seeding_mode) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Turning on seeding mode for PEPeerManager"));
            }
        }
    }

    private void checkRequests() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = peer_transports.size() - 1; i >= 0; --i) {
            List expired;
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc.getPeerState() != 30 || (expired = pc.getExpiredRequests()) == null || expired.size() <= 0) continue;
            boolean isSeed = pc.isSeed();
            long timeSinceGoodData = pc.getTimeSinceGoodDataReceived();
            if (timeSinceGoodData < 0L || timeSinceGoodData > 60000L) {
                pc.setSnubbed(true);
            }
            long timeSinceData = pc.getTimeSinceLastDataMessageReceived();
            long timeSinceOldestRequest = now - ((DiskManagerReadRequest)expired.get(0)).getTimeCreated(now);
            for (int j = 0; j < expired.size(); ++j) {
                DiskManagerReadRequest request2 = (DiskManagerReadRequest)expired.get(j);
                if (j <= 0 && (timeSinceOldestRequest <= 120000L || timeSinceData >= 0L && timeSinceData <= (long)((isSeed ? 120 : 60) * 1000))) continue;
                pc.sendCancel(request2);
                int pieceNumber = request2.getPieceNumber();
                PEPieceImpl pe_piece = this.pePieces[pieceNumber];
                if (pe_piece != null) {
                    pe_piece.clearRequested(request2.getOffset() / 16384);
                }
                if (this.piecePicker.isInEndGameMode()) continue;
                this.checkEmptyPiece(pieceNumber);
            }
        }
    }

    private void updateTrackerAnnounceInterval() {
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL != 0L) {
            return;
        }
        int WANT_LIMIT = 100;
        int num_wanted = this.getMaxNewConnectionsAllowed();
        boolean has_remote = this.adapter.isNATHealthy();
        if (has_remote) {
            num_wanted = (int)((double)num_wanted / 1.5);
        }
        if (num_wanted < 0 || num_wanted > 100) {
            num_wanted = 100;
        }
        int current_connection_count = PeerIdentityManager.getIdentityCount(this._hash);
        TRTrackerScraperResponse tsr = this.adapter.getTrackerScrapeResponse();
        if (tsr != null && tsr.isValid()) {
            int swarm_size;
            int num_seeds = tsr.getSeeds();
            int num_peers = tsr.getPeers();
            if (this.seeding_mode) {
                float ratio = (float)num_peers / (float)(num_seeds + num_peers);
                swarm_size = (int)((float)num_peers * ratio);
            } else {
                swarm_size = num_peers + num_seeds;
            }
            if (swarm_size < num_wanted) {
                num_wanted = swarm_size;
            }
        }
        if (num_wanted < 1) {
            this.adapter.setTrackerRefreshDelayOverrides(100);
            return;
        }
        if (current_connection_count == 0) {
            current_connection_count = 1;
        }
        int current_percent = current_connection_count * 100 / (current_connection_count + num_wanted);
        this.adapter.setTrackerRefreshDelayOverrides(current_percent);
    }

    public boolean hasDownloadablePiece() {
        return this.piecePicker.hasDownloadablePiece();
    }

    public int[] getAvailability() {
        return this.piecePicker.getAvailability();
    }

    public float getMinAvailability() {
        return this.piecePicker.getMinAvailability();
    }

    public float getAvgAvail() {
        return this.piecePicker.getAvgAvail();
    }

    public void addPeerTransport(PEPeerTransport transport) {
        if (!ip_filter.isInRange(transport.getIp(), this.adapter.getDisplayName())) {
            ArrayList peer_transports = this.peer_transports_cow;
            if (!peer_transports.contains(transport)) {
                this.addToPeerTransports(transport);
            } else {
                Debug.out("addPeerTransport():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                transport.closeConnection("already connected");
            }
        } else {
            transport.closeConnection("IP address blocked by filters");
        }
    }

    private void doUnchokes() {
        if (!UploadSlotManager.AUTO_SLOT_ENABLE) {
            if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
                return;
            }
            int max_to_unchoke = this.adapter.getMaxUploads();
            ArrayList peer_transports = this.peer_transports_cow;
            if (this.seeding_mode) {
                if (this.unchoker == null || !(this.unchoker instanceof SeedingUnchoker)) {
                    this.unchoker = new SeedingUnchoker();
                }
            } else if (this.unchoker == null || !(this.unchoker instanceof DownloadingUnchoker)) {
                this.unchoker = new DownloadingUnchoker();
            }
            if (this.mainloop_loop_count % (long)MAINLOOP_TEN_SECOND_INTERVAL == 0L) {
                boolean refresh = this.mainloop_loop_count % (long)MAINLOOP_THIRTY_SECOND_INTERVAL == 0L;
                this.unchoker.calculateUnchokes(max_to_unchoke, peer_transports, refresh);
                UnchokerUtil.performChokes(this.unchoker.getChokes(), this.unchoker.getUnchokes());
            } else if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
                ArrayList peers_to_unchoke = this.unchoker.getImmediateUnchokes(max_to_unchoke, peer_transports);
                Iterator it = peer_transports.iterator();
                while (it.hasNext()) {
                    PEPeerTransport peer = (PEPeerTransport)it.next();
                    if (peer.isLANLocal() && UnchokerUtil.isUnchokable(peer, true) && !peers_to_unchoke.contains(peer)) {
                        peers_to_unchoke.add(peer);
                        continue;
                    }
                    if (!fast_unchoke_new_peers || peer.getConnectionState() != 4 || !UnchokerUtil.isUnchokable(peer, true) || peer.getData("fast_unchoke_done") != null || peers_to_unchoke.contains(peer)) continue;
                    peer.setData("fast_unchoke_done", "");
                    peers_to_unchoke.add(peer);
                }
                UnchokerUtil.performChokes(null, peers_to_unchoke);
            }
        }
    }

    private void sendHave(int pieceNumber) {
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            pc.sendHave(pieceNumber);
        }
    }

    private void checkSeeds() {
        int i;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        if (!disconnect_seeds_when_seeding) {
            return;
        }
        ArrayList<PEPeerTransport> to_close = null;
        ArrayList peer_transports = this.peer_transports_cow;
        for (i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc == null || pc.getPeerState() != 30 || !pc.isSeed()) continue;
            if (to_close == null) {
                to_close = new ArrayList<PEPeerTransport>();
            }
            to_close.add(pc);
        }
        if (to_close != null) {
            for (i = 0; i < to_close.size(); ++i) {
                this.closeAndRemovePeer((PEPeerTransport)to_close.get(i), "disconnect other seed when seeding", false);
            }
        }
    }

    private void updateStats() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        ArrayList peer_transports = this.peer_transports_cow;
        int new_seeds = 0;
        int new_peers = 0;
        int new_remotes = 0;
        Iterator it = peer_transports.iterator();
        while (it.hasNext()) {
            PEPeerTransport pc = (PEPeerTransport)it.next();
            if (pc.getPeerState() != 30) continue;
            if (pc.isSeed()) {
                ++new_seeds;
            } else {
                ++new_peers;
            }
            if (!pc.isIncoming()) continue;
            ++new_remotes;
        }
        this._seeds = new_seeds;
        this._peers = new_peers;
        this._remotes = new_remotes;
    }

    public void requestCanceled(DiskManagerReadRequest request2) {
        int pieceNumber = request2.getPieceNumber();
        PEPieceImpl pe_piece = this.pePieces[pieceNumber];
        if (pe_piece != null) {
            pe_piece.clearRequested(request2.getOffset() / 16384);
        }
    }

    public PEPeerControl getControl() {
        return this;
    }

    public byte[][] getSecrets(int crypto_level) {
        return this.adapter.getSecrets(crypto_level);
    }

    public byte[] getHash() {
        return this._hash.getDataID();
    }

    public PeerIdentityDataID getPeerIdentityDataID() {
        return this._hash;
    }

    public byte[] getPeerId() {
        return this._myPeerId;
    }

    public long getRemaining() {
        return this.disk_mgr.getRemaining();
    }

    public void discarded(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.discarded(peer, length);
        }
    }

    public void dataBytesReceived(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.dataBytesReceived(peer, length);
            this._averageReceptionSpeed.addValue(length);
        }
    }

    public void protocolBytesReceived(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.protocolBytesReceived(peer, length);
        }
    }

    public void dataBytesSent(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.dataBytesSent(peer, length);
        }
    }

    public void protocolBytesSent(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.protocolBytesSent(peer, length);
        }
    }

    public void writeCompleted(DiskManagerWriteRequest request2) {
        int pieceNumber = request2.getPieceNumber();
        DiskManagerPiece dm_piece = this.dm_pieces[pieceNumber];
        if (!dm_piece.isDone()) {
            PEPieceImpl pePiece = this.pePieces[pieceNumber];
            if (pePiece != null) {
                pePiece.setWritten((PEPeer)request2.getUserData(), request2.getOffset() / 16384);
            } else {
                dm_piece.setWritten(request2.getOffset() / 16384);
            }
        }
    }

    public void writeFailed(DiskManagerWriteRequest request2, Throwable cause) {
    }

    public void writeBlock(int pieceNumber, int offset, DirectByteBuffer data, PEPeer sender, boolean cancel) {
        DiskManagerPiece dmPiece = this.dm_pieces[pieceNumber];
        int blockNumber = offset / 16384;
        if (dmPiece.isWritten(blockNumber)) {
            data.returnToPool();
            return;
        }
        PEPieceImpl pe_piece = this.pePieces[pieceNumber];
        if (pe_piece != null) {
            pe_piece.setDownloaded(offset);
        }
        DiskManagerWriteRequest request2 = this.disk_mgr.createWriteRequest(pieceNumber, offset, data, sender);
        this.disk_mgr.enqueueWriteRequest(request2, this);
        if (this.piecePicker.isInEndGameMode()) {
            this.piecePicker.removeFromEndGameModeChunks(pieceNumber, offset);
        }
        if (cancel || this.piecePicker.isInEndGameMode()) {
            ArrayList peer_transports = this.peer_transports_cow;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport connection = (PEPeerTransport)peer_transports.get(i);
                DiskManagerReadRequest dmr = this.disk_mgr.createReadRequest(pieceNumber, offset, dmPiece.getBlockSize(blockNumber));
                connection.sendCancel(dmr);
            }
        }
    }

    public boolean isWritten(int piece_number, int offset) {
        return this.dm_pieces[piece_number].isWritten(offset / 16384);
    }

    public boolean validateReadRequest(PEPeerTransport originator, int pieceNumber, int offset, int length) {
        if (this.disk_mgr.checkBlockConsistency(originator.getIp(), pieceNumber, offset, length)) {
            DiskManagerPiece dm_piece;
            int read_count;
            if (enable_seeding_piece_rechecks && this.isSeeding() && (read_count = (dm_piece = this.dm_pieces[pieceNumber]).getReadCount() & 0xFFFF) < 65525) {
                dm_piece.setReadCount((short)(++read_count));
            }
            return true;
        }
        return false;
    }

    public boolean validatePieceReply(int pieceNumber, int offset, DirectByteBuffer data) {
        return this.disk_mgr.checkBlockConsistency(pieceNumber, offset, data);
    }

    public int getAvailability(int pieceNumber) {
        return this.piecePicker.getAvailability(pieceNumber);
    }

    public void havePiece(int pieceNumber, int pieceLength, PEPeer pcOrigin) {
        int availability;
        this.piecePicker.addHavePiece(pcOrigin, pieceNumber);
        this._stats.haveNewPiece(pieceLength);
        if (this.superSeedMode) {
            this.superSeedPieces[pieceNumber].peerHasPiece(pcOrigin);
            if (pieceNumber == pcOrigin.getUniqueAnnounce()) {
                pcOrigin.setUniqueAnnounce(-1);
                --this.superSeedModeNumberOfAnnounces;
            }
        }
        if ((availability = this.piecePicker.getAvailability(pieceNumber) - 1) < 4) {
            if (this.dm_pieces[pieceNumber].isDone()) {
                --availability;
            }
            if (availability <= 0) {
                return;
            }
            ArrayList peer_transports = this.peer_transports_cow;
            for (int i = peer_transports.size() - 1; i >= 0; --i) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
                if (pc == pcOrigin || pc.getPeerState() != 30 || !pc.isPieceAvailable(pieceNumber)) continue;
                ((PEPeerStatsImpl)pc.getStats()).statisticalSentPiece(pieceLength / availability);
            }
        }
    }

    public int getPieceLength(int pieceNumber) {
        if (pieceNumber == this._nbPieces - 1) {
            return this.disk_mgr.getLastPieceLength();
        }
        return this.disk_mgr.getPieceLength();
    }

    public int getNbPeers() {
        return this._peers;
    }

    public int getNbSeeds() {
        return this._seeds;
    }

    public int getNbRemoteConnections() {
        return this._remotes;
    }

    public long getLastRemoteConnectionTime() {
        return this.last_remote_time;
    }

    public PEPeerManagerStats getStats() {
        return this._stats;
    }

    public int getNbPeersStalledPendingLoad() {
        int res = 0;
        Iterator it = this.peer_transports_cow.iterator();
        while (it.hasNext()) {
            PEPeerTransport transport = (PEPeerTransport)it.next();
            if (!transport.isStalledPendingLoad()) continue;
            ++res;
        }
        return res;
    }

    public long getETA() {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_eta_calculation || now - this.last_eta_calculation > 900L) {
            long result;
            long dataRemaining = this.disk_mgr.getRemainingExcludingDND();
            if (dataRemaining > 0L) {
                int writtenNotChecked = 0;
                for (int i = 0; i < this._nbPieces; ++i) {
                    if (!this.dm_pieces[i].isInteresting()) continue;
                    writtenNotChecked += this.dm_pieces[i].getNbWritten() * 16384;
                }
                if ((dataRemaining -= (long)writtenNotChecked) < 0L) {
                    dataRemaining = 0L;
                }
            }
            if (dataRemaining == 0L) {
                long timeElapsed = (this._timeFinished - this._timeStarted) / 1000L;
                result = timeElapsed > 1L ? timeElapsed * -1L : 0L;
            } else {
                long lETA;
                long averageSpeed = this._averageReceptionSpeed.getAverage();
                long l = lETA = averageSpeed == 0L ? 31536000L : dataRemaining / averageSpeed;
                if (lETA == 0L) {
                    lETA = 1L;
                }
                result = lETA;
            }
            this.last_eta = result;
            this.last_eta_calculation = now;
        }
        return this.last_eta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPeerTransports(PEPeerTransport peer) {
        boolean added = false;
        try {
            this.peer_transports_mon.enter();
            if (peer.getPeerState() == 50) {
                return;
            }
            if (this.peer_transports_cow.contains(peer)) {
                Debug.out("Transport added twice");
                return;
            }
            if (this.is_running) {
                ArrayList<PEPeerTransport> new_peer_transports = new ArrayList<PEPeerTransport>(this.peer_transports_cow.size() + 1);
                new_peer_transports.addAll(this.peer_transports_cow);
                new_peer_transports.add(peer);
                this.peer_transports_cow = new_peer_transports;
                added = true;
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (added) {
            long connect_time;
            if (peer.isIncoming() && (connect_time = SystemTime.getCurrentTime()) > this.last_remote_time) {
                this.last_remote_time = connect_time;
            }
            this.peerAdded(peer);
        } else {
            peer.closeConnection("PeerTransport added when manager not running");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerConnectionClosed(PEPeerTransport peer, boolean connect_failed) {
        boolean connection_found = false;
        try {
            this.peer_transports_mon.enter();
            int udp_port = peer.getUDPListenPort();
            if (this.is_running && connect_failed && peer.isTCP() && UDPNetworkManager.UDP_OUTGOING_ENABLED && udp_port > 0) {
                PeerItem peer_item = peer.getPeerItemIdentity();
                PeerItem self_item = this.peer_database.getSelfPeer();
                if (self_item == null || !self_item.equals(peer_item)) {
                    String ip = peer.getIp();
                    String key = ip + ":" + udp_port;
                    this.udp_fallbacks.put(key, peer_item);
                }
            }
            if (this.peer_transports_cow.contains(peer)) {
                ArrayList new_peer_transports = new ArrayList(this.peer_transports_cow);
                new_peer_transports.remove(peer);
                this.peer_transports_cow = new_peer_transports;
                connection_found = true;
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (connection_found) {
            if (peer.getPeerState() != 50) {
                System.out.println("peer.getPeerState() != PEPeer.DISCONNECTED: " + peer.getPeerState());
            }
            this.peerRemoved(peer);
        }
    }

    public void peerAdded(PEPeer pc) {
        this.adapter.addPeer(pc);
        ArrayList peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            ((PEPeerManagerListener)peer_manager_listeners.get(i)).peerAdded(this, pc);
        }
    }

    public void peerRemoved(PEPeer pc) {
        String reserved_by;
        PEPieceImpl pe_piece;
        int reserved_piece;
        int piece = pc.getUniqueAnnounce();
        if (piece != -1 && this.superSeedMode) {
            --this.superSeedModeNumberOfAnnounces;
            this.superSeedPieces[piece].peerLeft();
        }
        if ((reserved_piece = pc.getReservedPieceNumber()) >= 0 && (pe_piece = this.pePieces[reserved_piece]) != null && (reserved_by = pe_piece.getReservedBy()) != null && reserved_by.equals(pc.getIp())) {
            pe_piece.setReservedBy(null);
        }
        this.adapter.removePeer(pc);
        ArrayList peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            ((PEPeerManagerListener)peer_manager_listeners.get(i)).peerRemoved(this, pc);
        }
    }

    public void addPiece(PEPiece piece, int pieceNumber) {
        this.addPiece(piece, pieceNumber, false);
    }

    protected void addPiece(PEPiece piece, int pieceNumber, boolean force_add) {
        this.pePieces[pieceNumber] = (PEPieceImpl)piece;
        ++this.nbPiecesActive;
        if (this.is_running || force_add) {
            this.adapter.addPiece(piece);
        }
    }

    public void removePiece(PEPiece pePiece, int pieceNumber) {
        this.adapter.removePiece(pePiece);
        this.pePieces[pieceNumber] = null;
        --this.nbPiecesActive;
    }

    public int getNbActivePieces() {
        return this.nbPiecesActive;
    }

    public String getElapsedTime() {
        return TimeFormatter.format((SystemTime.getCurrentTime() - this._timeStarted) / 1000L);
    }

    public long getTimeStarted() {
        return this._timeStarted;
    }

    public long getTimeStartedSeeding() {
        return this._timeStartedSeeding;
    }

    private byte[] computeMd5Hash(DirectByteBuffer buffer) {
        BrokenMd5Hasher md5 = new BrokenMd5Hasher();
        md5.reset();
        int position = buffer.position((byte)8);
        md5.update(buffer.getBuffer((byte)8));
        buffer.position((byte)8, position);
        ByteBuffer md5Result = ByteBuffer.allocate(16);
        md5Result.position(0);
        md5.finalDigest(md5Result);
        byte[] result = new byte[16];
        md5Result.position(0);
        for (int i = 0; i < result.length; ++i) {
            result[i] = md5Result.get();
        }
        return result;
    }

    private void MD5CheckPiece(PEPiece piece, boolean correct) {
        String[] writers = piece.getWriters();
        int offset = 0;
        for (int i = 0; i < writers.length; ++i) {
            DirectByteBuffer buffer;
            int length = piece.getBlockSize(i);
            String peer = writers[i];
            if (peer != null && (buffer = this.disk_mgr.readBlock(piece.getPieceNumber(), offset, length)) != null) {
                byte[] hash = this.computeMd5Hash(buffer);
                buffer.returnToPool();
                buffer = null;
                piece.addWrite(i, peer, hash, correct);
            }
            offset += length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(passed ? 1 : 0)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCancelled(DiskManagerCheckRequest request2) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(2)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(0)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    public boolean needsMD5CheckOnCompletion(int pieceNumber) {
        PEPieceImpl piece = this.pePieces[pieceNumber];
        if (piece == null) {
            return false;
        }
        return piece.getPieceWrites().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPieceCheckResult(DiskManagerCheckRequest request2, int outcome) {
        int check_type = (Integer)request2.getUserData();
        try {
            int pieceNumber = request2.getPieceNumber();
            if (check_type == 2) {
                if (outcome == 0) {
                    Debug.out(this.getDisplayName() + ": Piece #" + pieceNumber + " failed final re-check. Re-downloading...");
                    if (!this.restart_initiated) {
                        this.restart_initiated = true;
                        this.adapter.restartDownload(true);
                    }
                }
                return;
            }
            if (check_type == 4) {
                if (outcome == 0) {
                    Debug.out(this.getDisplayName() + "Piece #" + pieceNumber + " failed recheck while seeding. Re-downloading...");
                    Logger.log(new LogAlert(true, 3, "Download '" + this.getDisplayName() + "': piece " + pieceNumber + " has been corrupted, re-downloading"));
                    if (!this.restart_initiated) {
                        this.restart_initiated = true;
                        this.adapter.restartDownload(true);
                    }
                }
                return;
            }
            PEPieceImpl pePiece = this.pePieces[pieceNumber];
            if (outcome == 1) {
                if (pePiece != null) {
                    List list;
                    if (this.needsMD5CheckOnCompletion(pieceNumber)) {
                        this.MD5CheckPiece(pePiece, true);
                    }
                    if ((list = pePiece.getPieceWrites()).size() > 0) {
                        for (int i = 0; i < pePiece.getNbBlocks(); ++i) {
                            PEPieceWriteImpl write;
                            List listPerBlock = pePiece.getPieceWrites(i);
                            byte[] correctHash = null;
                            Iterator iterPerBlock = listPerBlock.iterator();
                            while (iterPerBlock.hasNext()) {
                                write = (PEPieceWriteImpl)iterPerBlock.next();
                                if (!write.isCorrect()) continue;
                                correctHash = write.getHash();
                            }
                            if (correctHash == null) continue;
                            iterPerBlock = listPerBlock.iterator();
                            while (iterPerBlock.hasNext()) {
                                write = (PEPieceWriteImpl)iterPerBlock.next();
                                if (Arrays.equals(write.getHash(), correctHash)) continue;
                                this.badPeerDetected(write.getSender());
                            }
                        }
                    }
                }
                this.removePiece(pePiece, pieceNumber);
                this.sendHave(pieceNumber);
            } else if (outcome == 0 && pePiece != null) {
                this.MD5CheckPiece(pePiece, false);
                String[] writers = pePiece.getWriters();
                ArrayList<String> uniqueWriters = new ArrayList<String>();
                int[] writesPerWriter = new int[writers.length];
                for (int i = 0; i < writers.length; ++i) {
                    String writer = writers[i];
                    if (writer == null) continue;
                    int writerId = uniqueWriters.indexOf(writer);
                    if (writerId == -1) {
                        uniqueWriters.add(writer);
                        writerId = uniqueWriters.size() - 1;
                    }
                    int n = writerId;
                    writesPerWriter[n] = writesPerWriter[n] + 1;
                }
                int nbWriters = uniqueWriters.size();
                if (nbWriters == 1) {
                    this.badPeerDetected((String)uniqueWriters.get(0));
                    pePiece.reset();
                } else if (nbWriters > 1) {
                    int i;
                    int maxWrites = 0;
                    String bestWriter = null;
                    for (i = 0; i < uniqueWriters.size(); ++i) {
                        String writer;
                        PEPeerTransport pt;
                        int writes = writesPerWriter[i];
                        if (writes <= maxWrites || (pt = this.getTransportFromAddress(writer = (String)uniqueWriters.get(i))) == null || pt.getReservedPieceNumber() != -1 || ip_filter.isInRange(writer, this.adapter.getDisplayName())) continue;
                        bestWriter = writer;
                        maxWrites = writes;
                    }
                    if (bestWriter != null) {
                        pePiece.setReservedBy(bestWriter);
                        this.getTransportFromAddress(bestWriter).setReservedPieceNumber(pePiece.getPieceNumber());
                        pePiece.setRequestable();
                        for (i = 0; i < pePiece.getNbBlocks(); ++i) {
                            if (writers[i] != null && writers[i].equals(bestWriter)) continue;
                            pePiece.reDownloadBlock(i);
                        }
                    } else {
                        pePiece.reset();
                    }
                } else {
                    pePiece.reset();
                }
                this.piecePicker.addEndGameChunks(pePiece);
                this._stats.hashFailed(pePiece.getLength());
            }
        }
        finally {
            if (check_type == 3) {
                this.rescan_piece_time = SystemTime.getCurrentTime();
            }
            if (!this.seeding_mode) {
                this.checkFinished(false);
            }
        }
    }

    private void badPeerDetected(String ip) {
        PEPeerTransport peer = this.getTransportFromAddress(ip);
        IpFilterManager filter_manager = IpFilterManagerFactory.getSingleton();
        int nbWarnings = filter_manager.getBadIps().addWarningForIp(ip);
        if (nbWarnings > 2 && COConfigurationManager.getBooleanParameter("Ip Filter Enable Banning")) {
            if (ip_filter.ban(ip, this.adapter.getDisplayName())) {
                this.checkForBannedConnections();
            }
            if (peer != null) {
                int ps = peer.getPeerState();
                if (ps != 40 && ps != 50) {
                    this.closeAndRemovePeer(peer, "has sent too many bad pieces, 2 max.", true);
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)peer, LOGID, 3, ip + " : has been banned and won't be able " + "to connect until you restart azureus"));
                }
            }
        }
    }

    public PEPiece[] getPieces() {
        return this.pePieces;
    }

    public PEPiece getPiece(int pieceNumber) {
        return this.pePieces[pieceNumber];
    }

    public PEPeerStats createPeerStats(PEPeer owner) {
        return new PEPeerStatsImpl(owner);
    }

    public DiskManagerReadRequest createDiskManagerRequest(int pieceNumber, int offset, int length) {
        return this.disk_mgr.createReadRequest(pieceNumber, offset, length);
    }

    public boolean seedPieceRecheck() {
        DiskManagerPiece dm_piece;
        if (!enable_seeding_piece_rechecks && !this.isSeeding()) {
            return false;
        }
        int max_reads = 0;
        int max_reads_index = 0;
        for (int i = 0; i < this.dm_pieces.length; ++i) {
            int num = this.dm_pieces[i].getReadCount() & 0xFFFF;
            if (num > 65526) {
                if (--num == 65526) {
                    num = 0;
                }
                this.dm_pieces[i].setReadCount((short)num);
                continue;
            }
            if (num <= max_reads) continue;
            max_reads = num;
            max_reads_index = i;
        }
        if (max_reads > 0 && max_reads >= (dm_piece = this.dm_pieces[max_reads_index]).getNbBlocks() * 3) {
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(max_reads_index, new Integer(4));
            req.setAdHoc(true);
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rechecking piece " + max_reads_index + " while seeding as most active"));
            }
            this.disk_mgr.enqueueCheckRequest(req, this);
            dm_piece.setReadCount((short)-1);
            for (int i = 0; i < this.dm_pieces.length; ++i) {
                int num;
                if (i == max_reads_index || (num = this.dm_pieces[i].getReadCount() & 0xFFFF) >= 65526) continue;
                this.dm_pieces[i].setReadCount((short)0);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            ArrayList<PEPeerManagerListener> peer_manager_listeners = new ArrayList<PEPeerManagerListener>(this.peer_manager_listeners_cow.size() + 1);
            peer_manager_listeners.addAll(this.peer_manager_listeners_cow);
            peer_manager_listeners.add(l);
            this.peer_manager_listeners_cow = peer_manager_listeners;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            ArrayList peer_manager_listeners = new ArrayList(this.peer_manager_listeners_cow);
            peer_manager_listeners.remove(l);
            this.peer_manager_listeners_cow = peer_manager_listeners;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void parameterChanged(String parameterName) {
        disconnect_seeds_when_seeding = COConfigurationManager.getBooleanParameter("Disconnect Seed", true);
        if (parameterName.equals("Ip Filter Enabled")) {
            this.checkForBannedConnections();
        }
    }

    private void checkForBannedConnections() {
        if (ip_filter.isEnabled()) {
            int i;
            ArrayList<PEPeerTransport> to_close = null;
            ArrayList peer_transports = this.peer_transports_cow;
            for (i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
                if (!ip_filter.isInRange(conn.getIp(), this.adapter.getDisplayName())) continue;
                if (to_close == null) {
                    to_close = new ArrayList<PEPeerTransport>();
                }
                to_close.add(conn);
            }
            if (to_close != null) {
                for (i = 0; i < to_close.size(); ++i) {
                    this.closeAndRemovePeer((PEPeerTransport)to_close.get(i), "IPFilter banned IP address", true);
                }
            }
        }
    }

    public boolean isSeeding() {
        return this.seeding_mode;
    }

    public boolean isSuperSeedMode() {
        return this.superSeedMode;
    }

    public boolean isInEndGameMode() {
        return this.piecePicker.isInEndGameMode();
    }

    public void setSuperSeedMode(boolean _superSeedMode) {
        if (_superSeedMode && this.superSeedPieces == null) {
            this.initialiseSuperSeedMode();
        }
        this.superSeedMode = _superSeedMode;
    }

    private void initialiseSuperSeedMode() {
        this.superSeedPieces = new SuperSeedPiece[this._nbPieces];
        for (int i = 0; i < this._nbPieces; ++i) {
            this.superSeedPieces[i] = new SuperSeedPiece(this, i);
        }
    }

    private void updatePeersInSuperSeedMode() {
        if (!this.superSeedMode) {
            return;
        }
        for (int i = 0; i < this.superSeedPieces.length; ++i) {
            this.superSeedPieces[i].updateTime();
        }
        int nbUnchoke = this.adapter.getMaxUploads();
        if (this.superSeedModeNumberOfAnnounces >= 2 * nbUnchoke) {
            return;
        }
        PEPeer selectedPeer = null;
        ArrayList<SuperSeedPeer> sortedPeers = null;
        ArrayList peer_transports = this.peer_transports_cow;
        sortedPeers = new ArrayList<SuperSeedPeer>(peer_transports.size());
        Iterator iter = peer_transports.iterator();
        while (iter.hasNext()) {
            sortedPeers.add(new SuperSeedPeer((PEPeer)iter.next()));
        }
        Collections.sort(sortedPeers);
        iter = sortedPeers.iterator();
        while (iter.hasNext()) {
            PEPeer peer = ((SuperSeedPeer)iter.next()).peer;
            if (peer.getUniqueAnnounce() != -1 || peer.getPeerState() != 30) continue;
            selectedPeer = peer;
            break;
        }
        if (selectedPeer == null || selectedPeer.getPeerState() >= 40) {
            return;
        }
        if (selectedPeer.getUploadHint() == 0) {
            selectedPeer.setUploadHint(31536000);
        }
        boolean found = false;
        SuperSeedPiece piece = null;
        while (!found) {
            piece = this.superSeedPieces[this.superSeedModeCurrentPiece];
            if (piece.getLevel() > 0) {
                piece = null;
                ++this.superSeedModeCurrentPiece;
                if (this.superSeedModeCurrentPiece < this._nbPieces) continue;
                this.superSeedModeCurrentPiece = 0;
                this.superSeedMode = false;
                this.closeAndRemoveAllPeers("quiting SuperSeed mode", true);
                return;
            }
            found = true;
        }
        if (piece == null) {
            return;
        }
        if (selectedPeer.isPieceAvailable(piece.getPieceNumber())) {
            return;
        }
        selectedPeer.setUniqueAnnounce(piece.getPieceNumber());
        ++this.superSeedModeNumberOfAnnounces;
        piece.pieceRevealedToPeer();
        ((PEPeerTransport)selectedPeer).sendHave(piece.getPieceNumber());
    }

    public void updateSuperSeedPiece(PEPeer peer, int pieceNumber) {
        if (!this.superSeedMode) {
            return;
        }
        this.superSeedPieces[pieceNumber].peerHasPiece(null);
        if (peer.getUniqueAnnounce() == pieceNumber) {
            peer.setUniqueAnnounce(-1);
            --this.superSeedModeNumberOfAnnounces;
        }
    }

    public boolean isAZMessagingEnabled() {
        return this.adapter.isAZMessagingEnabled();
    }

    public boolean isPeerExchangeEnabled() {
        return this.adapter.isPeerExchangeEnabled();
    }

    public LimitedRateGroup getUploadLimitedRateGroup() {
        return this.upload_limited_rate_group;
    }

    public LimitedRateGroup getDownloadLimitedRateGroup() {
        return this.download_limited_rate_group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData(String key) {
        try {
            this.this_mon.enter();
            if (this.user_data == null) {
                Object var2_2 = null;
                return var2_2;
            }
            Object v = this.user_data.get(key);
            return v;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String key, Object value) {
        try {
            this.this_mon.enter();
            if (this.user_data == null) {
                this.user_data = new HashMap();
            }
            if (value == null) {
                if (this.user_data.containsKey(key)) {
                    this.user_data.remove(key);
                }
            } else {
                this.user_data.put(key, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void doConnectionChecks() {
        long last_update;
        int i;
        ArrayList peer_transports;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
            int allowed;
            int to_disconnect;
            peer_transports = this.peer_transports_cow;
            int num_waiting_establishments = 0;
            int udp_connections = 0;
            for (int i2 = 0; i2 < peer_transports.size(); ++i2) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i2);
                int state = transport.getConnectionState();
                if (state == 0 || state == 1) {
                    ++num_waiting_establishments;
                }
                if (transport.isTCP()) continue;
                ++udp_connections;
            }
            int allowed_seeds = this.getMaxSeedConnections();
            if (allowed_seeds > 0 && (to_disconnect = this._seeds - allowed_seeds) > 0) {
                for (int i3 = peer_transports.size() - 1; i3 >= 0 && to_disconnect > 0; --i3) {
                    PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i3);
                    if (!transport.isSeed()) continue;
                    this.closeAndRemovePeer(transport, "Too many seeds", false);
                    --to_disconnect;
                }
            }
            if ((allowed = this.getMaxNewConnectionsAllowed()) < 0 || allowed > 1000) {
                allowed = 1000;
            }
            if (this.adapter.isNATHealthy()) {
                int free = this.getMaxConnections() / 20;
                allowed -= free;
            }
            if (allowed > 0) {
                PeerItem item;
                int wanted = ConnectDisconnectManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - num_waiting_establishments;
                if (wanted > allowed) {
                    num_waiting_establishments += wanted - allowed;
                }
                int remaining = allowed;
                while (num_waiting_establishments < ConnectDisconnectManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS && this.is_running && (item = this.peer_database.getNextOptimisticConnectPeer()) != null && this.is_running) {
                    boolean use_crypto;
                    PeerItem self = this.peer_database.getSelfPeer();
                    if (self != null && self.equals(item) || this.isAlreadyConnected(item)) continue;
                    String source = PeerItem.convertSourceString(item.getSource());
                    boolean bl = use_crypto = item.getHandshakeType() == 1;
                    if (TCPNetworkManager.TCP_OUTGOING_ENABLED && item.getTCPPort() > 0) {
                        if (this.makeNewOutgoingConnection(source, item.getAddressString(), item.getTCPPort(), item.getUDPPort(), true, use_crypto, item.getCryptoLevel()) != null) continue;
                        ++num_waiting_establishments;
                        --remaining;
                        continue;
                    }
                    if (!UDPNetworkManager.UDP_OUTGOING_ENABLED || item.getUDPPort() <= 0 || this.makeNewOutgoingConnection(source, item.getAddressString(), item.getTCPPort(), item.getUDPPort(), false, use_crypto, item.getCryptoLevel()) != null) continue;
                    ++num_waiting_establishments;
                    --remaining;
                }
                if (UDPNetworkManager.UDP_OUTGOING_ENABLED && remaining > 0 && udp_connections < 10 && num_waiting_establishments < ConnectDisconnectManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS) {
                    this.doUDPConnectionChecks(remaining);
                }
            }
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL == 0L) {
            peer_transports = this.peer_transports_cow;
            for (i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i);
                if (transport.doTimeoutChecks()) continue;
                transport.doKeepAliveCheck();
                transport.doPerformanceTuningCheck();
            }
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_TEN_SECOND_INTERVAL == 0L && (last_update = ip_filter.getLastUpdateTime()) != this.ip_filter_last_update_time) {
            this.ip_filter_last_update_time = last_update;
            this.checkForBannedConnections();
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_THIRTY_SECOND_INTERVAL == 0L && this.getMaxNewConnectionsAllowed() == 0) {
            this.doOptimisticDisconnect(false);
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L) {
            ArrayList peer_transports2 = this.peer_transports_cow;
            for (i = 0; i < peer_transports2.size(); ++i) {
                PEPeerTransport peer = (PEPeerTransport)peer_transports2.get(i);
                peer.updatePeerExchange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUDPConnectionChecks(int number) {
        try {
            this.peer_transports_mon.enter();
            if (this.udp_fallbacks.size() == 0) {
                return;
            }
            int max = 3;
            if (this.seeding_mode) {
                max = this._peers > 8 ? 0 : 1;
            } else if (this._seeds > 8) {
                max = 0;
            } else if (this._seeds > 4) {
                max = 1;
            }
            int avail = max - this.udp_traversal_count;
            int to_do = Math.min(number, avail);
            Iterator it = this.udp_fallbacks.values().iterator();
            while (to_do > 0 && it.hasNext()) {
                --to_do;
                final PeerItem peer_item = (PeerItem)it.next();
                it.remove();
                PeerNATTraverser.getSingleton().create(this, new InetSocketAddress(peer_item.getAddressString(), peer_item.getUDPPort()), new PeerNATTraversalAdapter(){
                    private boolean done;

                    public void success(InetSocketAddress target) {
                        this.complete();
                        PEPeerControlImpl.this.makeNewOutgoingConnection(PeerItem.convertSourceString(peer_item.getSource()), target.getAddress().getHostAddress(), peer_item.getTCPPort(), target.getPort(), false, true, peer_item.getCryptoLevel());
                    }

                    public void failed() {
                        this.complete();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void complete() {
                        try {
                            PEPeerControlImpl.this.peer_transports_mon.enter();
                            if (!this.done) {
                                this.done = true;
                                PEPeerControlImpl.this.udp_traversal_count--;
                            }
                        }
                        finally {
                            PEPeerControlImpl.this.peer_transports_mon.exit();
                        }
                    }
                });
                ++this.udp_traversal_count;
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
    }

    public boolean doOptimisticDisconnect(boolean pending_lan_local_peer) {
        ArrayList peer_transports = this.peer_transports_cow;
        PEPeerTransport max_transport = null;
        PEPeerTransport max_seed_transport = null;
        PEPeerTransport max_non_lan_transport = null;
        long max_time = 0L;
        long max_seed_time = 0L;
        long max_non_lan_time = 0L;
        int lan_peer_count = 0;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            if (peer.getConnectionState() != 4) continue;
            long timeSinceSentData = peer.getTimeSinceLastDataMessageSent();
            long peerTestTime = 0L;
            if (this.seeding_mode) {
                if (timeSinceSentData != -1L) {
                    peerTestTime = timeSinceSentData;
                }
            } else {
                long timeSinceGoodData = peer.getTimeSinceGoodDataReceived();
                long timeSinceConnection = peer.getTimeSinceConnectionEstablished();
                peerTestTime = timeSinceGoodData == -1L ? (peerTestTime += timeSinceConnection) : (peerTestTime += timeSinceGoodData);
                if (!peer.isInteresting()) {
                    peerTestTime = !peer.isInterested() ? (peerTestTime += timeSinceConnection + timeSinceSentData) : (peerTestTime += timeSinceConnection - timeSinceSentData);
                    peerTestTime *= 2L;
                }
                peerTestTime += peer.getSnubbedTime();
            }
            if (!peer.isIncoming()) {
                peerTestTime *= 2L;
            }
            if (peer.isLANLocal()) {
                ++lan_peer_count;
            } else if (peerTestTime > max_non_lan_time) {
                max_non_lan_time = peerTestTime;
                max_non_lan_transport = peer;
            }
            if (peerTestTime > max_time) {
                max_time = peerTestTime;
                max_transport = peer;
            }
            if (!peer.isSeed() || peerTestTime <= max_seed_time) continue;
            max_seed_time = peerTestTime;
            max_seed_transport = peer;
        }
        if (max_transport != null) {
            int LAN_PEER_MAX = 4;
            if (max_transport.isLANLocal() && lan_peer_count < 4 && max_non_lan_transport != null) {
                max_transport = max_non_lan_transport;
                max_time = max_non_lan_time;
            }
            if (this.getMaxSeedConnections() > 0 && max_seed_transport != null && max_time > 300000L) {
                this.closeAndRemovePeer(max_seed_transport, "timed out by doOptimisticDisconnect()", true);
                return true;
            }
            if (max_transport != null && max_time > 300000L) {
                this.closeAndRemovePeer(max_transport, "timed out by doOptimisticDisconnect()", true);
                return true;
            }
            if (pending_lan_local_peer && lan_peer_count < 4) {
                this.closeAndRemovePeer(max_transport, "making space for LAN peer in doOptimisticDisconnect()", true);
                return true;
            }
        }
        return false;
    }

    public PeerExchangerItem createPeerExchangeConnection(final PEPeerTransport base_peer) {
        if (base_peer.getTCPListenPort() > 0) {
            PeerItem peer = PeerItemFactory.createPeerItem(base_peer.getIp(), base_peer.getTCPListenPort(), (byte)2, base_peer.getPeerItemIdentity().getHandshakeType(), base_peer.getUDPListenPort(), (byte)1, 0);
            return this.peer_database.registerPeerConnection(peer, new PeerExchangerItem.Helper(){

                public boolean isSeed() {
                    return base_peer.isSeed();
                }
            });
        }
        return null;
    }

    private boolean isAlreadyConnected(PeerItem peer_id) {
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            if (!peer.getPeerItemIdentity().equals(peer_id)) continue;
            return true;
        }
        return false;
    }

    public void peerVerifiedAsSelf(PEPeerTransport self) {
        if (self.getTCPListenPort() > 0) {
            PeerItem peer = PeerItemFactory.createPeerItem(self.getIp(), self.getTCPListenPort(), PeerItem.convertSourceID(self.getPeerSource()), self.getPeerItemIdentity().getHandshakeType(), self.getUDPListenPort(), (byte)2, 0);
            this.peer_database.setSelfPeer(peer);
        }
    }

    public void IPBanned(BannedIp ip) {
        for (int i = 0; i < this._nbPieces; ++i) {
            if (this.pePieces[i] == null) continue;
            this.pePieces[i].reDownloadBlocks(ip.getIp());
        }
    }

    public int getAverageCompletionInThousandNotation() {
        ArrayList peer_transports = this.peer_transports_cow;
        if (peer_transports != null) {
            long total = this.disk_mgr.getTotalLength();
            int my_completion = total == 0L ? 1000 : (int)(1000L * (total - this.disk_mgr.getRemainingExcludingDND()) / total);
            int sum = my_completion == 1000 ? 0 : my_completion;
            int num = my_completion == 1000 ? 0 : 1;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeer peer = (PEPeer)peer_transports.get(i);
                if (peer.getPeerState() != 30 || peer.isSeed()) continue;
                ++num;
                sum += peer.getPercentDoneInThousandNotation();
            }
            return num > 0 ? sum / num : 0;
        }
        return -1;
    }

    public int getMaxConnections() {
        return this.adapter.getMaxConnections();
    }

    public int getMaxSeedConnections() {
        return this.adapter.getMaxSeedConnections();
    }

    public int getMaxNewConnectionsAllowed() {
        int dl_max = this.getMaxConnections();
        int allowed_peers = PeerUtils.numNewConnectionsAllowed(this.getPeerIdentityDataID(), dl_max);
        return allowed_peers;
    }

    public String getRelationText() {
        return this.adapter.getLogRelation().getRelationText();
    }

    public Object[] getQueryableInterfaces() {
        return this.adapter.getLogRelation().getQueryableInterfaces();
    }

    public PEPeerTransport getTransportFromIdentity(byte[] peer_id) {
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
            if (!Arrays.equals(peer_id, conn.getId())) continue;
            return conn;
        }
        return null;
    }

    public PEPeerTransport getTransportFromAddress(String peer) {
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport pt = (PEPeerTransport)peer_transports.get(i);
            if (!peer.equals(pt.getIp())) continue;
            return pt;
        }
        return null;
    }

    public void incNbPeersSnubbed() {
        ++this.nbPeersSnubbed;
    }

    public void decNbPeersSnubbed() {
        --this.nbPeersSnubbed;
    }

    public void setNbPeersSnubbed(int n) {
        this.nbPeersSnubbed = n;
    }

    public int getNbPeersSnubbed() {
        return this.nbPeersSnubbed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter writer) {
        writer.println("PeerManager: seeding=" + this.seeding_mode);
        if (!this.seeding_mode) {
            int i;
            int num;
            String str;
            writer.println("  Active Pieces");
            int num_active = 0;
            try {
                writer.indent();
                str = "";
                num = 0;
                for (i = 0; i < this.pePieces.length; ++i) {
                    PEPieceImpl piece = this.pePieces[i];
                    if (piece == null) continue;
                    ++num_active;
                    str = str + (str.length() == 0 ? "" : ",") + "#" + i + " " + this.dm_pieces[i].getString() + ": " + piece.getString();
                    if (++num != 20) continue;
                    writer.println(str);
                    str = "";
                    num = 0;
                }
                if (num > 0) {
                    writer.println(str);
                }
            }
            finally {
                writer.exdent();
            }
            if (num_active == 0) {
                writer.println("  Inactive Pieces (excluding done/skiped)");
                try {
                    writer.indent();
                    str = "";
                    num = 0;
                    for (i = 0; i < this.dm_pieces.length; ++i) {
                        DiskManagerPiece dm_piece = this.dm_pieces[i];
                        if (!dm_piece.isInteresting()) continue;
                        str = str + (str.length() == 0 ? "" : ",") + "#" + i + " " + this.dm_pieces[i].getString();
                        if (++num != 20) continue;
                        writer.println(str);
                        str = "";
                        num = 0;
                    }
                    if (num > 0) {
                        writer.println(str);
                    }
                }
                finally {
                    writer.exdent();
                }
            }
            this.piecePicker.generateEvidence(writer);
        }
        try {
            this.peer_transports_mon.enter();
            writer.indent();
            writer.println("Peers: total = " + this.peer_transports_cow.size());
            try {
                writer.indent();
                Iterator it = this.peer_transports_cow.iterator();
                while (it.hasNext()) {
                    PEPeerTransport peer = (PEPeerTransport)it.next();
                    peer.generateEvidence(writer);
                }
            }
            finally {
                writer.exdent();
            }
        }
        finally {
            this.peer_transports_mon.exit();
            writer.exdent();
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListener("Peer.Fast.Initial.Unchoke.Enabled", new ParameterListener(){

            public void parameterChanged(String name) {
                fast_unchoke_new_peers = COConfigurationManager.getBooleanParameter(name);
            }
        });
    }
}

