/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.transfer.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.global.impl.GlobalManagerAdpater;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class OverallStatsImpl
extends GlobalManagerAdpater
implements OverallStats {
    private static final int download_stats_version = 1;
    private static final String[] exts = new String[]{"mp3;ogg;wav;wma;flac", "avi;mpg;mpeg;wmv;vob;mp4;divx;mov;mkv", "zip;rar;iso;bin;tar;sit;dmg"};
    private static Set[] ext_sets = new Set[exts.length];
    private long[] file_sizes = new long[]{400L, 800L, 1600L};
    private static final long TEN_YEARS = 315360000L;
    private static final long STATS_PERIOD = 60000L;
    private static final long DL_STATE_TICKS = 15L;
    private static final int DL_AVERAGE_CELLS = 48;
    AzureusCore core;
    long totalDownloaded;
    long totalUploaded;
    long totalUptime;
    long lastDownloaded;
    long lastUploaded;
    long lastUptime;
    long session_start_time = SystemTime.getCurrentTime();
    long downloadCount;
    Map downloadTypes = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("OverallStats");
    private int tick_count;
    private int dl_cell_pos;
    private int[] dl_average_cells = new int[48];
    private int[] seed_average_cells = new int[48];
    private int dl_average;
    private int seed_average;
    private int running_count;
    private int public_count;

    private Map load(String filename) {
        return FileUtil.readResilientConfigFile(filename);
    }

    private Map load() {
        return this.load("azureus.statistics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String filename, Map map) {
        try {
            this.this_mon.enter();
            FileUtil.writeResilientConfigFile(filename, map);
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void save(Map map) {
        this.save("azureus.statistics", map);
    }

    private void validateAndLoadValues(Map statisticsMap) {
        this.lastUptime = SystemTime.getCurrentTime() / 1000L;
        Map overallMap = (Map)statisticsMap.get("all");
        this.totalDownloaded = this.getLong(overallMap, "downloaded");
        this.totalUploaded = this.getLong(overallMap, "uploaded");
        this.totalUptime = this.getLong(overallMap, "uptime");
        this.downloadCount = this.getLong(overallMap, "download_count");
        this.downloadTypes = this.getMap(overallMap, "download_types");
        this.dl_average = (int)this.getLong(overallMap, "download_average");
        this.seed_average = (int)this.getLong(overallMap, "seed_average");
        if (this.dl_average < 0 || this.dl_average > 32000) {
            this.dl_average = 0;
        }
        if (this.seed_average < 0 || this.seed_average > 32000) {
            this.seed_average = 0;
        }
        this.dl_average_cells[0] = this.dl_average;
        this.seed_average_cells[0] = this.seed_average;
        this.running_count = (int)this.getLong(overallMap, "running");
        this.public_count = (int)this.getLong(overallMap, "public");
        this.dl_cell_pos = 1;
    }

    protected long getLong(Map map, String name) {
        if (map == null) {
            return 0L;
        }
        Object obj = map.get(name);
        if (!(obj instanceof Long)) {
            return 0L;
        }
        return (Long)obj;
    }

    protected Map getMap(Map map, String name) {
        if (map == null) {
            return new HashMap();
        }
        Object obj = map.get(name);
        if (!(obj instanceof Map)) {
            return new HashMap();
        }
        return (Map)obj;
    }

    public OverallStatsImpl(AzureusCore _core) {
        this.core = _core;
        Map stats = this.load();
        this.validateAndLoadValues(stats);
        this.core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                if (component instanceof GlobalManager) {
                    GlobalManager gm = (GlobalManager)component;
                    gm.addListener(OverallStatsImpl.this, false);
                    SimpleTimer.addPeriodicEvent("OverallStats", 60000L, new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            OverallStatsImpl.this.updateStats(false);
                        }
                    });
                }
            }
        });
    }

    public int getAverageDownloadSpeed() {
        if (this.totalUptime > 1L) {
            return (int)(this.totalDownloaded / this.totalUptime);
        }
        return 0;
    }

    public int getAverageUploadSpeed() {
        if (this.totalUptime > 1L) {
            return (int)(this.totalUploaded / this.totalUptime);
        }
        return 0;
    }

    public long getDownloadedBytes() {
        return this.totalDownloaded;
    }

    public long getUploadedBytes() {
        return this.totalUploaded;
    }

    public long getTotalUpTime() {
        return this.totalUptime;
    }

    public long getSessionUpTime() {
        return (SystemTime.getCurrentTime() - this.session_start_time) / 1000L;
    }

    public void downloadManagerAdded(DownloadManager dm) {
        if (!dm.isPersistent()) {
            return;
        }
        if (dm.getStats().getDownloadCompleted(false) > 0) {
            return;
        }
        if (!dm.getDownloadState().getBooleanParameter("stats.counted")) {
            int i;
            ++this.downloadCount;
            TOTorrent t = dm.getTorrent();
            if (t == null) {
                return;
            }
            TOTorrentFile[] files = t.getFiles();
            HashMap<String, Long> ext_sizes = new HashMap<String, Long>();
            long largest = 0L;
            String largest_ext = null;
            for (int i2 = 0; i2 < files.length; ++i2) {
                TOTorrentFile file = files[i2];
                String path = file.getRelativePath();
                int pos = path.lastIndexOf(File.separator);
                if (pos != -1) {
                    path = path.substring(pos + 1);
                }
                String ext = (pos = path.lastIndexOf(46)) == -1 ? "?" : path.substring(pos + 1).toLowerCase();
                Long old_tot = (Long)ext_sizes.get(ext);
                long new_tot = 0L;
                if (old_tot != null) {
                    new_tot = old_tot;
                }
                if ((new_tot += file.getLength()) > largest) {
                    largest = new_tot;
                    largest_ext = ext;
                }
                ext_sizes.put(ext, new Long(new_tot));
            }
            int size_id = 0;
            int type_id = 0;
            long size_mb = t.getSize() / 0x100000L;
            for (i = 0; i < this.file_sizes.length; ++i) {
                size_id = i + 1;
                if (size_mb < this.file_sizes[i]) break;
            }
            for (i = 0; i < ext_sets.length; ++i) {
                if (!ext_sets[i].contains(largest_ext)) continue;
                type_id = i + 1;
                break;
            }
            String key = String.valueOf(size_id * 1024 + type_id);
            Object old_val = this.downloadTypes.get(key);
            long val = 0L;
            if (old_val instanceof Long) {
                val = (Long)old_val;
            }
            this.downloadTypes.put(key, new Long(++val));
            dm.getDownloadState().setBooleanParameter("stats.counted", true);
        }
    }

    public void destroyInitiated() {
        this.updateStats(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStats(boolean force) {
        try {
            long delta;
            this.this_mon.enter();
            long current_time = SystemTime.getCurrentTime() / 1000L;
            if (current_time < this.lastUptime) {
                this.lastUptime = current_time;
                return;
            }
            GlobalManagerStats stats = this.core.getGlobalManager().getStats();
            long current_total_received = stats.getTotalDataBytesReceived() + stats.getTotalProtocolBytesReceived();
            long current_total_sent = stats.getTotalDataBytesSent() + stats.getTotalProtocolBytesSent();
            this.totalDownloaded += current_total_received - this.lastDownloaded;
            this.lastDownloaded = current_total_received;
            if (this.totalDownloaded < 0L) {
                this.totalDownloaded = 0L;
            }
            this.totalUploaded += current_total_sent - this.lastUploaded;
            this.lastUploaded = current_total_sent;
            if (this.totalUploaded < 0L) {
                this.totalUploaded = 0L;
            }
            if ((delta = current_time - this.lastUptime) > 100L || delta < 0L) {
                this.lastUptime = current_time;
                return;
            }
            if (this.totalUptime > 315360000L) {
                this.totalUptime = 0L;
            }
            if (this.totalUptime < 0L) {
                this.totalUptime = 0L;
            }
            this.totalUptime += delta;
            this.lastUptime = current_time;
            ++this.tick_count;
            if (force || (long)this.tick_count % 15L == 0L) {
                try {
                    List managers = this.core.getGlobalManager().getDownloadManagers();
                    int dl = 0;
                    int seed = 0;
                    int run = 0;
                    int pub = 0;
                    for (int i = 0; i < managers.size(); ++i) {
                        DownloadManager dm = (DownloadManager)managers.get(i);
                        int state = dm.getState();
                        if (state == 50) {
                            ++dl;
                        } else if (state == 60) {
                            ++seed;
                        }
                        TOTorrent torrent = dm.getTorrent();
                        if (torrent != null && !torrent.getPrivate()) {
                            ++pub;
                        }
                        if (state == 100 || state == 70) continue;
                        ++run;
                    }
                    this.dl_average_cells[this.dl_cell_pos % 48] = dl;
                    this.seed_average_cells[this.dl_cell_pos % 48] = seed;
                    ++this.dl_cell_pos;
                    int cells = Math.min(this.dl_cell_pos, 48);
                    this.dl_average = 0;
                    this.seed_average = 0;
                    for (int i = 0; i < cells; ++i) {
                        this.dl_average += this.dl_average_cells[i];
                        this.seed_average += this.seed_average_cells[i];
                    }
                    this.dl_average /= cells;
                    this.seed_average /= cells;
                    this.running_count = run;
                    this.public_count = pub;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            HashMap<String, Object> overallMap = new HashMap<String, Object>();
            overallMap.put("downloaded", new Long(this.totalDownloaded));
            overallMap.put("uploaded", new Long(this.totalUploaded));
            overallMap.put("uptime", new Long(this.totalUptime));
            overallMap.put("download_count", new Long(this.downloadCount));
            overallMap.put("download_types", this.downloadTypes);
            overallMap.put("download_average", new Long(this.dl_average));
            overallMap.put("seed_average", new Long(this.seed_average));
            overallMap.put("public", new Long(this.public_count));
            overallMap.put("running", new Long(this.running_count));
            HashMap<String, HashMap<String, Object>> map = new HashMap<String, HashMap<String, Object>>();
            map.put("all", overallMap);
            this.save(map);
        }
        finally {
            this.this_mon.exit();
        }
    }

    static {
        for (int i = 0; i < exts.length; ++i) {
            StringTokenizer tok = new StringTokenizer(exts[i], ";");
            HashSet<String> set = OverallStatsImpl.ext_sets[i] = new HashSet<String>();
            while (tok.hasMoreTokens()) {
                set.add(tok.nextToken());
            }
        }
    }
}

