/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentCreateImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentDeserialiseImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentXMLDeserialiser;

public class TOTorrentFactory {
    public static final long TO_DEFAULT_FIXED_PIECE_SIZE = 262144L;
    public static final long TO_DEFAULT_VARIABLE_PIECE_SIZE_MIN = 32768L;
    public static final long TO_DEFAULT_VARIABLE_PIECE_SIZE_MAX = 0x200000L;
    public static final long TO_DEFAULT_VARIABLE_PIECE_NUM_LOWER = 1024L;
    public static final long TO_DEFAULT_VARIABLE_PIECE_NUM_UPPER = 2048L;
    public static final long[] STANDARD_PIECE_SIZES = new long[]{32768L, 49152L, 65536L, 98304L, 131072L, 196608L, 262144L, 393216L, 524288L, 786432L, 0x100000L, 0x180000L, 0x200000L, 0x300000L, 0x400000L};

    public static TOTorrent deserialiseFromBEncodedFile(File file) throws TOTorrentException {
        return new TOTorrentDeserialiseImpl(file);
    }

    public static TOTorrent deserialiseFromBEncodedInputStream(InputStream is) throws TOTorrentException {
        return new TOTorrentDeserialiseImpl(is);
    }

    public static TOTorrent deserialiseFromBEncodedByteArray(byte[] bytes) throws TOTorrentException {
        return new TOTorrentDeserialiseImpl(bytes);
    }

    public static TOTorrent deserialiseFromMap(Map data) throws TOTorrentException {
        return new TOTorrentDeserialiseImpl(data);
    }

    public static TOTorrent deserialiseFromXMLFile(File file) throws TOTorrentException {
        return new TOTorrentXMLDeserialiser().deserialise(file);
    }

    public static TOTorrentCreator createFromFileOrDirWithFixedPieceLength(File file, URL announce_url) throws TOTorrentException {
        return TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(file, announce_url, false, 262144L);
    }

    public static TOTorrentCreator createFromFileOrDirWithFixedPieceLength(File file, URL announce_url, boolean add_hashes) throws TOTorrentException {
        return TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(file, announce_url, add_hashes, 262144L);
    }

    public static TOTorrentCreator createFromFileOrDirWithFixedPieceLength(File file, URL announce_url, long piece_length) throws TOTorrentException {
        return TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(file, announce_url, false, piece_length);
    }

    public static TOTorrentCreator createFromFileOrDirWithFixedPieceLength(File file, URL announce_url, boolean add_hashes, long piece_length) throws TOTorrentException {
        return TOTorrentCreateImpl.create(file, announce_url, add_hashes, piece_length);
    }

    public static TOTorrentCreator createFromFileOrDirWithComputedPieceLength(File file, URL announce_url) throws TOTorrentException {
        return TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(file, announce_url, false);
    }

    public static TOTorrentCreator createFromFileOrDirWithComputedPieceLength(File file, URL announce_url, boolean add_hashes) throws TOTorrentException {
        return TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(file, announce_url, add_hashes, 32768L, 0x200000L, 1024L, 2048L);
    }

    public static TOTorrentCreator createFromFileOrDirWithComputedPieceLength(File file, URL announce_url, long piece_min_size, long piece_max_size, long piece_num_lower, long piece_num_upper) throws TOTorrentException {
        return TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(file, announce_url, false, piece_min_size, piece_max_size, piece_num_lower, piece_num_upper);
    }

    public static TOTorrentCreator createFromFileOrDirWithComputedPieceLength(File file, URL announce_url, boolean add_hashes, long piece_min_size, long piece_max_size, long piece_num_lower, long piece_num_upper) throws TOTorrentException {
        return TOTorrentCreateImpl.create(file, announce_url, add_hashes, piece_min_size, piece_max_size, piece_num_lower, piece_num_upper);
    }

    public static long getTorrentDataSizeFromFileOrDir(File file_or_dir) {
        return TOTorrentCreateImpl.getTorrentDataSizeFromFileOrDir(file_or_dir);
    }

    public static long getComputedPieceSize(long data_size) {
        return TOTorrentCreateImpl.getComputedPieceSize(data_size, 32768L, 0x200000L, 1024L, 2048L);
    }

    public static long getPieceCount(long total_size, long piece_size) {
        return TOTorrentCreateImpl.getPieceCount(total_size, piece_size);
    }
}

