/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;

public class TRHostExternalTorrent
implements TOTorrent {
    private byte[] name;
    private byte[] hash;
    private HashWrapper hash_wrapper;
    private URL announce_url;
    protected Map additional_properties = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("TRHostExternalTorrent");

    protected TRHostExternalTorrent(byte[] _hash, URL _announce_url) {
        this.hash = _hash;
        this.hash_wrapper = new HashWrapper(this.hash);
        this.announce_url = _announce_url;
        this.name = ByteFormatter.nicePrint(this.hash, true).getBytes();
        try {
            LocaleTorrentUtil.setDefaultTorrentEncoding(this);
        }
        catch (LocaleUtilEncodingException e) {
            Debug.printStackTrace(e);
        }
    }

    public byte[] getName() {
        return this.name;
    }

    public boolean isSimpleTorrent() {
        return true;
    }

    public byte[] getComment() {
        return null;
    }

    public void setComment(String comment) {
    }

    public long getCreationDate() {
        return 0L;
    }

    public void setCreationDate(long date) {
    }

    public byte[] getCreatedBy() {
        return null;
    }

    public boolean isCreated() {
        return false;
    }

    public URL getAnnounceURL() {
        return this.announce_url;
    }

    public boolean setAnnounceURL(URL url) {
        return false;
    }

    public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
        return new TOTorrentAnnounceURLGroup(){

            public TOTorrentAnnounceURLSet[] getAnnounceURLSets() {
                return new TOTorrentAnnounceURLSet[0];
            }

            public void setAnnounceURLSets(TOTorrentAnnounceURLSet[] sets) {
            }

            public TOTorrentAnnounceURLSet createAnnounceURLSet(URL[] urls) {
                return new TOTorrentAnnounceURLSet(){

                    public URL[] getAnnounceURLs() {
                        return new URL[0];
                    }

                    public void setAnnounceURLs(URL[] urls) {
                    }
                };
            }
        };
    }

    public void addTorrentAnnounceURLSet(URL[] urls) {
    }

    public byte[][] getPieces() {
        return new byte[0][];
    }

    public void setPieces(byte[][] b) {
    }

    public int getNumberOfPieces() {
        return 0;
    }

    public long getPieceLength() {
        return -1L;
    }

    public long getSize() {
        return -1L;
    }

    public TOTorrentFile[] getFiles() {
        return new TOTorrentFile[0];
    }

    public byte[] getHash() throws TOTorrentException {
        return this.hash;
    }

    public HashWrapper getHashWrapper() throws TOTorrentException {
        return this.hash_wrapper;
    }

    public boolean getPrivate() {
        return false;
    }

    public void setPrivate(boolean _private) throws TOTorrentException {
    }

    public boolean hasSameHashAs(TOTorrent other) {
        try {
            byte[] other_hash = other.getHash();
            return Arrays.equals(this.hash, other_hash);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    public void setAdditionalStringProperty(String name, String value) {
        try {
            this.additional_properties.put(name, value.getBytes("UTF8"));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public String getAdditionalStringProperty(String name) {
        try {
            Object obj = this.additional_properties.get(name);
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof byte[])) {
                Debug.out("property '" + name + "' is not a byte[]: " + obj);
                return null;
            }
            return new String((byte[])obj, "UTF8");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public void setAdditionalByteArrayProperty(String name, byte[] value) {
        this.additional_properties.put(name, value);
    }

    public byte[] getAdditionalByteArrayProperty(String name) {
        return (byte[])this.additional_properties.get(name);
    }

    public void setAdditionalLongProperty(String name, Long value) {
        this.additional_properties.put(name, value);
    }

    public void setAdditionalProperty(String name, Object value) {
        if (name instanceof String) {
            this.setAdditionalStringProperty(name, (String)value);
        } else {
            this.additional_properties.put(name, value);
        }
    }

    public Long getAdditionalLongProperty(String name) {
        return (Long)this.additional_properties.get(name);
    }

    public void setAdditionalListProperty(String name, List value) {
        this.additional_properties.put(name, value);
    }

    public List getAdditionalListProperty(String name) {
        return (List)this.additional_properties.get(name);
    }

    public void setAdditionalMapProperty(String name, Map value) {
        this.additional_properties.put(name, value);
    }

    public Map getAdditionalMapProperty(String name) {
        return (Map)this.additional_properties.get(name);
    }

    public Object getAdditionalProperty(String name) {
        return this.additional_properties.get(name);
    }

    public void removeAdditionalProperty(String name) {
        this.additional_properties.remove(name);
    }

    public void removeAdditionalProperties() {
        this.additional_properties.clear();
    }

    public void serialiseToBEncodedFile(File file) throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    public Map serialiseToMap() throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    public void serialiseToXMLFile(File file) throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    public AEMonitor getMonitor() {
        return this.this_mon;
    }

    public void print() {
    }
}

