/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactoryListener;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.dht.TRTrackerServerDHT;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking.TRBlockingServer;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServer;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessorFactory;
import org.gudy.azureus2.core3.tracker.server.impl.udp.TRTrackerServerUDP;
import org.gudy.azureus2.core3.util.AEMonitor;

public class TRTrackerServerFactoryImpl {
    protected static List servers = new ArrayList();
    protected static List listeners = new ArrayList();
    protected static AEMonitor class_mon = new AEMonitor("TRTrackerServerFactory");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTrackerServer create(String name, int protocol, int port, InetAddress bind_ip, boolean ssl, boolean apply_ip_filter, boolean main_tracker, boolean start_up_ready) throws TRTrackerServerException {
        try {
            TRTrackerServerImpl server;
            class_mon.enter();
            if (protocol == 1) {
                server = COConfigurationManager.getBooleanParameter("Tracker TCP NonBlocking") && main_tracker && !ssl ? new TRNonBlockingServer(name, port, bind_ip, apply_ip_filter, start_up_ready, new TRNonBlockingServerProcessorFactory(){

                    public TRNonBlockingServerProcessor create(TRTrackerServerTCP _server, SocketChannel _socket) {
                        return new NonBlockingProcessor(_server, _socket);
                    }
                }) : new TRBlockingServer(name, port, bind_ip, ssl, apply_ip_filter, start_up_ready);
            } else if (protocol == 2) {
                if (ssl) {
                    throw new TRTrackerServerException("TRTrackerServerFactory: UDP doesn't support SSL");
                }
                server = new TRTrackerServerUDP(name, port, start_up_ready);
            } else {
                server = new TRTrackerServerDHT(name, start_up_ready);
            }
            servers.add(server);
            for (int i = 0; i < listeners.size(); ++i) {
                ((TRTrackerServerFactoryListener)listeners.get(i)).serverCreated(server);
            }
            TRTrackerServerImpl tRTrackerServerImpl = server;
            return tRTrackerServerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(TRTrackerServerFactoryListener l) {
        try {
            class_mon.enter();
            listeners.add(l);
            for (int i = 0; i < servers.size(); ++i) {
                l.serverCreated((TRTrackerServer)servers.get(i));
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(TRTrackerServerFactoryListener l) {
        try {
            class_mon.enter();
            listeners.remove(l);
        }
        finally {
            class_mon.exit();
        }
    }

    protected static class NonBlockingProcessor
    extends TRNonBlockingServerProcessor {
        protected NonBlockingProcessor(TRTrackerServerTCP _server, SocketChannel _socket) {
            super(_server, _socket);
        }

        protected ByteArrayOutputStream process(String input_header, String lowercase_input_header, String url_path, InetSocketAddress client_address, boolean announce_and_scrape_only, InputStream is) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            this.processRequest(input_header, lowercase_input_header, url_path, client_address, announce_and_scrape_only, is, os);
            return os;
        }
    }
}

