/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNATChecker;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNatCheckerListener;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.HostNameToIPResolverListener;

public class TRTrackerServerPeerImpl
implements TRTrackerServerPeer,
HostNameToIPResolverListener,
TRTrackerServerNatCheckerListener {
    private static final byte UNBIASED = 101;
    private HashWrapper peer_id;
    private int key_hash_code;
    private byte[] ip;
    private boolean ip_override;
    private short tcp_port;
    private short udp_port;
    private short http_port;
    private byte crypto_level;
    private byte az_ver;
    private String ip_str;
    private byte[] ip_bytes;
    private byte NAT_status = 0;
    private long timeout;
    private long uploaded;
    private long downloaded;
    private long amount_left;
    private long last_contact_time;
    private boolean download_completed;
    private byte bias = (byte)101;
    private short up_speed;
    private DHTNetworkPosition network_position;
    private Object user_data;

    protected TRTrackerServerPeerImpl(HashWrapper _peer_id, int _key_hash_code, byte[] _ip, boolean _ip_override, int _tcp_port, int _udp_port, int _http_port, byte _crypto_level, byte _az_ver, long _last_contact_time, boolean _download_completed, byte _last_nat_status, int _up_speed, DHTNetworkPosition _network_position) {
        this.peer_id = _peer_id;
        this.key_hash_code = _key_hash_code;
        this.ip = _ip;
        this.ip_override = _ip_override;
        this.tcp_port = (short)_tcp_port;
        this.udp_port = (short)_udp_port;
        this.http_port = (short)_http_port;
        this.crypto_level = _crypto_level;
        this.az_ver = _az_ver;
        this.last_contact_time = _last_contact_time;
        this.download_completed = _download_completed;
        this.NAT_status = _last_nat_status;
        this.up_speed = (short)(_up_speed > Short.MAX_VALUE ? Short.MAX_VALUE : (short)_up_speed);
        this.network_position = _network_position;
        this.resolveAndCheckNAT();
    }

    protected boolean update(byte[] _ip, int _port, int _udp_port, int _http_port, byte _crypto_level, byte _az_ver, int _up_speed, DHTNetworkPosition _network_position) {
        this.udp_port = (short)_udp_port;
        this.http_port = (short)_http_port;
        this.crypto_level = _crypto_level;
        this.az_ver = _az_ver;
        this.up_speed = (short)(_up_speed > Short.MAX_VALUE ? Short.MAX_VALUE : (short)_up_speed);
        this.network_position = _network_position;
        boolean res = false;
        if (_port != this.getTCPPort()) {
            this.tcp_port = (short)_port;
            res = true;
        }
        if (!Arrays.equals(_ip, this.ip)) {
            this.ip = _ip;
            res = true;
        }
        if (res) {
            this.resolveAndCheckNAT();
        }
        return res;
    }

    public void NATCheckComplete(boolean ok) {
        this.NAT_status = ok ? (byte)3 : (byte)4;
    }

    protected void setNATStatus(byte status) {
        this.NAT_status = status;
    }

    public byte getNATStatus() {
        return this.NAT_status;
    }

    protected boolean isNATStatusBad() {
        return this.NAT_status == 4 || this.NAT_status == 5;
    }

    protected void resolveAndCheckNAT() {
        this.ip_str = new String(this.ip);
        this.ip_bytes = null;
        HostNameToIPResolver.addResolverRequest(this.ip_str, this);
        if (this.tcp_port == 0) {
            this.NAT_status = (byte)5;
        } else if (this.NAT_status == 0) {
            this.NAT_status = (byte)2;
            if (!TRTrackerServerNATChecker.getSingleton().addNATCheckRequest(this.ip_str, this.getTCPPort(), this)) {
                this.NAT_status = 1;
            }
        }
    }

    public void hostNameResolutionComplete(InetAddress address) {
        if (address != null) {
            this.ip_str = address.getHostAddress();
            this.ip_bytes = address.getAddress();
        }
    }

    protected long getLastContactTime() {
        return this.last_contact_time;
    }

    protected boolean getDownloadCompleted() {
        return this.download_completed;
    }

    protected void setDownloadCompleted() {
        this.download_completed = true;
    }

    public void setBias(byte _bias) {
        this.bias = _bias;
    }

    public byte getBias() {
        if (this.bias == 101) {
            return 0;
        }
        return this.bias;
    }

    public boolean isBiased() {
        return this.bias != 101;
    }

    protected void setBiased(boolean biased) {
        this.bias = (byte)(biased ? 0 : 101);
    }

    protected HashWrapper getPeerId() {
        return this.peer_id;
    }

    public byte[] getPeerID() {
        return this.peer_id.getBytes();
    }

    protected int getKeyHashCode() {
        return this.key_hash_code;
    }

    protected byte[] getIPAsRead() {
        return this.ip;
    }

    public String getIPRaw() {
        return new String(this.ip);
    }

    public String getIP() {
        return this.ip_str;
    }

    protected boolean isIPOverride() {
        return this.ip_override;
    }

    public byte[] getIPBytes() {
        return this.ip_bytes;
    }

    public int getTCPPort() {
        return this.tcp_port & 0xFFFF;
    }

    protected int getUDPPort() {
        return this.udp_port & 0xFFFF;
    }

    protected int getHTTPPort() {
        return this.http_port & 0xFFFF;
    }

    protected byte getCryptoLevel() {
        return this.crypto_level;
    }

    protected byte getAZVer() {
        return this.az_ver;
    }

    protected int getUpSpeed() {
        return this.up_speed & 0xFFFF;
    }

    protected DHTNetworkPosition getNetworkPosition() {
        return this.network_position;
    }

    protected void setTimeout(long _now, long _timeout) {
        this.last_contact_time = _now;
        this.timeout = _timeout;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    protected void setStats(long _uploaded, long _downloaded, long _amount_left) {
        this.uploaded = _uploaded;
        this.downloaded = _downloaded;
        this.amount_left = _amount_left;
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public long getAmountLeft() {
        return this.amount_left;
    }

    protected boolean isSeed() {
        return this.amount_left == 0L;
    }

    public void setUserData(Object key, Object data) {
        if (this.user_data == null) {
            this.user_data = new Object[]{key, data};
        } else if (this.user_data instanceof Object[]) {
            Object[] x = (Object[])this.user_data;
            if (x[0] == key) {
                x[1] = data;
            } else {
                HashMap<Object, Object> map;
                this.user_data = map = new HashMap<Object, Object>();
                map.put(x[0], x[1]);
                map.put(key, data);
            }
        } else {
            ((Map)this.user_data).put(key, data);
        }
    }

    public Object getUserData(Object key) {
        if (this.user_data == null) {
            return null;
        }
        if (this.user_data instanceof Object[]) {
            Object[] x = (Object[])this.user_data;
            if (x[0] == key) {
                return x[1];
            }
            return null;
        }
        return ((Map)this.user_data).get(key);
    }

    protected String getString() {
        return new String(this.ip) + ":" + this.getTCPPort() + "(" + new String(this.peer_id.getHash()) + ")";
    }
}

