/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.ByteEncodedKeyHashMap;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.ThreadPoolTask;

public abstract class TRTrackerServerProcessor
extends ThreadPoolTask {
    private static final boolean QUEUE_TEST = false;
    private TRTrackerServerImpl server;

    protected TRTrackerServerTorrentImpl processTrackerRequest(TRTrackerServerImpl _server, String request2, Map[] root_out, TRTrackerServerPeerImpl[] peer_out, int request_type, byte[][] hashes, String scrape_flags, HashWrapper peer_id, boolean no_peer_id, byte compact_mode, String key, String event2, boolean stop_to_queue, int port, int udp_port, int http_port, String real_ip_address, String client_ip_address, long downloaded, long uploaded, long left, int num_want, byte crypto_level, byte az_ver, int up_speed, DHTNetworkPosition network_position) throws TRTrackerServerException {
        int i;
        this.server = _server;
        if (!this.server.isReady()) {
            throw new TRTrackerServerException("Tracker initialising, please wait");
        }
        boolean ip_override = real_ip_address != client_ip_address;
        boolean loopback = TRTrackerUtils.isLoopback(real_ip_address);
        if (loopback) {
            ip_override = false;
        }
        client_ip_address = TRTrackerUtils.adjustHostFromHosting(client_ip_address);
        if (!TRTrackerServerImpl.getAllNetworksSupported()) {
            String network = AENetworkClassifier.categoriseAddress(client_ip_address);
            String[] permitted_networks = TRTrackerServerImpl.getPermittedNetworks();
            boolean ok = false;
            for (i = 0; i < permitted_networks.length; ++i) {
                if (network != permitted_networks[i]) continue;
                ok = true;
                break;
            }
            if (!ok) {
                throw new TRTrackerServerException("Network '" + network + "' not supported");
            }
        }
        TRTrackerServerTorrentImpl torrent = null;
        if (request_type != 3) {
            if (hashes == null || hashes.length == 0) {
                throw new TRTrackerServerException("Hash missing from request ");
            }
            if (request_type == 1) {
                if (hashes.length != 1) {
                    throw new TRTrackerServerException("Too many hashes for announce");
                }
                byte[] hash = hashes[0];
                torrent = this.server.getTorrent(hash);
                if (torrent == null) {
                    if (!COConfigurationManager.getBooleanParameter("Tracker Public Enable", false)) {
                        throw new TRTrackerServerException("Torrent unauthorised");
                    }
                    try {
                        torrent = (TRTrackerServerTorrentImpl)this.server.permit(hash, false);
                    }
                    catch (Throwable e) {
                        throw new TRTrackerServerException("Torrent unauthorised", e);
                    }
                }
                if (peer_id == null) {
                    throw new TRTrackerServerException("peer_id missing from request");
                }
                long interval = this.server.getAnnounceRetryInterval(torrent);
                TRTrackerServerPeerImpl peer = torrent.peerContact(request2, event2, peer_id, port, udp_port, http_port, crypto_level, az_ver, client_ip_address, ip_override, loopback, key, uploaded, downloaded, left, interval, up_speed, network_position);
                if (stop_to_queue && !loopback && !ip_override) {
                    torrent.peerQueued(client_ip_address, port, udp_port, http_port, crypto_level, az_ver, (int)this.server.getScrapeRetryInterval(torrent), left == 0L);
                }
                HashMap pre_map = new HashMap();
                TRTrackerServerPeer pre_process_peer = peer;
                if (pre_process_peer == null) {
                    pre_process_peer = new lightweightPeer(client_ip_address, port, peer_id);
                }
                this.server.preProcess(pre_process_peer, torrent, request_type, request2, pre_map);
                boolean stopped = event2 != null && event2.equalsIgnoreCase("stopped");
                root_out[0] = torrent.exportAnnounceToMap(pre_map, peer, left > 0L, stopped ? 0 : num_want, interval, this.server.getMinAnnounceRetryInterval(), no_peer_id, compact_mode, crypto_level, network_position);
                peer_out[0] = peer;
            } else {
                char[] scrape_chars;
                HashMap<String, ByteEncodedKeyHashMap> root;
                boolean local_scrape = client_ip_address.equals("127.0.0.1");
                long max_interval = this.server.getMinScrapeRetryInterval();
                root_out[0] = root = new HashMap<String, ByteEncodedKeyHashMap>();
                ByteEncodedKeyHashMap files = new ByteEncodedKeyHashMap();
                root.put("files", files);
                char[] cArray = scrape_chars = scrape_flags == null ? null : scrape_flags.toCharArray();
                if (scrape_chars != null && scrape_chars.length != hashes.length) {
                    scrape_chars = null;
                }
                for (int i2 = 0; i2 < hashes.length; ++i2) {
                    long interval;
                    String str_hash;
                    byte[] hash = hashes[i2];
                    try {
                        str_hash = new String(hash, "ISO-8859-1");
                        if (i2 > 0 && files.get(str_hash) != null) {
                        }
                    }
                    catch (UnsupportedEncodingException e) {}
                    continue;
                    torrent = this.server.getTorrent(hash);
                    if (torrent == null) {
                        if (!COConfigurationManager.getBooleanParameter("Tracker Public Enable", false)) continue;
                        try {
                            torrent = (TRTrackerServerTorrentImpl)this.server.permit(hash, false);
                        }
                        catch (Throwable e) {
                            continue;
                        }
                    }
                    if ((interval = this.server.getScrapeRetryInterval(torrent)) > max_interval) {
                        max_interval = interval;
                    }
                    if (scrape_chars != null && !loopback && !ip_override && scrape_chars[i2] == 'Q') {
                        torrent.peerQueued(client_ip_address, port, udp_port, http_port, crypto_level, az_ver, (int)interval, true);
                    }
                    if (torrent.getRedirects() != null && hashes.length > 1) continue;
                    this.server.preProcess(new lightweightPeer(client_ip_address, port, peer_id), torrent, request_type, request2, null);
                    Map hash_entry = torrent.exportScrapeToMap(request2, client_ip_address, !local_scrape);
                    files.put(str_hash, hash_entry);
                }
                if (hashes.length > 1) {
                    torrent = null;
                }
                this.addScrapeInterval(max_interval, root);
            }
        } else {
            HashMap<String, ByteEncodedKeyHashMap> root;
            if (!TRTrackerServerImpl.isFullScrapeEnabled()) {
                throw new TRTrackerServerException("Full scrape disabled");
            }
            ByteEncodedKeyHashMap files = new ByteEncodedKeyHashMap();
            TRTrackerServerTorrentImpl[] torrents = this.server.getTorrents();
            for (i = 0; i < torrents.length; ++i) {
                TRTrackerServerTorrentImpl this_torrent = torrents[i];
                if (this_torrent.getRedirects() != null) continue;
                this.server.preProcess(new lightweightPeer(client_ip_address, port, peer_id), this_torrent, request_type, request2, null);
                byte[] torrent_hash = this_torrent.getHash().getHash();
                try {
                    String str_hash = new String(torrent_hash, "ISO-8859-1");
                    Map hash_entry = this_torrent.exportScrapeToMap(request2, client_ip_address, true);
                    files.put(str_hash, hash_entry);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new TRTrackerServerException("Encoding error", e);
                }
            }
            root_out[0] = root = new HashMap<String, ByteEncodedKeyHashMap>();
            this.addScrapeInterval(null, root);
            root.put("files", files);
        }
        return torrent;
    }

    protected void addScrapeInterval(TRTrackerServerTorrentImpl torrent, Map root) {
        long interval = this.server.getScrapeRetryInterval(torrent);
        this.addScrapeInterval(interval, root);
    }

    protected void addScrapeInterval(long interval, Map root) {
        if (interval > 0L) {
            HashMap<String, Long> flags = new HashMap<String, Long>();
            flags.put("min_request_interval", new Long(interval));
            root.put("flags", flags);
        }
    }

    protected static class lightweightPeer
    implements TRTrackerServerPeer {
        private String ip;
        private int port;
        private byte[] peer_id;

        public lightweightPeer(String _ip, int _port, HashWrapper _peer_id) {
            this.ip = _ip;
            this.port = _port;
            this.peer_id = _peer_id == null ? null : _peer_id.getBytes();
        }

        public long getUploaded() {
            return -1L;
        }

        public long getDownloaded() {
            return -1L;
        }

        public long getAmountLeft() {
            return -1L;
        }

        public String getIP() {
            return this.ip;
        }

        public String getIPRaw() {
            return this.ip;
        }

        public byte getNATStatus() {
            return 0;
        }

        public int getTCPPort() {
            return this.port;
        }

        public byte[] getPeerID() {
            return this.peer_id;
        }

        public boolean isBiased() {
            return false;
        }

        public byte getBias() {
            return 0;
        }

        public void setBias(byte bias) {
        }

        public void setUserData(Object key, Object data) {
        }

        public Object getUserData(Object key) {
            return null;
        }
    }
}

