/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Hasher;

public abstract class TRTrackerServerProcessorTCP
extends TRTrackerServerProcessor {
    protected static final int SOCKET_TIMEOUT = 5000;
    protected static final char CR = '\r';
    protected static final char FF = '\n';
    protected static final String NL = "\r\n";
    private static final String lc_azureus_name = "Azureus".toLowerCase();
    protected static final byte[] HTTP_RESPONSE_START = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nServer: Azureus 2.5.0.4\r\nConnection: close\r\nContent-Length: ".getBytes();
    protected static final byte[] HTTP_RESPONSE_END_GZIP = "\r\nContent-Encoding: gzip\r\n\r\n".getBytes();
    protected static final byte[] HTTP_RESPONSE_END_NOGZIP = "\r\n\r\n".getBytes();
    private TRTrackerServerTCP server;
    private String server_url;
    private boolean disable_timeouts = false;

    protected TRTrackerServerProcessorTCP(TRTrackerServerTCP _server) {
        this.server = _server;
        this.server_url = (this.server.isSSL() ? "https" : "http") + "://" + this.server.getHost() + ":" + this.server.getPort();
    }

    protected boolean areTimeoutsDisabled() {
        return this.disable_timeouts;
    }

    protected void setTimeoutsDisabled(boolean d) {
        this.disable_timeouts = d;
    }

    protected TRTrackerServerTCP getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void processRequest(String input_header, String lowercase_input_header, String url_path, InetSocketAddress client_address, boolean announce_and_scrape_only, InputStream is, OutputStream os) throws IOException {
        block102: {
            block99: {
                block100: {
                    block101: {
                        str = url_path;
                        root = null;
                        specific_torrent = null;
                        gzip_reply = false;
                        if (str.startsWith("/announce?")) {
                            request_type = 1;
                            str = str.substring(10);
                            break block99;
                        }
                        if (str.startsWith("/scrape?")) {
                            request_type = 2;
                            str = str.substring(8);
                            break block99;
                        }
                        if (str.equals("/scrape")) {
                            request_type = 3;
                            str = "";
                            break block99;
                        }
                        redirect = TRTrackerServerImpl.redirect_on_not_found;
                        if (announce_and_scrape_only) {
                            if (redirect.length() == 0) {
                                throw new Exception("Tracker only supports announce and scrape functions");
                            }
                            break block100;
                        }
                        this.setTaskState("external request");
                        this.disable_timeouts = true;
                        user = this.doAuthentication(url_path, input_header, os, false);
                        if (user != null) break block101;
                        this.setTaskState("final os flush");
                        os.flush();
                        return;
                    }
                    if (!this.handleExternalRequest(client_address, user, str, input_header, is, os)) break block100;
                    this.setTaskState("final os flush");
                    os.flush();
                    return;
                }
                if (redirect.length() > 0) {
                    os.write(("HTTP/1.1 301 Moved Permanently\r\nLocation: " + redirect + "\r\n" + "\r\n").getBytes());
                } else {
                    os.write("HTTP/1.1 404 Not Found\r\n\r\n".getBytes());
                }
                os.flush();
                this.setTaskState("final os flush");
                os.flush();
                return;
            }
            if (this.doAuthentication(url_path, input_header, os, true) != null) break block102;
            this.setTaskState("final os flush");
            os.flush();
            return;
        }
        try {
            enc_pos = lowercase_input_header.indexOf("accept-encoding:");
            if (enc_pos != -1 && (e_pos = input_header.indexOf("\r\n", enc_pos)) != -1) {
                if (enc_pos > 0 && (c = lowercase_input_header.charAt(enc_pos - 1)) != '\n' && c != ' ') {
                    enc_pos = -1;
                }
                if (enc_pos != -1 && (gzip_index = (accept_encoding = lowercase_input_header.substring(enc_pos + 16, e_pos)).indexOf("gzip")) != -1) {
                    gzip_reply = true;
                    if (accept_encoding.length() - gzip_index >= 8) {
                        chars = accept_encoding.toCharArray();
                        q_value = false;
                        for (i = gzip_index + 4; i < chars.length && (c = chars[i]) != ','; ++i) {
                            if (c == '=') {
                                q_value = true;
                                gzip_reply = false;
                                continue;
                            }
                            if (!q_value || c == ' ' || c == '0' || c == '.') continue;
                            gzip_reply = true;
                            break;
                        }
                    }
                }
            }
            this.setTaskState("decoding announce/scrape");
            pos = 0;
            hash = null;
            hash_list = null;
            peer_id = null;
            tcp_port = 0;
            event = null;
            uploaded = 0L;
            downloaded = 0L;
            left = 0L;
            num_want = -1;
            no_peer_id = false;
            compact_mode = 0;
            key = null;
            crypto_level = 0;
            crypto_port = 0;
            udp_port = 0;
            http_port = 0;
            az_ver = 0;
            stop_to_queue = false;
            scrape_flags = null;
            up_speed = 0;
            network_position = null;
            client_ip_address = real_ip_address = client_address.getAddress().getHostAddress();
            while (pos < str.length()) {
                p1 = str.indexOf(38, pos);
                if (p1 == -1) {
                    token = str.substring(pos);
                } else {
                    token = str.substring(pos, p1);
                    pos = p1 + 1;
                }
                p2 = token.indexOf(61);
                if (p2 == -1) {
                    throw new Exception("format invalid");
                }
                lhs = token.substring(0, p2).toLowerCase();
                rhs = URLDecoder.decode(token.substring(p2 + 1), "ISO-8859-1");
                if (lhs.equals("info_hash")) {
                    b = rhs.getBytes("ISO-8859-1");
                    if (hash == null) {
                        hash = b;
                    } else {
                        if (hash_list == null) {
                            hash_list = new ArrayList<byte[]>();
                            hash_list.add(hash);
                        }
                        hash_list.add(b);
                    }
                } else if (lhs.equals("peer_id")) {
                    peer_id = new HashWrapper(rhs.getBytes("ISO-8859-1"));
                } else if (lhs.equals("no_peer_id")) {
                    no_peer_id = rhs.equals("1");
                } else if (lhs.equals("compact")) {
                    if (this.server.isCompactEnabled() && rhs.equals("1") && compact_mode == 0) {
                        compact_mode = 1;
                    }
                } else if (lhs.equals("key")) {
                    if (this.server.isKeyEnabled()) {
                        key = rhs;
                    }
                } else if (lhs.equals("port")) {
                    tcp_port = Integer.parseInt(rhs);
                } else if (lhs.equals("event")) {
                    event = rhs;
                } else if (lhs.equals("ip")) {
                    if (AENetworkClassifier.categoriseAddress(rhs) == "Public") {
                        for (i = 0; i < rhs.length(); ++i) {
                            c = rhs.charAt(i);
                            if (c == '.' || Character.isDigit(c)) continue;
                            throw new Exception("IP override address must be resolved by the client");
                        }
                    }
                    client_ip_address = rhs;
                } else if (lhs.equals("uploaded")) {
                    uploaded = Long.parseLong(rhs);
                } else if (lhs.equals("downloaded")) {
                    downloaded = Long.parseLong(rhs);
                } else if (lhs.equals("left")) {
                    left = Long.parseLong(rhs);
                } else if (lhs.equals("numwant")) {
                    num_want = Integer.parseInt(rhs);
                } else if (lhs.equals("azudp")) {
                    udp_port = Integer.parseInt(rhs);
                    compact_mode = 2;
                } else if (lhs.equals("azhttp")) {
                    http_port = Integer.parseInt(rhs);
                } else if (lhs.equals("azver")) {
                    az_ver = Integer.parseInt(rhs);
                } else if (lhs.equals("supportcrypto")) {
                    if (crypto_level == 0) {
                        crypto_level = 1;
                    }
                } else if (lhs.equals("requirecrypto")) {
                    crypto_level = 2;
                } else if (lhs.equals("cryptoport")) {
                    crypto_port = Integer.parseInt(rhs);
                } else if (lhs.equals("azq")) {
                    stop_to_queue = true;
                } else if (lhs.equals("azsf")) {
                    scrape_flags = rhs;
                } else if (TRTrackerServerImpl.supportsExtensions()) {
                    if (lhs.equals("aznp")) {
                        try {
                            network_position = DHTNetworkPositionManager.deserialisePosition(Base32.decode(rhs));
                        }
                        catch (Throwable e) {}
                    } else if (lhs.equals("azup")) {
                        up_speed = Integer.parseInt(rhs);
                    }
                }
                if (p1 != -1) continue;
                break;
            }
            if (crypto_level == 2 && crypto_port != 0) {
                tcp_port = crypto_port;
            }
            hashes /* !! */  = null;
            if (hash_list != null) {
                hashes /* !! */  = new byte[hash_list.size()][];
                hash_list.toArray((T[])hashes /* !! */ );
            } else if (hash != null) {
                hashes /* !! */  = new byte[][]{hash};
            }
            if (az_ver >= 2) {
                compact_mode = 3;
            }
            root_out = new Map[1];
            peer_out = new TRTrackerServerPeerImpl[1];
            specific_torrent = this.processTrackerRequest(this.server, str, root_out, peer_out, request_type, hashes /* !! */ , scrape_flags, peer_id, no_peer_id, (byte)compact_mode, key, event, stop_to_queue, tcp_port & 65535, udp_port & 65535, http_port & 65535, real_ip_address, client_ip_address, downloaded, uploaded, left, num_want, (byte)crypto_level, (byte)az_ver, up_speed, network_position);
            root = root_out[0];
            if (request_type == 2 && lowercase_input_header.indexOf(TRTrackerServerProcessorTCP.lc_azureus_name) != -1) {
                root.put("aztracker", new Long(1L));
            }
            if (root.get("_data") == null) {
                post_process_peer /* !! */  = peer_out[0];
                if (post_process_peer /* !! */  == null) {
                    post_process_peer /* !! */  = new TRTrackerServerProcessor.lightweightPeer(client_ip_address, tcp_port, peer_id);
                }
                this.server.postProcess(post_process_peer /* !! */ , specific_torrent, request_type, str, root);
            }
            ** GOTO lbl254
            {
                catch (Exception e) {
                    block104: {
                        if (!(e instanceof TRTrackerServerException)) ** GOTO lbl245
                        tr_excep = (TRTrackerServerException)e;
                        reason = tr_excep.getResponseCode();
                        if (reason != -1) {
                            resp = "HTTP/1.1 " + reason + " " + tr_excep.getResponseText() + "\r\n";
                            headers = tr_excep.getResponseHeaders();
                            it = headers.entrySet().iterator();
                            while (it.hasNext()) {
                                entry = it.next();
                                key = (String)entry.getKey();
                                value = (String)entry.getValue();
                                resp = resp + key + ": " + value + "\r\n";
                            }
                            resp = resp + "\r\n";
                            os.write(resp.getBytes());
                            os.flush();
                            this.setTaskState("final os flush");
                            os.flush();
                            return;
                        }
                        break block104;
lbl245:
                        // 1 sources

                        if (e instanceof NullPointerException) {
                            e.printStackTrace();
                        }
                    }
                    message = e.getMessage();
                    if (message == null || message.length() == 0) {
                        message = e.toString();
                    }
                    root = new HashMap<String, Object>();
                    root.put("failure reason", (Long)message);
lbl254:
                    // 2 sources

                    this.setTaskState("writing response");
                    data = (byte[])root.get("_data");
                    if (data == null) {
                        data = BEncoder.encode(root);
                        root.put("_data", (Long)data);
                    }
                    if (gzip_reply) {
                        gzip_data = (byte[])root.get("_gzipdata");
                        if (gzip_data == null) {
                            tos = new ByteArrayOutputStream(data.length);
                            gos = new GZIPOutputStream(tos);
                            gos.write(data);
                            gos.close();
                            gzip_data = tos.toByteArray();
                            root.put("_gzipdata", (Long)gzip_data);
                        }
                        data = gzip_data;
                    }
                    this.setTaskState("writing header");
                    os.write(TRTrackerServerProcessorTCP.HTTP_RESPONSE_START);
                    length_bytes = String.valueOf(data.length).getBytes();
                    os.write(length_bytes);
                    header_len = TRTrackerServerProcessorTCP.HTTP_RESPONSE_START.length + length_bytes.length;
                    this.setTaskState("writing content");
                    if (gzip_reply) {
                        os.write(TRTrackerServerProcessorTCP.HTTP_RESPONSE_END_GZIP);
                        header_len += TRTrackerServerProcessorTCP.HTTP_RESPONSE_END_GZIP.length;
                    } else {
                        os.write(TRTrackerServerProcessorTCP.HTTP_RESPONSE_END_NOGZIP);
                        header_len += TRTrackerServerProcessorTCP.HTTP_RESPONSE_END_NOGZIP.length;
                    }
                    os.write(data);
                    this.server.updateStats(specific_torrent, input_header.length(), header_len + data.length);
                }
            }
        }
        finally {
            this.setTaskState("final os flush");
            os.flush();
        }
    }

    protected String doAuthentication(String url_path, String header, OutputStream os, boolean tracker) throws IOException {
        boolean apply_torrent_password;
        boolean apply_web_password = !tracker && this.server.isWebPasswordEnabled();
        boolean bl = apply_torrent_password = tracker && this.server.isTrackerPasswordEnabled();
        if (apply_web_password && this.server.isWebPasswordHTTPSOnly() && !this.server.isSSL()) {
            os.write("HTTP/1.1 403 BAD\r\n\r\nAccess Denied\r\n".getBytes());
            os.flush();
            return null;
        }
        if (apply_torrent_password || apply_web_password) {
            int x = header.indexOf("Authorization:");
            if (x == -1) {
                if (this.server.hasExternalAuthorisation()) {
                    try {
                        String resource_str = (this.server.isSSL() ? "https" : "http") + "://" + this.server.getHost() + ":" + this.server.getPort() + url_path;
                        URL resource = new URL(resource_str);
                        if (this.server.performExternalAuthorisation(resource, "", "")) {
                            return "";
                        }
                    }
                    catch (MalformedURLException e) {
                        Debug.printStackTrace(e);
                    }
                }
            } else {
                int p1 = header.indexOf(32, x);
                int p2 = header.indexOf(32, p1 + 1);
                String body = header.substring(p2, header.indexOf(13, p2)).trim();
                String decoded = new String(Base64.decode(body));
                int cp = decoded.indexOf(58);
                String user = decoded.substring(0, cp);
                String pw = decoded.substring(cp + 1);
                boolean auth_failed = false;
                if (this.server.hasExternalAuthorisation()) {
                    try {
                        String resource_str = (this.server.isSSL() ? "https" : "http") + "://" + this.server.getHost() + ":" + this.server.getPort() + url_path;
                        URL resource = new URL(resource_str);
                        if (this.server.performExternalAuthorisation(resource, user, pw)) {
                            return user;
                        }
                    }
                    catch (MalformedURLException e) {
                        Debug.printStackTrace(e);
                    }
                    auth_failed = true;
                }
                if (this.server.hasInternalAuthorisation() && !auth_failed) {
                    try {
                        byte[] internal_pw;
                        SHA1Hasher hasher = new SHA1Hasher();
                        byte[] password = pw.getBytes();
                        byte[] encoded = password.length > 0 ? hasher.calculateHash(password) : new byte[]{};
                        if (user.equals("<internal>") ? Arrays.equals(internal_pw = Base64.decode(pw), this.server.getPassword()) : user.equalsIgnoreCase(this.server.getUsername()) && Arrays.equals(encoded, this.server.getPassword())) {
                            return user;
                        }
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            os.write(("HTTP/1.1 401 BAD\r\nWWW-Authenticate: Basic realm=\"" + this.server.getName() + "\"\r\n\r\nAccess Denied\r\n").getBytes());
            os.flush();
            return null;
        }
        return "";
    }

    protected boolean handleExternalRequest(InetSocketAddress client_address, String user, String url, String header, InputStream is, OutputStream os) throws IOException {
        URL absolute_url = new URL(this.server_url + (url.startsWith("/") ? url : "/" + url));
        return this.server.handleExternalRequest(client_address, user, url, absolute_url, header, is, os);
    }
}

