/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.udp;

import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketTracker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPTrackerCodecs;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.tracker.server.impl.udp.TRTrackerServerUDP;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRTrackerServerProcessorUDP
extends TRTrackerServerProcessor {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    public static final long CONNECTION_ID_LIFETIME = 180000L;
    private TRTrackerServerUDP server;
    private DatagramSocket socket;
    private DatagramPacket request_dg;
    private static Map connection_id_map = new LinkedHashMap();
    private static SecureRandom random = new SecureRandom();
    private static AEMonitor random_mon = new AEMonitor("TRTrackerServerUDP:rand");

    protected TRTrackerServerProcessorUDP(TRTrackerServerUDP _server, DatagramSocket _socket, DatagramPacket _packet) {
        this.server = _server;
        this.socket = _socket;
        this.request_dg = _packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSupport() {
        byte[] input_buffer = new byte[this.request_dg.getLength()];
        System.arraycopy(this.request_dg.getData(), 0, input_buffer, 0, input_buffer.length);
        int packet_data_length = input_buffer.length;
        String auth_user = null;
        byte[] auth_user_bytes = null;
        byte[] auth_hash = null;
        if (this.server.isTrackerPasswordEnabled()) {
            int user_len;
            if (input_buffer.length < 17) {
                Logger.log(new LogEvent(LOGID, 1, "TRTrackerServerProcessorUDP: packet received but authorisation missing"));
                return;
            }
            auth_user_bytes = new byte[8];
            auth_hash = new byte[8];
            System.arraycopy(input_buffer, packet_data_length -= 16, auth_user_bytes, 0, 8);
            for (user_len = 0; user_len < 8 && auth_user_bytes[user_len] != 0; ++user_len) {
            }
            auth_user = new String(auth_user_bytes, 0, user_len);
            System.arraycopy(input_buffer, packet_data_length + 8, auth_hash, 0, 8);
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(input_buffer, 0, packet_data_length));
        try {
            String client_ip_address = this.request_dg.getAddress().getHostAddress();
            PRUDPPacketRequest request2 = PRUDPPacketRequest.deserialiseRequest(null, is);
            Logger.log(new LogEvent(LOGID, "TRTrackerServerProcessorUDP: packet received: " + request2.getString()));
            PRUDPPacket reply = null;
            TRTrackerServerTorrentImpl torrent = null;
            if (auth_user_bytes != null) {
                byte[] sha1_pw = null;
                if (this.server.hasExternalAuthorisation()) {
                    try {
                        URL resource = new URL("udp://" + this.server.getHost() + ":" + this.server.getPort() + "/");
                        sha1_pw = this.server.performExternalAuthorisation(resource, auth_user);
                    }
                    catch (MalformedURLException e) {
                        Debug.printStackTrace(e);
                    }
                    if (sha1_pw == null) {
                        Logger.log(new LogEvent(LOGID, 3, "TRTrackerServerProcessorUDP: auth fails for user '" + auth_user + "'"));
                        reply = new PRUDPPacketReplyError(request2.getTransactionId(), "Access Denied");
                    }
                } else {
                    sha1_pw = this.server.getPassword();
                }
                if (reply == null) {
                    SHA1Hasher hasher = new SHA1Hasher();
                    hasher.update(input_buffer, 0, packet_data_length);
                    hasher.update(auth_user_bytes);
                    hasher.update(sha1_pw);
                    byte[] digest = hasher.getDigest();
                    for (int i = 0; i < auth_hash.length; ++i) {
                        if (auth_hash[i] == digest[i]) continue;
                        Logger.log(new LogEvent(LOGID, 3, "TRTrackerServerProcessorUDP: auth fails for user '" + auth_user + "'"));
                        reply = new PRUDPPacketReplyError(request2.getTransactionId(), "Access Denied");
                        break;
                    }
                }
            }
            if (reply == null) {
                try {
                    Object[] x;
                    int type = request2.getAction();
                    if (type == 0) {
                        reply = this.handleConnect(client_ip_address, request2);
                    } else if (type == 1) {
                        x = this.handleAnnounceAndScrape(client_ip_address, request2, 1);
                        reply = (PRUDPPacket)x[0];
                        torrent = (TRTrackerServerTorrentImpl)x[1];
                    } else if (type == 2) {
                        x = this.handleAnnounceAndScrape(client_ip_address, request2, 2);
                        reply = (PRUDPPacket)x[0];
                        torrent = (TRTrackerServerTorrentImpl)x[1];
                    } else {
                        reply = new PRUDPPacketReplyError(request2.getTransactionId(), "unsupported action");
                    }
                }
                catch (Throwable e) {
                    String error = e.getMessage();
                    if (error == null) {
                        error = e.toString();
                    }
                    reply = new PRUDPPacketReplyError(request2.getTransactionId(), error);
                }
            }
            if (reply != null) {
                InetAddress address = this.request_dg.getAddress();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream os = new DataOutputStream(baos);
                reply.serialise(os);
                byte[] output_buffer = baos.toByteArray();
                DatagramPacket reply_packet = new DatagramPacket(output_buffer, output_buffer.length, address, this.request_dg.getPort());
                this.socket.send(reply_packet);
                if (torrent != null) {
                    this.server.updateStats(torrent, input_buffer.length, output_buffer.length);
                }
            }
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "TRTrackerServerProcessorUDP: processing fails", e));
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable e) {}
        }
    }

    public void interruptTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long allocateConnectionId(String client_address) {
        try {
            random_mon.enter();
            long id = random.nextLong();
            Long new_key = new Long(id);
            connectionData new_data = new connectionData(client_address);
            Iterator it = connection_id_map.keySet().iterator();
            while (it.hasNext()) {
                Long key = (Long)it.next();
                connectionData data = (connectionData)connection_id_map.get(key);
                if (new_data.getTime() - data.getTime() <= 180000L) break;
                it.remove();
            }
            connection_id_map.put(new_key, new_data);
            long l = id;
            return l;
        }
        finally {
            random_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkConnectionId(String client_address, long id) {
        try {
            boolean ok;
            random_mon.enter();
            Long key = new Long(id);
            connectionData data = (connectionData)connection_id_map.get(key);
            if (data == null) {
                boolean bl = false;
                return bl;
            }
            connection_id_map.remove(key);
            boolean bl = ok = data.getAddress().equals(client_address);
            return bl;
        }
        finally {
            random_mon.exit();
        }
    }

    protected PRUDPPacket handleConnect(String client_ip_address, PRUDPPacketRequest request2) {
        long conn_id = this.allocateConnectionId(client_ip_address);
        PRUDPPacketReplyConnect reply = new PRUDPPacketReplyConnect(request2.getTransactionId(), conn_id);
        return reply;
    }

    protected Object[] handleAnnounceAndScrape(String client_ip_address, PRUDPPacketRequest request2, int request_type) throws Exception {
        if (!this.checkConnectionId(client_ip_address, request2.getConnectionId())) {
            return null;
        }
        byte[] hash_bytes = null;
        HashWrapper peer_id = null;
        short port = 0;
        String event2 = null;
        long uploaded = 0L;
        long downloaded = 0L;
        long left = 0L;
        int num_want = -1;
        String key = null;
        if (request_type == 1) {
            int i_ip;
            int i_event;
            PRUDPPacketRequest announce;
            if (PRUDPPacketTracker.VERSION == 1) {
                announce = (PRUDPPacketRequestAnnounce)request2;
                hash_bytes = ((PRUDPPacketRequestAnnounce)announce).getHash();
                peer_id = new HashWrapper(((PRUDPPacketRequestAnnounce)announce).getPeerId());
                port = ((PRUDPPacketRequestAnnounce)announce).getPort();
                i_event = ((PRUDPPacketRequestAnnounce)announce).getEvent();
                switch (i_event) {
                    case 2: {
                        event2 = "started";
                        break;
                    }
                    case 3: {
                        event2 = "stopped";
                        break;
                    }
                    case 1: {
                        event2 = "completed";
                    }
                }
                uploaded = ((PRUDPPacketRequestAnnounce)announce).getUploaded();
                downloaded = ((PRUDPPacketRequestAnnounce)announce).getDownloaded();
                left = ((PRUDPPacketRequestAnnounce)announce).getLeft();
                num_want = ((PRUDPPacketRequestAnnounce)announce).getNumWant();
                i_ip = ((PRUDPPacketRequestAnnounce)announce).getIPAddress();
                if (i_ip != 0) {
                    client_ip_address = PRHelpers.intToAddress(i_ip);
                }
            } else {
                announce = (PRUDPPacketRequestAnnounce2)request2;
                hash_bytes = ((PRUDPPacketRequestAnnounce2)announce).getHash();
                peer_id = new HashWrapper(((PRUDPPacketRequestAnnounce2)announce).getPeerId());
                port = ((PRUDPPacketRequestAnnounce2)announce).getPort();
                i_event = ((PRUDPPacketRequestAnnounce2)announce).getEvent();
                switch (i_event) {
                    case 2: {
                        event2 = "started";
                        break;
                    }
                    case 3: {
                        event2 = "stopped";
                        break;
                    }
                    case 1: {
                        event2 = "completed";
                    }
                }
                uploaded = ((PRUDPPacketRequestAnnounce2)announce).getUploaded();
                downloaded = ((PRUDPPacketRequestAnnounce2)announce).getDownloaded();
                left = ((PRUDPPacketRequestAnnounce2)announce).getLeft();
                num_want = ((PRUDPPacketRequestAnnounce2)announce).getNumWant();
                i_ip = ((PRUDPPacketRequestAnnounce2)announce).getIPAddress();
                if (i_ip != 0) {
                    client_ip_address = PRHelpers.intToAddress(i_ip);
                }
                key = "" + ((PRUDPPacketRequestAnnounce2)announce).getKey();
            }
        } else {
            PRUDPPacketRequestScrape scrape = (PRUDPPacketRequestScrape)request2;
            hash_bytes = scrape.getHash();
        }
        Map[] root_out = new Map[1];
        TRTrackerServerPeerImpl[] peer_out = new TRTrackerServerPeerImpl[1];
        TRTrackerServerTorrentImpl torrent = this.processTrackerRequest(this.server, "", root_out, peer_out, request_type, new byte[][]{hash_bytes}, null, peer_id, false, (byte)0, key, event2, false, port, 0, 0, client_ip_address, client_ip_address, downloaded, uploaded, left, num_want, (byte)0, (byte)1, 0, null);
        Map root = root_out[0];
        if (request_type == 1) {
            if (PRUDPPacketTracker.VERSION == 1) {
                PRUDPPacketReplyAnnounce reply = new PRUDPPacketReplyAnnounce(request2.getTransactionId());
                reply.setInterval(((Long)root.get("interval")).intValue());
                List peers = (List)root.get("peers");
                int[] addresses = new int[peers.size()];
                short[] ports = new short[addresses.length];
                for (int i = 0; i < addresses.length; ++i) {
                    Map peer = (Map)peers.get(i);
                    addresses[i] = PRHelpers.addressToInt(new String((byte[])peer.get("ip")));
                    ports[i] = ((Long)peer.get("port")).shortValue();
                }
                reply.setPeers(addresses, ports);
                return new Object[]{reply, torrent};
            }
            PRUDPPacketReplyAnnounce2 reply = new PRUDPPacketReplyAnnounce2(request2.getTransactionId());
            reply.setInterval(((Long)root.get("interval")).intValue());
            boolean local_scrape = client_ip_address.equals("127.0.0.1");
            Map scrape_details = torrent.exportScrapeToMap("", client_ip_address, !local_scrape);
            int seeders = ((Long)scrape_details.get("complete")).intValue();
            int leechers = ((Long)scrape_details.get("incomplete")).intValue();
            reply.setLeechersSeeders(leechers, seeders);
            List peers = (List)root.get("peers");
            int[] addresses = new int[peers.size()];
            short[] ports = new short[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                Map peer = (Map)peers.get(i);
                addresses[i] = PRHelpers.addressToInt(new String((byte[])peer.get("ip")));
                ports[i] = ((Long)peer.get("port")).shortValue();
            }
            reply.setPeers(addresses, ports);
            return new Object[]{reply, torrent};
        }
        if (PRUDPPacketTracker.VERSION == 1) {
            PRUDPPacketReplyScrape reply = new PRUDPPacketReplyScrape(request2.getTransactionId());
            Map files = (Map)root.get("files");
            byte[][] hashes = new byte[files.size()][];
            int[] s_complete = new int[hashes.length];
            int[] s_downloaded = new int[hashes.length];
            int[] s_incomplete = new int[hashes.length];
            Iterator it = files.keySet().iterator();
            int pos = 0;
            while (it.hasNext()) {
                String hash_str = (String)it.next();
                hashes[pos] = hash_str.getBytes("ISO-8859-1");
                Map details = (Map)files.get(hash_str);
                s_complete[pos] = ((Long)details.get("complete")).intValue();
                s_incomplete[pos] = ((Long)details.get("incomplete")).intValue();
                s_downloaded[pos] = ((Long)details.get("downloaded")).intValue();
                ++pos;
            }
            reply.setDetails(hashes, s_complete, s_downloaded, s_incomplete);
            return new Object[]{reply, torrent};
        }
        PRUDPPacketReplyScrape2 reply = new PRUDPPacketReplyScrape2(request2.getTransactionId());
        Map files = (Map)root.get("files");
        int[] s_complete = new int[files.size()];
        int[] s_downloaded = new int[s_complete.length];
        int[] s_incomplete = new int[s_complete.length];
        Iterator it = files.keySet().iterator();
        int pos = 0;
        while (it.hasNext()) {
            String hash_str = (String)it.next();
            Map details = (Map)files.get(hash_str);
            s_complete[pos] = ((Long)details.get("complete")).intValue();
            s_incomplete[pos] = ((Long)details.get("incomplete")).intValue();
            s_downloaded[pos] = ((Long)details.get("downloaded")).intValue();
            ++pos;
        }
        reply.setDetails(s_complete, s_downloaded, s_incomplete);
        return new Object[]{reply, torrent};
    }

    static {
        PRUDPTrackerCodecs.registerCodecs();
    }

    protected static class connectionData {
        protected String address;
        protected long time;

        protected connectionData(String _address) {
            this.address = _address;
            this.time = SystemTime.getCurrentTime();
        }

        protected String getAddress() {
            return this.address;
        }

        protected long getTime() {
            return this.time;
        }
    }
}

