/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.udp;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequestListener;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.udp.TRTrackerServerProcessorUDP;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ThreadPool;

public class TRTrackerServerUDP
extends TRTrackerServerImpl {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    protected static final int THREAD_POOL_SIZE = 10;
    protected ThreadPool thread_pool;
    protected int port;

    public TRTrackerServerUDP(String _name, int _port, boolean _start_up_ready) {
        super(_name, _start_up_ready);
        this.port = _port;
        this.thread_pool = new ThreadPool("TrackerServer:UDP:" + this.port, 10);
        try {
            DatagramSocket socket;
            InetSocketAddress address;
            InetAddress bind_ip = NetworkAdmin.getSingleton().getDefaultBindAddress();
            if (bind_ip == null) {
                address = new InetSocketAddress(InetAddress.getByName("127.0.0.1"), this.port);
                socket = new DatagramSocket(this.port);
            } else {
                address = new InetSocketAddress(bind_ip, this.port);
                socket = new DatagramSocket(address);
            }
            socket.setReuseAddress(true);
            final DatagramSocket f_socket = socket;
            final InetSocketAddress f_address = address;
            AEThread recv_thread = new AEThread("TRTrackerServerUDP:recv.loop"){

                public void runSupport() {
                    TRTrackerServerUDP.this.recvLoop(f_socket, f_address);
                }
            };
            recv_thread.setDaemon(true);
            recv_thread.start();
            Logger.log(new LogEvent(LOGID, "TRTrackerServerUDP: recv established on port " + this.port));
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "TRTrackerServerUDP: DatagramSocket bind failed on port " + this.port, e));
        }
    }

    protected void recvLoop(DatagramSocket socket, InetSocketAddress address) {
        long successful_accepts = 0L;
        long failed_accepts = 0L;
        while (true) {
            try {
                while (true) {
                    byte[] buf = new byte[8192];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length, address);
                    socket.receive(packet);
                    ++successful_accepts;
                    failed_accepts = 0L;
                    String ip = packet.getAddress().getHostAddress();
                    if (this.ip_filter.isInRange(ip, "Tracker")) continue;
                    this.thread_pool.run(new TRTrackerServerProcessorUDP(this, socket, packet));
                }
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, "TRTrackerServer: receive failed on port " + this.port, e));
                if ((++failed_accepts <= 100L || successful_accepts != 0L) && failed_accepts <= 1000L) continue;
                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + this.port, "UDP"});
                return;
            }
            break;
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return COConfigurationManager.getStringParameter("Tracker IP", "");
    }

    public boolean isSSL() {
        return false;
    }

    public void addRequestListener(TRTrackerServerRequestListener l) {
    }

    public void removeRequestListener(TRTrackerServerRequestListener l) {
    }
}

