/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class AEDiagnostics {
    public static final boolean ALWAYS_PASS_HASH_CHECKS = false;
    public static final boolean USE_DUMMY_FILE_DATA = false;
    public static final boolean CHECK_DUMMY_FILE_DATA = false;
    public static final boolean DEBUG_MONITOR_SEM_USAGE = false;
    public static final boolean DEBUG_THREADS = true;
    public static final boolean TRACE_DIRECT_BYTE_BUFFERS = false;
    public static final boolean TRACE_DBB_POOL_USAGE = false;
    public static final boolean PRINT_DBB_POOL_USAGE = false;
    public static final boolean TRACE_TCP_TRANSPORT_STATS = false;
    public static final boolean TRACE_CONNECTION_DROPS = false;
    private static final int MAX_FILE_SIZE = 262144;
    private static final String CONFIG_KEY = "diagnostics.tidy_close";
    private static File debug_dir;
    private static File debug_save_dir;
    private static boolean started_up;
    private static boolean startup_complete;
    private static Map loggers;
    private static boolean loggers_enabled;
    private static List evidence_generators;
    private static boolean load_15_tried;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void startup() {
        if (started_up) {
            return;
        }
        started_up = true;
        try {
            debug_dir = FileUtil.getUserFile("logs");
            debug_save_dir = new File(debug_dir, "save");
            loggers_enabled = COConfigurationManager.getBooleanParameter("Logger.DebugFiles.Enabled", true);
            boolean was_tidy = COConfigurationManager.getBooleanParameter(CONFIG_KEY);
            SimpleTimer.addEvent("AEDiagnostics:logCleaner", SystemTime.getCurrentTime() + 60000L + (long)((int)(Math.random() * 15000.0)), new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    AEDiagnostics.cleanOldLogs();
                }
            });
            if (debug_dir.exists()) {
                long now = SystemTime.getCurrentTime();
                debug_save_dir.mkdir();
                File[] files = debug_dir.listFiles();
                if (files != null) {
                    boolean file_copied = false;
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file.isDirectory() || was_tidy) continue;
                        file_copied = true;
                        FileUtil.copyFile(file, new File(debug_save_dir, now + "_" + file.getName()));
                    }
                    if (file_copied) {
                        Logger.logTextResource(new LogAlert(false, 1, "diagnostics.log_found"), new String[]{debug_save_dir.toString()});
                    }
                }
            } else {
                debug_dir.mkdir();
            }
        }
        catch (Throwable e) {
            if (!(e instanceof NoClassDefFoundError)) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            startup_complete = true;
            AEDiagnostics.load15Stuff();
        }
    }

    protected static void load15Stuff() {
        if (load_15_tried) {
            return;
        }
        load_15_tried = true;
        try {
            Class.forName("com.aelitis.azureus.jdk15.Java15Initialiser");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static void cleanOldLogs() {
        try {
            long now = SystemTime.getCurrentTime();
            File[] files = debug_save_dir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    long last_modified;
                    File file = files[i];
                    if (file.isDirectory() || now - (last_modified = file.lastModified()) <= 2592000000L) continue;
                    file.delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isStartupComplete() {
        return startup_complete;
    }

    public static synchronized AEDiagnosticsLogger getLogger(String name) {
        AEDiagnosticsLogger logger = (AEDiagnosticsLogger)loggers.get(name);
        if (logger == null) {
            AEDiagnostics.startup();
            logger = new AEDiagnosticsLogger(name);
            try {
                File f1 = AEDiagnostics.getLogFile(logger);
                logger.setFirstFile(false);
                File f2 = AEDiagnostics.getLogFile(logger);
                logger.setFirstFile(true);
                if (f1.exists() && f2.exists() && f1.lastModified() < f2.lastModified()) {
                    logger.setFirstFile(false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            loggers.put(name, logger);
        }
        return logger;
    }

    public static void logWithStack(String logger_name, String str) {
        AEDiagnostics.log(logger_name, str + ": " + Debug.getCompressedStackTrace());
    }

    public static void log(String logger_name, String str) {
        AEDiagnostics.getLogger(logger_name).log(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void log(AEDiagnosticsLogger logger, String str) {
        if (!loggers_enabled) {
            return;
        }
        try {
            File log_file = AEDiagnostics.getLogFile(logger);
            if (log_file.length() >= 262144L) {
                logger.setFirstFile(!logger.isFirstFile());
                log_file = AEDiagnostics.getLogFile(logger);
                log_file.delete();
            }
            Calendar now = GregorianCalendar.getInstance();
            String timeStamp = "[" + AEDiagnostics.format(now.get(5)) + AEDiagnostics.format(now.get(2) + 1) + " " + AEDiagnostics.format(now.get(11)) + ":" + AEDiagnostics.format(now.get(12)) + ":" + AEDiagnostics.format(now.get(13)) + "] ";
            str = timeStamp + str;
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new FileWriter(log_file, true));
                pw.println(str);
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static File getLogFile(AEDiagnosticsLogger logger) {
        return new File(debug_dir, logger.getName() + "_" + (logger.isFirstFile() ? "1" : "2") + ".log");
    }

    private static String format(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return String.valueOf(n);
    }

    protected static void log(AEDiagnosticsLogger logger, Throwable e) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
            e.printStackTrace(pw);
            pw.close();
            AEDiagnostics.log(logger, baos.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void markDirty() {
        try {
            COConfigurationManager.setParameter(CONFIG_KEY, false);
            COConfigurationManager.save();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static boolean isDirty() {
        return !COConfigurationManager.getBooleanParameter(CONFIG_KEY);
    }

    public static void markClean() {
        try {
            COConfigurationManager.setParameter(CONFIG_KEY, true);
            COConfigurationManager.save();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEvidenceGenerator(AEDiagnosticsEvidenceGenerator gen) {
        List list = evidence_generators;
        synchronized (list) {
            evidence_generators.add(gen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateEvidence(PrintWriter _writer) {
        IndentWriter writer = new IndentWriter(_writer);
        List list = evidence_generators;
        synchronized (list) {
            for (int i = 0; i < evidence_generators.size(); ++i) {
                try {
                    ((AEDiagnosticsEvidenceGenerator)evidence_generators.get(i)).generate(writer);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace(_writer);
                }
            }
        }
        writer.println("Memory");
        try {
            writer.indent();
            Runtime rt = Runtime.getRuntime();
            writer.println("max=" + rt.maxMemory() + ",total=" + rt.totalMemory() + ",free=" + rt.freeMemory());
        }
        finally {
            writer.exdent();
        }
    }

    static {
        loggers = new HashMap();
        evidence_generators = new ArrayList();
    }
}

