/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;

public class Average {
    private int refreshRate;
    private int period;
    private int nbElements;
    private long lastUpdate;
    private long[] values;

    protected Average(int _refreshRate, int _period) {
        this.refreshRate = _refreshRate;
        this.period = _period;
        this.nbElements = _period * 1000 / _refreshRate + 2;
        this.lastUpdate = this.getEffectiveTime() / (long)_refreshRate;
        this.values = new long[this.nbElements];
    }

    public static Average getInstance(int refreshRate, int period) {
        if (refreshRate < 100) {
            return null;
        }
        if (period * 1000 < refreshRate) {
            return null;
        }
        return new Average(refreshRate, period);
    }

    private synchronized void update(long timeFactor) {
        if (this.lastUpdate < timeFactor - (long)this.nbElements) {
            this.lastUpdate = timeFactor - (long)this.nbElements - 1L;
        }
        for (long i = this.lastUpdate + 1L; i <= timeFactor; ++i) {
            this.values[(int)(i % (long)this.nbElements)] = 0L;
        }
        this.values[(int)((timeFactor + 1L) % (long)this.nbElements)] = 0L;
        this.lastUpdate = timeFactor;
    }

    public void addValue(long value) {
        long timeFactor = this.getEffectiveTime() / (long)this.refreshRate;
        this.update(timeFactor);
        int n = (int)(timeFactor % (long)this.nbElements);
        this.values[n] = this.values[n] + value;
    }

    public long getAverage() {
        return this.getSum() / (long)this.period;
    }

    public double getDoubleAverage() {
        return (double)this.getSum() / (double)this.period;
    }

    public String getDoubleAverageAsString(int precision) {
        return DisplayFormatters.formatDecimal(this.getDoubleAverage(), precision);
    }

    protected final long getSum() {
        long timeFactor = this.getEffectiveTime() / (long)this.refreshRate;
        this.update(timeFactor);
        long sum = 0L;
        for (long i = timeFactor + 2L; i < timeFactor + (long)this.nbElements; ++i) {
            sum += this.values[(int)(i % (long)this.nbElements)];
        }
        return sum;
    }

    protected long getEffectiveTime() {
        return SystemTime.getCurrentTime();
    }
}

