/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.SystemTime;

public class Debug {
    private static AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("debug");

    public static void out(String _debug_message) {
        Debug.out(_debug_message, null);
    }

    public static void out(Throwable _exception) {
        Debug.out("", _exception);
    }

    public static void outNoStack(String str) {
        Debug.outNoStack(str, false);
    }

    public static void outNoStack(String str, boolean stderr) {
        Debug.diagLoggerLogAndOut("DEBUG::" + new Date(SystemTime.getCurrentTime()).toString() + "  " + str, stderr);
    }

    public static void outDiagLoggerOnly(String str) {
        Debug.diagLoggerLog(str);
    }

    public static void out(String _debug_msg, Throwable _exception) {
        String header = "DEBUG::";
        header = header + new Date(SystemTime.getCurrentTime()).toString() + "::";
        String trace_trace_tail = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] st = e.getStackTrace();
            StackTraceElement first_line = st[2];
            String className = first_line.getClassName() + "::";
            String methodName = first_line.getMethodName() + "::";
            int lineNumber = first_line.getLineNumber();
            trace_trace_tail = Debug.getCompressedStackTrace(e, 3, 200);
            Debug.diagLoggerLogAndOut(header + className + methodName + lineNumber + ":", true);
            if (_debug_msg.length() > 0) {
                Debug.diagLoggerLogAndOut("  " + _debug_msg, true);
            }
            if (trace_trace_tail != null) {
                Debug.diagLoggerLogAndOut("    " + trace_trace_tail, true);
            }
            if (_exception != null) {
                Debug.diagLoggerLogAndOut(_exception);
            }
            return;
        }
    }

    public static String getLastCaller() {
        return Debug.getLastCaller(0);
    }

    public static String getLastCaller(int numToGoBackFurther) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] st = e.getStackTrace();
            if (st == null || st.length == 0) {
                return "??";
            }
            if (st.length > 3 + numToGoBackFurther) {
                return st[3 + numToGoBackFurther].toString();
            }
            return st[st.length - 1].toString();
        }
    }

    public static void outStackTrace() {
        Debug.diagLoggerLogAndOut(Debug.getStackTrace(1), false);
    }

    private static String getStackTrace(int endNumToSkip) {
        String sStackTrace = "";
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] st = e.getStackTrace();
            for (int i = 1; i < st.length - endNumToSkip; ++i) {
                if (st[i].getMethodName().endsWith("StackTrace")) continue;
                sStackTrace = sStackTrace + st[i].toString() + "\n";
            }
            if (e.getCause() != null) {
                sStackTrace = sStackTrace + "\tCaused By: " + Debug.getStackTrace(e.getCause()) + "\n";
            }
            return sStackTrace;
        }
    }

    public static void killAWTThreads() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Debug.killAWTThreads(threadGroup);
    }

    private static String getCompressedStackTrace(Throwable t, int frames_to_skip) {
        return Debug.getCompressedStackTrace(t, frames_to_skip, 200);
    }

    private static String getCompressedStackTrace(Throwable t, int frames_to_skip, int iMaxLines) {
        String sStackTrace = "";
        StackTraceElement[] st = t.getStackTrace();
        int iMax = Math.min(st.length, iMaxLines + frames_to_skip);
        for (int i = frames_to_skip; i < iMax; ++i) {
            if (i > frames_to_skip) {
                sStackTrace = sStackTrace + ",";
            }
            String cn = st[i].getClassName();
            cn = cn.substring(cn.lastIndexOf(".") + 1);
            sStackTrace = sStackTrace + cn + "::" + st[i].getMethodName() + "::" + st[i].getLineNumber();
        }
        if (t.getCause() != null) {
            sStackTrace = sStackTrace + "\n\tCaused By: " + Debug.getCompressedStackTrace(t, 0);
        }
        return sStackTrace;
    }

    public static String getStackTrace(boolean bCompressed, boolean bIncludeSelf) {
        return Debug.getStackTrace(bCompressed, bIncludeSelf, bIncludeSelf ? 0 : 1, 200);
    }

    public static String getStackTrace(boolean bCompressed, boolean bIncludeSelf, int iNumLinesToSkip, int iMaxLines) {
        if (bCompressed) {
            return Debug.getCompressedStackTrace(bIncludeSelf ? 2 + iNumLinesToSkip : 3 + iNumLinesToSkip, iMaxLines);
        }
        return Debug.getStackTrace(1);
    }

    private static String getCompressedStackTrace(int frames_to_skip, int iMaxLines) {
        String trace_trace_tail = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            trace_trace_tail = Debug.getCompressedStackTrace(e, frames_to_skip, iMaxLines);
            return trace_trace_tail;
        }
    }

    public static void killAWTThreads(ThreadGroup threadGroup) {
        Thread[] threadList = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadList);
        for (int i = 0; i < threadList.length; ++i) {
            String name;
            Thread t = threadList[i];
            if (t == null || !(name = t.getName()).startsWith("AWT")) continue;
            Debug.out("Interrupting thread '".concat(t.toString()).concat("'"));
            t.interrupt();
        }
        if (threadGroup.getParent() != null) {
            Debug.killAWTThreads(threadGroup.getParent());
        }
    }

    public static void dumpThreads(String name) {
        Debug.out(name + ":");
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Debug.dumpThreads(threadGroup, "\t");
    }

    public static void dumpThreads(ThreadGroup threadGroup, String indent) {
        Thread[] threadList = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadList);
        for (int i = 0; i < threadList.length; ++i) {
            Thread t = threadList[i];
            if (t == null) continue;
            Debug.out(indent.concat("active thread = ").concat(t.toString()).concat(", daemon = ").concat(String.valueOf(t.isDaemon())));
        }
        if (threadGroup.getParent() != null) {
            Debug.dumpThreads(threadGroup.getParent(), indent + "\t");
        }
    }

    public static void dumpThreadsLoop(final String name) {
        new AEThread("Thread Dumper"){

            public void runSupport() {
                while (true) {
                    Debug.dumpThreads(name);
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public static void dumpSystemProperties() {
        Debug.out("System Properties:");
        Properties props = System.getProperties();
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Debug.out("\t".concat(name).concat(" = '").concat(props.get(name).toString()).concat("'"));
        }
    }

    public static String getNestedExceptionMessage(Throwable e) {
        String last_message = "";
        while (e != null) {
            String this_message = e instanceof UnknownHostException ? "Unknown host " + e.getMessage() : e.getMessage();
            if (this_message == null || this_message.length() == 0) {
                this_message = e.getClass().getName();
                int pos = this_message.lastIndexOf(".");
                this_message = this_message.substring(pos + 1);
            }
            if (last_message.indexOf(this_message) == -1) {
                last_message = this_message + (last_message.length() == 0 ? "" : ", " + last_message);
            }
            e = e.getCause();
        }
        return last_message;
    }

    public static String getNestedExceptionMessageAndStack(Throwable e) {
        return Debug.getNestedExceptionMessage(e) + ", " + Debug.getCompressedStackTrace(e, 2);
    }

    public static String getCompressedStackTrace() {
        return Debug.getCompressedStackTrace(new Throwable(), 2);
    }

    public static String getExceptionMessage(Throwable e) {
        String message = e.getMessage();
        if (message == null || message.length() == 0) {
            message = e.getClass().getName();
            int pos = message.lastIndexOf(".");
            message = message.substring(pos + 1);
        } else if (e instanceof ClassNotFoundException && message.toLowerCase().indexOf("found") == -1) {
            message = "Class " + message + " not found";
        }
        return message;
    }

    public static void printStackTrace(Throwable e) {
        String header = "DEBUG::";
        header = header + new Date(SystemTime.getCurrentTime()).toString() + "::";
        String className = "?::";
        String methodName = "?::";
        int lineNumber = -1;
        try {
            throw new Exception();
        }
        catch (Exception f) {
            StackTraceElement[] st = f.getStackTrace();
            for (int i = 1; i < st.length; ++i) {
                StackTraceElement first_line = st[i];
                className = first_line.getClassName() + "::";
                methodName = first_line.getMethodName() + "::";
                lineNumber = first_line.getLineNumber();
                if (className.indexOf(".logging.") == -1 && !className.endsWith(".Debug")) break;
            }
            Debug.diagLoggerLogAndOut(header + className + methodName + lineNumber + ":", true);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
                e.printStackTrace(pw);
                pw.close();
                String stack = baos.toString();
                Debug.diagLoggerLogAndOut("  " + stack, true);
            }
            catch (Throwable ignore) {
                e.printStackTrace();
            }
            return;
        }
    }

    public static String getStackTrace(Throwable e) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
            e.printStackTrace(pw);
            pw.close();
            return baos.toString();
        }
        catch (Throwable ignore) {
            return "";
        }
    }

    private static void diagLoggerLog(String str) {
        diag_logger.log(str);
    }

    private static void diagLoggerLogAndOut(String str, boolean stderr) {
        if (diag_logger == null) {
            if (stderr) {
                System.err.println(str);
            } else {
                System.out.println(str);
            }
        } else {
            diag_logger.logAndOut(str, stderr);
        }
    }

    private static void diagLoggerLogAndOut(Throwable e) {
        if (diag_logger == null) {
            e.printStackTrace();
        } else {
            diag_logger.logAndOut(e);
        }
    }

    public static String secretFileName(String key) {
        if (key == null) {
            return "";
        }
        String sep = File.separator;
        String regex = "([\\" + sep + "][^\\" + sep + "]{0,3}+)[^\\" + sep + "]*";
        String secretName = key.replaceAll(regex, "$1");
        int iExtensionPos = key.lastIndexOf(".");
        if (iExtensionPos >= 0) {
            secretName = secretName + key.substring(iExtensionPos);
        }
        return secretName;
    }
}

