/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Properties;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class SystemProperties {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String SYS_PROP_CONFIG_OVERRIDE = "azureus.config.path";
    public static final String SEP = System.getProperty("file.separator");
    public static String APPLICATION_NAME = "Azureus";
    private static String APPLICATION_ID = "az";
    private static String APPLICATION_ENTRY_POINT = "org.gudy.azureus2.ui.swt.Main";
    private static final String WIN_DEFAULT = "Application Data";
    private static final String OSX_DEFAULT = "Library" + SEP + "Application Support";
    private static String user_path;
    private static String app_path;

    public static void setApplicationName(String name) {
        if (name != null && name.trim().length() > 0) {
            name = name.trim();
            if (user_path != null && !name.equals(APPLICATION_NAME)) {
                System.out.println("**** SystemProperties::setApplicationName called too late! ****");
            }
            APPLICATION_NAME = name;
        }
    }

    public static void setApplicationIdentifier(String application_id) {
        if (application_id != null && application_id.trim().length() > 0) {
            APPLICATION_ID = application_id.trim();
        }
    }

    public static void setApplicationEntryPoint(String entry_point) {
        if (entry_point != null && entry_point.trim().length() > 0) {
            APPLICATION_ENTRY_POINT = entry_point.trim();
        }
    }

    public static String getApplicationName() {
        return APPLICATION_NAME;
    }

    public static String getApplicationIdentifier() {
        return APPLICATION_ID;
    }

    public static String getApplicationEntryPoint() {
        return APPLICATION_ENTRY_POINT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserPath() {
        if (user_path != null) {
            return user_path;
        }
        String temp_user_path = System.getProperty(SYS_PROP_CONFIG_OVERRIDE);
        try {
            File dir;
            block25: {
                if (temp_user_path != null) {
                    File dir2;
                    if (!temp_user_path.endsWith(SEP)) {
                        temp_user_path = temp_user_path + SEP;
                    }
                    if (!(dir2 = new File(temp_user_path)).exists()) {
                        FileUtil.mkdirs(dir2);
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Custom): user_path = " + temp_user_path));
                    }
                    String string = temp_user_path;
                    return string;
                }
                PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
                try {
                    temp_user_path = platformManager.getLocation(1L).getPath() + SEP;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath: user_path = " + temp_user_path));
                    }
                }
                catch (Exception e) {
                    if (!Logger.isEnabled()) break block25;
                    Logger.log(new LogEvent(LOGID, "Unable to retrieve user config path from " + platformManager.getClass().getName() + "Make sure aereg.dll is present."));
                }
            }
            if (temp_user_path == null) {
                String userhome = System.getProperty("user.home");
                if (Constants.isWindows) {
                    temp_user_path = SystemProperties.getEnvironmentalVariable("APPDATA");
                    if (temp_user_path != null && temp_user_path.length() > 0) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Using user config path from APPDATA env var instead: " + temp_user_path));
                        }
                    } else {
                        temp_user_path = userhome + SEP + WIN_DEFAULT;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Using user config path from java user.home var instead: " + temp_user_path));
                        }
                    }
                    temp_user_path = temp_user_path + SEP + APPLICATION_NAME + SEP;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Win): user_path = " + temp_user_path));
                    }
                } else if (Constants.isOSX) {
                    temp_user_path = userhome + SEP + OSX_DEFAULT + SEP + APPLICATION_NAME + SEP;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Mac): user_path = " + temp_user_path));
                    }
                } else {
                    temp_user_path = userhome + SEP + "." + APPLICATION_NAME.toLowerCase() + SEP;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Unix): user_path = " + temp_user_path));
                    }
                }
            }
            if (!(dir = new File(temp_user_path)).exists()) {
                FileUtil.mkdirs(dir);
            }
            String string = temp_user_path;
            return string;
        }
        finally {
            user_path = temp_user_path;
        }
    }

    public static String getApplicationPath() {
        if (app_path != null) {
            return app_path;
        }
        String temp_app_path = System.getProperty("azureus.install.path", System.getProperty("user.dir"));
        if (!temp_app_path.endsWith(SEP)) {
            temp_app_path = temp_app_path + SEP;
        }
        app_path = temp_app_path;
        return app_path;
    }

    public static boolean isJavaWebStartInstance() {
        try {
            String java_ws_prop = System.getProperty("azureus.javaws");
            return java_ws_prop != null && java_ws_prop.equals("true");
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String getEnvironmentalVariable(String _var) {
        Properties envVars;
        block7: {
            Process p = null;
            envVars = new Properties();
            Runtime r = Runtime.getRuntime();
            BufferedReader br = null;
            if (Constants.isWindows9598ME) {
                return "";
            }
            try {
                String line;
                p = Constants.isWindows ? r.exec("cmd.exe /c set") : r.exec("env");
                String system_encoding = LocaleUtil.getSingleton().getSystemEncoding();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "SystemProperties::getEnvironmentalVariable - " + _var + ", system encoding = " + system_encoding));
                }
                br = new BufferedReader(new InputStreamReader(p.getInputStream(), system_encoding), 8192);
                while ((line = br.readLine()) != null) {
                    int idx = line.indexOf(61);
                    if (idx < 0) continue;
                    String key = line.substring(0, idx);
                    String value = line.substring(idx + 1);
                    envVars.setProperty(key, value);
                }
                br.close();
            }
            catch (Throwable t) {
                if (br == null) break block7;
                try {
                    br.close();
                }
                catch (Exception ingore) {
                    // empty catch block
                }
            }
        }
        return envVars.getProperty(_var, "");
    }

    public static String getDocPath() {
        PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
        File fDocPath = null;
        try {
            fDocPath = platformManager.getLocation(3L);
        }
        catch (PlatformManagerException platformManagerException) {
            // empty catch block
        }
        if (fDocPath == null) {
            fDocPath = new File(SystemProperties.getUserPath(), "Documents");
        }
        return fDocPath.getAbsolutePath();
    }
}

