/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;

public class SystemTime {
    public static final long TIME_GRANULARITY_MILLIS = 25L;
    private static SystemTimeProvider instance;
    private static volatile List consumer_list;
    private static volatile List clock_change_list;
    private static highPrecisionCounter high_precision_counter;
    private static long hpc_base_time;
    private static long hpc_last_time;

    public static void useRawProvider() {
        if (!(instance instanceof RawProvider)) {
            instance = new RawProvider();
        }
    }

    public static long getCurrentTime() {
        return instance.getTime();
    }

    public static long getOffsetTime(long offsetMS) {
        return instance.getTime() + offsetMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConsumer(consumer c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<consumer> new_list = new ArrayList<consumer>(consumer_list);
            new_list.add(c);
            consumer_list = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterConsumer(consumer c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList new_list = new ArrayList(consumer_list);
            new_list.remove(c);
            consumer_list = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClockChangeListener(consumer c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<consumer> new_list = new ArrayList<consumer>(clock_change_list);
            new_list.add(c);
            clock_change_list = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterClockChangeListener(consumer c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList new_list = new ArrayList(clock_change_list);
            new_list.remove(c);
            clock_change_list = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getHighPrecisionCounter() {
        if (high_precision_counter == null) {
            AEDiagnostics.load15Stuff();
            Class clazz = SystemTime.class;
            synchronized (clazz) {
                long now = SystemTime.getCurrentTime();
                if (now < hpc_last_time) {
                    long gone_back_by_at_least = hpc_last_time - now;
                    hpc_base_time -= gone_back_by_at_least;
                }
                hpc_last_time = now;
                return (now - hpc_base_time) * 1000000L;
            }
        }
        return high_precision_counter.nanoTime();
    }

    public static void registerHighPrecisionCounter(highPrecisionCounter counter) {
        high_precision_counter = counter;
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 1) {
            int f_i = i++;
            new Thread(){

                public void run() {
                    long start = SystemTime.getCurrentTime();
                    while (true) {
                        long now = SystemTime.getCurrentTime();
                        System.out.println(now - start);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable e) {
                        }
                    }
                }
            }.start();
        }
    }

    static {
        try {
            instance = System.getProperty("azureus.time.use.raw.provider", "0").equals("1") ? new RawProvider() : new SteppedProvider();
        }
        catch (Throwable e) {
            instance = new SteppedProvider();
        }
        consumer_list = new ArrayList();
        clock_change_list = new ArrayList();
    }

    public static interface highPrecisionCounter {
        public long nanoTime();
    }

    public static interface consumer {
        public void consume(long var1);
    }

    protected static class RawProvider
    implements SystemTimeProvider {
        private static final int STEPS_PER_SECOND = 40;
        private final Thread updater;

        private RawProvider() {
            System.out.println("SystemTime: using raw time provider");
            this.updater = new Thread("SystemTime"){
                long last_time;

                public void run() {
                    while (true) {
                        long offset;
                        long current_time = System.currentTimeMillis();
                        List consumer_list_ref = consumer_list;
                        if (this.last_time != 0L && ((offset = current_time - this.last_time) < 0L || offset > 5000L)) {
                            Iterator it = clock_change_list.iterator();
                            while (it.hasNext()) {
                                ((consumer)it.next()).consume(offset);
                            }
                        }
                        this.last_time = current_time;
                        for (int i = 0; i < consumer_list_ref.size(); ++i) {
                            consumer cons = (consumer)consumer_list_ref.get(i);
                            try {
                                cons.consume(current_time);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        try {
                            Thread.sleep(25L);
                            continue;
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                            continue;
                        }
                        break;
                    }
                }
            };
            this.updater.setDaemon(true);
            this.updater.setPriority(10);
            this.updater.start();
        }

        public long getTime() {
            return System.currentTimeMillis();
        }
    }

    protected static class SteppedProvider
    implements SystemTimeProvider {
        private static final int STEPS_PER_SECOND = 40;
        private final Thread updater;
        private volatile long stepped_time = System.currentTimeMillis();
        private volatile long last_approximate_time;
        private volatile int access_count;
        private volatile int slice_access_count;
        private volatile int access_average_per_slice;
        private volatile int drift_adjusted_granularity;

        private SteppedProvider() {
            this.updater = new Thread("SystemTime"){

                public void run() {
                    Average access_average = null;
                    Average drift_average = null;
                    long last_second = 0L;
                    int tick_count = 0;
                    while (true) {
                        SteppedProvider.this.stepped_time = System.currentTimeMillis();
                        List consumer_list_ref = consumer_list;
                        if (last_second == 0L) {
                            last_second = SteppedProvider.this.stepped_time - 1000L;
                        } else {
                            long offset = SteppedProvider.this.stepped_time - last_second;
                            if (offset < 0L || offset > 5000L) {
                                SteppedProvider.this.last_approximate_time = 0L;
                                last_second = SteppedProvider.this.stepped_time - 1000L;
                                access_average = null;
                                drift_average = null;
                                Iterator it = clock_change_list.iterator();
                                while (it.hasNext()) {
                                    ((consumer)it.next()).consume(offset);
                                }
                            }
                        }
                        if (++tick_count == 40) {
                            if (access_average == null) {
                                access_average = Average.getInstance(1000, 10);
                                drift_average = Average.getInstance(1000, 10);
                            }
                            long drift = SteppedProvider.this.stepped_time - last_second - 1000L;
                            last_second = SteppedProvider.this.stepped_time;
                            drift_average.addValue(drift);
                            SteppedProvider.this.drift_adjusted_granularity = (int)(25L + drift_average.getAverage() / 40L);
                            access_average.addValue(SteppedProvider.this.access_count);
                            SteppedProvider.this.access_average_per_slice = (int)(access_average.getAverage() / 40L);
                            SteppedProvider.this.access_count = 0;
                            tick_count = 0;
                        }
                        SteppedProvider.this.slice_access_count = 0;
                        for (int i = 0; i < consumer_list_ref.size(); ++i) {
                            consumer cons = (consumer)consumer_list_ref.get(i);
                            try {
                                cons.consume(SteppedProvider.this.stepped_time);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        try {
                            Thread.sleep(25L);
                            continue;
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                            continue;
                        }
                        break;
                    }
                }
            };
            this.updater.setDaemon(true);
            this.updater.setPriority(10);
            this.updater.start();
        }

        public long getTime() {
            long adjusted_time = this.stepped_time;
            long temp = this.access_average_per_slice;
            if (temp > 0L) {
                long x = (long)(this.drift_adjusted_granularity * this.slice_access_count) / temp;
                if (x >= (long)this.drift_adjusted_granularity) {
                    x = this.drift_adjusted_granularity - 1;
                }
                adjusted_time += x;
            }
            ++this.access_count;
            ++this.slice_access_count;
            if (adjusted_time < this.last_approximate_time) {
                adjusted_time = this.last_approximate_time;
            } else {
                this.last_approximate_time = adjusted_time;
            }
            return adjusted_time;
        }
    }

    protected static interface SystemTimeProvider {
        public long getTime();
    }
}

