/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.DebugLight;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class TimerEventPeriodic
implements TimerEventPerformer {
    private Timer timer;
    private long frequency;
    private TimerEventPerformer performer;
    private String name;
    private TimerEvent current_event;
    private boolean cancelled;

    protected TimerEventPeriodic(Timer _timer, long _frequency, TimerEventPerformer _performer) {
        this.timer = _timer;
        this.frequency = _frequency;
        this.performer = _performer;
        this.current_event = this.timer.addEvent(SystemTime.getCurrentTime() + this.frequency, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String _name) {
        this.name = _name;
        TimerEventPeriodic timerEventPeriodic = this;
        synchronized (timerEventPeriodic) {
            if (this.current_event != null) {
                this.current_event.setName(this.name);
            }
        }
    }

    protected TimerEventPerformer getPerformer() {
        return this.performer;
    }

    protected long getFrequency() {
        return this.frequency;
    }

    protected boolean isCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(TimerEvent event2) {
        if (!this.cancelled) {
            try {
                this.performer.perform(event2);
            }
            catch (Throwable e) {
                DebugLight.printStackTrace(e);
            }
            TimerEventPeriodic timerEventPeriodic = this;
            synchronized (timerEventPeriodic) {
                if (!this.cancelled) {
                    this.current_event = this.timer.addEvent(this.name, SystemTime.getCurrentTime() + this.frequency, (TimerEventPerformer)this);
                }
            }
        }
    }

    public synchronized void cancel() {
        if (this.current_event != null) {
            this.current_event.cancel();
            this.cancelled = true;
        }
    }

    protected String getString() {
        TimerEvent ce = this.current_event;
        String ev_data = ce == null ? "?" : "when=" + ce.getWhen() + ",run=" + ce.hasRun() + ", can=" + ce.isCancelled();
        return ev_data + ",freq=" + this.getFrequency() + ",target=" + this.getPerformer() + (this.name == null ? "" : ",name=" + this.name);
    }
}

