/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class TrackersUtil {
    private List trackers = new ArrayList();
    private Map multiTrackers = new HashMap();
    private static TrackersUtil instance;
    private static AEMonitor class_mon;

    private TrackersUtil() {
        this.loadList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrackersUtil getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new TrackersUtil();
            }
            TrackersUtil trackersUtil = instance;
            return trackersUtil;
        }
        finally {
            class_mon.exit();
        }
    }

    public List getTrackersList() {
        if (this.trackers != null) {
            return new ArrayList(this.trackers);
        }
        return null;
    }

    public void addTracker(String trackerAnnounceUrl) {
        if (this.trackers.contains(trackerAnnounceUrl)) {
            return;
        }
        this.trackers.add(0, trackerAnnounceUrl);
        this.saveList();
    }

    public void addMultiTracker(String configName, List groups) {
        this.multiTrackers.put(configName, groups);
        this.saveList();
    }

    public void removeMultiTracker(String configName) {
        this.multiTrackers.remove(configName);
        this.saveList();
    }

    public Map getMultiTrackers() {
        return new HashMap(this.multiTrackers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadList() {
        File fTrackers = FileUtil.getUserFile("trackers.config");
        if (fTrackers.exists() && fTrackers.isFile()) {
            FileInputStream fin = null;
            BufferedInputStream bin = null;
            try {
                Map mapMT;
                fin = new FileInputStream(fTrackers);
                bin = new BufferedInputStream(fin, 8192);
                Map map = BDecoder.decode(bin);
                List list = (List)map.get("trackers");
                if (list != null) {
                    Iterator iter = list.iterator();
                    while (iter.hasNext()) {
                        String tracker = new String((byte[])iter.next());
                        this.trackers.add(tracker);
                    }
                }
                if ((mapMT = (Map)map.get("multi-trackers")) != null) {
                    Iterator iter = mapMT.keySet().iterator();
                    while (iter.hasNext()) {
                        String configName = (String)iter.next();
                        List groups = (List)mapMT.get(configName);
                        ArrayList resGroups = new ArrayList(groups.size());
                        Iterator iterGroups = groups.iterator();
                        while (iterGroups.hasNext()) {
                            List theseTrackers = (List)iterGroups.next();
                            ArrayList<String> resTrackers = new ArrayList<String>(theseTrackers.size());
                            Iterator iterTrackers = theseTrackers.iterator();
                            while (iterTrackers.hasNext()) {
                                String tracker = new String((byte[])iterTrackers.next());
                                resTrackers.add(tracker);
                            }
                            resGroups.add(resTrackers);
                        }
                        this.multiTrackers.put(configName, resGroups);
                    }
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
            finally {
                if (bin != null) {
                    try {
                        bin.close();
                    }
                    catch (Throwable e) {}
                }
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Throwable e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveList() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("trackers", this.trackers);
        map.put("multi-trackers", this.multiTrackers);
        FileOutputStream fos = null;
        try {
            File fTrackers = FileUtil.getUserFile("trackers.config");
            fos = new FileOutputStream(fTrackers);
            fos.write(BEncoder.encode(map));
            fos.close();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    static {
        class_mon = new AEMonitor("TrackersUtil:class");
    }
}

