/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.net.magneturi.MagnetURIHandler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;

public class UrlUtils {
    private static final String[] prefixes = new String[]{"http://", "https://", "ftp://", "magnet:?", "magnet://?"};
    private static int MAGNETURL_STARTS_AT = 3;

    public static boolean isURL(String sURL) {
        return UrlUtils.parseTextForURL(sURL, true) != null;
    }

    public static boolean isURL(String sURL, boolean bGuess) {
        return UrlUtils.parseTextForURL(sURL, true, bGuess) != null;
    }

    public static String parseTextForURL(String text, boolean accept_magnets) {
        return UrlUtils.parseTextForURL(text, accept_magnets, true);
    }

    public static String parseTextForURL(String text, boolean accept_magnets, boolean guess) {
        String textLower;
        if (text == null || text.length() < 5) {
            return null;
        }
        String href = UrlUtils.parseHTMLforURL(text);
        if (href != null) {
            return href;
        }
        try {
            text = text.trim();
            text = URLDecoder.decode(text);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            textLower = text.toLowerCase();
        }
        catch (Throwable e) {
            textLower = text;
        }
        int max = accept_magnets ? prefixes.length : MAGNETURL_STARTS_AT;
        int end = -1;
        int start = textLower.length();
        String strURL = null;
        for (int i = 0; i < max; ++i) {
            int testBegin = textLower.indexOf(prefixes[i]);
            if (testBegin < 0 || testBegin >= start) continue;
            end = text.indexOf("\n", testBegin + prefixes[i].length());
            String strURLTest = end >= 0 ? text.substring(testBegin, end - 1) : text.substring(testBegin);
            try {
                URL parsedURL = new URL(strURLTest);
                strURL = parsedURL.toExternalForm();
                continue;
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
                if (i < MAGNETURL_STARTS_AT) continue;
                strURL = strURLTest;
            }
        }
        if (strURL != null) {
            return strURL;
        }
        if (new File(text).exists()) {
            return null;
        }
        if (accept_magnets && text.matches("^[a-fA-F0-9]{40}$")) {
            byte[] infohash = ByteFormatter.decodeString(text.toUpperCase());
            return "magnet:?xt=urn:btih:" + Base32.encode(infohash);
        }
        if (accept_magnets && text.matches("^[a-zA-Z2-7]{32}$")) {
            return "magnet:?xt=urn:btih:" + text;
        }
        if (accept_magnets && guess) {
            String hash;
            Pattern pattern = Pattern.compile("[^a-zA-Z2-7][a-zA-Z2-7]{32}[^a-zA-Z2-7]");
            Matcher matcher = pattern.matcher(text);
            if (matcher.find()) {
                hash = text.substring(matcher.start() + 1, matcher.start() + 33);
                return "magnet:?xt=urn:btih:" + hash;
            }
            pattern = Pattern.compile("[^a-fA-F0-9][a-fA-F0-9]{40}[^a-fA-F0-9]");
            matcher = pattern.matcher(text);
            if (matcher.find()) {
                hash = text.substring(matcher.start() + 1, matcher.start() + 41);
                byte[] infohash = ByteFormatter.decodeString(hash.toUpperCase());
                return "magnet:?xt=urn:btih:" + Base32.encode(infohash);
            }
        }
        return null;
    }

    public static String parseHTMLforURL(String text) {
        Pattern pat = Pattern.compile("<.*a\\s++.*href=\"?([^\\'\"\\s>]++).*", 2);
        Matcher m = pat.matcher(text);
        if (m.find()) {
            String sURL = m.group(1);
            try {
                sURL = URLDecoder.decode(sURL);
            }
            catch (Exception e) {
                // empty catch block
            }
            return sURL;
        }
        return null;
    }

    public static void main(String[] args) {
        MagnetURIHandler.getSingleton();
        byte[] infohash = ByteFormatter.decodeString("1234567890123456789012345678901234567890");
        String[] test = new String[]{"http://moo.com", "http%3A%2F/moo%2Ecom", "magnet:?moo", "magnet%3A%3Fxt=urn:btih:26", "magnet%3A//%3Fmooo", "magnet:?xt=urn:btih:" + Base32.encode(infohash), "aaaaaaaaaabbbbbbbbbbccccccccccdddddddddd", "magnet:?dn=OpenOffice.org_2.0.3_Win32Intel_install.exe&xt=urn:sha1:PEMIGLKMNFI4HZ4CCHZNPKZJNMAAORKN&xt=urn:tree:tiger:JMIJVWHCQUX47YYH7O4XIBCORNU2KYKHBBC6DHA&xt=urn:ed2k:1c0804541f34b6583a383bb8f2cec682&xl=96793015&xs=http://mirror.switch.ch/ftp/mirror/OpenOffice/stable/2.0.3/OOo_2.0.3_Win32Intel_install.exe"};
        for (int i = 0; i < test.length; ++i) {
            System.out.println("decode: " + test[i] + " -> " + URLDecoder.decode(test[i]));
            System.out.println("isURL: " + test[i] + " -> " + UrlUtils.isURL(test[i]));
            System.out.println("parse: " + test[i] + " -> " + UrlUtils.parseTextForURL(test[i], true));
        }
    }

    public static String encode(String s) {
        return URLEncoder.encode(s).replaceAll("\\+", "%20");
    }
}

